/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.config.manager.impl.ConfigTransactionControllerInternal;

@NotThreadSafe
class TransactionsHolder {
    @GuardedBy(value="ConfigRegistryImpl.this")
    private final Map<String, ConfigTransactionControllerInternal> transactions = new HashMap<String, ConfigTransactionControllerInternal>();

    TransactionsHolder() {
    }

    public void add(String transactionName, ConfigTransactionControllerInternal transactionController) {
        ConfigTransactionControllerInternal oldValue = this.transactions.put(transactionName, transactionController);
        if (oldValue != null) {
            throw new IllegalStateException("Error: two transactions with same name");
        }
    }

    public Map<String, ConfigTransactionControllerInternal> getCurrentTransactions() {
        Iterator<Map.Entry<String, ConfigTransactionControllerInternal>> it = this.transactions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ConfigTransactionControllerInternal> entry = it.next();
            if (!entry.getValue().isClosed()) continue;
            it.remove();
        }
        return Collections.unmodifiableMap(this.transactions);
    }
}

