/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import javax.annotation.concurrent.GuardedBy;

public class TransactionStatus {
    @GuardedBy(value="this")
    private boolean secondPhaseCommitStarted = false;
    @GuardedBy(value="this")
    private boolean aborted;
    @GuardedBy(value="this")
    private boolean committed;

    public synchronized boolean isSecondPhaseCommitStarted() {
        return this.secondPhaseCommitStarted;
    }

    synchronized void setSecondPhaseCommitStarted() {
        this.secondPhaseCommitStarted = true;
    }

    public synchronized boolean isAborted() {
        return this.aborted;
    }

    synchronized void setAborted() {
        this.aborted = true;
    }

    public synchronized boolean isCommitted() {
        return this.committed;
    }

    synchronized void setCommitted() {
        this.committed = true;
    }

    public synchronized boolean isAbortedOrCommitted() {
        return this.aborted || this.committed;
    }

    public synchronized void checkNotCommitStarted() {
        if (this.secondPhaseCommitStarted) {
            throw new IllegalStateException("Commit was triggered");
        }
    }

    public synchronized void checkCommitStarted() {
        if (!this.secondPhaseCommitStarted) {
            throw new IllegalStateException("Commit was not triggered");
        }
    }

    public synchronized void checkNotAborted() {
        if (this.aborted) {
            throw new IllegalStateException("Configuration was aborted");
        }
    }

    public synchronized void checkNotCommitted() {
        if (this.committed) {
            throw new IllegalStateException("Cannot use this method after second phase commit");
        }
    }

    public synchronized void checkCommitted() {
        if (!this.committed) {
            throw new IllegalStateException("Cannot use this method before second phase commit");
        }
    }
}

