/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.LookupRegistry;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.ServiceReferenceReadableRegistry;
import org.opendaylight.controller.config.api.ServiceReferenceWritableRegistry;
import org.opendaylight.controller.config.api.annotations.ServiceInterfaceAnnotation;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.CloseableServiceReferenceReadableRegistry;
import org.opendaylight.controller.config.manager.impl.ConfigTransactionLookupRegistry;
import org.opendaylight.controller.config.manager.impl.jmx.BaseJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.ServiceReference;
import org.opendaylight.controller.config.manager.impl.jmx.ServiceReferenceMXBeanImpl;
import org.opendaylight.controller.config.manager.impl.jmx.ServiceReferenceRegistrator;
import org.opendaylight.controller.config.manager.impl.util.InterfacesHelper;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceReferenceRegistryImpl
implements CloseableServiceReferenceReadableRegistry,
ServiceReferenceWritableRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ServiceReferenceRegistryImpl.class);
    private final Map<String, ModuleFactory> factories;
    private final Map<String, Set<String>> factoryNamesToQNames;
    private final LookupRegistry lookupRegistry;
    private final ServiceReferenceRegistrator serviceReferenceRegistrator;
    private final Map<String, Map<String, ServiceInterfaceAnnotation>> namespacesToAnnotations;
    private final Set<String> allQNames;
    private final Map<ServiceReference, ModuleIdentifier> refNames = new HashMap<ServiceReference, ModuleIdentifier>();
    private final boolean writable;
    private final Map<ServiceReference, Map.Entry<ServiceReferenceMXBeanImpl, ServiceReferenceRegistrator.ServiceReferenceJMXRegistration>> mBeans = new HashMap<ServiceReference, Map.Entry<ServiceReferenceMXBeanImpl, ServiceReferenceRegistrator.ServiceReferenceJMXRegistration>>();

    public static CloseableServiceReferenceReadableRegistry createInitialSRLookupRegistry() {
        LookupRegistry lookupRegistry = new LookupRegistry(){

            public Set<ObjectName> lookupConfigBeans() {
                throw new UnsupportedOperationException();
            }

            public Set<ObjectName> lookupConfigBeans(String moduleName) {
                throw new UnsupportedOperationException();
            }

            public Set<ObjectName> lookupConfigBeans(String moduleName, String instanceName) {
                throw new UnsupportedOperationException();
            }

            public ObjectName lookupConfigBean(String moduleName, String instanceName) throws InstanceNotFoundException {
                throw new UnsupportedOperationException();
            }

            public void checkConfigBeanExists(ObjectName objectName) throws InstanceNotFoundException {
                throw new InstanceNotFoundException("Cannot find " + objectName + " - Tried to use mocking registry");
            }

            public Set<String> getAvailableModuleFactoryQNames() {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "initial";
            }
        };
        ServiceReferenceRegistrator.ServiceReferenceTransactionRegistratorFactory serviceReferenceRegistratorFactory = new ServiceReferenceRegistrator.ServiceReferenceTransactionRegistratorFactory(){

            @Override
            public ServiceReferenceRegistrator create() {
                return new ServiceReferenceRegistrator(){

                    @Override
                    public String getNullableTransactionName() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public ServiceReferenceRegistrator.ServiceReferenceJMXRegistration registerMBean(ServiceReferenceMXBeanImpl object, ObjectName on) throws InstanceAlreadyExistsException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
        return new ServiceReferenceRegistryImpl(Collections.emptyMap(), lookupRegistry, serviceReferenceRegistratorFactory, false);
    }

    public static ServiceReferenceWritableRegistry createSRWritableRegistry(ServiceReferenceReadableRegistry oldReadableRegistry, ConfigTransactionLookupRegistry txLookupRegistry, Map<String, Map.Entry<ModuleFactory, BundleContext>> currentlyRegisteredFactories) {
        if (txLookupRegistry == null) {
            throw new IllegalArgumentException("txLookupRegistry is null");
        }
        ServiceReferenceRegistryImpl old = (ServiceReferenceRegistryImpl)oldReadableRegistry;
        Map<String, ModuleFactory> factories = ServiceReferenceRegistryImpl.extractFactoriesMap(currentlyRegisteredFactories);
        ServiceReferenceRegistrator.ServiceReferenceTransactionRegistratorFactoryImpl serviceReferenceRegistratorFactory = new ServiceReferenceRegistrator.ServiceReferenceTransactionRegistratorFactoryImpl(txLookupRegistry.getTxModuleJMXRegistrator(), txLookupRegistry.getTxModuleJMXRegistrator().getTransactionName());
        ServiceReferenceRegistryImpl newRegistry = new ServiceReferenceRegistryImpl(factories, txLookupRegistry, serviceReferenceRegistratorFactory, true);
        ServiceReferenceRegistryImpl.copy(old, newRegistry, txLookupRegistry.getTransactionIdentifier().getName());
        return newRegistry;
    }

    public static CloseableServiceReferenceReadableRegistry createSRReadableRegistry(ServiceReferenceWritableRegistry oldWritableRegistry, LookupRegistry lookupRegistry, BaseJMXRegistrator baseJMXRegistrator) {
        ServiceReferenceRegistryImpl old = (ServiceReferenceRegistryImpl)oldWritableRegistry;
        ServiceReferenceRegistrator.ServiceReferenceTransactionRegistratorFactoryImpl serviceReferenceRegistratorFactory = new ServiceReferenceRegistrator.ServiceReferenceTransactionRegistratorFactoryImpl(baseJMXRegistrator);
        ServiceReferenceRegistryImpl newRegistry = new ServiceReferenceRegistryImpl(old.factories, lookupRegistry, serviceReferenceRegistratorFactory, false);
        ServiceReferenceRegistryImpl.copy(old, newRegistry, null);
        return newRegistry;
    }

    private static void copy(ServiceReferenceRegistryImpl old, ServiceReferenceRegistryImpl newRegistry, String nullableDstTransactionName) {
        for (Map.Entry<ServiceReference, Map.Entry<ServiceReferenceMXBeanImpl, ServiceReferenceRegistrator.ServiceReferenceJMXRegistration>> refNameEntry : old.mBeans.entrySet()) {
            ObjectName currentImplementationSrc = refNameEntry.getValue().getKey().getCurrentImplementation();
            ObjectName currentImplementation = nullableDstTransactionName != null ? ObjectNameUtil.withTransactionName((ObjectName)currentImplementationSrc, (String)nullableDstTransactionName) : ObjectNameUtil.withoutTransactionName((ObjectName)currentImplementationSrc);
            try {
                boolean skipChecks = true;
                newRegistry.saveServiceReference(refNameEntry.getKey(), currentImplementation, skipChecks);
            }
            catch (InstanceNotFoundException e) {
                logger.error("Cannot save service reference({}, {})", (Object)refNameEntry.getKey(), (Object)currentImplementation);
                throw new IllegalStateException("Possible code error", e);
            }
        }
    }

    private static Map<String, ModuleFactory> extractFactoriesMap(Map<String, Map.Entry<ModuleFactory, BundleContext>> currentlyRegisteredFactories) {
        HashMap<String, ModuleFactory> result = new HashMap<String, ModuleFactory>();
        for (Map.Entry<String, Map.Entry<ModuleFactory, BundleContext>> entry : currentlyRegisteredFactories.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getKey());
        }
        return result;
    }

    private ServiceReferenceRegistryImpl(Map<String, ModuleFactory> factories, LookupRegistry lookupRegistry, ServiceReferenceRegistrator.ServiceReferenceTransactionRegistratorFactory serviceReferenceRegistratorFactory, boolean writable) {
        this.factories = factories;
        this.writable = writable;
        this.lookupRegistry = lookupRegistry;
        this.serviceReferenceRegistrator = serviceReferenceRegistratorFactory.create();
        HashMap factoryNamesToQNames = new HashMap();
        HashSet<ServiceInterfaceAnnotation> allAnnotations = new HashSet<ServiceInterfaceAnnotation>();
        HashSet allQNames = new HashSet();
        for (Map.Entry<String, ModuleFactory> entry : factories.entrySet()) {
            if (!entry.getKey().equals(entry.getValue().getImplementationName())) {
                logger.error("Possible error in code: Mismatch between supplied and actual name of {}", entry);
                throw new IllegalArgumentException("Possible error in code: Mismatch between supplied and actual name of " + entry);
            }
            Set<ServiceInterfaceAnnotation> siAnnotations = InterfacesHelper.getServiceInterfaceAnnotations(entry.getValue());
            HashSet<String> qNames = new HashSet<String>();
            for (ServiceInterfaceAnnotation sia : siAnnotations) {
                qNames.add(sia.value());
            }
            allAnnotations.addAll(siAnnotations);
            allQNames.addAll(qNames);
            factoryNamesToQNames.put(entry.getKey(), Collections.unmodifiableSet(qNames));
        }
        this.factoryNamesToQNames = Collections.unmodifiableMap(factoryNamesToQNames);
        this.allQNames = Collections.unmodifiableSet(allQNames);
        HashMap namespacesToAnnotations = new HashMap();
        for (ServiceInterfaceAnnotation sia : allAnnotations) {
            HashMap<String, ServiceInterfaceAnnotation> ofNamespace = (HashMap<String, ServiceInterfaceAnnotation>)namespacesToAnnotations.get(sia.namespace());
            if (ofNamespace == null) {
                ofNamespace = new HashMap<String, ServiceInterfaceAnnotation>();
                namespacesToAnnotations.put(sia.namespace(), ofNamespace);
            }
            if (ofNamespace.containsKey(sia.localName())) {
                logger.error("Cannot construct namespacesToAnnotations map, conflict between local names in {}, offending local name: {}, map so far {}", new Object[]{sia.namespace(), sia.localName(), namespacesToAnnotations});
                throw new IllegalArgumentException("Conflict between local names in " + sia.namespace() + " : " + sia.localName());
            }
            ofNamespace.put(sia.localName(), sia);
        }
        this.namespacesToAnnotations = Collections.unmodifiableMap(namespacesToAnnotations);
        logger.trace("factoryNamesToQNames:{}", this.factoryNamesToQNames);
    }

    public synchronized Set<String> lookupServiceInterfaceNames(ObjectName objectName) throws InstanceNotFoundException {
        this.lookupRegistry.checkConfigBeanExists(objectName);
        String factoryName = ObjectNameUtil.getFactoryName((ObjectName)objectName);
        Set<String> serviceInterfaceAnnotations = this.factoryNamesToQNames.get(factoryName);
        if (serviceInterfaceAnnotations == null) {
            logger.error("Possible error in code: cannot find factory annotations of '{}' extracted from ON {} in {}", new Object[]{factoryName, objectName, this.factoryNamesToQNames});
            throw new IllegalArgumentException("Cannot find factory with name " + factoryName);
        }
        return serviceInterfaceAnnotations;
    }

    public synchronized String getServiceInterfaceName(String namespace, String localName) {
        Map<String, ServiceInterfaceAnnotation> ofNamespace = this.namespacesToAnnotations.get(namespace);
        if (ofNamespace == null) {
            logger.error("Cannot find namespace {} in {}", (Object)namespace, this.namespacesToAnnotations);
            throw new IllegalArgumentException("Cannot find namespace " + namespace);
        }
        ServiceInterfaceAnnotation sia = ofNamespace.get(localName);
        if (sia == null) {
            logger.error("Cannot find local name {} in namespace {}, found only {}", new Object[]{localName, namespace, ofNamespace});
            throw new IllegalArgumentException("Cannot find local name " + localName + " in namespace " + namespace);
        }
        return sia.value();
    }

    public synchronized Map<String, Map<String, ObjectName>> getServiceMapping() {
        HashMap<String, Map<String, ObjectName>> result = new HashMap<String, Map<String, ObjectName>>();
        for (Map.Entry<ServiceReference, ModuleIdentifier> entry : this.refNames.entrySet()) {
            String qName = entry.getKey().getServiceInterfaceName();
            HashMap<String, ObjectName> innerMap = (HashMap<String, ObjectName>)result.get(qName);
            if (innerMap == null) {
                innerMap = new HashMap<String, ObjectName>();
                result.put(qName, innerMap);
            }
            innerMap.put(entry.getKey().getRefName(), this.getObjectName(entry.getValue()));
        }
        return result;
    }

    private ObjectName getObjectName(ModuleIdentifier moduleIdentifier) {
        ObjectName on;
        try {
            on = this.lookupRegistry.lookupConfigBean(moduleIdentifier.getFactoryName(), moduleIdentifier.getInstanceName());
        }
        catch (InstanceNotFoundException e) {
            logger.error("Cannot find instance {}", (Object)moduleIdentifier);
            throw new IllegalStateException("Cannot find instance " + moduleIdentifier, e);
        }
        return on;
    }

    public synchronized ObjectName lookupConfigBeanByServiceInterfaceName(String serviceInterfaceQName, String refName) {
        ServiceReference serviceReference = new ServiceReference(serviceInterfaceQName, refName);
        ModuleIdentifier moduleIdentifier = this.refNames.get(serviceReference);
        if (moduleIdentifier == null) {
            logger.error("Cannot find qname {} and refName {} in {}", new Object[]{serviceInterfaceQName, refName, refName});
            throw new IllegalArgumentException("Cannot find " + serviceReference);
        }
        return this.getObjectName(moduleIdentifier);
    }

    public synchronized Map<String, ObjectName> lookupServiceReferencesByServiceInterfaceName(String serviceInterfaceQName) {
        Map<String, Map<String, ObjectName>> serviceMapping = this.getServiceMapping();
        Map<String, ObjectName> innerMap = serviceMapping.get(serviceInterfaceQName);
        if (innerMap == null) {
            logger.error("Cannot find qname {} in {}", (Object)serviceInterfaceQName, this.refNames);
            throw new IllegalArgumentException("Cannot find " + serviceInterfaceQName);
        }
        return innerMap;
    }

    public synchronized ObjectName getServiceReference(String serviceInterfaceQName, String refName) throws InstanceNotFoundException {
        ServiceReference serviceReference = new ServiceReference(serviceInterfaceQName, refName);
        if (!this.mBeans.containsKey(serviceReference)) {
            throw new InstanceNotFoundException("Cannot find " + serviceReference);
        }
        return this.getServiceON(serviceReference);
    }

    public synchronized void checkServiceReferenceExists(ObjectName objectName) throws InstanceNotFoundException {
        String referenceName;
        String actualTransactionName = ObjectNameUtil.getTransactionName((ObjectName)objectName);
        String expectedTransactionName = this.serviceReferenceRegistrator.getNullableTransactionName();
        if (this.writable & actualTransactionName == null || this.writable && !actualTransactionName.equals(expectedTransactionName)) {
            throw new IllegalArgumentException("Mismatched transaction name in " + objectName);
        }
        String serviceQName = ObjectNameUtil.getServiceQName((ObjectName)objectName);
        ServiceReference serviceReference = new ServiceReference(serviceQName, referenceName = ObjectNameUtil.getReferenceName((ObjectName)objectName));
        if (!this.refNames.containsKey(serviceReference)) {
            logger.warn("Cannot find {} in {}", (Object)serviceReference, this.refNames);
            throw new InstanceNotFoundException("Service reference not found:" + objectName);
        }
    }

    private void assertWritable() {
        if (!this.writable) {
            throw new IllegalStateException("Cannot write to readable registry");
        }
    }

    public synchronized ObjectName saveServiceReference(String serviceInterfaceName, String refName, ObjectName moduleON) throws InstanceNotFoundException {
        this.assertWritable();
        ServiceReference serviceReference = new ServiceReference(serviceInterfaceName, refName);
        return this.saveServiceReference(serviceReference, moduleON);
    }

    private synchronized ObjectName saveServiceReference(ServiceReference serviceReference, ObjectName moduleON) throws InstanceNotFoundException {
        return this.saveServiceReference(serviceReference, moduleON, false);
    }

    private synchronized ObjectName saveServiceReference(ServiceReference serviceReference, ObjectName moduleON, boolean skipChecks) throws InstanceNotFoundException {
        String instanceName;
        String factoryName;
        ModuleIdentifier moduleIdentifier;
        Set<String> serviceInterfaceQNames;
        if (!skipChecks) {
            this.lookupRegistry.checkConfigBeanExists(moduleON);
        }
        if ((serviceInterfaceQNames = this.factoryNamesToQNames.get((moduleIdentifier = new ModuleIdentifier(factoryName = ObjectNameUtil.getFactoryName((ObjectName)moduleON), instanceName = ObjectNameUtil.getInstanceName((ObjectName)moduleON))).getFactoryName())) == null) {
            logger.error("Possible error in code: cannot find factoryName {} in {}, {}", new Object[]{moduleIdentifier.getFactoryName(), this.factoryNamesToQNames, moduleIdentifier});
            throw new IllegalStateException("Possible error in code: cannot find annotations of existing factory " + moduleIdentifier.getFactoryName());
        }
        if (!serviceInterfaceQNames.contains(serviceReference.getServiceInterfaceName())) {
            logger.error("Cannot find qName {} with factory name {}, found {}", new Object[]{serviceReference.getServiceInterfaceName(), moduleIdentifier.getFactoryName(), serviceInterfaceQNames});
            throw new IllegalArgumentException("Cannot find service interface " + serviceReference.getServiceInterfaceName() + " within factory " + moduleIdentifier.getFactoryName());
        }
        ObjectName result = this.getServiceON(serviceReference);
        Map.Entry<ServiceReferenceMXBeanImpl, ServiceReferenceRegistrator.ServiceReferenceJMXRegistration> mxBeanEntry = this.mBeans.get(serviceReference);
        if (mxBeanEntry == null) {
            ServiceReferenceRegistrator.ServiceReferenceJMXRegistration dummyMXBeanRegistration;
            ServiceReferenceMXBeanImpl dummyMXBean = new ServiceReferenceMXBeanImpl(moduleON);
            try {
                dummyMXBeanRegistration = this.serviceReferenceRegistrator.registerMBean(dummyMXBean, result);
            }
            catch (InstanceAlreadyExistsException e) {
                throw new IllegalStateException("Possible error in code. Cannot register " + result, e);
            }
            this.mBeans.put(serviceReference, this.createMXBeanEntry(dummyMXBean, dummyMXBeanRegistration));
        } else {
            mxBeanEntry.getKey().setCurrentImplementation(moduleON);
        }
        this.refNames.put(serviceReference, moduleIdentifier);
        return result;
    }

    private Map.Entry<ServiceReferenceMXBeanImpl, ServiceReferenceRegistrator.ServiceReferenceJMXRegistration> createMXBeanEntry(final ServiceReferenceMXBeanImpl mxBean, final ServiceReferenceRegistrator.ServiceReferenceJMXRegistration registration) {
        return new Map.Entry<ServiceReferenceMXBeanImpl, ServiceReferenceRegistrator.ServiceReferenceJMXRegistration>(){

            @Override
            public ServiceReferenceMXBeanImpl getKey() {
                return mxBean;
            }

            @Override
            public ServiceReferenceRegistrator.ServiceReferenceJMXRegistration getValue() {
                return registration;
            }

            @Override
            public ServiceReferenceRegistrator.ServiceReferenceJMXRegistration setValue(ServiceReferenceRegistrator.ServiceReferenceJMXRegistration value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private ObjectName getServiceON(ServiceReference serviceReference) {
        if (this.writable) {
            return ObjectNameUtil.createTransactionServiceON((String)this.serviceReferenceRegistrator.getNullableTransactionName(), (String)serviceReference.getServiceInterfaceName(), (String)serviceReference.getRefName());
        }
        return ObjectNameUtil.createReadOnlyServiceON((String)serviceReference.getServiceInterfaceName(), (String)serviceReference.getRefName());
    }

    public synchronized void removeServiceReference(String serviceInterfaceName, String refName) throws InstanceNotFoundException {
        ServiceReference serviceReference = new ServiceReference(serviceInterfaceName, refName);
        this.removeServiceReference(serviceReference);
    }

    private synchronized void removeServiceReference(ServiceReference serviceReference) throws InstanceNotFoundException {
        logger.debug("Removing service reference {} from {}", (Object)serviceReference, (Object)this);
        this.assertWritable();
        if (!this.allQNames.contains(serviceReference.getServiceInterfaceName())) {
            logger.error("Cannot find qname {} in {}", (Object)serviceReference.getServiceInterfaceName(), this.allQNames);
            throw new IllegalArgumentException("Cannot find service interface " + serviceReference.getServiceInterfaceName());
        }
        ModuleIdentifier removed = this.refNames.remove(serviceReference);
        if (removed == null) {
            throw new InstanceNotFoundException("Cannot find " + serviceReference.getServiceInterfaceName());
        }
        Map.Entry<ServiceReferenceMXBeanImpl, ServiceReferenceRegistrator.ServiceReferenceJMXRegistration> entry = this.mBeans.remove(serviceReference);
        if (entry == null) {
            throw new IllegalStateException("Possible code error: cannot remove from mBeans: " + serviceReference);
        }
        entry.getValue().close();
    }

    public synchronized void removeAllServiceReferences() {
        this.assertWritable();
        for (ServiceReference serviceReference : this.mBeans.keySet()) {
            try {
                this.removeServiceReference(serviceReference);
            }
            catch (InstanceNotFoundException e) {
                throw new IllegalStateException("Possible error in code", e);
            }
        }
    }

    public synchronized boolean removeServiceReferences(ObjectName moduleObjectName) throws InstanceNotFoundException {
        this.assertWritable();
        Set<ServiceReference> serviceReferencesLinkingTo = this.findServiceReferencesLinkingTo(moduleObjectName);
        for (ServiceReference sr : serviceReferencesLinkingTo) {
            this.removeServiceReference(sr);
        }
        return !serviceReferencesLinkingTo.isEmpty();
    }

    private synchronized Set<ServiceReference> findServiceReferencesLinkingTo(ObjectName moduleObjectName) throws InstanceNotFoundException {
        this.lookupRegistry.checkConfigBeanExists(moduleObjectName);
        String factoryName = ObjectNameUtil.getFactoryName((ObjectName)moduleObjectName);
        Set<String> serviceInterfaceQNames = this.factoryNamesToQNames.get(factoryName);
        if (serviceInterfaceQNames == null) {
            logger.error("Possible error in code: cannot find factoryName {} in {}, object name {}", new Object[]{factoryName, this.factoryNamesToQNames, moduleObjectName});
            throw new IllegalStateException("Possible error in code: cannot find annotations of existing factory " + factoryName);
        }
        String instanceName = ObjectNameUtil.getInstanceName((ObjectName)moduleObjectName);
        ModuleIdentifier moduleIdentifier = new ModuleIdentifier(factoryName, instanceName);
        HashSet<ServiceReference> result = new HashSet<ServiceReference>();
        for (Map.Entry<ServiceReference, ModuleIdentifier> entry : this.refNames.entrySet()) {
            if (!entry.getValue().equals((Object)moduleIdentifier)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public String toString() {
        return "ServiceReferenceRegistryImpl{lookupRegistry=" + this.lookupRegistry + "refNames=" + this.refNames + ", factoryNamesToQNames=" + this.factoryNamesToQNames + '}';
    }

    @Override
    public void close() {
        this.serviceReferenceRegistrator.close();
    }
}

