/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import javax.annotation.Nullable;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.manager.impl.DestroyedModule;
import org.opendaylight.controller.config.manager.impl.ModuleInternalInfo;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.DynamicReadableWrapper;
import org.opendaylight.controller.config.manager.impl.jmx.TransactionModuleJMXRegistrator;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.yangtools.concepts.Identifiable;

public class ModuleInternalTransactionalInfo
implements Identifiable<ModuleIdentifier> {
    private final ModuleIdentifier name;
    private final Module module;
    private final ModuleFactory moduleFactory;
    @Nullable
    private final ModuleInternalInfo maybeOldInternalInfo;
    private final TransactionModuleJMXRegistrator.TransactionModuleJMXRegistration transactionModuleJMXRegistration;
    private final boolean isDefaultBean;

    ModuleInternalTransactionalInfo(ModuleIdentifier name, Module module, ModuleFactory moduleFactory, ModuleInternalInfo maybeOldInternalInfo, TransactionModuleJMXRegistrator.TransactionModuleJMXRegistration transactionModuleJMXRegistration, boolean isDefaultBean) {
        this.name = name;
        this.module = module;
        this.moduleFactory = moduleFactory;
        this.maybeOldInternalInfo = maybeOldInternalInfo;
        this.transactionModuleJMXRegistration = transactionModuleJMXRegistration;
        this.isDefaultBean = isDefaultBean;
    }

    public boolean hasOldModule() {
        return this.maybeOldInternalInfo != null;
    }

    public DestroyedModule toDestroyedModule() {
        if (this.maybeOldInternalInfo == null) {
            throw new IllegalStateException("Cannot destroy uncommitted module");
        }
        DynamicReadableWrapper oldModule = this.maybeOldInternalInfo.getReadableModule();
        return new DestroyedModule(this.name, oldModule.getInstance(), this.maybeOldInternalInfo.getModuleJMXRegistrator(), this.maybeOldInternalInfo.getOsgiRegistration(), this.maybeOldInternalInfo.getOrderingIdx());
    }

    public Module getModule() {
        return this.module;
    }

    public ModuleFactory getModuleFactory() {
        return this.moduleFactory;
    }

    @Nullable
    public ModuleInternalInfo getOldInternalInfo() {
        if (this.maybeOldInternalInfo == null) {
            throw new NullPointerException();
        }
        return this.maybeOldInternalInfo;
    }

    public TransactionModuleJMXRegistrator.TransactionModuleJMXRegistration getTransactionModuleJMXRegistration() {
        return this.transactionModuleJMXRegistration;
    }

    public ModuleIdentifier getIdentifier() {
        return this.name;
    }

    public boolean isDefaultBean() {
        return this.isDefaultBean;
    }
}

