/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import javax.annotation.Nullable;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.manager.impl.DestroyedModule;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.DynamicReadableWrapper;
import org.opendaylight.controller.config.manager.impl.jmx.ModuleJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.RootRuntimeBeanRegistratorImpl;
import org.opendaylight.controller.config.manager.impl.osgi.BeanToOsgiServiceManager;
import org.opendaylight.yangtools.concepts.Identifiable;

public class ModuleInternalInfo
implements Comparable<ModuleInternalInfo>,
Identifiable<ModuleIdentifier> {
    private final ModuleIdentifier name;
    @Nullable
    private final DynamicReadableWrapper readableModule;
    private final RootRuntimeBeanRegistratorImpl runtimeBeanRegistrator;
    private final BeanToOsgiServiceManager.OsgiRegistration osgiRegistration;
    private final ModuleJMXRegistrator moduleJMXRegistrator;
    private final int orderingIdx;
    private final boolean isDefaultBean;

    public ModuleInternalInfo(ModuleIdentifier name, @Nullable DynamicReadableWrapper readableModule, BeanToOsgiServiceManager.OsgiRegistration osgiRegistration, RootRuntimeBeanRegistratorImpl runtimeBeanRegistrator, ModuleJMXRegistrator moduleJMXRegistrator, int orderingIdx, boolean isDefaultBean) {
        if (osgiRegistration == null) {
            throw new IllegalArgumentException("Parameter 'osgiRegistration' is missing");
        }
        if (runtimeBeanRegistrator == null) {
            throw new IllegalArgumentException("Parameter 'runtimeBeanRegistrator' is missing");
        }
        this.readableModule = readableModule;
        this.osgiRegistration = osgiRegistration;
        this.runtimeBeanRegistrator = runtimeBeanRegistrator;
        this.name = name;
        this.moduleJMXRegistrator = moduleJMXRegistrator;
        this.orderingIdx = orderingIdx;
        this.isDefaultBean = isDefaultBean;
    }

    public DynamicReadableWrapper getReadableModule() {
        return this.readableModule;
    }

    public ModuleJMXRegistrator getModuleJMXRegistrator() {
        return this.moduleJMXRegistrator;
    }

    public boolean hasReadableModule() {
        return this.readableModule != null;
    }

    public String toString() {
        return "ModuleInternalInfo [name=" + this.name + "]";
    }

    public RootRuntimeBeanRegistratorImpl getRuntimeBeanRegistrator() {
        return this.runtimeBeanRegistrator;
    }

    public BeanToOsgiServiceManager.OsgiRegistration getOsgiRegistration() {
        return this.osgiRegistration;
    }

    public int getOrderingIdx() {
        return this.orderingIdx;
    }

    @Override
    public int compareTo(ModuleInternalInfo o) {
        return Integer.compare(this.orderingIdx, o.orderingIdx);
    }

    public DestroyedModule toDestroyedModule() {
        return new DestroyedModule(this.getIdentifier(), this.getReadableModule().getInstance(), this.getModuleJMXRegistrator(), this.getOsgiRegistration(), this.getOrderingIdx());
    }

    public ModuleIdentifier getIdentifier() {
        return this.name;
    }

    public boolean isDefaultBean() {
        return this.isDefaultBean;
    }
}

