/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.manager.impl.jmx.ModuleJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.osgi.BeanToOsgiServiceManager;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestroyedModule
implements AutoCloseable,
Comparable<DestroyedModule>,
Identifiable<ModuleIdentifier> {
    private static final Logger logger = LoggerFactory.getLogger(DestroyedModule.class);
    private final ModuleIdentifier identifier;
    private final AutoCloseable instance;
    private final ModuleJMXRegistrator oldJMXRegistrator;
    private final BeanToOsgiServiceManager.OsgiRegistration osgiRegistration;
    private final int orderingIdx;

    DestroyedModule(ModuleIdentifier identifier, AutoCloseable instance, ModuleJMXRegistrator oldJMXRegistrator, BeanToOsgiServiceManager.OsgiRegistration osgiRegistration, int orderingIdx) {
        this.identifier = identifier;
        this.instance = instance;
        this.oldJMXRegistrator = oldJMXRegistrator;
        this.osgiRegistration = osgiRegistration;
        this.orderingIdx = orderingIdx;
    }

    @Override
    public void close() {
        logger.trace("Destroying {}", (Object)this.identifier);
        try {
            this.instance.close();
        }
        catch (Exception e) {
            logger.error("Error while closing instance of {}", (Object)this.identifier, (Object)e);
        }
        try {
            this.oldJMXRegistrator.close();
        }
        catch (Exception e) {
            logger.error("Error while closing jmx registrator of {}", (Object)this.identifier, (Object)e);
        }
        try {
            this.osgiRegistration.close();
        }
        catch (Exception e) {
            logger.error("Error while closing osgi registration of {}", (Object)this.identifier, (Object)e);
        }
    }

    @Override
    public int compareTo(DestroyedModule o) {
        return Integer.compare(this.orderingIdx, o.orderingIdx);
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }
}

