/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.LookupRegistry;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.ConfigTransactionControllerInternal;
import org.opendaylight.controller.config.manager.impl.TransactionIdentifier;
import org.opendaylight.controller.config.manager.impl.TransactionJMXRegistratorFactory;
import org.opendaylight.controller.config.manager.impl.jmx.TransactionJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.TransactionModuleJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.util.LookupBeansUtil;
import org.opendaylight.controller.config.manager.impl.util.ModuleQNameUtil;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.osgi.framework.BundleContext;

class ConfigTransactionLookupRegistry
implements LookupRegistry,
Closeable {
    private final TransactionJMXRegistrator transactionJMXRegistrator;
    private final TransactionIdentifier transactionIdentifier;
    private final TransactionModuleJMXRegistrator txModuleJMXRegistrator;
    private final Map<String, Map.Entry<ModuleFactory, BundleContext>> allCurrentFactories;

    ConfigTransactionLookupRegistry(TransactionIdentifier transactionIdentifier, TransactionJMXRegistratorFactory factory, Map<String, Map.Entry<ModuleFactory, BundleContext>> allCurrentFactories) {
        this.transactionIdentifier = transactionIdentifier;
        this.transactionJMXRegistrator = factory.create();
        this.txModuleJMXRegistrator = this.transactionJMXRegistrator.createTransactionModuleJMXRegistrator();
        this.allCurrentFactories = allCurrentFactories;
    }

    private void checkTransactionName(ObjectName objectName) {
        String foundTransactionName = ObjectNameUtil.getTransactionName((ObjectName)objectName);
        if (!this.transactionIdentifier.getName().equals(foundTransactionName)) {
            throw new IllegalArgumentException("Wrong transaction name " + objectName);
        }
    }

    public Set<ObjectName> lookupConfigBeans() {
        return this.lookupConfigBeans("*", "*");
    }

    public Set<ObjectName> lookupConfigBeans(String moduleName) {
        return this.lookupConfigBeans(moduleName, "*");
    }

    public ObjectName lookupConfigBean(String moduleName, String instanceName) throws InstanceNotFoundException {
        return LookupBeansUtil.lookupConfigBean(this, moduleName, instanceName);
    }

    public Set<ObjectName> lookupConfigBeans(String moduleName, String instanceName) {
        ObjectName namePattern = ObjectNameUtil.createModulePattern((String)moduleName, (String)instanceName, (String)this.transactionIdentifier.getName());
        return this.txModuleJMXRegistrator.queryNames(namePattern, null);
    }

    public void checkConfigBeanExists(ObjectName objectName) throws InstanceNotFoundException {
        ObjectNameUtil.checkDomain((ObjectName)objectName);
        ObjectNameUtil.checkType((ObjectName)objectName, (String)"Module");
        this.checkTransactionName(objectName);
        LookupBeansUtil.lookupConfigBean(this, ObjectNameUtil.getFactoryName((ObjectName)objectName), ObjectNameUtil.getInstanceName((ObjectName)objectName));
    }

    TransactionIdentifier getTransactionIdentifier() {
        return this.transactionIdentifier;
    }

    TransactionModuleJMXRegistrator getTxModuleJMXRegistrator() {
        return this.txModuleJMXRegistrator;
    }

    @Override
    public void close() {
        this.transactionJMXRegistrator.close();
    }

    public void registerMBean(ConfigTransactionControllerInternal transactionController, ObjectName controllerObjectName) throws InstanceAlreadyExistsException {
        this.transactionJMXRegistrator.registerMBean(transactionController, controllerObjectName);
    }

    public Set<String> getAvailableModuleFactoryQNames() {
        return ModuleQNameUtil.getQNames(this.allCurrentFactories);
    }

    public String toString() {
        return "ConfigTransactionLookupRegistry{transactionIdentifier=" + this.transactionIdentifier + '}';
    }
}

