/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DependencyResolverFactory;
import org.opendaylight.controller.config.api.DynamicMBeanWithInstance;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.ServiceReferenceReadableRegistry;
import org.opendaylight.controller.config.api.ServiceReferenceWritableRegistry;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.CommitInfo;
import org.opendaylight.controller.config.manager.impl.ConfigTransactionControllerImplMXBean;
import org.opendaylight.controller.config.manager.impl.ConfigTransactionControllerInternal;
import org.opendaylight.controller.config.manager.impl.ConfigTransactionLookupRegistry;
import org.opendaylight.controller.config.manager.impl.ModuleInternalInfo;
import org.opendaylight.controller.config.manager.impl.ModuleInternalTransactionalInfo;
import org.opendaylight.controller.config.manager.impl.TransactionIdentifier;
import org.opendaylight.controller.config.manager.impl.TransactionStatus;
import org.opendaylight.controller.config.manager.impl.dependencyresolver.DependencyResolverImpl;
import org.opendaylight.controller.config.manager.impl.dependencyresolver.DependencyResolverManager;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.DynamicWritableWrapper;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.ReadOnlyAtomicBoolean;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.HierarchicalConfigMBeanFactoriesHolder;
import org.opendaylight.controller.config.manager.impl.jmx.TransactionModuleJMXRegistrator;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.data.impl.codec.CodecRegistry;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigTransactionControllerImpl
implements ConfigTransactionControllerInternal,
ConfigTransactionControllerImplMXBean,
Identifiable<TransactionIdentifier> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigTransactionControllerImpl.class);
    private final ConfigTransactionLookupRegistry txLookupRegistry;
    private final ObjectName controllerON;
    private final long parentVersion;
    private final long currentVersion;
    private final HierarchicalConfigMBeanFactoriesHolder factoriesHolder;
    private final DependencyResolverManager dependencyResolverManager;
    private final TransactionStatus transactionStatus;
    private final MBeanServer transactionsMBeanServer;
    private final Map<String, Map.Entry<ModuleFactory, BundleContext>> currentlyRegisteredFactories;
    @GuardedBy(value="this")
    private final AtomicBoolean configBeanModificationDisabled = new AtomicBoolean(false);
    private final ReadOnlyAtomicBoolean readOnlyAtomicBoolean = new ReadOnlyAtomicBoolean.ReadOnlyAtomicBooleanImpl(this.configBeanModificationDisabled);
    private final MBeanServer configMBeanServer;
    private final boolean blankTransaction;
    @GuardedBy(value="this")
    private final ServiceReferenceWritableRegistry writableSRRegistry;

    public ConfigTransactionControllerImpl(ConfigTransactionLookupRegistry txLookupRegistry, long parentVersion, CodecRegistry codecRegistry, long currentVersion, Map<String, Map.Entry<ModuleFactory, BundleContext>> currentlyRegisteredFactories, MBeanServer transactionsMBeanServer, MBeanServer configMBeanServer, boolean blankTransaction, ServiceReferenceWritableRegistry writableSRRegistry) {
        this.txLookupRegistry = txLookupRegistry;
        String transactionName = txLookupRegistry.getTransactionIdentifier().getName();
        this.controllerON = ObjectNameUtil.createTransactionControllerON((String)transactionName);
        this.parentVersion = parentVersion;
        this.currentVersion = currentVersion;
        this.currentlyRegisteredFactories = currentlyRegisteredFactories;
        this.factoriesHolder = new HierarchicalConfigMBeanFactoriesHolder(currentlyRegisteredFactories);
        this.transactionStatus = new TransactionStatus();
        this.dependencyResolverManager = new DependencyResolverManager(transactionName, this.transactionStatus, (ServiceReferenceReadableRegistry)writableSRRegistry, codecRegistry);
        this.transactionsMBeanServer = transactionsMBeanServer;
        this.configMBeanServer = configMBeanServer;
        this.blankTransaction = blankTransaction;
        this.writableSRRegistry = writableSRRegistry;
    }

    @Override
    public void copyExistingModulesAndProcessFactoryDiff(Collection<ModuleInternalInfo> existingModules, List<ModuleFactory> lastListOfFactories) {
        for (ModuleInternalInfo oldConfigInfo : existingModules) {
            try {
                this.copyExistingModule(oldConfigInfo);
            }
            catch (InstanceAlreadyExistsException e) {
                throw new IllegalStateException("Error while copying " + oldConfigInfo, e);
            }
        }
        this.processDefaultBeans(lastListOfFactories);
    }

    private synchronized void processDefaultBeans(List<ModuleFactory> lastListOfFactories) {
        this.transactionStatus.checkNotCommitStarted();
        this.transactionStatus.checkNotAborted();
        HashSet<ModuleFactory> oldSet = new HashSet<ModuleFactory>(lastListOfFactories);
        HashSet<ModuleFactory> newSet = new HashSet<ModuleFactory>(this.factoriesHolder.getModuleFactories());
        ArrayList<ModuleFactory> toBeAdded = new ArrayList<ModuleFactory>();
        ArrayList<ModuleFactory> toBeRemoved = new ArrayList<ModuleFactory>();
        for (ModuleFactory moduleFactory : this.factoriesHolder.getModuleFactories()) {
            if (oldSet.contains(moduleFactory)) continue;
            toBeAdded.add(moduleFactory);
        }
        for (ModuleFactory moduleFactory : lastListOfFactories) {
            if (newSet.contains(moduleFactory)) continue;
            toBeRemoved.add(moduleFactory);
        }
        for (ModuleFactory moduleFactory : toBeAdded) {
            Set defaultModules = moduleFactory.getDefaultModules((DependencyResolverFactory)this.dependencyResolverManager, this.getModuleFactoryBundleContext(moduleFactory.getImplementationName()));
            for (Module module : defaultModules) {
                DependencyResolverImpl dependencyResolver = this.dependencyResolverManager.getOrCreate((ModuleIdentifier)module.getIdentifier());
                try {
                    boolean defaultBean = true;
                    this.putConfigBeanToJMXAndInternalMaps((ModuleIdentifier)module.getIdentifier(), module, moduleFactory, null, dependencyResolver, defaultBean);
                }
                catch (InstanceAlreadyExistsException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        for (ModuleFactory removedFactory : toBeRemoved) {
            List<ModuleIdentifier> modulesOfRemovedFactory = this.dependencyResolverManager.findAllByFactory(removedFactory);
            for (ModuleIdentifier name : modulesOfRemovedFactory) {
                this.destroyModule(name);
            }
        }
    }

    private synchronized void copyExistingModule(ModuleInternalInfo oldConfigBeanInfo) throws InstanceAlreadyExistsException {
        Module module;
        this.transactionStatus.checkNotCommitStarted();
        this.transactionStatus.checkNotAborted();
        ModuleIdentifier moduleIdentifier = oldConfigBeanInfo.getIdentifier();
        this.dependencyResolverManager.assertNotExists(moduleIdentifier);
        ModuleFactory moduleFactory = this.factoriesHolder.findByModuleName(moduleIdentifier.getFactoryName());
        DependencyResolverImpl dependencyResolver = this.dependencyResolverManager.getOrCreate(moduleIdentifier);
        try {
            BundleContext bc = this.getModuleFactoryBundleContext(moduleFactory.getImplementationName());
            module = moduleFactory.createModule(moduleIdentifier.getInstanceName(), (DependencyResolver)dependencyResolver, (DynamicMBeanWithInstance)oldConfigBeanInfo.getReadableModule(), bc);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while copying old configuration from %s to %s", oldConfigBeanInfo, moduleFactory), e);
        }
        this.putConfigBeanToJMXAndInternalMaps(moduleIdentifier, module, moduleFactory, oldConfigBeanInfo, dependencyResolver, oldConfigBeanInfo.isDefaultBean());
    }

    public synchronized ObjectName createModule(String factoryName, String instanceName) throws InstanceAlreadyExistsException {
        this.transactionStatus.checkNotCommitStarted();
        this.transactionStatus.checkNotAborted();
        ModuleIdentifier moduleIdentifier = new ModuleIdentifier(factoryName, instanceName);
        this.dependencyResolverManager.assertNotExists(moduleIdentifier);
        ModuleFactory moduleFactory = this.factoriesHolder.findByModuleName(factoryName);
        DependencyResolverImpl dependencyResolver = this.dependencyResolverManager.getOrCreate(moduleIdentifier);
        Module module = moduleFactory.createModule(instanceName, (DependencyResolver)dependencyResolver, this.getModuleFactoryBundleContext(moduleFactory.getImplementationName()));
        boolean defaultBean = false;
        return this.putConfigBeanToJMXAndInternalMaps(moduleIdentifier, module, moduleFactory, null, dependencyResolver, defaultBean);
    }

    private synchronized ObjectName putConfigBeanToJMXAndInternalMaps(ModuleIdentifier moduleIdentifier, Module module, ModuleFactory moduleFactory, @Nullable ModuleInternalInfo maybeOldConfigBeanInfo, DependencyResolver dependencyResolver, boolean isDefaultBean) throws InstanceAlreadyExistsException {
        logger.debug("Adding module {} to transaction {}", (Object)moduleIdentifier, (Object)this);
        if (!moduleIdentifier.equals(module.getIdentifier())) {
            throw new IllegalStateException("Incorrect name reported by module. Expected " + moduleIdentifier + ", got " + module.getIdentifier());
        }
        if (!((ModuleIdentifier)dependencyResolver.getIdentifier()).equals((Object)moduleIdentifier)) {
            throw new IllegalStateException("Incorrect name reported by dependency resolver. Expected " + moduleIdentifier + ", got " + dependencyResolver.getIdentifier());
        }
        DynamicWritableWrapper writableDynamicWrapper = new DynamicWritableWrapper(module, moduleIdentifier, this.getTransactionIdentifier(), this.readOnlyAtomicBoolean, this.transactionsMBeanServer, this.configMBeanServer);
        ObjectName writableON = ObjectNameUtil.createTransactionModuleON((String)this.getTransactionIdentifier().getName(), (ModuleIdentifier)moduleIdentifier);
        TransactionModuleJMXRegistrator.TransactionModuleJMXRegistration transactionModuleJMXRegistration = this.getTxModuleJMXRegistrator().registerMBean(writableDynamicWrapper, writableON);
        ModuleInternalTransactionalInfo moduleInternalTransactionalInfo = new ModuleInternalTransactionalInfo(moduleIdentifier, module, moduleFactory, maybeOldConfigBeanInfo, transactionModuleJMXRegistration, isDefaultBean);
        this.dependencyResolverManager.put(moduleInternalTransactionalInfo);
        return writableON;
    }

    public synchronized void destroyModule(ObjectName objectName) throws InstanceNotFoundException {
        this.checkTransactionName(objectName);
        ObjectNameUtil.checkDomain((ObjectName)objectName);
        ModuleIdentifier moduleIdentifier = ObjectNameUtil.fromON((ObjectName)objectName, (String)"Module");
        this.destroyModule(moduleIdentifier);
    }

    private void checkTransactionName(ObjectName objectName) {
        String foundTransactionName = ObjectNameUtil.getTransactionName((ObjectName)objectName);
        if (!this.getTransactionIdentifier().getName().equals(foundTransactionName)) {
            throw new IllegalArgumentException("Wrong transaction name " + objectName);
        }
    }

    private synchronized void destroyModule(ModuleIdentifier moduleIdentifier) {
        ModuleInternalTransactionalInfo found;
        logger.debug("Destroying module {} in transaction {}", (Object)moduleIdentifier, (Object)this);
        this.transactionStatus.checkNotAborted();
        if (!this.blankTransaction && (found = this.dependencyResolverManager.findModuleInternalTransactionalInfo(moduleIdentifier)).isDefaultBean()) {
            logger.warn("Warning: removing default bean. This will be forbidden in next version of config-subsystem");
        }
        try {
            this.writableSRRegistry.removeServiceReferences(ObjectNameUtil.createTransactionModuleON((String)this.getTransactionName(), (ModuleIdentifier)moduleIdentifier));
        }
        catch (InstanceNotFoundException e) {
            logger.error("Possible code error: cannot find {} in {}", (Object)moduleIdentifier, (Object)this.writableSRRegistry);
            throw new IllegalStateException("Possible code error: cannot find " + moduleIdentifier, e);
        }
        ModuleInternalTransactionalInfo removedTInfo = this.dependencyResolverManager.destroyModule(moduleIdentifier);
        removedTInfo.getTransactionModuleJMXRegistration().close();
    }

    @Override
    public long getParentVersion() {
        return this.parentVersion;
    }

    @Override
    public long getVersion() {
        return this.currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void validateConfig() throws ValidationException {
        if (this.configBeanModificationDisabled.get()) {
            throw new IllegalStateException("Cannot start validation");
        }
        this.configBeanModificationDisabled.set(true);
        try {
            this.validate_noLocks();
        }
        finally {
            this.configBeanModificationDisabled.set(false);
        }
    }

    private void validate_noLocks() throws ValidationException {
        this.transactionStatus.checkNotAborted();
        logger.trace("Validating transaction {}", (Object)this.getTransactionIdentifier());
        ArrayList<ValidationException> collectedExceptions = new ArrayList<ValidationException>();
        for (Map.Entry<ModuleIdentifier, Module> entry : this.dependencyResolverManager.getAllModules().entrySet()) {
            ModuleIdentifier name = entry.getKey();
            Module module = entry.getValue();
            try {
                module.validate();
            }
            catch (Exception e) {
                logger.warn("Validation exception in {}", (Object)this.getTransactionName(), (Object)e);
                collectedExceptions.add(ValidationException.createForSingleException((ModuleIdentifier)name, (Exception)e));
            }
        }
        if (collectedExceptions.size() > 0) {
            throw ValidationException.createFromCollectedValidationExceptions(collectedExceptions);
        }
        logger.trace("Validated transaction {}", (Object)this.getTransactionIdentifier());
    }

    @Override
    public synchronized CommitInfo validateBeforeCommitAndLockTransaction() throws ValidationException {
        this.transactionStatus.checkNotAborted();
        this.transactionStatus.checkNotCommitStarted();
        this.configBeanModificationDisabled.set(true);
        try {
            this.validate_noLocks();
        }
        catch (ValidationException e) {
            logger.trace("Commit failed on validation");
            this.configBeanModificationDisabled.set(false);
            throw e;
        }
        this.transactionStatus.setSecondPhaseCommitStarted();
        return this.dependencyResolverManager.toCommitInfo();
    }

    @Override
    public synchronized List<ModuleIdentifier> secondPhaseCommit() {
        this.transactionStatus.checkNotAborted();
        this.transactionStatus.checkCommitStarted();
        if (!this.configBeanModificationDisabled.get()) {
            throw new IllegalStateException("Internal error - validateBeforeCommitAndLockTransaction should be called to obtain a lock");
        }
        logger.trace("Committing transaction {}", (Object)this.getTransactionIdentifier());
        for (Map.Entry<ModuleIdentifier, Module> entry : this.dependencyResolverManager.getAllModules().entrySet()) {
            Module module = entry.getValue();
            ModuleIdentifier name = entry.getKey();
            try {
                logger.debug("About to commit {} in transaction {}", (Object)name, (Object)this.getTransactionIdentifier());
                module.getInstance();
            }
            catch (Exception e) {
                logger.error("Commit failed on {} in transaction {}", new Object[]{name, this.getTransactionIdentifier(), e});
                this.internalAbort();
                throw new RuntimeException(String.format("Error - getInstance() failed for %s in transaction %s", name, this.getTransactionIdentifier()), e);
            }
        }
        logger.trace("Committed configuration {}", (Object)this.getTransactionIdentifier());
        this.transactionStatus.setCommitted();
        this.close();
        return this.dependencyResolverManager.getSortedModuleIdentifiers();
    }

    public synchronized void abortConfig() {
        this.transactionStatus.checkNotCommitStarted();
        this.transactionStatus.checkNotAborted();
        this.internalAbort();
    }

    private void internalAbort() {
        this.transactionStatus.setAborted();
        this.close();
    }

    public void close() {
        this.txLookupRegistry.close();
    }

    @Override
    public ObjectName getControllerObjectName() {
        return this.controllerON;
    }

    public String getTransactionName() {
        return this.getTransactionIdentifier().getName();
    }

    public Set<ObjectName> lookupConfigBeans() {
        return this.txLookupRegistry.lookupConfigBeans();
    }

    public Set<ObjectName> lookupConfigBeans(String moduleName) {
        return this.txLookupRegistry.lookupConfigBeans(moduleName);
    }

    public ObjectName lookupConfigBean(String moduleName, String instanceName) throws InstanceNotFoundException {
        return this.txLookupRegistry.lookupConfigBean(moduleName, instanceName);
    }

    public Set<ObjectName> lookupConfigBeans(String moduleName, String instanceName) {
        return this.txLookupRegistry.lookupConfigBeans(moduleName, instanceName);
    }

    public void checkConfigBeanExists(ObjectName objectName) throws InstanceNotFoundException {
        this.txLookupRegistry.checkConfigBeanExists(objectName);
    }

    public Set<String> getAvailableModuleNames() {
        return this.factoriesHolder.getModuleNames();
    }

    @Override
    public boolean isClosed() {
        return this.transactionStatus.isAbortedOrCommitted();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("transactionName=");
        sb.append(this.getTransactionName());
        return sb.toString();
    }

    TransactionModuleJMXRegistrator getTxModuleJMXRegistrator() {
        return this.txLookupRegistry.getTxModuleJMXRegistrator();
    }

    public TransactionIdentifier getName() {
        return this.getTransactionIdentifier();
    }

    @Override
    public List<ModuleFactory> getCurrentlyRegisteredFactories() {
        return new ArrayList<ModuleFactory>(this.factoriesHolder.getModuleFactories());
    }

    public TransactionIdentifier getIdentifier() {
        return this.getTransactionIdentifier();
    }

    @Override
    public BundleContext getModuleFactoryBundleContext(String factoryName) {
        Map.Entry<ModuleFactory, BundleContext> factoryBundleContextEntry = this.currentlyRegisteredFactories.get(factoryName);
        if (factoryBundleContextEntry == null || factoryBundleContextEntry.getValue() == null) {
            throw new NullPointerException("Bundle context of " + factoryName + " ModuleFactory not found.");
        }
        return factoryBundleContextEntry.getValue();
    }

    public synchronized ObjectName lookupConfigBeanByServiceInterfaceName(String serviceInterfaceQName, String refName) {
        return this.writableSRRegistry.lookupConfigBeanByServiceInterfaceName(serviceInterfaceQName, refName);
    }

    public synchronized Map<String, Map<String, ObjectName>> getServiceMapping() {
        return this.writableSRRegistry.getServiceMapping();
    }

    public synchronized Map<String, ObjectName> lookupServiceReferencesByServiceInterfaceName(String serviceInterfaceQName) {
        return this.writableSRRegistry.lookupServiceReferencesByServiceInterfaceName(serviceInterfaceQName);
    }

    public synchronized Set<String> lookupServiceInterfaceNames(ObjectName objectName) throws InstanceNotFoundException {
        return this.writableSRRegistry.lookupServiceInterfaceNames(objectName);
    }

    public synchronized String getServiceInterfaceName(String namespace, String localName) {
        return this.writableSRRegistry.getServiceInterfaceName(namespace, localName);
    }

    public synchronized ObjectName saveServiceReference(String serviceInterfaceName, String refName, ObjectName moduleON) throws InstanceNotFoundException {
        return this.writableSRRegistry.saveServiceReference(serviceInterfaceName, refName, moduleON);
    }

    public synchronized void removeServiceReference(String serviceInterfaceName, String refName) throws InstanceNotFoundException {
        this.writableSRRegistry.removeServiceReference(serviceInterfaceName, refName);
    }

    public synchronized void removeAllServiceReferences() {
        this.writableSRRegistry.removeAllServiceReferences();
    }

    public boolean removeServiceReferences(ObjectName objectName) throws InstanceNotFoundException {
        return this.writableSRRegistry.removeServiceReferences(objectName);
    }

    @Override
    public ServiceReferenceWritableRegistry getWritableRegistry() {
        return this.writableSRRegistry;
    }

    public TransactionIdentifier getTransactionIdentifier() {
        return this.txLookupRegistry.getTransactionIdentifier();
    }

    public Set<String> getAvailableModuleFactoryQNames() {
        return this.txLookupRegistry.getAvailableModuleFactoryQNames();
    }

    public void checkServiceReferenceExists(ObjectName objectName) throws InstanceNotFoundException {
        this.writableSRRegistry.checkServiceReferenceExists(objectName);
    }

    public ObjectName getServiceReference(String serviceInterfaceQName, String refName) throws InstanceNotFoundException {
        return this.writableSRRegistry.getServiceReference(serviceInterfaceQName, refName);
    }
}

