/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.ConflictingVersionException;
import org.opendaylight.controller.config.api.LookupRegistry;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.ServiceReferenceWritableRegistry;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.manager.impl.CloseableServiceReferenceReadableRegistry;
import org.opendaylight.controller.config.manager.impl.CommitInfo;
import org.opendaylight.controller.config.manager.impl.ConfigHolder;
import org.opendaylight.controller.config.manager.impl.ConfigRegistryImplMXBean;
import org.opendaylight.controller.config.manager.impl.ConfigTransactionControllerImpl;
import org.opendaylight.controller.config.manager.impl.ConfigTransactionControllerInternal;
import org.opendaylight.controller.config.manager.impl.ConfigTransactionLookupRegistry;
import org.opendaylight.controller.config.manager.impl.DestroyedModule;
import org.opendaylight.controller.config.manager.impl.ModuleInternalInfo;
import org.opendaylight.controller.config.manager.impl.ModuleInternalTransactionalInfo;
import org.opendaylight.controller.config.manager.impl.ServiceReferenceRegistryImpl;
import org.opendaylight.controller.config.manager.impl.TransactionIdentifier;
import org.opendaylight.controller.config.manager.impl.TransactionJMXRegistratorFactory;
import org.opendaylight.controller.config.manager.impl.TransactionsHolder;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.DynamicReadableWrapper;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.HierarchicalConfigMBeanFactoriesHolder;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.ModuleFactoriesResolver;
import org.opendaylight.controller.config.manager.impl.jmx.BaseJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.ModuleJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.RootRuntimeBeanRegistratorImpl;
import org.opendaylight.controller.config.manager.impl.jmx.TransactionJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.osgi.BeanToOsgiServiceManager;
import org.opendaylight.controller.config.manager.impl.util.LookupBeansUtil;
import org.opendaylight.controller.config.manager.impl.util.ModuleQNameUtil;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.yangtools.yang.data.impl.codec.CodecRegistry;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ConfigRegistryImpl
implements AutoCloseable,
ConfigRegistryImplMXBean {
    private static final Logger logger = LoggerFactory.getLogger(ConfigRegistryImpl.class);
    private final ModuleFactoriesResolver resolver;
    private final MBeanServer configMBeanServer;
    private final CodecRegistry codecRegistry;
    @GuardedBy(value="this")
    private long version = 0L;
    @GuardedBy(value="this")
    private long versionCounter = 0L;
    @GuardedBy(value="this")
    private final ConfigHolder currentConfig = new ConfigHolder();
    @GuardedBy(value="this")
    private boolean isHealthy = true;
    @GuardedBy(value="this")
    private final TransactionsHolder transactionsHolder = new TransactionsHolder();
    private final BaseJMXRegistrator baseJMXRegistrator;
    private final BeanToOsgiServiceManager beanToOsgiServiceManager;
    private final MBeanServer registryMBeanServer;
    private final MBeanServer transactionsMBeanServer;
    @GuardedBy(value="this")
    private List<ModuleFactory> lastListOfFactories = Collections.emptyList();
    @GuardedBy(value="this")
    private CloseableServiceReferenceReadableRegistry readableSRRegistry = ServiceReferenceRegistryImpl.createInitialSRLookupRegistry();

    public ConfigRegistryImpl(ModuleFactoriesResolver resolver, MBeanServer configMBeanServer, CodecRegistry codecRegistry) {
        this(resolver, configMBeanServer, new BaseJMXRegistrator(configMBeanServer), codecRegistry);
    }

    public ConfigRegistryImpl(ModuleFactoriesResolver resolver, MBeanServer configMBeanServer, BaseJMXRegistrator baseJMXRegistrator, CodecRegistry codecRegistry) {
        this.resolver = resolver;
        this.beanToOsgiServiceManager = new BeanToOsgiServiceManager();
        this.configMBeanServer = configMBeanServer;
        this.baseJMXRegistrator = baseJMXRegistrator;
        this.codecRegistry = codecRegistry;
        this.registryMBeanServer = MBeanServerFactory.createMBeanServer("ConfigRegistry" + configMBeanServer.getDefaultDomain());
        this.transactionsMBeanServer = MBeanServerFactory.createMBeanServer("ConfigTransactions" + configMBeanServer.getDefaultDomain());
    }

    public synchronized ObjectName beginConfig() {
        return this.beginConfig(false);
    }

    public synchronized ObjectName beginConfig(boolean blankTransaction) {
        return this.beginConfigInternal(blankTransaction).getControllerObjectName();
    }

    private synchronized ConfigTransactionControllerInternal beginConfigInternal(boolean blankTransaction) {
        ++this.versionCounter;
        final String transactionName = "ConfigTransaction-" + this.version + "-" + this.versionCounter;
        TransactionJMXRegistratorFactory factory = new TransactionJMXRegistratorFactory(){

            @Override
            public TransactionJMXRegistrator create() {
                return ConfigRegistryImpl.this.baseJMXRegistrator.createTransactionJMXRegistrator(transactionName);
            }
        };
        Map<String, Map.Entry<ModuleFactory, BundleContext>> allCurrentFactories = Collections.unmodifiableMap(this.resolver.getAllFactories());
        ConfigTransactionLookupRegistry txLookupRegistry = new ConfigTransactionLookupRegistry(new TransactionIdentifier(transactionName), factory, allCurrentFactories);
        ServiceReferenceWritableRegistry writableRegistry = ServiceReferenceRegistryImpl.createSRWritableRegistry(this.readableSRRegistry, txLookupRegistry, allCurrentFactories);
        ConfigTransactionControllerImpl transactionController = new ConfigTransactionControllerImpl(txLookupRegistry, this.version, this.codecRegistry, this.versionCounter, allCurrentFactories, this.transactionsMBeanServer, this.configMBeanServer, blankTransaction, writableRegistry);
        try {
            txLookupRegistry.registerMBean(transactionController, transactionController.getControllerObjectName());
        }
        catch (InstanceAlreadyExistsException e) {
            throw new IllegalStateException(e);
        }
        transactionController.copyExistingModulesAndProcessFactoryDiff(this.currentConfig.getEntries(), this.lastListOfFactories);
        this.transactionsHolder.add(transactionName, transactionController);
        return transactionController;
    }

    public synchronized CommitStatus commitConfig(ObjectName transactionControllerON) throws ConflictingVersionException, ValidationException {
        String transactionName = ObjectNameUtil.getTransactionName((ObjectName)transactionControllerON);
        logger.trace("About to commit {}. Current parentVersion: {}, versionCounter {}", new Object[]{transactionName, this.version, this.versionCounter});
        Map<String, ConfigTransactionControllerInternal> transactions = this.transactionsHolder.getCurrentTransactions();
        ConfigTransactionControllerInternal configTransactionController = transactions.get(transactionName);
        if (configTransactionController == null) {
            throw new IllegalArgumentException(String.format("Transaction with name '%s' not found", transactionName));
        }
        if (this.version != configTransactionController.getParentVersion()) {
            throw new ConflictingVersionException(String.format("Optimistic lock failed. Expected parent version %d, was %d", this.version, configTransactionController.getParentVersion()));
        }
        CommitInfo commitInfo = configTransactionController.validateBeforeCommitAndLockTransaction();
        this.lastListOfFactories = Collections.unmodifiableList(configTransactionController.getCurrentlyRegisteredFactories());
        try {
            return this.secondPhaseCommit(configTransactionController, commitInfo);
        }
        catch (Throwable t) {
            this.isHealthy = false;
            logger.error("Configuration Transaction failed on 2PC, server is unhealthy", t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
    }

    private CommitStatus secondPhaseCommit(ConfigTransactionControllerInternal configTransactionController, CommitInfo commitInfo) {
        for (DestroyedModule toBeDestroyed : commitInfo.getDestroyedFromPreviousTransactions()) {
            toBeDestroyed.close();
            this.currentConfig.remove(toBeDestroyed.getIdentifier());
        }
        HashMap<ModuleIdentifier, RootRuntimeBeanRegistratorImpl> runtimeRegistrators = new HashMap<ModuleIdentifier, RootRuntimeBeanRegistratorImpl>();
        for (ModuleInternalTransactionalInfo entry : commitInfo.getCommitted().values()) {
            RootRuntimeBeanRegistratorImpl runtimeBeanRegistrator = !entry.hasOldModule() ? this.baseJMXRegistrator.createRuntimeBeanRegistrator(entry.getIdentifier()) : entry.getOldInternalInfo().getRuntimeBeanRegistrator();
            Module module = entry.getModule();
            if (module instanceof RuntimeBeanRegistratorAwareModule) {
                ((RuntimeBeanRegistratorAwareModule)module).setRuntimeBeanRegistrator((RootRuntimeBeanRegistrator)runtimeBeanRegistrator);
            }
            runtimeRegistrators.put(entry.getIdentifier(), runtimeBeanRegistrator);
        }
        List<ModuleIdentifier> orderedModuleIdentifiers = configTransactionController.secondPhaseCommit();
        LinkedList<ObjectName> newInstances = new LinkedList<ObjectName>();
        LinkedList<ObjectName> reusedInstances = new LinkedList<ObjectName>();
        LinkedList<ObjectName> recreatedInstances = new LinkedList<ObjectName>();
        HashMap<Module, ModuleInternalInfo> newConfigEntries = new HashMap<Module, ModuleInternalInfo>();
        int orderingIdx = 0;
        for (ModuleIdentifier moduleIdentifier : orderedModuleIdentifiers) {
            ModuleInternalTransactionalInfo entry = commitInfo.getCommitted().get(moduleIdentifier);
            if (entry == null) {
                throw new NullPointerException("Module not found " + moduleIdentifier);
            }
            Module module = entry.getModule();
            ObjectName primaryReadOnlyON = ObjectNameUtil.createReadOnlyModuleON((ModuleIdentifier)moduleIdentifier);
            ModuleJMXRegistrator newModuleJMXRegistrator = this.baseJMXRegistrator.createModuleJMXRegistrator();
            BeanToOsgiServiceManager.OsgiRegistration osgiRegistration = null;
            if (entry.hasOldModule()) {
                ModuleInternalInfo oldInternalInfo = entry.getOldInternalInfo();
                DynamicReadableWrapper oldReadableConfigBean = oldInternalInfo.getReadableModule();
                this.currentConfig.remove(entry.getIdentifier());
                if (oldReadableConfigBean.getInstance().equals(module.getInstance())) {
                    reusedInstances.add(primaryReadOnlyON);
                    osgiRegistration = oldInternalInfo.getOsgiRegistration();
                } else {
                    recreatedInstances.add(primaryReadOnlyON);
                    oldInternalInfo.getOsgiRegistration().close();
                }
                oldInternalInfo.getModuleJMXRegistrator().close();
            } else {
                newInstances.add(primaryReadOnlyON);
            }
            DynamicReadableWrapper newReadableConfigBean = new DynamicReadableWrapper(module, module.getInstance(), moduleIdentifier, this.registryMBeanServer, this.configMBeanServer);
            try {
                newModuleJMXRegistrator.registerMBean(newReadableConfigBean, primaryReadOnlyON);
            }
            catch (InstanceAlreadyExistsException e) {
                throw new IllegalStateException(e);
            }
            if (osgiRegistration == null) {
                ModuleFactory moduleFactory = entry.getModuleFactory();
                if (moduleFactory != null) {
                    BundleContext bc = configTransactionController.getModuleFactoryBundleContext(moduleFactory.getImplementationName());
                    osgiRegistration = this.beanToOsgiServiceManager.registerToOsgi(module.getClass(), newReadableConfigBean.getInstance(), entry.getIdentifier(), bc);
                } else {
                    throw new NullPointerException(entry.getIdentifier().getFactoryName() + " ModuleFactory not found.");
                }
            }
            RootRuntimeBeanRegistratorImpl runtimeBeanRegistrator = (RootRuntimeBeanRegistratorImpl)runtimeRegistrators.get(entry.getIdentifier());
            ModuleInternalInfo newInfo = new ModuleInternalInfo(entry.getIdentifier(), newReadableConfigBean, osgiRegistration, runtimeBeanRegistrator, newModuleJMXRegistrator, orderingIdx, entry.isDefaultBean());
            newConfigEntries.put(module, newInfo);
            ++orderingIdx;
        }
        this.currentConfig.addAll(newConfigEntries.values());
        this.version = configTransactionController.getVersion();
        this.readableSRRegistry.close();
        this.readableSRRegistry = ServiceReferenceRegistryImpl.createSRReadableRegistry(configTransactionController.getWritableRegistry(), (LookupRegistry)this, this.baseJMXRegistrator);
        return new CommitStatus(newInstances, reusedInstances, recreatedInstances);
    }

    public synchronized List<ObjectName> getOpenConfigs() {
        Map<String, ConfigTransactionControllerInternal> transactions = this.transactionsHolder.getCurrentTransactions();
        ArrayList<ObjectName> result = new ArrayList<ObjectName>(transactions.size());
        for (ConfigTransactionControllerInternal configTransactionController : transactions.values()) {
            result.add(configTransactionController.getControllerObjectName());
        }
        return result;
    }

    @Override
    public synchronized void close() {
        Map<String, ConfigTransactionControllerInternal> transactions = this.transactionsHolder.getCurrentTransactions();
        for (ConfigTransactionControllerInternal configTransactionController : transactions.values()) {
            try {
                configTransactionController.abortConfig();
            }
            catch (RuntimeException e) {
                logger.warn("Ignoring exception while aborting {}", (Object)configTransactionController, (Object)e);
            }
        }
        List<DestroyedModule> destroyedModules = this.currentConfig.getModulesToBeDestroyed();
        for (DestroyedModule destroyedModule : destroyedModules) {
            destroyedModule.close();
        }
        this.baseJMXRegistrator.close();
        MBeanServerFactory.releaseMBeanServer(this.registryMBeanServer);
        MBeanServerFactory.releaseMBeanServer(this.transactionsMBeanServer);
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    public Set<String> getAvailableModuleNames() {
        return new HierarchicalConfigMBeanFactoriesHolder(this.resolver.getAllFactories()).getModuleNames();
    }

    public boolean isHealthy() {
        return this.isHealthy;
    }

    public Set<ObjectName> lookupConfigBeans() {
        return this.lookupConfigBeans("*", "*");
    }

    public Set<ObjectName> lookupConfigBeans(String moduleName) {
        return this.lookupConfigBeans(moduleName, "*");
    }

    public ObjectName lookupConfigBean(String moduleName, String instanceName) throws InstanceNotFoundException {
        return LookupBeansUtil.lookupConfigBean((LookupRegistry)this, moduleName, instanceName);
    }

    public Set<ObjectName> lookupConfigBeans(String moduleName, String instanceName) {
        ObjectName namePattern = ObjectNameUtil.createModulePattern((String)moduleName, (String)instanceName);
        return this.baseJMXRegistrator.queryNames(namePattern, null);
    }

    public Set<ObjectName> lookupRuntimeBeans() {
        return this.lookupRuntimeBeans("*", "*");
    }

    public Set<ObjectName> lookupRuntimeBeans(String moduleName, String instanceName) {
        if (moduleName == null) {
            moduleName = "*";
        }
        if (instanceName == null) {
            instanceName = "*";
        }
        ObjectName namePattern = ObjectNameUtil.createRuntimeBeanPattern((String)moduleName, (String)instanceName);
        return this.baseJMXRegistrator.queryNames(namePattern, null);
    }

    public void checkConfigBeanExists(ObjectName objectName) throws InstanceNotFoundException {
        ObjectNameUtil.checkDomain((ObjectName)objectName);
        ObjectNameUtil.checkType((ObjectName)objectName, (String)"Module");
        String transactionName = ObjectNameUtil.getTransactionName((ObjectName)objectName);
        if (transactionName != null) {
            throw new IllegalArgumentException("Transaction attribute not supported in registry, wrong ObjectName: " + objectName);
        }
        LookupBeansUtil.lookupConfigBean((LookupRegistry)this, ObjectNameUtil.getFactoryName((ObjectName)objectName), ObjectNameUtil.getInstanceName((ObjectName)objectName));
    }

    public synchronized ObjectName lookupConfigBeanByServiceInterfaceName(String serviceInterfaceQName, String refName) {
        return this.readableSRRegistry.lookupConfigBeanByServiceInterfaceName(serviceInterfaceQName, refName);
    }

    public synchronized Map<String, Map<String, ObjectName>> getServiceMapping() {
        return this.readableSRRegistry.getServiceMapping();
    }

    public synchronized Map<String, ObjectName> lookupServiceReferencesByServiceInterfaceName(String serviceInterfaceQName) {
        return this.readableSRRegistry.lookupServiceReferencesByServiceInterfaceName(serviceInterfaceQName);
    }

    public synchronized Set<String> lookupServiceInterfaceNames(ObjectName objectName) throws InstanceNotFoundException {
        return this.readableSRRegistry.lookupServiceInterfaceNames(objectName);
    }

    public synchronized String getServiceInterfaceName(String namespace, String localName) {
        return this.readableSRRegistry.getServiceInterfaceName(namespace, localName);
    }

    public void checkServiceReferenceExists(ObjectName objectName) throws InstanceNotFoundException {
        this.readableSRRegistry.checkServiceReferenceExists(objectName);
    }

    public ObjectName getServiceReference(String serviceInterfaceQName, String refName) throws InstanceNotFoundException {
        return this.readableSRRegistry.getServiceReference(serviceInterfaceQName, refName);
    }

    public Set<String> getAvailableModuleFactoryQNames() {
        return ModuleQNameUtil.getQNames(this.resolver.getAllFactories());
    }

    public String toString() {
        return "ConfigRegistryImpl{versionCounter=" + this.versionCounter + ", version=" + this.version + '}';
    }
}

