/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.manager.impl.DestroyedModule;
import org.opendaylight.controller.config.manager.impl.ModuleInternalInfo;

@NotThreadSafe
class ConfigHolder {
    private final Map<ModuleIdentifier, ModuleInternalInfo> currentConfig = new HashMap<ModuleIdentifier, ModuleInternalInfo>();

    ConfigHolder() {
    }

    public void addAll(Collection<ModuleInternalInfo> configInfos) {
        if (this.currentConfig.size() > 0) {
            throw new IllegalStateException("Error - some config entries were not removed: " + this.currentConfig);
        }
        for (ModuleInternalInfo configInfo : configInfos) {
            this.add(configInfo);
        }
    }

    private void add(ModuleInternalInfo configInfo) {
        ModuleInternalInfo oldValue = this.currentConfig.put(configInfo.getIdentifier(), configInfo);
        if (oldValue != null) {
            throw new IllegalStateException("Cannot overwrite module with same name:" + configInfo.getIdentifier() + ":" + configInfo);
        }
    }

    public void remove(ModuleIdentifier name) {
        ModuleInternalInfo removed = this.currentConfig.remove(name);
        if (removed == null) {
            throw new IllegalStateException("Cannot remove from ConfigHolder - name not found:" + name);
        }
    }

    public Collection<ModuleInternalInfo> getEntries() {
        return this.currentConfig.values();
    }

    public List<DestroyedModule> getModulesToBeDestroyed() {
        ArrayList<DestroyedModule> result = new ArrayList<DestroyedModule>();
        for (ModuleInternalInfo moduleInternalInfo : this.getEntries()) {
            result.add(moduleInternalInfo.toDestroyedModule());
        }
        Collections.sort(result);
        return result;
    }
}

