/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.api;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class AbstractBrokerAwareActivator
implements BundleActivator {
    private static final ExecutorService mdActivationPool = Executors.newCachedThreadPool();
    private BundleContext context;
    private ServiceTracker<BindingAwareBroker, BindingAwareBroker> tracker;
    private BindingAwareBroker broker;
    private ServiceTrackerCustomizer<BindingAwareBroker, BindingAwareBroker> customizer = new ServiceTrackerCustomizer<BindingAwareBroker, BindingAwareBroker>(){

        public BindingAwareBroker addingService(ServiceReference<BindingAwareBroker> reference) {
            AbstractBrokerAwareActivator.this.broker = (BindingAwareBroker)AbstractBrokerAwareActivator.this.context.getService(reference);
            mdActivationPool.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractBrokerAwareActivator.this.onBrokerAvailable(AbstractBrokerAwareActivator.this.broker, AbstractBrokerAwareActivator.this.context);
                }
            });
            return AbstractBrokerAwareActivator.this.broker;
        }

        public void modifiedService(ServiceReference<BindingAwareBroker> reference, BindingAwareBroker service) {
        }

        public void removedService(ServiceReference<BindingAwareBroker> reference, BindingAwareBroker service) {
        }
    };

    public final void start(BundleContext context) throws Exception {
        this.context = context;
        this.startImpl(context);
        this.tracker = new ServiceTracker(context, BindingAwareBroker.class, this.customizer);
        this.tracker.open();
    }

    public final void stop(BundleContext context) throws Exception {
        this.tracker.close();
        this.stopImpl(context);
    }

    protected void startImpl(BundleContext context) {
    }

    protected void stopImpl(BundleContext context) {
    }

    protected abstract void onBrokerAvailable(BindingAwareBroker var1, BundleContext var2);

    protected void onBrokerRemoved(BindingAwareBroker broker, BundleContext context) {
    }
}

