/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.api;

import java.util.Collection;
import java.util.Collections;
import org.opendaylight.controller.sal.binding.api.AbstractBrokerAwareActivator;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareProvider;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.osgi.framework.BundleContext;

public abstract class AbstractBindingAwareProvider
extends AbstractBrokerAwareActivator
implements BindingAwareProvider {
    @Override
    protected final void onBrokerAvailable(BindingAwareBroker broker, BundleContext context) {
        BindingAwareBroker.ProviderContext ctx = broker.registerProvider(this, context);
        this.registerRpcImplementations(ctx);
        this.registerFunctionality(ctx);
    }

    private void registerFunctionality(BindingAwareBroker.ProviderContext ctx) {
        Collection<? extends BindingAwareProvider.ProviderFunctionality> functionality = this.getFunctionality();
        if (functionality == null || functionality.isEmpty()) {
            return;
        }
        for (BindingAwareProvider.ProviderFunctionality providerFunctionality : functionality) {
            ctx.registerFunctionality(providerFunctionality);
        }
    }

    private void registerRpcImplementations(BindingAwareBroker.ProviderContext ctx) {
        Collection<? extends RpcService> rpcs = this.getImplementations();
        if (rpcs == null || rpcs.isEmpty()) {
            return;
        }
        for (RpcService rpcService : rpcs) {
        }
    }

    @Override
    public Collection<? extends BindingAwareProvider.ProviderFunctionality> getFunctionality() {
        return Collections.emptySet();
    }

    @Override
    public Collection<? extends RpcService> getImplementations() {
        return Collections.emptySet();
    }

    @Override
    @Deprecated
    public final void onSessionInitialized(BindingAwareBroker.ConsumerContext session) {
    }
}

