/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.compatibility.topology;

import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandler;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.opendaylight.controller.sal.compatibility.topology.TopologyCommitHandler;
import org.opendaylight.controller.sal.topology.IPluginOutTopologyService;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyProvider
implements AutoCloseable {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(TopologyProvider.class);
            return _logger;
        }
    }.apply();
    private TopologyCommitHandler commitHandler;
    private IPluginOutTopologyService _topologyPublisher;
    private DataProviderService _dataService;
    private Registration<DataCommitHandler<InstanceIdentifier<? extends DataObject>, DataObject>> commitHandlerRegistration;

    public IPluginOutTopologyService getTopologyPublisher() {
        return this._topologyPublisher;
    }

    public DataProviderService getDataService() {
        return this._dataService;
    }

    public void setDataService(DataProviderService dataService) {
        this._dataService = dataService;
    }

    public void start() {
        Registration _registerCommitHandler;
        TopologyCommitHandler _topologyCommitHandler;
        DataProviderService _dataService = this.getDataService();
        this.commitHandler = _topologyCommitHandler = new TopologyCommitHandler(_dataService);
        IPluginOutTopologyService _topologyPublisher = this.getTopologyPublisher();
        this.commitHandler.setTopologyPublisher(_topologyPublisher);
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(NetworkTopology.class);
        TopologyId _topologyId = new TopologyId("flow:1");
        TopologyKey _topologyKey = new TopologyKey(_topologyId);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(Topology.class, (Identifier)_topologyKey);
        InstanceIdentifier.InstanceIdentifierBuilder _child_1 = _child.child(Link.class);
        InstanceIdentifier path = (InstanceIdentifier)_child_1.toInstance();
        DataProviderService _dataService_1 = this.getDataService();
        this.commitHandlerRegistration = _registerCommitHandler = _dataService_1.registerCommitHandler((Path)path, (DataCommitHandler)this.commitHandler);
        LOG.info("TopologyProvider started");
    }

    @Override
    public void close() throws Exception {
        this.commitHandlerRegistration.close();
    }

    public void setTopologyPublisher(IPluginOutTopologyService topologyPublisher) {
        this._topologyPublisher = topologyPublisher;
        this.commitHandler.setTopologyPublisher(topologyPublisher);
    }
}

