/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.compatibility.topology;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.md.sal.binding.util.TypeSafeDataReader;
import org.opendaylight.controller.sal.compatibility.NodeMapping;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.topology.TopoEdgeUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TpId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Destination;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Source;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyMapping {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(TopologyMapping.class);
            return _logger;
        }
    }.apply();

    private TopologyMapping() {
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("Utility class. Instantiation is not allowed.");
        throw _unsupportedOperationException;
    }

    public static List<TopoEdgeUpdate> toADEdgeUpdates(final Topology topology, final TypeSafeDataReader reader) {
        CopyOnWriteArrayList _copyOnWriteArrayList;
        CopyOnWriteArrayList result = _copyOnWriteArrayList = new CopyOnWriteArrayList();
        List _link = topology.getLink();
        FluentIterable _from = FluentIterable.from((Iterable)_link);
        Function<Link, TopoEdgeUpdate> _function = new Function<Link, TopoEdgeUpdate>(){

            public TopoEdgeUpdate apply(Link it) {
                Edge _adEdge = TopologyMapping.toAdEdge(it, topology);
                TopoEdgeUpdate _topoEdgeUpdate = TopologyMapping.toTopoEdgeUpdate(_adEdge, reader);
                return _topoEdgeUpdate;
            }
        };
        FluentIterable _transform = _from.transform((Function)_function);
        return (List)_transform.copyInto(result);
    }

    public static Edge toAdEdge(Link link, Topology topology) {
        try {
            Source _source = link.getSource();
            TpId _sourceTp = _source.getSourceTp();
            Source _source_1 = link.getSource();
            NodeId _sourceNode = _source_1.getSourceNode();
            NodeConnector adSrc = TopologyMapping.toADNodeConnector(_sourceTp, _sourceNode);
            Destination _destination = link.getDestination();
            TpId _destTp = _destination.getDestTp();
            Destination _destination_1 = link.getDestination();
            NodeId _destNode = _destination_1.getDestNode();
            NodeConnector adDst = TopologyMapping.toADNodeConnector(_destTp, _destNode);
            try {
                Edge _edge = new Edge(adSrc, adDst);
                return _edge;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        catch (Throwable _e_1) {
            throw Exceptions.sneakyThrow((Throwable)_e_1);
        }
    }

    public static TopoEdgeUpdate toTopoEdgeUpdate(Edge e, TypeSafeDataReader reader) {
        return TopologyMapping.toTopoEdgeUpdate(e, UpdateType.ADDED, reader);
    }

    public static TopoEdgeUpdate toTopoEdgeUpdate(Edge e, UpdateType type, TypeSafeDataReader reader) {
        HashSet<Property> _adEdgeProperties = TopologyMapping.toAdEdgeProperties(e, reader);
        TopoEdgeUpdate _topoEdgeUpdate = new TopoEdgeUpdate(e, _adEdgeProperties, type);
        return _topoEdgeUpdate;
    }

    public static HashSet<Property> toAdEdgeProperties(Edge e, TypeSafeDataReader reader) {
        NodeConnector _tailNodeConnector = e.getTailNodeConnector();
        NodeConnectorRef ncref = NodeMapping.toNodeConnectorRef(_tailNodeConnector);
        boolean _equals = Objects.equal((Object)ncref, null);
        if (_equals) {
            LOG.debug("Edge {} ncref {}", (Object)e, (Object)ncref);
            return null;
        }
        InstanceIdentifier _value = ncref.getValue();
        InstanceIdentifier ncInstanceId = _value;
        boolean _equals_1 = Objects.equal((Object)ncInstanceId, null);
        if (_equals_1) {
            LOG.debug("Edge {} ncref {}", (Object)e, (Object)ncref);
            return null;
        }
        org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector nc = (org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector)reader.readOperationalData(ncInstanceId);
        boolean _equals_2 = Objects.equal((Object)nc, null);
        if (_equals_2) {
            return null;
        }
        return NodeMapping.toADNodeConnectorProperties(nc);
    }

    public static String toADNodeId(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId);
        return nodeId.getValue();
    }

    public static NodeConnector toADNodeConnector(TpId source, NodeId nodeId) throws ConstructionException {
        Preconditions.checkNotNull((Object)source);
        String _aDNodeConnectorId = TopologyMapping.toADNodeConnectorId(source);
        Node _aDNode = TopologyMapping.toADNode(nodeId);
        NodeConnector _nodeConnector = new NodeConnector("MD_SAL", (Object)_aDNodeConnectorId, _aDNode);
        return _nodeConnector;
    }

    public static String toADNodeConnectorId(TpId nodeConnectorId) {
        return nodeConnectorId.getValue();
    }

    public static Node toADNode(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId);
        try {
            String _aDNodeId = TopologyMapping.toADNodeId(nodeId);
            Node _node = new Node("MD_SAL", (Object)_aDNodeId);
            return _node;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

