/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.compatibility.topology;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.md.sal.binding.util.TypeSafeDataReader;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandler;
import org.opendaylight.controller.md.sal.common.api.data.DataModification;
import org.opendaylight.controller.md.sal.common.api.data.DataReader;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.opendaylight.controller.sal.compatibility.topology.TopologyMapping;
import org.opendaylight.controller.sal.compatibility.topology.TopologyTransaction;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.topology.IPluginOutTopologyService;
import org.opendaylight.controller.sal.topology.TopoEdgeUpdate;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyCommitHandler
implements DataCommitHandler<InstanceIdentifier<? extends DataObject>, DataObject> {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(TopologyCommitHandler.class);
            return _logger;
        }
    }.apply();
    private IPluginOutTopologyService _topologyPublisher;
    private DataProviderService _dataService;

    public IPluginOutTopologyService getTopologyPublisher() {
        return this._topologyPublisher;
    }

    public void setTopologyPublisher(IPluginOutTopologyService topologyPublisher) {
        this._topologyPublisher = topologyPublisher;
    }

    public DataProviderService getDataService() {
        return this._dataService;
    }

    public void setDataService(DataProviderService dataService) {
        this._dataService = dataService;
    }

    public TopologyCommitHandler(DataProviderService dataService) {
        IPluginOutTopologyService _topologyPublisher;
        this._topologyPublisher = _topologyPublisher = this.getTopologyPublisher();
        this._dataService = dataService;
    }

    public DataCommitHandler.DataCommitTransaction<InstanceIdentifier<? extends DataObject>, DataObject> requestCommit(final DataModification<InstanceIdentifier<? extends DataObject>, DataObject> modification) {
        CopyOnWriteArrayList<TopoEdgeUpdate> _copyOnWriteArrayList;
        CopyOnWriteArrayList<TopoEdgeUpdate> msg = _copyOnWriteArrayList = new CopyOnWriteArrayList<TopoEdgeUpdate>();
        try {
            DataProviderService _dataService = this.getDataService();
            final TypeSafeDataReader reader = TypeSafeDataReader.forReader((DataReader)_dataService);
            InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(NetworkTopology.class);
            TopologyId _topologyId = new TopologyId("flow:1");
            TopologyKey _topologyKey = new TopologyKey(_topologyId);
            InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(Topology.class, (Identifier)_topologyKey);
            InstanceIdentifier topologyPath = (InstanceIdentifier)_child.toInstance();
            final Topology topology = (Topology)reader.readOperationalData(topologyPath);
            Map _createdOperationalData = modification.getCreatedOperationalData();
            Set _entrySet = _createdOperationalData.entrySet();
            FluentIterable _from = FluentIterable.from(_entrySet);
            Predicate<Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject>> _function = new Predicate<Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject>>(){

                public boolean apply(Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject> it) {
                    DataObject _value = it.getValue();
                    return _value instanceof Link;
                }
            };
            FluentIterable _filter = _from.filter((Predicate)_function);
            Function<Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject>, TopoEdgeUpdate> _function_1 = new Function<Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject>, TopoEdgeUpdate>(){

                public TopoEdgeUpdate apply(Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject> it) {
                    DataObject _value = it.getValue();
                    Edge _adEdge = TopologyMapping.toAdEdge((Link)_value, topology);
                    TopoEdgeUpdate _topoEdgeUpdate = TopologyMapping.toTopoEdgeUpdate(_adEdge, UpdateType.ADDED, reader);
                    return _topoEdgeUpdate;
                }
            };
            FluentIterable _transform = _filter.transform((Function)_function_1);
            ImmutableList adds = _transform.toList();
            Map _updatedOperationalData = modification.getUpdatedOperationalData();
            Set _entrySet_1 = _updatedOperationalData.entrySet();
            FluentIterable _from_1 = FluentIterable.from(_entrySet_1);
            Predicate<Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject>> _function_2 = new Predicate<Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject>>(){

                public boolean apply(Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject> it) {
                    boolean _not;
                    InstanceIdentifier<? extends DataObject> _key;
                    boolean _and = false;
                    Map _createdOperationalData = modification.getCreatedOperationalData();
                    boolean _containsKey = _createdOperationalData.containsKey(_key = it.getKey());
                    boolean bl = _not = !_containsKey;
                    if (!_not) {
                        _and = false;
                    } else {
                        DataObject _value = it.getValue();
                        _and = _not && _value instanceof Link;
                    }
                    return _and;
                }
            };
            FluentIterable _filter_1 = _from_1.filter((Predicate)_function_2);
            Function<Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject>, TopoEdgeUpdate> _function_3 = new Function<Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject>, TopoEdgeUpdate>(){

                public TopoEdgeUpdate apply(Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject> it) {
                    DataObject _value = it.getValue();
                    Edge _adEdge = TopologyMapping.toAdEdge((Link)_value, topology);
                    TopoEdgeUpdate _topoEdgeUpdate = TopologyMapping.toTopoEdgeUpdate(_adEdge, UpdateType.ADDED, reader);
                    return _topoEdgeUpdate;
                }
            };
            FluentIterable _transform_1 = _filter_1.transform((Function)_function_3);
            ImmutableList updates = _transform_1.toList();
            Set _removedOperationalData = modification.getRemovedOperationalData();
            FluentIterable _from_2 = FluentIterable.from((Iterable)_removedOperationalData);
            Function<InstanceIdentifier<? extends DataObject>, DataObject> _function_4 = new Function<InstanceIdentifier<? extends DataObject>, DataObject>(){

                public DataObject apply(InstanceIdentifier<? extends DataObject> it) {
                    DataObject _readOperationalData = reader.readOperationalData(it);
                    return _readOperationalData;
                }
            };
            FluentIterable _transform_2 = _from_2.transform((Function)_function_4);
            Predicate<DataObject> _function_5 = new Predicate<DataObject>(){

                public boolean apply(DataObject it) {
                    return it instanceof Link;
                }
            };
            FluentIterable _filter_2 = _transform_2.filter((Predicate)_function_5);
            Function<DataObject, TopoEdgeUpdate> _function_6 = new Function<DataObject, TopoEdgeUpdate>(){

                public TopoEdgeUpdate apply(DataObject it) {
                    Edge _adEdge = TopologyMapping.toAdEdge((Link)it, topology);
                    TopoEdgeUpdate _topoEdgeUpdate = TopologyMapping.toTopoEdgeUpdate(_adEdge, UpdateType.REMOVED, reader);
                    return _topoEdgeUpdate;
                }
            };
            FluentIterable _transform_3 = _filter_2.transform((Function)_function_6);
            ImmutableList removes = _transform_3.toList();
            msg.addAll((Collection<TopoEdgeUpdate>)adds);
            msg.addAll((Collection<TopoEdgeUpdate>)updates);
            msg.addAll((Collection<TopoEdgeUpdate>)removes);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                LOG.error("Exception caught", (Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        IPluginOutTopologyService _topologyPublisher = this.getTopologyPublisher();
        DataProviderService _dataService_1 = this.getDataService();
        TopologyTransaction _topologyTransaction = new TopologyTransaction(modification, _topologyPublisher, _dataService_1, msg);
        return _topologyTransaction;
    }
}

