/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.compatibility.adsal;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.common.util.Futures;
import org.opendaylight.controller.sal.common.util.Rpcs;
import org.opendaylight.controller.sal.compatibility.FromSalConversionsUtils;
import org.opendaylight.controller.sal.compatibility.InventoryMapping;
import org.opendaylight.controller.sal.compatibility.NodeMapping;
import org.opendaylight.controller.sal.compatibility.ToSalConversionsUtils;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.reader.FlowOnNode;
import org.opendaylight.controller.sal.reader.IReadService;
import org.opendaylight.controller.sal.reader.IReadServiceListener;
import org.opendaylight.controller.sal.reader.NodeConnectorStatistics;
import org.opendaylight.controller.sal.reader.NodeDescription;
import org.opendaylight.controller.sal.reader.NodeTableStatistics;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter32;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.FlowsStatisticsUpdateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAggregateFlowStatisticsFromFlowTableForAllFlowsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAggregateFlowStatisticsFromFlowTableForAllFlowsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAggregateFlowStatisticsFromFlowTableForGivenMatchInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAggregateFlowStatisticsFromFlowTableForGivenMatchOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowStatisticsFromFlowTableInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowStatisticsFromFlowTableOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowStatisticsFromFlowTableOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowsStatisticsFromAllFlowTablesInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowsStatisticsFromAllFlowTablesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowsStatisticsFromAllFlowTablesOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetFlowStatisticsFromFlowTableInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetFlowStatisticsFromFlowTableOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetFlowStatisticsFromFlowTableOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.OpendaylightFlowStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.flow.and.statistics.map.list.FlowAndStatisticsMapList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.flow.and.statistics.map.list.FlowAndStatisticsMapListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.FlowTableStatisticsUpdateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.flow.table.and.statistics.map.FlowTableAndStatisticsMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.flow.table.and.statistics.map.FlowTableAndStatisticsMapBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.duration.Duration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.duration.DurationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.node.connector.statistics.Bytes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.node.connector.statistics.BytesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.node.connector.statistics.Packets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.node.connector.statistics.PacketsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.NodeConnectorStatisticsUpdateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.node.connector.statistics.and.port.number.map.NodeConnectorStatisticsAndPortNumberMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.node.connector.statistics.and.port.number.map.NodeConnectorStatisticsAndPortNumberMapBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableId;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowStatisticsAdapter
implements OpendaylightFlowStatisticsService,
IReadServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(FlowStatisticsAdapter.class);
    private IReadService readDelegate;
    private NotificationProviderService notifier;

    public Future<RpcResult<GetAggregateFlowStatisticsFromFlowTableForAllFlowsOutput>> getAggregateFlowStatisticsFromFlowTableForAllFlows(GetAggregateFlowStatisticsFromFlowTableForAllFlowsInput input) {
        return null;
    }

    public Future<RpcResult<GetAggregateFlowStatisticsFromFlowTableForGivenMatchOutput>> getAggregateFlowStatisticsFromFlowTableForGivenMatch(GetAggregateFlowStatisticsFromFlowTableForGivenMatchInput input) {
        return null;
    }

    public Future<RpcResult<GetAllFlowStatisticsFromFlowTableOutput>> getAllFlowStatisticsFromFlowTable(GetAllFlowStatisticsFromFlowTableInput input) {
        GetAllFlowStatisticsFromFlowTableOutput rpcResultType = null;
        boolean rpcResultBool = false;
        try {
            Node adNode = NodeMapping.toADNode(input.getNode());
            List flowsOnNode = this.readDelegate.readAllFlows(adNode);
            List<FlowAndStatisticsMapList> flowsStatistics = this.toOdFlowsStatistics(flowsOnNode);
            GetAllFlowStatisticsFromFlowTableOutputBuilder builder = new GetAllFlowStatisticsFromFlowTableOutputBuilder();
            builder.setTransactionId(new TransactionId(new BigInteger("0")));
            rpcResultType = builder.setFlowAndStatisticsMapList(flowsStatistics).build();
            rpcResultBool = true;
        }
        catch (ConstructionException e) {
            LOG.error(e.getMessage());
        }
        return Futures.immediateFuture((Object)Rpcs.getRpcResult((boolean)rpcResultBool, rpcResultType, null));
    }

    public Future<RpcResult<GetAllFlowsStatisticsFromAllFlowTablesOutput>> getAllFlowsStatisticsFromAllFlowTables(GetAllFlowsStatisticsFromAllFlowTablesInput input) {
        GetAllFlowsStatisticsFromAllFlowTablesOutput rpcResultType = null;
        boolean rpcResultBool = false;
        try {
            Node adNode = NodeMapping.toADNode(input.getNode());
            List flowsOnNode = this.readDelegate.readAllFlows(adNode);
            List<FlowAndStatisticsMapList> flowsStatistics = this.toOdFlowsStatistics(flowsOnNode);
            GetAllFlowsStatisticsFromAllFlowTablesOutputBuilder builder = new GetAllFlowsStatisticsFromAllFlowTablesOutputBuilder();
            builder.setTransactionId(new TransactionId(new BigInteger("0")));
            rpcResultType = builder.setFlowAndStatisticsMapList(flowsStatistics).build();
            rpcResultBool = true;
        }
        catch (ConstructionException e) {
            LOG.error(e.getMessage());
        }
        return Futures.immediateFuture((Object)Rpcs.getRpcResult((boolean)rpcResultBool, rpcResultType, null));
    }

    public Future<RpcResult<GetFlowStatisticsFromFlowTableOutput>> getFlowStatisticsFromFlowTable(GetFlowStatisticsFromFlowTableInput input) {
        GetFlowStatisticsFromFlowTableOutput rpcResultType = null;
        boolean rpcResultBool = false;
        try {
            Node node = NodeMapping.toADNode(input.getNode());
            Flow flow = ToSalConversionsUtils.toFlow((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow)input, null);
            FlowOnNode readFlow = this.readDelegate.readFlow(node, flow);
            ArrayList<FlowAndStatisticsMapList> flowOnNodeToFlowStatistics = new ArrayList<FlowAndStatisticsMapList>();
            flowOnNodeToFlowStatistics.add(this.toOdFlowStatistics(readFlow));
            rpcResultType = new GetFlowStatisticsFromFlowTableOutputBuilder().setFlowAndStatisticsMapList(flowOnNodeToFlowStatistics).build();
            rpcResultBool = true;
        }
        catch (ConstructionException e) {
            LOG.error(e.getMessage());
        }
        return Futures.immediateFuture((Object)Rpcs.getRpcResult((boolean)rpcResultBool, rpcResultType, null));
    }

    public void nodeFlowStatisticsUpdated(Node node, List<FlowOnNode> flowStatsList) {
        List<FlowAndStatisticsMapList> flowStatistics = this.toOdFlowsStatistics(flowStatsList);
        FlowsStatisticsUpdateBuilder flowsStatisticsUpdateBuilder = new FlowsStatisticsUpdateBuilder();
        flowsStatisticsUpdateBuilder.setFlowAndStatisticsMapList(flowStatistics);
        flowsStatisticsUpdateBuilder.setMoreReplies(Boolean.valueOf(false));
        flowsStatisticsUpdateBuilder.setTransactionId(null);
        flowsStatisticsUpdateBuilder.setId(InventoryMapping.toNodeKey(node).getId());
        this.notifier.publish((Notification)flowsStatisticsUpdateBuilder.build());
    }

    public void nodeConnectorStatisticsUpdated(Node node, List<NodeConnectorStatistics> ncStatsList) {
        NodeConnectorStatisticsUpdateBuilder nodeConnectorStatisticsUpdateBuilder = new NodeConnectorStatisticsUpdateBuilder();
        List<NodeConnectorStatisticsAndPortNumberMap> nodeConnectorStatistics = this.toOdNodeConnectorStatistics(ncStatsList);
        nodeConnectorStatisticsUpdateBuilder.setNodeConnectorStatisticsAndPortNumberMap(nodeConnectorStatistics);
        nodeConnectorStatisticsUpdateBuilder.setMoreReplies(Boolean.valueOf(false));
        nodeConnectorStatisticsUpdateBuilder.setTransactionId(null);
        nodeConnectorStatisticsUpdateBuilder.setId(InventoryMapping.toNodeKey(node).getId());
        this.notifier.publish((Notification)nodeConnectorStatisticsUpdateBuilder.build());
    }

    public void nodeTableStatisticsUpdated(Node node, List<NodeTableStatistics> tableStatsList) {
        FlowTableStatisticsUpdateBuilder flowTableStatisticsUpdateBuilder = new FlowTableStatisticsUpdateBuilder();
        List<FlowTableAndStatisticsMap> flowTableStatistics = this.toOdFlowTableStatistics(tableStatsList);
        flowTableStatisticsUpdateBuilder.setFlowTableAndStatisticsMap(flowTableStatistics);
        flowTableStatisticsUpdateBuilder.setMoreReplies(Boolean.valueOf(false));
        flowTableStatisticsUpdateBuilder.setTransactionId(null);
        flowTableStatisticsUpdateBuilder.setId(InventoryMapping.toNodeKey(node).getId());
        this.notifier.publish((Notification)flowTableStatisticsUpdateBuilder.build());
    }

    public void descriptionStatisticsUpdated(Node node, NodeDescription nodeDescription) {
    }

    private List<FlowAndStatisticsMapList> toOdFlowsStatistics(List<FlowOnNode> flowsOnNode) {
        ArrayList<FlowAndStatisticsMapList> flowsStatistics = new ArrayList<FlowAndStatisticsMapList>();
        for (FlowOnNode flowOnNode : flowsOnNode) {
            flowsStatistics.add(this.toOdFlowStatistics(flowOnNode));
        }
        return flowsStatistics;
    }

    private FlowAndStatisticsMapList toOdFlowStatistics(FlowOnNode flowOnNode) {
        FlowAndStatisticsMapListBuilder builder = new FlowAndStatisticsMapListBuilder();
        builder.setByteCount(this.toCounter64(flowOnNode.getByteCount()));
        builder.setPacketCount(this.toCounter64(flowOnNode.getPacketCount()));
        builder.setDuration(this.extractDuration(flowOnNode));
        builder.setMatch(FromSalConversionsUtils.toMatch(flowOnNode.getFlow().getMatch()));
        builder.setPriority(Integer.valueOf(flowOnNode.getFlow().getPriority()));
        builder.setHardTimeout(Integer.valueOf(flowOnNode.getFlow().getHardTimeout()));
        builder.setIdleTimeout(Integer.valueOf(flowOnNode.getFlow().getIdleTimeout()));
        builder.setInstructions(null);
        return builder.build();
    }

    private Duration extractDuration(FlowOnNode flowOnNode) {
        DurationBuilder builder = new DurationBuilder();
        builder.setNanosecond(new Counter32(Long.valueOf(flowOnNode.getDurationNanoseconds())));
        builder.setSecond(new Counter32(Long.valueOf(flowOnNode.getDurationSeconds())));
        return builder.build();
    }

    private Counter64 toCounter64(long num) {
        String byteCountStr = String.valueOf(num);
        BigInteger byteCountBigInt = new BigInteger(byteCountStr);
        return new Counter64(byteCountBigInt);
    }

    private List<FlowTableAndStatisticsMap> toOdFlowTableStatistics(List<NodeTableStatistics> tableStatsList) {
        ArrayList<FlowTableAndStatisticsMap> flowTableStatsMap = new ArrayList<FlowTableAndStatisticsMap>();
        for (NodeTableStatistics nodeTableStatistics : tableStatsList) {
            FlowTableAndStatisticsMapBuilder flowTableAndStatisticsMapBuilder = new FlowTableAndStatisticsMapBuilder();
            flowTableAndStatisticsMapBuilder.setActiveFlows(new Counter32(Long.valueOf(nodeTableStatistics.getActiveCount())));
            flowTableAndStatisticsMapBuilder.setPacketsLookedUp(this.toCounter64(nodeTableStatistics.getLookupCount()));
            flowTableAndStatisticsMapBuilder.setPacketsMatched(this.toCounter64(nodeTableStatistics.getMatchedCount()));
            flowTableAndStatisticsMapBuilder.setActiveFlows(new Counter32(Long.valueOf(nodeTableStatistics.getActiveCount())));
            flowTableAndStatisticsMapBuilder.setTableId(new TableId(Short.valueOf((Short)nodeTableStatistics.getNodeTable().getID())));
            flowTableStatsMap.add(flowTableAndStatisticsMapBuilder.build());
        }
        return flowTableStatsMap;
    }

    private List<NodeConnectorStatisticsAndPortNumberMap> toOdNodeConnectorStatistics(List<NodeConnectorStatistics> ncStatsList) {
        ArrayList<NodeConnectorStatisticsAndPortNumberMap> nodeConnectorStatisticsList = new ArrayList<NodeConnectorStatisticsAndPortNumberMap>();
        for (NodeConnectorStatistics ofNodeConnectorStatistics : ncStatsList) {
            NodeConnectorStatisticsAndPortNumberMapBuilder nodeConnectorStatisticsAndPortNumberMapBuilder = new NodeConnectorStatisticsAndPortNumberMapBuilder();
            nodeConnectorStatisticsAndPortNumberMapBuilder.setBytes(this.extractBytes(ofNodeConnectorStatistics));
            nodeConnectorStatisticsAndPortNumberMapBuilder.setCollisionCount(this.toBI(ofNodeConnectorStatistics.getCollisionCount()));
            nodeConnectorStatisticsAndPortNumberMapBuilder.setDuration(null);
            nodeConnectorStatisticsAndPortNumberMapBuilder.setPackets(this.extractPackets(ofNodeConnectorStatistics));
            nodeConnectorStatisticsAndPortNumberMapBuilder.setReceiveCrcError(this.toBI(ofNodeConnectorStatistics.getReceiveCRCErrorCount()));
            nodeConnectorStatisticsAndPortNumberMapBuilder.setReceiveDrops(this.toBI(ofNodeConnectorStatistics.getReceiveDropCount()));
            nodeConnectorStatisticsAndPortNumberMapBuilder.setReceiveErrors(this.toBI(ofNodeConnectorStatistics.getReceiveErrorCount()));
            nodeConnectorStatisticsAndPortNumberMapBuilder.setReceiveFrameError(this.toBI(ofNodeConnectorStatistics.getReceiveFrameErrorCount()));
            nodeConnectorStatisticsAndPortNumberMapBuilder.setReceiveOverRunError(this.toBI(ofNodeConnectorStatistics.getReceiveOverRunErrorCount()));
            nodeConnectorStatisticsAndPortNumberMapBuilder.setTransmitDrops(this.toBI(ofNodeConnectorStatistics.getTransmitDropCount()));
            nodeConnectorStatisticsAndPortNumberMapBuilder.setTransmitErrors(this.toBI(ofNodeConnectorStatistics.getTransmitErrorCount()));
            nodeConnectorStatisticsList.add(nodeConnectorStatisticsAndPortNumberMapBuilder.build());
        }
        return nodeConnectorStatisticsList;
    }

    private BigInteger toBI(long num) {
        String numStr = String.valueOf(num);
        return new BigInteger(numStr);
    }

    private Packets extractPackets(NodeConnectorStatistics nodeConnectorStatistics) {
        long receivePacketCount = nodeConnectorStatistics.getReceivePacketCount();
        long transmitPacketCount = nodeConnectorStatistics.getTransmitPacketCount();
        PacketsBuilder builder = new PacketsBuilder();
        builder.setReceived(this.toBI(receivePacketCount));
        builder.setTransmitted(this.toBI(transmitPacketCount));
        return builder.build();
    }

    private Bytes extractBytes(NodeConnectorStatistics nodeConnectorStatistics) {
        long transmitByteCount = nodeConnectorStatistics.getTransmitByteCount();
        long receiveByteCount = nodeConnectorStatistics.getReceiveByteCount();
        BytesBuilder builder = new BytesBuilder();
        builder.setReceived(this.toBI(receiveByteCount));
        builder.setTransmitted(this.toBI(transmitByteCount));
        return builder.build();
    }
}

