/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.compatibility.adsal;

import java.math.BigInteger;
import java.util.concurrent.Future;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.common.util.Futures;
import org.opendaylight.controller.sal.common.util.Rpcs;
import org.opendaylight.controller.sal.compatibility.InventoryMapping;
import org.opendaylight.controller.sal.compatibility.ToSalConversionsUtils;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.flowprogrammer.IFlowProgrammerListener;
import org.opendaylight.controller.sal.flowprogrammer.IFlowProgrammerService;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.AddFlowInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.AddFlowOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.AddFlowOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.FlowRemovedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.RemoveFlowInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.RemoveFlowOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.RemoveFlowOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.SalFlowService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.UpdateFlowInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.UpdateFlowOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.UpdateFlowOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionId;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowServiceAdapter
implements SalFlowService,
IFlowProgrammerListener {
    private static final Logger LOG = LoggerFactory.getLogger(FlowServiceAdapter.class);
    private IFlowProgrammerService delegate;
    private NotificationProviderService publish;

    public void flowRemoved(Node node, Flow flow) {
        FlowRemovedBuilder flowRemovedBuilder = new FlowRemovedBuilder();
        flowRemovedBuilder.setNode(InventoryMapping.toNodeRef(node));
        this.publish.publish((Notification)flowRemovedBuilder.build());
    }

    public void flowErrorReported(Node node, long rid, Object err) {
    }

    public Future<RpcResult<AddFlowOutput>> addFlow(AddFlowInput input) {
        Flow flow = ToSalConversionsUtils.toFlow((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow)input, null);
        Node node = InventoryMapping.toAdNode((InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node>)input.getNode().getValue());
        Status status = this.delegate.addFlowAsync(node, flow);
        AddFlowOutputBuilder builder = new AddFlowOutputBuilder();
        builder.setTransactionId(new TransactionId(BigInteger.valueOf(status.getRequestId())));
        AddFlowOutput rpcResultType = builder.build();
        return Futures.immediateFuture((Object)Rpcs.getRpcResult((boolean)status.isSuccess(), (Object)rpcResultType, null));
    }

    public Future<RpcResult<RemoveFlowOutput>> removeFlow(RemoveFlowInput input) {
        Flow flow = ToSalConversionsUtils.toFlow((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow)input, null);
        Node node = InventoryMapping.toAdNode((InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node>)input.getNode().getValue());
        Status status = this.delegate.removeFlowAsync(node, flow);
        RemoveFlowOutputBuilder builder = new RemoveFlowOutputBuilder();
        builder.setTransactionId(new TransactionId(BigInteger.valueOf(status.getRequestId())));
        RemoveFlowOutput rpcResultType = builder.build();
        return Futures.immediateFuture((Object)Rpcs.getRpcResult((boolean)status.isSuccess(), (Object)rpcResultType, null));
    }

    public Future<RpcResult<UpdateFlowOutput>> updateFlow(UpdateFlowInput input) {
        Node node = InventoryMapping.toAdNode((InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node>)input.getNode().getValue());
        Flow originalFlow = ToSalConversionsUtils.toFlow((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow)input.getOriginalFlow(), null);
        Flow updatedFlow = ToSalConversionsUtils.toFlow((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow)input.getUpdatedFlow(), null);
        Status status = this.delegate.modifyFlowAsync(node, originalFlow, updatedFlow);
        UpdateFlowOutputBuilder builder = new UpdateFlowOutputBuilder();
        builder.setTransactionId(new TransactionId(BigInteger.valueOf(status.getRequestId())));
        UpdateFlowOutput rpcResultType = builder.build();
        throw new UnsupportedOperationException("Need to translate AD-SAL status to MD-SAL UpdateFlowOuptut - eaw@cisco.com");
    }
}

