/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.compatibility;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.controller.sal.action.Action;
import org.opendaylight.controller.sal.action.Controller;
import org.opendaylight.controller.sal.action.Drop;
import org.opendaylight.controller.sal.action.Flood;
import org.opendaylight.controller.sal.action.FloodAll;
import org.opendaylight.controller.sal.action.HwPath;
import org.opendaylight.controller.sal.action.Loopback;
import org.opendaylight.controller.sal.action.Output;
import org.opendaylight.controller.sal.action.PopVlan;
import org.opendaylight.controller.sal.action.PushVlan;
import org.opendaylight.controller.sal.action.SetDlDst;
import org.opendaylight.controller.sal.action.SetDlSrc;
import org.opendaylight.controller.sal.action.SetDlType;
import org.opendaylight.controller.sal.action.SetNextHop;
import org.opendaylight.controller.sal.action.SetNwDst;
import org.opendaylight.controller.sal.action.SetNwSrc;
import org.opendaylight.controller.sal.action.SetNwTos;
import org.opendaylight.controller.sal.action.SetTpDst;
import org.opendaylight.controller.sal.action.SetTpSrc;
import org.opendaylight.controller.sal.action.SetVlanCfi;
import org.opendaylight.controller.sal.action.SetVlanId;
import org.opendaylight.controller.sal.action.SetVlanPcp;
import org.opendaylight.controller.sal.action.SwPath;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.match.MatchType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Dscp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.VlanCfi;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.ControllerActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.DropActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.FloodActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.FloodAllActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.HwPathActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.LoopbackActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.OutputActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PopMplsActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PopVlanActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PushMplsActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PushPbbActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PushVlanActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetDlDstActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetDlSrcActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetDlTypeActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetMplsTtlActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetNextHopActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetNwDstActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetNwSrcActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetNwTosActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetNwTtlActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetQueueActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetTpDstActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetTpSrcActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetVlanCfiActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetVlanIdActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetVlanPcpActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SwPathActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.push.vlan.action._case.PushVlanAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.address.Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.address.address.Ipv4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.address.address.Ipv6;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.ApplyActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.EtherType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanPcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.arp.match.fields.ArpSourceHardwareAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.arp.match.fields.ArpTargetHardwareAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetDestination;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetSource;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.EthernetMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.IpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer3Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.VlanMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.ArpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv6Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.SctpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.TcpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.UdpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.vlan.match.fields.VlanId;

public class ToSalConversionsUtils {
    private ToSalConversionsUtils() {
    }

    public static Flow toFlow(org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow source, Node node) {
        Integer priority;
        Integer idleTimeout;
        Flow target = new Flow();
        Integer hardTimeout = source.getHardTimeout();
        if (hardTimeout != null) {
            target.setHardTimeout(hardTimeout.shortValue());
        }
        if ((idleTimeout = source.getIdleTimeout()) != null) {
            target.setIdleTimeout(idleTimeout.shortValue());
        }
        if ((priority = source.getPriority()) != null) {
            target.setPriority(priority.shortValue());
        }
        target.setMatch(ToSalConversionsUtils.toMatch(source.getMatch()));
        List<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action> actions = ToSalConversionsUtils.getAction(source);
        if (actions != null) {
            target.setActions(ToSalConversionsUtils.actionFrom(actions, node));
        }
        target.setId(source.getCookie().longValue());
        return target;
    }

    public static List<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action> getAction(org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow source) {
        if (source.getInstructions() != null) {
            for (Instruction instruction : source.getInstructions().getInstruction()) {
                if (!(instruction.getInstruction() instanceof ApplyActionsCase)) continue;
                return ((ApplyActionsCase)instruction.getInstruction()).getApplyActions().getAction();
            }
        }
        return Collections.emptyList();
    }

    public static List<Action> actionFrom(List<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action> actions, Node node) {
        ArrayList<Action> targetAction = new ArrayList<Action>();
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action action : actions) {
            Integer portValue;
            PortNumber port;
            InetAddress inetAddress;
            Address addressL3;
            org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action sourceAction = action.getAction();
            if (sourceAction instanceof ControllerActionCase) {
                targetAction.add((Action)new Controller());
                continue;
            }
            if (sourceAction instanceof OutputActionCase) {
                Uri nodeConnector = ((OutputActionCase)sourceAction).getOutputAction().getOutputNodeConnector();
                if (nodeConnector == null) continue;
                targetAction.add((Action)new Output(ToSalConversionsUtils.fromNodeConnectorRef(nodeConnector, node)));
                continue;
            }
            if (sourceAction instanceof PopMplsActionCase || sourceAction instanceof PushMplsActionCase || sourceAction instanceof PushPbbActionCase || sourceAction instanceof SetMplsTtlActionCase || sourceAction instanceof SetNwTtlActionCase || sourceAction instanceof SetQueueActionCase) continue;
            if (sourceAction instanceof DropActionCase) {
                targetAction.add((Action)new Drop());
                continue;
            }
            if (sourceAction instanceof FloodActionCase) {
                targetAction.add((Action)new Flood());
                continue;
            }
            if (sourceAction instanceof FloodAllActionCase) {
                targetAction.add((Action)new FloodAll());
                continue;
            }
            if (sourceAction instanceof HwPathActionCase) {
                targetAction.add((Action)new HwPath());
                continue;
            }
            if (sourceAction instanceof LoopbackActionCase) {
                targetAction.add((Action)new Loopback());
                continue;
            }
            if (sourceAction instanceof PopVlanActionCase) {
                targetAction.add((Action)new PopVlan());
                continue;
            }
            if (sourceAction instanceof PushVlanActionCase) {
                PushVlanActionCase pushVlanAction = (PushVlanActionCase)sourceAction;
                PushVlan pushVlan = ToSalConversionsUtils.pushVlanFrom(pushVlanAction.getPushVlanAction());
                if (pushVlan == null) continue;
                targetAction.add((Action)pushVlan);
                continue;
            }
            if (sourceAction instanceof SetDlDstActionCase) {
                MacAddress addressL2Dest = ((SetDlDstActionCase)sourceAction).getSetDlDstAction().getAddress();
                if (addressL2Dest == null) continue;
                targetAction.add((Action)new SetDlDst(ToSalConversionsUtils.bytesFrom(addressL2Dest)));
                continue;
            }
            if (sourceAction instanceof SetDlSrcActionCase) {
                MacAddress addressL2Src = ((SetDlSrcActionCase)sourceAction).getSetDlSrcAction().getAddress();
                if (addressL2Src == null) continue;
                targetAction.add((Action)new SetDlSrc(ToSalConversionsUtils.bytesFrom(addressL2Src)));
                continue;
            }
            if (sourceAction instanceof SetDlTypeActionCase) {
                Long dlTypeValue;
                EtherType dlType = ((SetDlTypeActionCase)sourceAction).getSetDlTypeAction().getDlType();
                if (dlType == null || (dlTypeValue = dlType.getValue()) == null) continue;
                targetAction.add((Action)new SetDlType(dlTypeValue.intValue()));
                continue;
            }
            if (sourceAction instanceof SetNextHopActionCase) {
                addressL3 = ((SetNextHopActionCase)sourceAction).getSetNextHopAction().getAddress();
                inetAddress = ToSalConversionsUtils.inetAddressFrom(addressL3);
                if (inetAddress == null) continue;
                targetAction.add((Action)new SetNextHop(inetAddress));
                continue;
            }
            if (sourceAction instanceof SetNwDstActionCase) {
                addressL3 = ((SetNwDstActionCase)sourceAction).getSetNwDstAction().getAddress();
                inetAddress = ToSalConversionsUtils.inetAddressFrom(addressL3);
                if (inetAddress == null) continue;
                targetAction.add((Action)new SetNwDst(inetAddress));
                continue;
            }
            if (sourceAction instanceof SetNwSrcActionCase) {
                addressL3 = ((SetNwSrcActionCase)sourceAction).getSetNwSrcAction().getAddress();
                inetAddress = ToSalConversionsUtils.inetAddressFrom(addressL3);
                if (inetAddress == null) continue;
                targetAction.add((Action)new SetNwSrc(inetAddress));
                continue;
            }
            if (sourceAction instanceof SetNwTosActionCase) {
                Integer tos = ((SetNwTosActionCase)sourceAction).getSetNwTosAction().getTos();
                if (tos == null) continue;
                targetAction.add((Action)new SetNwTos(tos.intValue()));
                continue;
            }
            if (sourceAction instanceof SetTpDstActionCase) {
                port = ((SetTpDstActionCase)sourceAction).getSetTpDstAction().getPort();
                if (port == null) continue;
                portValue = port.getValue();
                if (port.getValue() == null) continue;
                targetAction.add((Action)new SetTpDst(portValue.intValue()));
                continue;
            }
            if (sourceAction instanceof SetTpSrcActionCase) {
                port = ((SetTpSrcActionCase)sourceAction).getSetTpSrcAction().getPort();
                if (port == null) continue;
                portValue = port.getValue();
                if (port.getValue() == null) continue;
                targetAction.add((Action)new SetTpSrc(portValue.intValue()));
                continue;
            }
            if (sourceAction instanceof SetVlanCfiActionCase) {
                Integer vlanCfiValue;
                VlanCfi vlanCfi = ((SetVlanCfiActionCase)sourceAction).getSetVlanCfiAction().getVlanCfi();
                if (vlanCfi == null || (vlanCfiValue = vlanCfi.getValue()) == null) continue;
                targetAction.add((Action)new SetVlanCfi(vlanCfiValue.intValue()));
                continue;
            }
            if (sourceAction instanceof SetVlanIdActionCase) {
                Integer vlanIdValue;
                org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanId vlanID = ((SetVlanIdActionCase)sourceAction).getSetVlanIdAction().getVlanId();
                if (vlanID == null || (vlanIdValue = vlanID.getValue()) == null) continue;
                targetAction.add((Action)new SetVlanId(vlanIdValue.intValue()));
                continue;
            }
            if (sourceAction instanceof SetVlanPcpActionCase) {
                Short vlanPcpValue;
                VlanPcp vlanPcp = ((SetVlanPcpActionCase)sourceAction).getSetVlanPcpAction().getVlanPcp();
                if (vlanPcp == null || (vlanPcpValue = vlanPcp.getValue()) == null) continue;
                targetAction.add((Action)new SetVlanPcp((int)vlanPcpValue.shortValue()));
                continue;
            }
            if (!(sourceAction instanceof SwPathActionCase)) continue;
            targetAction.add((Action)new SwPath());
        }
        return targetAction;
    }

    private static InetAddress inetAddressFrom(Address addressL3) {
        if (addressL3 != null) {
            Ipv6Prefix addressL3Ipv6;
            if (addressL3 instanceof Ipv4) {
                Ipv4Prefix addressL3Ipv4 = ((Ipv4)addressL3).getIpv4Address();
                if (addressL3Ipv4 != null) {
                    return ToSalConversionsUtils.inetAddressFrom(addressL3Ipv4);
                }
            } else if (addressL3 instanceof Ipv6 && (addressL3Ipv6 = ((Ipv6)addressL3).getIpv6Address()) != null) {
                return ToSalConversionsUtils.inetAddressFrom(addressL3Ipv6);
            }
        }
        return null;
    }

    private static PushVlan pushVlanFrom(PushVlanAction pushVlanAction) {
        if (pushVlanAction.getTag() != null) {
            int tag = pushVlanAction.getTag();
            if (pushVlanAction.getPcp() != null) {
                int pcp = pushVlanAction.getPcp();
                if (pushVlanAction.getCfi() != null && pushVlanAction.getCfi().getValue() != null) {
                    int cfi = pushVlanAction.getCfi().getValue();
                    if (pushVlanAction.getVlanId() != null && pushVlanAction.getVlanId().getValue() != null) {
                        int vlanId = pushVlanAction.getVlanId().getValue();
                        return new PushVlan(tag, pcp, cfi, vlanId);
                    }
                }
            }
        }
        return null;
    }

    private static NodeConnector fromNodeConnectorRef(Uri uri, Node node) {
        NodeConnector nodeConnector = null;
        try {
            nodeConnector = new NodeConnector("MD_SAL", (Object)(node.getNodeIDString() + ":" + uri.getValue()), node);
        }
        catch (ConstructionException e) {
            e.printStackTrace();
        }
        return nodeConnector;
    }

    public static org.opendaylight.controller.sal.match.Match toMatch(Match source) {
        org.opendaylight.controller.sal.match.Match target = new org.opendaylight.controller.sal.match.Match();
        if (source != null) {
            ToSalConversionsUtils.fillFrom(target, source.getVlanMatch());
            ToSalConversionsUtils.fillFrom(target, source.getEthernetMatch());
            ToSalConversionsUtils.fillFrom(target, source.getLayer3Match());
            ToSalConversionsUtils.fillFrom(target, source.getLayer4Match());
            ToSalConversionsUtils.fillFrom(target, source.getIpMatch());
        }
        return target;
    }

    private static void fillFrom(org.opendaylight.controller.sal.match.Match target, VlanMatch vlanMatch) {
        if (vlanMatch != null) {
            Short vlanPcpValue;
            VlanPcp vlanPcp;
            Integer vlanValue;
            org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanId vlanIdInner;
            VlanId vlanId = vlanMatch.getVlanId();
            if (vlanId != null && (vlanIdInner = vlanId.getVlanId()) != null && (vlanValue = vlanIdInner.getValue()) != null) {
                target.setField(MatchType.DL_VLAN, (Object)vlanValue.shortValue());
            }
            if ((vlanPcp = vlanMatch.getVlanPcp()) != null && (vlanPcpValue = vlanPcp.getValue()) != null) {
                target.setField(MatchType.DL_VLAN_PR, (Object)vlanPcpValue.byteValue());
            }
        }
    }

    private static void fillFrom(org.opendaylight.controller.sal.match.Match target, IpMatch ipMatch) {
        if (ipMatch != null) {
            Short dscpValue;
            Dscp dscp;
            Short ipProtocol = ipMatch.getIpProtocol();
            if (ipProtocol != null && target.getField(MatchType.NW_PROTO) == null) {
                target.setField(MatchType.NW_PROTO, (Object)ipProtocol.byteValue());
            }
            if ((dscp = ipMatch.getIpDscp()) != null && (dscpValue = dscp.getValue()) != null) {
                target.setField(MatchType.NW_TOS, (Object)dscpValue.byteValue());
            }
        }
    }

    private static void fillFrom(org.opendaylight.controller.sal.match.Match target, Layer4Match layer4Match) {
        if (layer4Match == null) {
            return;
        }
        if (layer4Match instanceof SctpMatch) {
            ToSalConversionsUtils.fillTransportLayer(target, (SctpMatch)layer4Match);
        } else if (layer4Match instanceof TcpMatch) {
            ToSalConversionsUtils.fillTransportLayer(target, (TcpMatch)layer4Match);
        } else if (layer4Match instanceof UdpMatch) {
            ToSalConversionsUtils.fillTransportLayer(target, (UdpMatch)layer4Match);
        }
    }

    private static void fillTransportLayer(org.opendaylight.controller.sal.match.Match target, UdpMatch source) {
        Integer udpDestPortValue;
        PortNumber udpDestPort;
        Integer udpSourcePortValue;
        PortNumber udpSourcePort = source.getUdpSourcePort();
        if (udpSourcePort != null && (udpSourcePortValue = udpSourcePort.getValue()) != null) {
            target.setField(MatchType.TP_SRC, (Object)udpSourcePortValue.shortValue());
        }
        if ((udpDestPort = source.getUdpDestinationPort()) != null && (udpDestPortValue = udpDestPort.getValue()) != null) {
            target.setField(MatchType.TP_DST, (Object)udpDestPortValue.shortValue());
        }
        target.setField(MatchType.NW_PROTO, (Object)17);
    }

    private static void fillTransportLayer(org.opendaylight.controller.sal.match.Match target, TcpMatch source) {
        Integer tcpDestPortValue;
        PortNumber tcpDestPort;
        Integer tcpSourcePortValue;
        PortNumber tcpSourcePort = source.getTcpSourcePort();
        if (tcpSourcePort != null && (tcpSourcePortValue = tcpSourcePort.getValue()) != null) {
            target.setField(MatchType.TP_SRC, (Object)tcpSourcePortValue.shortValue());
        }
        if ((tcpDestPort = source.getTcpDestinationPort()) != null && (tcpDestPortValue = tcpDestPort.getValue()) != null) {
            target.setField(MatchType.TP_DST, (Object)tcpDestPortValue.shortValue());
        }
        target.setField(MatchType.NW_PROTO, (Object)6);
    }

    private static void fillTransportLayer(org.opendaylight.controller.sal.match.Match target, SctpMatch source) {
        Integer sctpDestPortValue;
        PortNumber sctpDestPort;
        Integer sctpSourcePortValue;
        PortNumber sctpSourcePort = source.getSctpSourcePort();
        if (sctpSourcePort != null && (sctpSourcePortValue = sctpSourcePort.getValue()) != null) {
            target.setField(MatchType.TP_SRC, (Object)sctpSourcePortValue.shortValue());
        }
        if ((sctpDestPort = source.getSctpDestinationPort()) != null && (sctpDestPortValue = sctpDestPort.getValue()) != null) {
            target.setField(MatchType.TP_DST, (Object)sctpDestPortValue.shortValue());
        }
        target.setField(MatchType.NW_PROTO, (Object)127);
    }

    private static void fillFrom(org.opendaylight.controller.sal.match.Match target, Layer3Match source) {
        if (source == null) {
            return;
        }
        if (source instanceof Ipv4Match) {
            ToSalConversionsUtils.fillFromIpv4(target, (Ipv4Match)source);
        } else if (source instanceof Ipv6Match) {
            ToSalConversionsUtils.fillFromIpv6(target, (Ipv6Match)source);
        } else if (source instanceof ArpMatch) {
            ToSalConversionsUtils.fillFromArp(target, (ArpMatch)source);
        }
    }

    private static void fillFromArp(org.opendaylight.controller.sal.match.Match target, ArpMatch source) {
        ArpTargetHardwareAddress targetHwAddress;
        ArpSourceHardwareAddress sourceHwAddress;
        Ipv4Prefix destAddress;
        Ipv4Prefix sourceAddress = source.getArpSourceTransportAddress();
        if (sourceAddress != null) {
            target.setField(MatchType.NW_SRC, (Object)ToSalConversionsUtils.inetAddressFrom(sourceAddress), null);
        }
        if ((destAddress = source.getArpTargetTransportAddress()) != null) {
            target.setField(MatchType.NW_DST, (Object)ToSalConversionsUtils.inetAddressFrom(destAddress), null);
        }
        if ((sourceHwAddress = source.getArpSourceHardwareAddress()) != null) {
            target.setField(MatchType.DL_SRC, (Object)ToSalConversionsUtils.bytesFrom(sourceHwAddress.getAddress()));
        }
        if ((targetHwAddress = source.getArpTargetHardwareAddress()) != null) {
            target.setField(MatchType.DL_DST, (Object)ToSalConversionsUtils.bytesFrom(targetHwAddress.getAddress()));
        }
        target.setField(MatchType.DL_TYPE, (Object)new Short(2054));
    }

    private static void fillFromIpv6(org.opendaylight.controller.sal.match.Match target, Ipv6Match source) {
        Ipv6Prefix destAddress;
        Ipv6Prefix sourceAddress = source.getIpv6Source();
        if (sourceAddress != null) {
            target.setField(MatchType.NW_SRC, (Object)ToSalConversionsUtils.inetAddressFrom(sourceAddress), null);
        }
        if ((destAddress = source.getIpv6Destination()) != null) {
            target.setField(MatchType.NW_DST, (Object)ToSalConversionsUtils.inetAddressFrom(destAddress), null);
        }
    }

    private static void fillFromIpv4(org.opendaylight.controller.sal.match.Match target, Ipv4Match source) {
        Ipv4Prefix destAddress;
        Ipv4Prefix sourceAddress = source.getIpv4Source();
        if (sourceAddress != null) {
            target.setField(MatchType.NW_SRC, (Object)ToSalConversionsUtils.inetAddressFrom(sourceAddress), null);
        }
        if ((destAddress = source.getIpv4Destination()) != null) {
            target.setField(MatchType.NW_DST, (Object)ToSalConversionsUtils.inetAddressFrom(destAddress), null);
        }
    }

    private static InetAddress inetAddressFrom(Ipv4Prefix source) {
        if (source != null) {
            String[] parts = source.getValue().split("/");
            return InetAddresses.forString((String)parts[0]);
        }
        return null;
    }

    private static InetAddress inetAddressFrom(Ipv6Prefix source) {
        if (source != null) {
            String[] parts = source.getValue().split("/");
            return InetAddresses.forString((String)parts[0]);
        }
        return null;
    }

    private static void fillFrom(org.opendaylight.controller.sal.match.Match target, EthernetMatch source) {
        EthernetDestination ethDest;
        EthernetSource ethSource;
        EtherType ethInnerType;
        if (source == null) {
            return;
        }
        EthernetType ethType = source.getEthernetType();
        if (ethType != null && (ethInnerType = ethType.getType()) != null && target.getField(MatchType.DL_TYPE) == null) {
            Long value = ethInnerType.getValue();
            target.setField(MatchType.DL_TYPE, (Object)value.shortValue());
        }
        if ((ethSource = source.getEthernetSource()) != null) {
            target.setField(MatchType.DL_SRC, (Object)ToSalConversionsUtils.bytesFrom(ethSource.getAddress()));
        }
        if ((ethDest = source.getEthernetDestination()) != null) {
            target.setField(MatchType.DL_DST, (Object)ToSalConversionsUtils.bytesFrom(ethDest.getAddress()));
        }
    }

    public static byte[] bytesFrom(MacAddress address) {
        String[] mac = address.getValue().split(":");
        byte[] macAddress = new byte[6];
        for (int i = 0; i < mac.length; ++i) {
            macAddress[i] = Integer.decode("0x" + mac[i]).byteValue();
        }
        return macAddress;
    }

    public static byte[] bytesFromDpid(long dpid) {
        byte[] mac = new byte[]{0, 0, 0, 0, 0, 0};
        for (int i = 0; i < 6; i = (int)((short)(i + 1))) {
            mac[5 - i] = (byte)dpid;
            dpid >>= 8;
        }
        return mac;
    }
}

