/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.compatibility;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.opendaylight.controller.sal.common.util.Arguments;
import org.opendaylight.controller.sal.compatibility.ToSalConversionsUtils;
import org.opendaylight.controller.sal.core.AdvertisedBandwidth;
import org.opendaylight.controller.sal.core.Bandwidth;
import org.opendaylight.controller.sal.core.Buffers;
import org.opendaylight.controller.sal.core.Capabilities;
import org.opendaylight.controller.sal.core.Config;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.MacAddress;
import org.opendaylight.controller.sal.core.Name;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.PeerBandwidth;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.SupportedBandwidth;
import org.opendaylight.controller.sal.core.Tables;
import org.opendaylight.controller.sal.core.TimeStamp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FeatureCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnectorUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityArpMatchIp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityFlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityIpReasm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityPortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityQueueStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityStp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityTableStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowNodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.SwitchFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.flow.capable.port.State;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class NodeMapping {
    public static final String MD_SAL_TYPE = "MD_SAL";
    private static final Class<org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node> NODE_CLASS = org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class;
    private static final Class<org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector> NODECONNECTOR_CLASS = org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector.class;

    private NodeMapping() {
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("Utility class. Instantiation is not allowed.");
        throw _unsupportedOperationException;
    }

    public static Node toADNode(InstanceIdentifier<? extends Object> node) throws ConstructionException {
        NodeId _nodeId = NodeMapping.toNodeId(node);
        return NodeMapping.toADNode(_nodeId);
    }

    public static Node toADNode(NodeId id) {
        try {
            String _aDNodeId = NodeMapping.toADNodeId(id);
            Node _node = new Node(MD_SAL_TYPE, (Object)_aDNodeId);
            return _node;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static NodeId toNodeId(InstanceIdentifier<? extends Object> node) {
        Preconditions.checkNotNull(node);
        List _path = node.getPath();
        Preconditions.checkNotNull((Object)_path);
        List _path_1 = node.getPath();
        int _size = _path_1.size();
        boolean _greaterEqualsThan = _size >= 2;
        Preconditions.checkArgument((boolean)_greaterEqualsThan);
        List _path_2 = node.getPath();
        InstanceIdentifier.PathArgument arg = (InstanceIdentifier.PathArgument)_path_2.get(1);
        InstanceIdentifier.IdentifiableItem item = (InstanceIdentifier.IdentifiableItem)Arguments.checkInstanceOf((Object)arg, InstanceIdentifier.IdentifiableItem.class);
        Identifier _key = item.getKey();
        NodeKey nodeKey = (NodeKey)Arguments.checkInstanceOf((Object)_key, NodeKey.class);
        return nodeKey.getId();
    }

    public static String toADNodeId(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId);
        return nodeId.getValue();
    }

    public static NodeConnector toADNodeConnector(NodeConnectorRef source) throws ConstructionException {
        Preconditions.checkNotNull((Object)source);
        InstanceIdentifier _value = source.getValue();
        InstanceIdentifier path = (InstanceIdentifier)Preconditions.checkNotNull((Object)_value);
        List _path = path.getPath();
        int _size = _path.size();
        boolean _greaterEqualsThan = _size >= 3;
        Preconditions.checkArgument((boolean)_greaterEqualsThan);
        List _path_1 = path.getPath();
        InstanceIdentifier.PathArgument arg = (InstanceIdentifier.PathArgument)_path_1.get(2);
        InstanceIdentifier.IdentifiableItem item = (InstanceIdentifier.IdentifiableItem)Arguments.checkInstanceOf((Object)arg, InstanceIdentifier.IdentifiableItem.class);
        Identifier _key = item.getKey();
        NodeConnectorKey connectorKey = (NodeConnectorKey)Arguments.checkInstanceOf((Object)_key, NodeConnectorKey.class);
        NodeConnectorId _id = connectorKey.getId();
        NodeId _nodeId = NodeMapping.toNodeId((InstanceIdentifier<? extends Object>)path);
        return NodeMapping.toADNodeConnector(_id, _nodeId);
    }

    public static NodeConnector toADNodeConnector(NodeConnectorId ncid, NodeId nid) {
        try {
            String _nodeConnectorType = NodeMapping.toNodeConnectorType(ncid, nid);
            Object _aDNodeConnectorId = NodeMapping.toADNodeConnectorId(ncid, nid);
            Node _aDNode = NodeMapping.toADNode(nid);
            NodeConnector _nodeConnector = new NodeConnector(_nodeConnectorType, _aDNodeConnectorId, _aDNode);
            return _nodeConnector;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String toNodeConnectorType(NodeConnectorId ncId, NodeId nodeId) {
        NodeConnectorId _localNodeConnectorId = NodeMapping.toLocalNodeConnectorId(nodeId);
        boolean _equals = ncId.equals((Object)_localNodeConnectorId);
        if (_equals) {
            return NodeConnector.NodeConnectorIDType.SWSTACK;
        }
        NodeConnectorId _normalNodeConnectorId = NodeMapping.toNormalNodeConnectorId(nodeId);
        boolean _equals_1 = ncId.equals((Object)_normalNodeConnectorId);
        if (_equals_1) {
            return NodeConnector.NodeConnectorIDType.HWPATH;
        }
        NodeConnectorId _controllerNodeConnectorId = NodeMapping.toControllerNodeConnectorId(nodeId);
        boolean _equals_2 = ncId.equals((Object)_controllerNodeConnectorId);
        if (_equals_2) {
            return NodeConnector.NodeConnectorIDType.CONTROLLER;
        }
        return MD_SAL_TYPE;
    }

    public static Object toADNodeConnectorId(NodeConnectorId nodeConnectorId, NodeId nodeId) {
        boolean _or = false;
        boolean _or_1 = false;
        NodeConnectorId _localNodeConnectorId = NodeMapping.toLocalNodeConnectorId(nodeId);
        boolean _equals = nodeConnectorId.equals((Object)_localNodeConnectorId);
        if (_equals) {
            _or_1 = true;
        } else {
            NodeConnectorId _normalNodeConnectorId = NodeMapping.toNormalNodeConnectorId(nodeId);
            boolean _equals_1 = nodeConnectorId.equals((Object)_normalNodeConnectorId);
            boolean bl = _or_1 = _equals || _equals_1;
        }
        if (_or_1) {
            _or = true;
        } else {
            NodeConnectorId _controllerNodeConnectorId = NodeMapping.toControllerNodeConnectorId(nodeId);
            boolean _equals_2 = nodeConnectorId.equals((Object)_controllerNodeConnectorId);
            boolean bl = _or = _or_1 || _equals_2;
        }
        if (_or) {
            return NodeConnector.SPECIALNODECONNECTORID;
        }
        return nodeConnectorId.getValue();
    }

    public static NodeConnectorId toControllerNodeConnectorId(NodeId node) {
        String _value = node.getValue();
        String _plus = _value + ":";
        String _plus_1 = _plus + Long.valueOf(0xFFFFFFFDL);
        NodeConnectorId _nodeConnectorId = new NodeConnectorId(_plus_1);
        return _nodeConnectorId;
    }

    public static NodeConnectorId toLocalNodeConnectorId(NodeId node) {
        String _value = node.getValue();
        String _plus = _value + ":";
        String _plus_1 = _plus + Long.valueOf(0xFFFFFFFEL);
        NodeConnectorId _nodeConnectorId = new NodeConnectorId(_plus_1);
        return _nodeConnectorId;
    }

    public static NodeConnectorId toNormalNodeConnectorId(NodeId node) {
        String _value = node.getValue();
        String _plus = _value + ":";
        String _plus_1 = _plus + Long.valueOf(0xFFFFFFFAL);
        NodeConnectorId _nodeConnectorId = new NodeConnectorId(_plus_1);
        return _nodeConnectorId;
    }

    public static NodeRef toNodeRef(Node node) {
        NodeKey _nodeKey;
        String _type = node.getType();
        boolean _equals = MD_SAL_TYPE.equals(_type);
        Preconditions.checkArgument((boolean)_equals);
        Object _iD = node.getID();
        String nodeId = (String)Arguments.checkInstanceOf((Object)_iD, String.class);
        NodeId _nodeId = new NodeId(nodeId);
        NodeKey nodeKey = _nodeKey = new NodeKey(_nodeId);
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder();
        InstanceIdentifier.InstanceIdentifierBuilder _node = _builder.node(Nodes.class);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _node.child(NODE_CLASS, (Identifier)nodeKey);
        InstanceIdentifier nodePath = (InstanceIdentifier)_child.toInstance();
        NodeRef _nodeRef = new NodeRef(nodePath);
        return _nodeRef;
    }

    public static NodeConnectorRef toNodeConnectorRef(NodeConnector nodeConnector) {
        NodeConnectorKey _nodeConnectorKey;
        InstanceIdentifier _value;
        Node _node = nodeConnector.getNode();
        NodeRef node = NodeMapping.toNodeRef(_node);
        InstanceIdentifier nodePath = _value = node.getValue();
        NodeConnectorId nodeConnectorId = null;
        Object _iD = nodeConnector.getID();
        boolean _equals = _iD.equals(NodeConnector.SPECIALNODECONNECTORID);
        if (_equals) {
            String _type = nodeConnector.getType();
            boolean _equals_1 = _type.equals(NodeConnector.NodeConnectorIDType.SWSTACK);
            if (_equals_1) {
                NodeConnectorId _localNodeConnectorId;
                NodeId _nodeId = NodeMapping.toNodeId((InstanceIdentifier<? extends Object>)nodePath);
                nodeConnectorId = _localNodeConnectorId = NodeMapping.toLocalNodeConnectorId(_nodeId);
            } else {
                String _type_1 = nodeConnector.getType();
                boolean _equals_2 = _type_1.equals(NodeConnector.NodeConnectorIDType.HWPATH);
                if (_equals_2) {
                    NodeConnectorId _normalNodeConnectorId;
                    NodeId _nodeId_1 = NodeMapping.toNodeId((InstanceIdentifier<? extends Object>)nodePath);
                    nodeConnectorId = _normalNodeConnectorId = NodeMapping.toNormalNodeConnectorId(_nodeId_1);
                } else {
                    String _type_2 = nodeConnector.getType();
                    boolean _equals_3 = _type_2.equals(NodeConnector.NodeConnectorIDType.CONTROLLER);
                    if (_equals_3) {
                        NodeConnectorId _controllerNodeConnectorId;
                        NodeId _nodeId_2 = NodeMapping.toNodeId((InstanceIdentifier<? extends Object>)nodePath);
                        nodeConnectorId = _controllerNodeConnectorId = NodeMapping.toControllerNodeConnectorId(_nodeId_2);
                    }
                }
            }
        } else {
            NodeConnectorId _nodeConnectorId;
            Object _iD_1 = nodeConnector.getID();
            String _checkInstanceOf = (String)Arguments.checkInstanceOf((Object)_iD_1, String.class);
            nodeConnectorId = _nodeConnectorId = new NodeConnectorId(_checkInstanceOf);
        }
        NodeConnectorKey connectorKey = _nodeConnectorKey = new NodeConnectorKey(nodeConnectorId);
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder((InstanceIdentifier)nodePath);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(NODECONNECTOR_CLASS, (Identifier)connectorKey);
        InstanceIdentifier path = (InstanceIdentifier)_child.toInstance();
        NodeConnectorRef _nodeConnectorRef = new NodeConnectorRef(path);
        return _nodeConnectorRef;
    }

    public static Node toADNode(NodeRef node) throws ConstructionException {
        InstanceIdentifier _value = node.getValue();
        return NodeMapping.toADNode((InstanceIdentifier<? extends Object>)_value);
    }

    public static HashSet<Property> toADNodeConnectorProperties(NodeConnectorUpdated nc) {
        boolean _notEquals;
        FlowCapableNodeConnectorUpdated fcncu = (FlowCapableNodeConnectorUpdated)nc.getAugmentation(FlowCapableNodeConnectorUpdated.class);
        boolean bl = _notEquals = !Objects.equal((Object)fcncu, null);
        if (_notEquals) {
            return NodeMapping.toADNodeConnectorProperties((FlowNodeConnector)fcncu);
        }
        HashSet<Property> _hashSet = new HashSet<Property>();
        return _hashSet;
    }

    public static HashSet<Property> toADNodeConnectorProperties(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector nc) {
        boolean _notEquals;
        FlowCapableNodeConnector fcnc = (FlowCapableNodeConnector)nc.getAugmentation(FlowCapableNodeConnector.class);
        boolean bl = _notEquals = !Objects.equal((Object)fcnc, null);
        if (_notEquals) {
            return NodeMapping.toADNodeConnectorProperties((FlowNodeConnector)fcnc);
        }
        HashSet<Property> _hashSet = new HashSet<Property>();
        return _hashSet;
    }

    public static HashSet<Property> toADNodeConnectorProperties(FlowNodeConnector fcncu) {
        boolean _notEquals;
        HashSet<Property> _hashSet;
        HashSet<Property> props = _hashSet = new HashSet<Property>();
        boolean bl = _notEquals = !Objects.equal((Object)fcncu, null);
        if (_notEquals) {
            boolean _notEquals_13;
            boolean _notEquals_11;
            boolean _notEquals_9;
            boolean _notEquals_7;
            boolean _notEquals_5;
            boolean _notEquals_3;
            boolean _notEquals_1;
            boolean _and = false;
            PortFeatures _currentFeature = fcncu.getCurrentFeature();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_currentFeature, null);
            if (!_notEquals_1) {
                _and = false;
            } else {
                PortFeatures _currentFeature_1 = fcncu.getCurrentFeature();
                Bandwidth _adBandwidth = NodeMapping.toAdBandwidth(_currentFeature_1);
                boolean _notEquals_2 = !Objects.equal((Object)_adBandwidth, null);
                boolean bl3 = _and = _notEquals_1 && _notEquals_2;
            }
            if (_and) {
                PortFeatures _currentFeature_2 = fcncu.getCurrentFeature();
                Bandwidth _adBandwidth_1 = NodeMapping.toAdBandwidth(_currentFeature_2);
                props.add((Property)_adBandwidth_1);
            }
            boolean _and_1 = false;
            PortFeatures _advertisedFeatures = fcncu.getAdvertisedFeatures();
            boolean bl4 = _notEquals_3 = !Objects.equal((Object)_advertisedFeatures, null);
            if (!_notEquals_3) {
                _and_1 = false;
            } else {
                PortFeatures _advertisedFeatures_1 = fcncu.getAdvertisedFeatures();
                AdvertisedBandwidth _adAdvertizedBandwidth = NodeMapping.toAdAdvertizedBandwidth(_advertisedFeatures_1);
                boolean _notEquals_4 = !Objects.equal((Object)_adAdvertizedBandwidth, null);
                boolean bl5 = _and_1 = _notEquals_3 && _notEquals_4;
            }
            if (_and_1) {
                PortFeatures _advertisedFeatures_2 = fcncu.getAdvertisedFeatures();
                AdvertisedBandwidth _adAdvertizedBandwidth_1 = NodeMapping.toAdAdvertizedBandwidth(_advertisedFeatures_2);
                props.add((Property)_adAdvertizedBandwidth_1);
            }
            boolean _and_2 = false;
            PortFeatures _supported = fcncu.getSupported();
            boolean bl6 = _notEquals_5 = !Objects.equal((Object)_supported, null);
            if (!_notEquals_5) {
                _and_2 = false;
            } else {
                PortFeatures _supported_1 = fcncu.getSupported();
                SupportedBandwidth _adSupportedBandwidth = NodeMapping.toAdSupportedBandwidth(_supported_1);
                boolean _notEquals_6 = !Objects.equal((Object)_adSupportedBandwidth, null);
                boolean bl7 = _and_2 = _notEquals_5 && _notEquals_6;
            }
            if (_and_2) {
                PortFeatures _supported_2 = fcncu.getSupported();
                SupportedBandwidth _adSupportedBandwidth_1 = NodeMapping.toAdSupportedBandwidth(_supported_2);
                props.add((Property)_adSupportedBandwidth_1);
            }
            boolean _and_3 = false;
            PortFeatures _peerFeatures = fcncu.getPeerFeatures();
            boolean bl8 = _notEquals_7 = !Objects.equal((Object)_peerFeatures, null);
            if (!_notEquals_7) {
                _and_3 = false;
            } else {
                PortFeatures _peerFeatures_1 = fcncu.getPeerFeatures();
                PeerBandwidth _adPeerBandwidth = NodeMapping.toAdPeerBandwidth(_peerFeatures_1);
                boolean _notEquals_8 = !Objects.equal((Object)_adPeerBandwidth, null);
                boolean bl9 = _and_3 = _notEquals_7 && _notEquals_8;
            }
            if (_and_3) {
                PortFeatures _peerFeatures_2 = fcncu.getPeerFeatures();
                PeerBandwidth _adPeerBandwidth_1 = NodeMapping.toAdPeerBandwidth(_peerFeatures_2);
                props.add((Property)_adPeerBandwidth_1);
            }
            boolean _and_4 = false;
            String _name = fcncu.getName();
            boolean bl10 = _notEquals_9 = !Objects.equal((Object)_name, null);
            if (!_notEquals_9) {
                _and_4 = false;
            } else {
                String _name_1 = fcncu.getName();
                Name _adName = NodeMapping.toAdName(_name_1);
                boolean _notEquals_10 = !Objects.equal((Object)_adName, null);
                boolean bl11 = _and_4 = _notEquals_9 && _notEquals_10;
            }
            if (_and_4) {
                String _name_2 = fcncu.getName();
                Name _adName_1 = NodeMapping.toAdName(_name_2);
                props.add((Property)_adName_1);
            }
            boolean _and_5 = false;
            PortConfig _configuration = fcncu.getConfiguration();
            boolean bl12 = _notEquals_11 = !Objects.equal((Object)_configuration, null);
            if (!_notEquals_11) {
                _and_5 = false;
            } else {
                PortConfig _configuration_1 = fcncu.getConfiguration();
                Config _adConfig = NodeMapping.toAdConfig(_configuration_1);
                boolean _notEquals_12 = !Objects.equal((Object)_adConfig, null);
                boolean bl13 = _and_5 = _notEquals_11 && _notEquals_12;
            }
            if (_and_5) {
                PortConfig _configuration_2 = fcncu.getConfiguration();
                Config _adConfig_1 = NodeMapping.toAdConfig(_configuration_2);
                props.add((Property)_adConfig_1);
            }
            boolean _and_6 = false;
            State _state = fcncu.getState();
            boolean bl14 = _notEquals_13 = !Objects.equal((Object)_state, null);
            if (!_notEquals_13) {
                _and_6 = false;
            } else {
                State _state_1 = fcncu.getState();
                org.opendaylight.controller.sal.core.State _adState = NodeMapping.toAdState(_state_1);
                boolean _notEquals_14 = !Objects.equal((Object)_adState, null);
                boolean bl15 = _and_6 = _notEquals_13 && _notEquals_14;
            }
            if (_and_6) {
                State _state_2 = fcncu.getState();
                org.opendaylight.controller.sal.core.State _adState_1 = NodeMapping.toAdState(_state_2);
                props.add((Property)_adState_1);
            }
        }
        return props;
    }

    public static Name toAdName(String name) {
        Name _name = new Name(name);
        return _name;
    }

    public static Config toAdConfig(PortConfig pc) {
        Config _config_1;
        Config _config;
        Config config = null;
        Boolean _isPORTDOWN = pc.isPORTDOWN();
        config = _isPORTDOWN != false ? (_config = new Config(0)) : (_config_1 = new Config(1));
        return config;
    }

    public static org.opendaylight.controller.sal.core.State toAdState(State s) {
        org.opendaylight.controller.sal.core.State _state_1;
        org.opendaylight.controller.sal.core.State _state;
        org.opendaylight.controller.sal.core.State state = null;
        Boolean _isLinkDown = s.isLinkDown();
        state = _isLinkDown != false ? (_state = new org.opendaylight.controller.sal.core.State(0)) : (_state_1 = new org.opendaylight.controller.sal.core.State(1));
        return state;
    }

    public static Bandwidth toAdBandwidth(PortFeatures pf) {
        Bandwidth bw = null;
        boolean _or = false;
        Boolean _isTenMbHd = pf.isTenMbHd();
        if (_isTenMbHd.booleanValue()) {
            _or = true;
        } else {
            Boolean _isTenMbFd = pf.isTenMbFd();
            boolean bl = _or = _isTenMbHd != false || _isTenMbFd != false;
        }
        if (_or) {
            Bandwidth _bandwidth;
            bw = _bandwidth = new Bandwidth(Bandwidth.BW10Mbps);
        } else {
            boolean _or_1 = false;
            Boolean _isHundredMbHd = pf.isHundredMbHd();
            if (_isHundredMbHd.booleanValue()) {
                _or_1 = true;
            } else {
                Boolean _isHundredMbFd = pf.isHundredMbFd();
                boolean bl = _or_1 = _isHundredMbHd != false || _isHundredMbFd != false;
            }
            if (_or_1) {
                Bandwidth _bandwidth_1;
                bw = _bandwidth_1 = new Bandwidth(Bandwidth.BW100Mbps);
            } else {
                boolean _or_2 = false;
                Boolean _isOneGbHd = pf.isOneGbHd();
                if (_isOneGbHd.booleanValue()) {
                    _or_2 = true;
                } else {
                    Boolean _isOneGbFd = pf.isOneGbFd();
                    boolean bl = _or_2 = _isOneGbHd != false || _isOneGbFd != false;
                }
                if (_or_2) {
                    Bandwidth _bandwidth_2;
                    bw = _bandwidth_2 = new Bandwidth(Bandwidth.BW1Gbps);
                } else {
                    Boolean _isOneGbFd_1 = pf.isOneGbFd();
                    if (_isOneGbFd_1.booleanValue()) {
                        Bandwidth _bandwidth_3;
                        bw = _bandwidth_3 = new Bandwidth(Bandwidth.BW10Gbps);
                    } else {
                        Boolean _isTenGbFd = pf.isTenGbFd();
                        if (_isTenGbFd.booleanValue()) {
                            Bandwidth _bandwidth_4;
                            bw = _bandwidth_4 = new Bandwidth(Bandwidth.BW10Gbps);
                        } else {
                            Boolean _isFortyGbFd = pf.isFortyGbFd();
                            if (_isFortyGbFd.booleanValue()) {
                                Bandwidth _bandwidth_5;
                                bw = _bandwidth_5 = new Bandwidth(Bandwidth.BW40Gbps);
                            } else {
                                Boolean _isHundredGbFd = pf.isHundredGbFd();
                                if (_isHundredGbFd.booleanValue()) {
                                    Bandwidth _bandwidth_6;
                                    bw = _bandwidth_6 = new Bandwidth(Bandwidth.BW100Gbps);
                                } else {
                                    Boolean _isOneTbFd = pf.isOneTbFd();
                                    if (_isOneTbFd.booleanValue()) {
                                        Bandwidth _bandwidth_7;
                                        bw = _bandwidth_7 = new Bandwidth(Bandwidth.BW1Tbps);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return bw;
    }

    public static AdvertisedBandwidth toAdAdvertizedBandwidth(PortFeatures pf) {
        boolean _notEquals;
        AdvertisedBandwidth abw = null;
        Bandwidth bw = NodeMapping.toAdBandwidth(pf);
        boolean bl = _notEquals = !Objects.equal((Object)bw, null);
        if (_notEquals) {
            AdvertisedBandwidth _advertisedBandwidth;
            long _value = bw.getValue();
            abw = _advertisedBandwidth = new AdvertisedBandwidth(_value);
        }
        return abw;
    }

    public static SupportedBandwidth toAdSupportedBandwidth(PortFeatures pf) {
        boolean _notEquals;
        SupportedBandwidth sbw = null;
        Bandwidth bw = NodeMapping.toAdBandwidth(pf);
        boolean bl = _notEquals = !Objects.equal((Object)bw, null);
        if (_notEquals) {
            SupportedBandwidth _supportedBandwidth;
            long _value = bw.getValue();
            sbw = _supportedBandwidth = new SupportedBandwidth(_value);
        }
        return sbw;
    }

    public static PeerBandwidth toAdPeerBandwidth(PortFeatures pf) {
        boolean _notEquals;
        PeerBandwidth pbw = null;
        Bandwidth bw = NodeMapping.toAdBandwidth(pf);
        boolean bl = _notEquals = !Objects.equal((Object)bw, null);
        if (_notEquals) {
            PeerBandwidth _peerBandwidth;
            long _value = bw.getValue();
            pbw = _peerBandwidth = new PeerBandwidth(_value);
        }
        return pbw;
    }

    public static HashSet<Property> toADNodeProperties(NodeUpdated nu) {
        boolean _notEquals;
        FlowCapableNodeUpdated fcnu = (FlowCapableNodeUpdated)nu.getAugmentation(FlowCapableNodeUpdated.class);
        boolean bl = _notEquals = !Objects.equal((Object)fcnu, null);
        if (_notEquals) {
            NodeId _id = nu.getId();
            return NodeMapping.toADNodeProperties((FlowNode)fcnu, _id);
        }
        HashSet<Property> _hashSet = new HashSet<Property>();
        return _hashSet;
    }

    public static HashSet<Property> toADNodeProperties(FlowNode fcnu, NodeId id) {
        boolean _notEquals;
        HashSet<Property> _hashSet;
        HashSet<Property> props = _hashSet = new HashSet<Property>();
        boolean bl = _notEquals = !Objects.equal((Object)fcnu, null);
        if (_notEquals) {
            SwitchFeatures _switchFeatures;
            boolean _notEquals_2;
            boolean _notEquals_1;
            TimeStamp _aDTimestamp = NodeMapping.toADTimestamp();
            props.add((Property)_aDTimestamp);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)id, null);
            if (_notEquals_1) {
                MacAddress _aDMacAddress = NodeMapping.toADMacAddress(id);
                props.add((Property)_aDMacAddress);
            }
            boolean bl3 = _notEquals_2 = !Objects.equal((Object)(_switchFeatures = fcnu.getSwitchFeatures()), null);
            if (_notEquals_2) {
                SwitchFeatures _switchFeatures_5;
                Long _maxBuffers;
                boolean _notEquals_5;
                SwitchFeatures _switchFeatures_3;
                List _capabilities;
                boolean _notEquals_4;
                boolean _notEquals_3;
                SwitchFeatures _switchFeatures_1 = fcnu.getSwitchFeatures();
                Short _maxTables = _switchFeatures_1.getMaxTables();
                boolean bl4 = _notEquals_3 = !Objects.equal((Object)_maxTables, null);
                if (_notEquals_3) {
                    SwitchFeatures _switchFeatures_2 = fcnu.getSwitchFeatures();
                    Short _maxTables_1 = _switchFeatures_2.getMaxTables();
                    Tables _aDTables = NodeMapping.toADTables(_maxTables_1);
                    props.add((Property)_aDTables);
                }
                boolean bl5 = _notEquals_4 = !Objects.equal((Object)(_capabilities = (_switchFeatures_3 = fcnu.getSwitchFeatures()).getCapabilities()), null);
                if (_notEquals_4) {
                    SwitchFeatures _switchFeatures_4 = fcnu.getSwitchFeatures();
                    List _capabilities_1 = _switchFeatures_4.getCapabilities();
                    Capabilities _aDCapabiliities = NodeMapping.toADCapabiliities(_capabilities_1);
                    props.add((Property)_aDCapabiliities);
                }
                boolean bl6 = _notEquals_5 = !Objects.equal((Object)(_maxBuffers = (_switchFeatures_5 = fcnu.getSwitchFeatures()).getMaxBuffers()), null);
                if (_notEquals_5) {
                    SwitchFeatures _switchFeatures_6 = fcnu.getSwitchFeatures();
                    Long _maxBuffers_1 = _switchFeatures_6.getMaxBuffers();
                    Buffers _aDBuffers = NodeMapping.toADBuffers(_maxBuffers_1);
                    props.add((Property)_aDBuffers);
                }
            }
        }
        return props;
    }

    public static TimeStamp toADTimestamp() {
        TimeStamp _timeStamp;
        Date _date;
        Date date = _date = new Date();
        long _time = date.getTime();
        TimeStamp timestamp = _timeStamp = new TimeStamp(_time, "connectedSince");
        return timestamp;
    }

    public static MacAddress toADMacAddress(NodeId id) {
        String _value = id.getValue();
        String _replaceAll = _value.replaceAll("openflow:", "");
        long _parseLong = Long.parseLong(_replaceAll);
        long _longValue = _parseLong;
        byte[] _bytesFromDpid = ToSalConversionsUtils.bytesFromDpid(_longValue);
        MacAddress _macAddress = new MacAddress(_bytesFromDpid);
        return _macAddress;
    }

    public static Tables toADTables(Short tables) {
        byte _byteValue = tables.byteValue();
        Tables _tables = new Tables(_byteValue);
        return _tables;
    }

    public static Capabilities toADCapabiliities(List<Class<? extends FeatureCapability>> capabilities) {
        int b = 0;
        for (Class<? extends FeatureCapability> capability : capabilities) {
            int _bitwiseOr_6;
            boolean _equals = capability.equals(FlowFeatureCapabilityFlowStats.class);
            if (_equals) {
                int _bitwiseOr;
                int _value = Capabilities.CapabilitiesType.FLOW_STATS_CAPABILITY.getValue();
                b = _bitwiseOr = _value | b;
                continue;
            }
            boolean _equals_1 = capability.equals(FlowFeatureCapabilityTableStats.class);
            if (_equals_1) {
                int _bitwiseOr_1;
                int _value_1 = Capabilities.CapabilitiesType.TABLE_STATS_CAPABILITY.getValue();
                b = _bitwiseOr_1 = _value_1 | b;
                continue;
            }
            boolean _equals_2 = capability.equals(FlowFeatureCapabilityPortStats.class);
            if (_equals_2) {
                int _bitwiseOr_2;
                int _value_2 = Capabilities.CapabilitiesType.PORT_STATS_CAPABILITY.getValue();
                b = _bitwiseOr_2 = _value_2 | b;
                continue;
            }
            boolean _equals_3 = capability.equals(FlowFeatureCapabilityStp.class);
            if (_equals_3) {
                int _bitwiseOr_3;
                int _value_3 = Capabilities.CapabilitiesType.STP_CAPABILITY.getValue();
                b = _bitwiseOr_3 = _value_3 | b;
                continue;
            }
            boolean _equals_4 = capability.equals(FlowFeatureCapabilityIpReasm.class);
            if (_equals_4) {
                int _bitwiseOr_4;
                int _value_4 = Capabilities.CapabilitiesType.IP_REASSEM_CAPABILITY.getValue();
                b = _bitwiseOr_4 = _value_4 | b;
                continue;
            }
            boolean _equals_5 = capability.equals(FlowFeatureCapabilityQueueStats.class);
            if (_equals_5) {
                int _bitwiseOr_5;
                int _value_5 = Capabilities.CapabilitiesType.QUEUE_STATS_CAPABILITY.getValue();
                b = _bitwiseOr_5 = _value_5 | b;
                continue;
            }
            boolean _equals_6 = capability.equals(FlowFeatureCapabilityArpMatchIp.class);
            if (!_equals_6) continue;
            int _value_6 = Capabilities.CapabilitiesType.ARP_MATCH_IP_CAPABILITY.getValue();
            b = _bitwiseOr_6 = _value_6 | b;
        }
        Capabilities _capabilities = new Capabilities(b);
        return _capabilities;
    }

    public static Buffers toADBuffers(Long buffers) {
        int _intValue = buffers.intValue();
        Buffers _buffers = new Buffers(_intValue);
        return _buffers;
    }
}

