/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.compatibility;

import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class InventoryMapping {
    public static NodeConnector toAdNodeConnector(InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector> identifier) {
        List _path = identifier.getPath();
        InstanceIdentifier.PathArgument _last = (InstanceIdentifier.PathArgument)IterableExtensions.last((Iterable)_path);
        NodeConnectorKey tpKey = (NodeConnectorKey)((InstanceIdentifier.IdentifiableItem)_last).getKey();
        NodeConnectorId _id = tpKey.getId();
        String _value = _id.getValue();
        return InventoryMapping.nodeConnectorFromId(_value);
    }

    public static Node toAdNode(InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node> identifier) {
        List _path = identifier.getPath();
        InstanceIdentifier.PathArgument _last = (InstanceIdentifier.PathArgument)IterableExtensions.last((Iterable)_path);
        NodeKey tpKey = (NodeKey)((InstanceIdentifier.IdentifiableItem)_last).getKey();
        NodeId _id = tpKey.getId();
        String _value = _id.getValue();
        return InventoryMapping.nodeFromNodeId(_value);
    }

    public static NodeRef toNodeRef(Node node) {
        NodeKey _nodeKey;
        String _nodeId = InventoryMapping.toNodeId(node);
        NodeId _nodeId_1 = new NodeId(_nodeId);
        NodeKey nodeId = _nodeKey = new NodeKey(_nodeId_1);
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder();
        InstanceIdentifier.InstanceIdentifierBuilder _node = _builder.node(Nodes.class);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _node.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class, (Identifier)nodeId);
        InstanceIdentifier path = (InstanceIdentifier)_child.toInstance();
        NodeRef _nodeRef = new NodeRef(path);
        return _nodeRef;
    }

    public static NodeKey toNodeKey(Node node) {
        NodeId _nodeId_1;
        String _nodeId = InventoryMapping.toNodeId(node);
        NodeId nodeId = _nodeId_1 = new NodeId(_nodeId);
        NodeKey _nodeKey = new NodeKey(nodeId);
        return _nodeKey;
    }

    public static NodeConnectorKey toNodeConnectorKey(NodeConnector nc) {
        NodeConnectorId _nodeConnectorId_1;
        String _nodeConnectorId = InventoryMapping.toNodeConnectorId(nc);
        NodeConnectorId nodeId = _nodeConnectorId_1 = new NodeConnectorId(_nodeConnectorId);
        NodeConnectorKey _nodeConnectorKey = new NodeConnectorKey(nodeId);
        return _nodeConnectorKey;
    }

    public static String toNodeId(Node node) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"ad-sal:");
        String _type = node.getType();
        _builder.append((Object)_type, "");
        _builder.append((Object)"::");
        String _nodeIDString = node.getNodeIDString();
        _builder.append((Object)_nodeIDString, "");
        return _builder.toString();
    }

    public static String toNodeConnectorId(NodeConnector nc) {
        StringConcatenation _builder = new StringConcatenation();
        Node _node = nc.getNode();
        String _nodeId = InventoryMapping.toNodeId(_node);
        _builder.append((Object)_nodeId, "");
        _builder.append((Object)"::");
        String _nodeConnectorIDString = nc.getNodeConnectorIDString();
        _builder.append((Object)_nodeConnectorIDString, "");
        return _builder.toString();
    }

    public static Node nodeFromNodeId(String nodeId) {
        String[] _split = nodeId.split("::");
        return InventoryMapping.nodeFromString(_split);
    }

    public static NodeConnector nodeConnectorFromId(String invId) {
        String[] _split = invId.split("::");
        return InventoryMapping.nodeConnectorFromString(_split);
    }

    private static NodeConnector nodeConnectorFromString(String[] string) {
        List _subList = ((List)Conversions.doWrapArray((Object)string)).subList(0, 1);
        Node node = InventoryMapping.nodeFromString((String[])Conversions.unwrapArray(_subList, String.class));
        String _get = string[2];
        return NodeConnector.fromStringNoNode((String)_get, (Node)node);
    }

    private static Node nodeFromString(String[] strings) {
        Node _fromString;
        Node _xblockexpression = null;
        String _get = strings[0];
        String type = _get.substring(6);
        String _get_1 = strings[1];
        _xblockexpression = _fromString = Node.fromString((String)type, (String)_get_1);
        return _xblockexpression;
    }
}

