/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.compatibility;

import com.google.common.base.Objects;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.md.sal.binding.util.TypeSafeDataReader;
import org.opendaylight.controller.md.sal.common.api.data.DataReader;
import org.opendaylight.controller.sal.binding.api.data.DataBrokerService;
import org.opendaylight.controller.sal.binding.api.data.DataModificationTransaction;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.opendaylight.controller.sal.common.util.Arguments;
import org.opendaylight.controller.sal.compatibility.FromSalConversionsUtils;
import org.opendaylight.controller.sal.compatibility.InventoryMapping;
import org.opendaylight.controller.sal.compatibility.MDFlowMapping;
import org.opendaylight.controller.sal.compatibility.NodeMapping;
import org.opendaylight.controller.sal.compatibility.ToSalConversionsUtils;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.NodeTable;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.inventory.IPluginInInventoryService;
import org.opendaylight.controller.sal.inventory.IPluginOutInventoryService;
import org.opendaylight.controller.sal.reader.FlowOnNode;
import org.opendaylight.controller.sal.reader.IPluginInReadService;
import org.opendaylight.controller.sal.reader.IPluginOutReadService;
import org.opendaylight.controller.sal.reader.NodeConnectorStatistics;
import org.opendaylight.controller.sal.reader.NodeDescription;
import org.opendaylight.controller.sal.reader.NodeTableStatistics;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter32;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowNodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.AggregateFlowStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.FlowStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.FlowsStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowsStatisticsFromAllFlowTablesInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowsStatisticsFromAllFlowTablesInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetFlowStatisticsFromFlowTableInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetFlowStatisticsFromFlowTableInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.OpendaylightFlowStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.OpendaylightFlowStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.flow.and.statistics.map.list.FlowAndStatisticsMapList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.flow.statistics.FlowStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.FlowTableStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.FlowTableStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.GetFlowTablesStatisticsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.GetFlowTablesStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.OpendaylightFlowTableStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.OpendaylightFlowTableStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.flow.table.and.statistics.map.FlowTableAndStatisticsMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.flow.table.statistics.FlowTableStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.topology.discovery.rev130819.FlowTopologyDiscoveryService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.topology.discovery.rev130819.Link;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.OpendaylightInventoryListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.duration.Duration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.node.connector.statistics.Bytes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.node.connector.statistics.Packets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.FlowCapableNodeConnectorStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.GetAllNodeConnectorsStatisticsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.GetAllNodeConnectorsStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.GetNodeConnectorStatisticsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.GetNodeConnectorStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.NodeConnectorStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.OpendaylightPortStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.OpendaylightPortStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.flow.capable.node.connector.statistics.FlowCapableNodeConnectorStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.node.connector.statistics.and.port.number.map.NodeConnectorStatisticsAndPortNumberMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableId;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryAndReadAdapter
implements IPluginInReadService,
IPluginInInventoryService,
OpendaylightInventoryListener,
OpendaylightFlowStatisticsListener,
OpendaylightFlowTableStatisticsListener,
OpendaylightPortStatisticsListener {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(InventoryAndReadAdapter.class);
            return _logger;
        }
    }.apply();
    private static final short OPENFLOWV10_TABLE_ID = new Functions.Function0<Short>(){

        public Short apply() {
            Integer _integer = new Integer(0);
            short _shortValue = _integer.shortValue();
            return _shortValue;
        }
    }.apply();
    private DataBrokerService _dataService;
    private DataProviderService _dataProviderService;
    private OpendaylightFlowStatisticsService _flowStatisticsService;
    private OpendaylightPortStatisticsService _nodeConnectorStatisticsService;
    private OpendaylightFlowTableStatisticsService _flowTableStatisticsService;
    private FlowTopologyDiscoveryService _topologyDiscovery;
    private List<IPluginOutReadService> _statisticsPublisher = new Functions.Function0<List<IPluginOutReadService>>(){

        public List<IPluginOutReadService> apply() {
            CopyOnWriteArrayList<IPluginOutReadService> _copyOnWriteArrayList = new CopyOnWriteArrayList<IPluginOutReadService>();
            return _copyOnWriteArrayList;
        }
    }.apply();
    private List<IPluginOutInventoryService> _inventoryPublisher = new Functions.Function0<List<IPluginOutInventoryService>>(){

        public List<IPluginOutInventoryService> apply() {
            CopyOnWriteArrayList<IPluginOutInventoryService> _copyOnWriteArrayList = new CopyOnWriteArrayList<IPluginOutInventoryService>();
            return _copyOnWriteArrayList;
        }
    }.apply();

    public DataBrokerService getDataService() {
        return this._dataService;
    }

    public void setDataService(DataBrokerService dataService) {
        this._dataService = dataService;
    }

    public DataProviderService getDataProviderService() {
        return this._dataProviderService;
    }

    public void setDataProviderService(DataProviderService dataProviderService) {
        this._dataProviderService = dataProviderService;
    }

    public OpendaylightFlowStatisticsService getFlowStatisticsService() {
        return this._flowStatisticsService;
    }

    public void setFlowStatisticsService(OpendaylightFlowStatisticsService flowStatisticsService) {
        this._flowStatisticsService = flowStatisticsService;
    }

    public OpendaylightPortStatisticsService getNodeConnectorStatisticsService() {
        return this._nodeConnectorStatisticsService;
    }

    public void setNodeConnectorStatisticsService(OpendaylightPortStatisticsService nodeConnectorStatisticsService) {
        this._nodeConnectorStatisticsService = nodeConnectorStatisticsService;
    }

    public OpendaylightFlowTableStatisticsService getFlowTableStatisticsService() {
        return this._flowTableStatisticsService;
    }

    public void setFlowTableStatisticsService(OpendaylightFlowTableStatisticsService flowTableStatisticsService) {
        this._flowTableStatisticsService = flowTableStatisticsService;
    }

    public FlowTopologyDiscoveryService getTopologyDiscovery() {
        return this._topologyDiscovery;
    }

    public void setTopologyDiscovery(FlowTopologyDiscoveryService topologyDiscovery) {
        this._topologyDiscovery = topologyDiscovery;
    }

    public List<IPluginOutReadService> getStatisticsPublisher() {
        return this._statisticsPublisher;
    }

    public void setStatisticsPublisher(List<IPluginOutReadService> statisticsPublisher) {
        this._statisticsPublisher = statisticsPublisher;
    }

    public List<IPluginOutInventoryService> getInventoryPublisher() {
        return this._inventoryPublisher;
    }

    public void setInventoryPublisher(List<IPluginOutInventoryService> inventoryPublisher) {
        this._inventoryPublisher = inventoryPublisher;
    }

    public boolean setInventoryPublisher(IPluginOutInventoryService listener) {
        List<IPluginOutInventoryService> _inventoryPublisher = this.getInventoryPublisher();
        boolean _add = _inventoryPublisher.add(listener);
        return _add;
    }

    public boolean unsetInventoryPublisher(IPluginOutInventoryService listener) {
        List<IPluginOutInventoryService> _inventoryPublisher = this.getInventoryPublisher();
        boolean _remove = _inventoryPublisher.remove(listener);
        return _remove;
    }

    public boolean setReadPublisher(IPluginOutReadService listener) {
        List<IPluginOutReadService> _statisticsPublisher = this.getStatisticsPublisher();
        boolean _add = _statisticsPublisher.add(listener);
        return _add;
    }

    public Boolean unsetReadPublisher(IPluginOutReadService listener) {
        boolean _notEquals;
        Boolean _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)listener, null);
        if (_notEquals) {
            List<IPluginOutReadService> _statisticsPublisher = this.getStatisticsPublisher();
            boolean _remove = _statisticsPublisher.remove(listener);
            _xifexpression = _remove;
        }
        return _xifexpression;
    }

    protected DataModificationTransaction startChange() {
        DataProviderService _dataProviderService = this.getDataProviderService();
        return _dataProviderService.beginTransaction();
    }

    public long getTransmitRate(NodeConnector connector) {
        NodeConnectorRef _nodeConnectorRef = NodeMapping.toNodeConnectorRef(connector);
        FlowCapableNodeConnector nodeConnector = this.readFlowCapableNodeConnector(_nodeConnectorRef);
        return nodeConnector.getCurrentSpeed();
    }

    public List<FlowOnNode> readAllFlow(Node node, boolean cached) {
        GetAllFlowsStatisticsFromAllFlowTablesInputBuilder _getAllFlowsStatisticsFromAllFlowTablesInputBuilder;
        boolean _notEquals;
        ArrayList<FlowOnNode> _arrayList;
        ArrayList<FlowOnNode> output = _arrayList = new ArrayList<FlowOnNode>();
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(Nodes.class);
        NodeKey _nodeKey = InventoryMapping.toNodeKey(node);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class, (Identifier)_nodeKey);
        InstanceIdentifier.InstanceIdentifierBuilder _augmentation = _child.augmentation(FlowCapableNode.class);
        TableKey _tableKey = new TableKey(Short.valueOf(OPENFLOWV10_TABLE_ID));
        InstanceIdentifier.InstanceIdentifierBuilder _child_1 = _augmentation.child(Table.class, (Identifier)_tableKey);
        InstanceIdentifier tableRef = (InstanceIdentifier)_child_1.toInstance();
        DataModificationTransaction it = this.startChange();
        DataObject _readConfigurationData = (DataObject)it.readConfigurationData((Object)tableRef);
        Table table = (Table)_readConfigurationData;
        boolean bl = _notEquals = !Objects.equal((Object)table, null);
        if (_notEquals) {
            List _flow = table.getFlow();
            int _size = _flow.size();
            LOG.trace("Number of flows installed in table 0 of node {} : {}", (Object)node, (Object)_size);
            List _flow_1 = table.getFlow();
            for (org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow flow : _flow_1) {
                FlowOnNode _flowOnNode;
                Flow adsalFlow = ToSalConversionsUtils.toFlow((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow)flow, node);
                FlowStatisticsData statsFromDataStore = (FlowStatisticsData)flow.getAugmentation(FlowStatisticsData.class);
                boolean _notEquals_1 = !Objects.equal((Object)statsFromDataStore, null);
                if (!_notEquals_1) continue;
                FlowOnNode it_1 = _flowOnNode = new FlowOnNode(adsalFlow);
                FlowStatistics _flowStatistics = statsFromDataStore.getFlowStatistics();
                Counter64 _byteCount = _flowStatistics.getByteCount();
                BigInteger _value = _byteCount.getValue();
                long _longValue = _value.longValue();
                it_1.setByteCount(_longValue);
                FlowStatistics _flowStatistics_1 = statsFromDataStore.getFlowStatistics();
                Counter64 _packetCount = _flowStatistics_1.getPacketCount();
                BigInteger _value_1 = _packetCount.getValue();
                long _longValue_1 = _value_1.longValue();
                it_1.setPacketCount(_longValue_1);
                FlowStatistics _flowStatistics_2 = statsFromDataStore.getFlowStatistics();
                Duration _duration = _flowStatistics_2.getDuration();
                Counter32 _second = _duration.getSecond();
                Long _value_2 = _second.getValue();
                int _intValue = _value_2.intValue();
                it_1.setDurationSeconds(_intValue);
                FlowStatistics _flowStatistics_3 = statsFromDataStore.getFlowStatistics();
                Duration _duration_1 = _flowStatistics_3.getDuration();
                Counter32 _nanosecond = _duration_1.getNanosecond();
                Long _value_3 = _nanosecond.getValue();
                int _intValue_1 = _value_3.intValue();
                it_1.setDurationNanoseconds(_intValue_1);
                output.add(it_1);
            }
        }
        GetAllFlowsStatisticsFromAllFlowTablesInputBuilder input = _getAllFlowsStatisticsFromAllFlowTablesInputBuilder = new GetAllFlowsStatisticsFromAllFlowTablesInputBuilder();
        NodeRef _nodeRef = NodeMapping.toNodeRef(node);
        input.setNode(_nodeRef);
        OpendaylightFlowStatisticsService _flowStatisticsService = this.getFlowStatisticsService();
        GetAllFlowsStatisticsFromAllFlowTablesInput _build = input.build();
        _flowStatisticsService.getAllFlowsStatisticsFromAllFlowTables(_build);
        return output;
    }

    public List<NodeConnectorStatistics> readAllNodeConnector(Node node, boolean cached) {
        GetAllNodeConnectorsStatisticsInputBuilder _getAllNodeConnectorsStatisticsInputBuilder;
        boolean _notEquals;
        ArrayList<NodeConnectorStatistics> _arrayList;
        ArrayList<NodeConnectorStatistics> ret = _arrayList = new ArrayList<NodeConnectorStatistics>();
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(Nodes.class);
        NodeKey _nodeKey = InventoryMapping.toNodeKey(node);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class, (Identifier)_nodeKey);
        InstanceIdentifier nodeRef = (InstanceIdentifier)_child.toInstance();
        DataModificationTransaction provider = this.startChange();
        DataObject _readConfigurationData = (DataObject)provider.readConfigurationData((Object)nodeRef);
        org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node dsNode = (org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node)_readConfigurationData;
        boolean bl = _notEquals = !Objects.equal((Object)dsNode, null);
        if (_notEquals) {
            List _nodeConnector = dsNode.getNodeConnector();
            for (org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector dsNodeConnector : _nodeConnector) {
                FlowCapableNodeConnectorStatisticsData _augmentation;
                NodeConnectorKey _key;
                NodeKey _nodeKey_1;
                InstanceIdentifier.InstanceIdentifierBuilder _builder_1 = InstanceIdentifier.builder(Nodes.class);
                InstanceIdentifier.InstanceIdentifierBuilder _child_1 = _builder_1.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class, (Identifier)(_nodeKey_1 = InventoryMapping.toNodeKey(node)));
                InstanceIdentifier.InstanceIdentifierBuilder _child_2 = _child_1.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector.class, (Identifier)(_key = dsNodeConnector.getKey()));
                InstanceIdentifier nodeConnectorRef = (InstanceIdentifier)_child_2.toInstance();
                DataObject _readConfigurationData_1 = (DataObject)provider.readConfigurationData((Object)nodeConnectorRef);
                org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector nodeConnectorFromDS = (org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector)_readConfigurationData_1;
                boolean _notEquals_1 = !Objects.equal((Object)nodeConnectorFromDS, null);
                if (!_notEquals_1) continue;
                FlowCapableNodeConnectorStatisticsData nodeConnectorStatsFromDs = _augmentation = (FlowCapableNodeConnectorStatisticsData)nodeConnectorFromDS.getAugmentation(FlowCapableNodeConnectorStatisticsData.class);
                FlowCapableNodeConnectorStatistics _flowCapableNodeConnectorStatistics = nodeConnectorStatsFromDs.getFlowCapableNodeConnectorStatistics();
                NodeId _id = dsNode.getId();
                NodeConnectorId _id_1 = dsNodeConnector.getId();
                NodeConnectorStatistics _nodeConnectorStatistics = this.toNodeConnectorStatistics((org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.NodeConnectorStatistics)_flowCapableNodeConnectorStatistics, _id, _id_1);
                ret.add(_nodeConnectorStatistics);
            }
        }
        GetAllNodeConnectorsStatisticsInputBuilder input = _getAllNodeConnectorsStatisticsInputBuilder = new GetAllNodeConnectorsStatisticsInputBuilder();
        NodeRef _nodeRef = NodeMapping.toNodeRef(node);
        input.setNode(_nodeRef);
        OpendaylightPortStatisticsService _nodeConnectorStatisticsService = this.getNodeConnectorStatisticsService();
        GetAllNodeConnectorsStatisticsInput _build = input.build();
        _nodeConnectorStatisticsService.getAllNodeConnectorsStatistics(_build);
        return ret;
    }

    public List<NodeTableStatistics> readAllNodeTable(Node node, boolean cached) {
        GetFlowTablesStatisticsInputBuilder _getFlowTablesStatisticsInputBuilder;
        boolean _notEquals;
        ArrayList<NodeTableStatistics> _arrayList;
        ArrayList<NodeTableStatistics> ret = _arrayList = new ArrayList<NodeTableStatistics>();
        NodeRef _nodeRef = NodeMapping.toNodeRef(node);
        FlowCapableNode dsFlowCapableNode = this.readFlowCapableNode(_nodeRef);
        boolean bl = _notEquals = !Objects.equal((Object)dsFlowCapableNode, null);
        if (_notEquals) {
            List _table = dsFlowCapableNode.getTable();
            for (Table table : _table) {
                FlowTableStatisticsData tableStats = (FlowTableStatisticsData)table.getAugmentation(FlowTableStatisticsData.class);
                boolean _notEquals_1 = !Objects.equal((Object)tableStats, null);
                if (!_notEquals_1) continue;
                FlowTableStatistics _flowTableStatistics = tableStats.getFlowTableStatistics();
                Short _id = table.getId();
                NodeTableStatistics _nodeTableStatistics = this.toNodeTableStatistics(_flowTableStatistics, _id, node);
                ret.add(_nodeTableStatistics);
            }
        }
        GetFlowTablesStatisticsInputBuilder input = _getFlowTablesStatisticsInputBuilder = new GetFlowTablesStatisticsInputBuilder();
        NodeRef _nodeRef_1 = NodeMapping.toNodeRef(node);
        input.setNode(_nodeRef_1);
        OpendaylightFlowTableStatisticsService _flowTableStatisticsService = this.getFlowTableStatisticsService();
        GetFlowTablesStatisticsInput _build = input.build();
        _flowTableStatisticsService.getFlowTablesStatistics(_build);
        return ret;
    }

    public NodeDescription readDescription(Node node, boolean cached) {
        NodeRef _nodeRef = NodeMapping.toNodeRef(node);
        return this.toNodeDescription(_nodeRef);
    }

    public FlowOnNode readFlow(Node node, Flow targetFlow, boolean cached) {
        GetFlowStatisticsFromFlowTableInputBuilder _getFlowStatisticsFromFlowTableInputBuilder;
        boolean _notEquals;
        FlowOnNode ret = null;
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(Nodes.class);
        NodeKey _nodeKey = InventoryMapping.toNodeKey(node);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class, (Identifier)_nodeKey);
        InstanceIdentifier.InstanceIdentifierBuilder _augmentation = _child.augmentation(FlowCapableNode.class);
        TableKey _tableKey = new TableKey(Short.valueOf(OPENFLOWV10_TABLE_ID));
        InstanceIdentifier.InstanceIdentifierBuilder _child_1 = _augmentation.child(Table.class, (Identifier)_tableKey);
        InstanceIdentifier tableRef = (InstanceIdentifier)_child_1.toInstance();
        DataModificationTransaction it = this.startChange();
        DataObject _readConfigurationData = (DataObject)it.readConfigurationData((Object)tableRef);
        Table table = (Table)_readConfigurationData;
        boolean bl = _notEquals = !Objects.equal((Object)table, null);
        if (_notEquals) {
            List _flow = table.getFlow();
            int _size = _flow.size();
            LOG.trace("Number of flows installed in table 0 of node {} : {}", (Object)node, (Object)_size);
            List _flow_1 = table.getFlow();
            for (org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow mdsalFlow : _flow_1) {
                FlowOnNode _flowOnNode;
                FlowStatisticsData statsFromDataStore;
                boolean _notEquals_1;
                org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow _mDSalflow;
                boolean _flowEquals = FromSalConversionsUtils.flowEquals(mdsalFlow, _mDSalflow = MDFlowMapping.toMDSalflow(targetFlow));
                if (!_flowEquals || !(_notEquals_1 = !Objects.equal((Object)(statsFromDataStore = (FlowStatisticsData)mdsalFlow.getAugmentation(FlowStatisticsData.class)), null))) continue;
                LOG.debug("Found matching flow in the data store flow table ");
                FlowOnNode it_1 = _flowOnNode = new FlowOnNode(targetFlow);
                FlowStatistics _flowStatistics = statsFromDataStore.getFlowStatistics();
                Counter64 _byteCount = _flowStatistics.getByteCount();
                BigInteger _value = _byteCount.getValue();
                long _longValue = _value.longValue();
                it_1.setByteCount(_longValue);
                FlowStatistics _flowStatistics_1 = statsFromDataStore.getFlowStatistics();
                Counter64 _packetCount = _flowStatistics_1.getPacketCount();
                BigInteger _value_1 = _packetCount.getValue();
                long _longValue_1 = _value_1.longValue();
                it_1.setPacketCount(_longValue_1);
                FlowStatistics _flowStatistics_2 = statsFromDataStore.getFlowStatistics();
                Duration _duration = _flowStatistics_2.getDuration();
                Counter32 _second = _duration.getSecond();
                Long _value_2 = _second.getValue();
                int _intValue = _value_2.intValue();
                it_1.setDurationSeconds(_intValue);
                FlowStatistics _flowStatistics_3 = statsFromDataStore.getFlowStatistics();
                Duration _duration_1 = _flowStatistics_3.getDuration();
                Counter32 _nanosecond = _duration_1.getNanosecond();
                Long _value_3 = _nanosecond.getValue();
                int _intValue_1 = _value_3.intValue();
                it_1.setDurationNanoseconds(_intValue_1);
                ret = it_1;
            }
        }
        GetFlowStatisticsFromFlowTableInputBuilder input = _getFlowStatisticsFromFlowTableInputBuilder = new GetFlowStatisticsFromFlowTableInputBuilder();
        NodeRef _nodeRef = NodeMapping.toNodeRef(node);
        input.setNode(_nodeRef);
        org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow _mDSalflow_1 = MDFlowMapping.toMDSalflow(targetFlow);
        input.fieldsFrom((DataObject)_mDSalflow_1);
        OpendaylightFlowStatisticsService _flowStatisticsService = this.getFlowStatisticsService();
        GetFlowStatisticsFromFlowTableInput _build = input.build();
        _flowStatisticsService.getFlowStatisticsFromFlowTable(_build);
        return ret;
    }

    public NodeConnectorStatistics readNodeConnector(NodeConnector connector, boolean cached) {
        GetNodeConnectorStatisticsInputBuilder _getNodeConnectorStatisticsInputBuilder;
        boolean _notEquals;
        NodeConnectorStatistics nodeConnectorStatistics = null;
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(Nodes.class);
        Node _node = connector.getNode();
        NodeKey _nodeKey = InventoryMapping.toNodeKey(_node);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class, (Identifier)_nodeKey);
        NodeConnectorKey _nodeConnectorKey = InventoryMapping.toNodeConnectorKey(connector);
        InstanceIdentifier.InstanceIdentifierBuilder _child_1 = _child.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector.class, (Identifier)_nodeConnectorKey);
        InstanceIdentifier nodeConnectorRef = (InstanceIdentifier)_child_1.toInstance();
        DataModificationTransaction provider = this.startChange();
        DataObject _readConfigurationData = (DataObject)provider.readConfigurationData((Object)nodeConnectorRef);
        org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector nodeConnectorFromDS = (org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector)_readConfigurationData;
        boolean bl = _notEquals = !Objects.equal((Object)nodeConnectorFromDS, null);
        if (_notEquals) {
            boolean _notEquals_1;
            FlowCapableNodeConnectorStatisticsData _augmentation = (FlowCapableNodeConnectorStatisticsData)nodeConnectorFromDS.getAugmentation(FlowCapableNodeConnectorStatisticsData.class);
            FlowCapableNodeConnectorStatisticsData nodeConnectorStatsFromDs = _augmentation;
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)nodeConnectorStatsFromDs, null);
            if (_notEquals_1) {
                NodeConnectorStatistics _nodeConnectorStatistics;
                FlowCapableNodeConnectorStatistics _flowCapableNodeConnectorStatistics = nodeConnectorStatsFromDs.getFlowCapableNodeConnectorStatistics();
                Node _node_1 = connector.getNode();
                NodeKey _nodeKey_1 = InventoryMapping.toNodeKey(_node_1);
                NodeId _id = _nodeKey_1.getId();
                NodeConnectorKey _nodeConnectorKey_1 = InventoryMapping.toNodeConnectorKey(connector);
                NodeConnectorId _id_1 = _nodeConnectorKey_1.getId();
                nodeConnectorStatistics = _nodeConnectorStatistics = this.toNodeConnectorStatistics((org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.NodeConnectorStatistics)_flowCapableNodeConnectorStatistics, _id, _id_1);
            }
        }
        GetNodeConnectorStatisticsInputBuilder input = _getNodeConnectorStatisticsInputBuilder = new GetNodeConnectorStatisticsInputBuilder();
        Node _node_2 = connector.getNode();
        NodeRef _nodeRef = NodeMapping.toNodeRef(_node_2);
        input.setNode(_nodeRef);
        NodeConnectorKey _nodeConnectorKey_2 = InventoryMapping.toNodeConnectorKey(connector);
        NodeConnectorId _id_2 = _nodeConnectorKey_2.getId();
        input.setNodeConnectorId(_id_2);
        OpendaylightPortStatisticsService _nodeConnectorStatisticsService = this.getNodeConnectorStatisticsService();
        GetNodeConnectorStatisticsInput _build = input.build();
        _nodeConnectorStatisticsService.getNodeConnectorStatistics(_build);
        return nodeConnectorStatistics;
    }

    public NodeTableStatistics readNodeTable(NodeTable nodeTable, boolean cached) {
        GetFlowTablesStatisticsInputBuilder _getFlowTablesStatisticsInputBuilder;
        boolean _notEquals;
        NodeTableStatistics nodeStats = null;
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(Nodes.class);
        Node _node = nodeTable.getNode();
        NodeKey _nodeKey = InventoryMapping.toNodeKey(_node);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class, (Identifier)_nodeKey);
        InstanceIdentifier.InstanceIdentifierBuilder _augmentation = _child.augmentation(FlowCapableNode.class);
        Object _iD = nodeTable.getID();
        TableKey _tableKey = new TableKey((Short)_iD);
        InstanceIdentifier.InstanceIdentifierBuilder _child_1 = _augmentation.child(Table.class, (Identifier)_tableKey);
        InstanceIdentifier tableRef = (InstanceIdentifier)_child_1.toInstance();
        DataModificationTransaction it = this.startChange();
        DataObject _readConfigurationData = (DataObject)it.readConfigurationData((Object)tableRef);
        Table table = (Table)_readConfigurationData;
        boolean bl = _notEquals = !Objects.equal((Object)table, null);
        if (_notEquals) {
            boolean _notEquals_1;
            FlowTableStatisticsData tableStats = (FlowTableStatisticsData)table.getAugmentation(FlowTableStatisticsData.class);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)tableStats, null);
            if (_notEquals_1) {
                NodeTableStatistics _nodeTableStatistics;
                FlowTableStatistics _flowTableStatistics = tableStats.getFlowTableStatistics();
                Short _id = table.getId();
                Node _node_1 = nodeTable.getNode();
                nodeStats = _nodeTableStatistics = this.toNodeTableStatistics(_flowTableStatistics, _id, _node_1);
            }
        }
        GetFlowTablesStatisticsInputBuilder input = _getFlowTablesStatisticsInputBuilder = new GetFlowTablesStatisticsInputBuilder();
        Node _node_2 = nodeTable.getNode();
        NodeRef _nodeRef = NodeMapping.toNodeRef(_node_2);
        input.setNode(_nodeRef);
        OpendaylightFlowTableStatisticsService _flowTableStatisticsService = this.getFlowTableStatisticsService();
        GetFlowTablesStatisticsInput _build = input.build();
        _flowTableStatisticsService.getFlowTablesStatistics(_build);
        return nodeStats;
    }

    public void onNodeConnectorRemoved(NodeConnectorRemoved update) {
    }

    public void onNodeRemoved(NodeRemoved notification) {
        try {
            Set<Property> properties = Collections.emptySet();
            NodeRef _nodeRef = notification.getNodeRef();
            Node _aDNode = NodeMapping.toADNode(_nodeRef);
            this.publishNodeUpdate(_aDNode, UpdateType.REMOVED, properties);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void onNodeConnectorUpdated(NodeConnectorUpdated update) {
        try {
            UpdateType updateType = UpdateType.CHANGED;
            NodeConnectorRef _nodeConnectorRef = update.getNodeConnectorRef();
            InstanceIdentifier _value = _nodeConnectorRef.getValue();
            DataObject _readOperationalData = this._dataService.readOperationalData(_value);
            boolean _equals = Objects.equal((Object)_readOperationalData, null);
            if (_equals) {
                updateType = UpdateType.ADDED;
            }
            NodeConnectorRef _nodeConnectorRef_1 = update.getNodeConnectorRef();
            NodeConnector nodeConnector = NodeMapping.toADNodeConnector(_nodeConnectorRef_1);
            HashSet<Property> _aDNodeConnectorProperties = NodeMapping.toADNodeConnectorProperties(update);
            this.publishNodeConnectorUpdate(nodeConnector, updateType, _aDNodeConnectorProperties);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void onNodeUpdated(NodeUpdated notification) {
        try {
            InstanceIdentifier _value;
            NodeRef _nodeRef = notification.getNodeRef();
            InstanceIdentifier identifier = _value = _nodeRef.getValue();
            UpdateType updateType = UpdateType.CHANGED;
            DataObject _readOperationalData = this._dataService.readOperationalData(identifier);
            boolean _equals = Objects.equal((Object)_readOperationalData, null);
            if (_equals) {
                updateType = UpdateType.ADDED;
            }
            NodeRef _nodeRef_1 = notification.getNodeRef();
            Node _aDNode = NodeMapping.toADNode(_nodeRef_1);
            HashSet<Property> _aDNodeProperties = NodeMapping.toADNodeProperties(notification);
            this.publishNodeUpdate(_aDNode, updateType, _aDNodeProperties);
            List<IPluginOutReadService> _statisticsPublisher = this.getStatisticsPublisher();
            for (IPluginOutReadService statsPublisher : _statisticsPublisher) {
                InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(Nodes.class);
                NodeId _id = notification.getId();
                NodeKey _nodeKey = new NodeKey(_id);
                InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class, (Identifier)_nodeKey);
                InstanceIdentifier nodeRef = (InstanceIdentifier)_child.toInstance();
                NodeRef _nodeRef_2 = notification.getNodeRef();
                NodeDescription description = this.toNodeDescription(_nodeRef_2);
                boolean _notEquals = !Objects.equal((Object)description, null);
                if (!_notEquals) continue;
                Node _aDNode_1 = NodeMapping.toADNode((InstanceIdentifier<? extends Object>)nodeRef);
                statsPublisher.descriptionStatisticsUpdated(_aDNode_1, description);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ConcurrentMap<Node, Map<String, Property>> getNodeProps() {
        try {
            ConcurrentHashMap<Node, Map<String, Property>> _concurrentHashMap;
            ConcurrentHashMap<Node, Map<String, Property>> props = _concurrentHashMap = new ConcurrentHashMap<Node, Map<String, Property>>();
            Nodes nodes = this.readAllMDNodes();
            List _node = nodes.getNode();
            for (org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node node : _node) {
                boolean _notEquals_1;
                ConcurrentHashMap<String, Property> _concurrentHashMap_1;
                FlowCapableNode fcn = (FlowCapableNode)node.getAugmentation(FlowCapableNode.class);
                boolean _notEquals = !Objects.equal((Object)fcn, null);
                if (!_notEquals) continue;
                NodeId _id = node.getId();
                HashSet<Property> perNodeProps = NodeMapping.toADNodeProperties((FlowNode)fcn, _id);
                ConcurrentHashMap<String, Property> perNodePropMap = _concurrentHashMap_1 = new ConcurrentHashMap<String, Property>();
                boolean bl = _notEquals_1 = !Objects.equal(perNodeProps, null);
                if (_notEquals_1) {
                    for (Property perNodeProp : perNodeProps) {
                        String _name = perNodeProp.getName();
                        perNodePropMap.put(_name, perNodeProp);
                    }
                }
                NodeId _id_1 = node.getId();
                String _aDNodeId = NodeMapping.toADNodeId(_id_1);
                Node _node_1 = new Node("MD_SAL", (Object)_aDNodeId);
                props.put(_node_1, perNodePropMap);
            }
            return props;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Nodes readAllMDNodes() {
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(Nodes.class);
        InstanceIdentifier nodesRef = (InstanceIdentifier)_builder.toInstance();
        DataBrokerService _dataService = this.getDataService();
        TypeSafeDataReader reader = TypeSafeDataReader.forReader((DataReader)_dataService);
        return (Nodes)reader.readOperationalData(nodesRef);
    }

    private List<org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector> readAllMDNodeConnectors(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node node) {
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(Nodes.class);
        NodeId _id = node.getId();
        NodeKey _nodeKey = new NodeKey(_id);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class, (Identifier)_nodeKey);
        InstanceIdentifier nodeRef = (InstanceIdentifier)_child.toInstance();
        DataBrokerService _dataService = this.getDataService();
        TypeSafeDataReader reader = TypeSafeDataReader.forReader((DataReader)_dataService);
        org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node _readOperationalData = (org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node)reader.readOperationalData(nodeRef);
        return _readOperationalData.getNodeConnector();
    }

    public ConcurrentMap<NodeConnector, Map<String, Property>> getNodeConnectorProps(Boolean refresh) {
        ConcurrentHashMap<NodeConnector, Map<String, Property>> _concurrentHashMap;
        ConcurrentHashMap<NodeConnector, Map<String, Property>> props = _concurrentHashMap = new ConcurrentHashMap<NodeConnector, Map<String, Property>>();
        Nodes nodes = this.readAllMDNodes();
        List _node = nodes.getNode();
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node node : _node) {
            List<org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector> ncs = this.readAllMDNodeConnectors(node);
            boolean _notEquals = !Objects.equal(ncs, null);
            if (!_notEquals) continue;
            for (org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector nc : ncs) {
                boolean _notEquals_2;
                ConcurrentHashMap<String, Property> _concurrentHashMap_1;
                FlowCapableNodeConnector fcnc = (FlowCapableNodeConnector)nc.getAugmentation(FlowCapableNodeConnector.class);
                boolean _notEquals_1 = !Objects.equal((Object)fcnc, null);
                if (!_notEquals_1) continue;
                HashSet<Property> ncps = NodeMapping.toADNodeConnectorProperties((FlowNodeConnector)fcnc);
                ConcurrentHashMap<String, Property> ncpsm = _concurrentHashMap_1 = new ConcurrentHashMap<String, Property>();
                boolean bl = _notEquals_2 = !Objects.equal(ncps, null);
                if (_notEquals_2) {
                    for (Property p : ncps) {
                        String _name = p.getName();
                        ncpsm.put(_name, p);
                    }
                }
                NodeConnectorId _id = nc.getId();
                NodeId _id_1 = node.getId();
                NodeConnector _aDNodeConnector = NodeMapping.toADNodeConnector(_id, _id_1);
                props.put(_aDNodeConnector, ncpsm);
            }
        }
        return props;
    }

    private FlowCapableNode readFlowCapableNode(NodeRef ref) {
        boolean _notEquals;
        InstanceIdentifier _value;
        DataBrokerService _dataService = this.getDataService();
        DataObject dataObject = _dataService.readOperationalData(_value = ref.getValue());
        boolean bl = _notEquals = !Objects.equal((Object)dataObject, null);
        if (_notEquals) {
            org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node node = (org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node)Arguments.checkInstanceOf((Object)dataObject, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class);
            return (FlowCapableNode)node.getAugmentation(FlowCapableNode.class);
        }
        return null;
    }

    private FlowCapableNodeConnector readFlowCapableNodeConnector(NodeConnectorRef ref) {
        DataBrokerService _dataService = this.getDataService();
        InstanceIdentifier _value = ref.getValue();
        DataObject dataObject = _dataService.readOperationalData(_value);
        org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector node = (org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector)Arguments.checkInstanceOf((Object)dataObject, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector.class);
        return (FlowCapableNodeConnector)node.getAugmentation(FlowCapableNodeConnector.class);
    }

    private NodeConnectorStatistics toNodeConnectorStatistics(org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.NodeConnectorStatistics nodeConnectorStatistics, NodeId nodeId, NodeConnectorId nodeConnectorId) {
        try {
            NodeConnectorStatistics _nodeConnectorStatistics;
            NodeConnectorStatistics it = _nodeConnectorStatistics = new NodeConnectorStatistics();
            Packets _packets = nodeConnectorStatistics.getPackets();
            BigInteger _received = _packets.getReceived();
            long _longValue = _received.longValue();
            it.setReceivePacketCount(_longValue);
            Packets _packets_1 = nodeConnectorStatistics.getPackets();
            BigInteger _transmitted = _packets_1.getTransmitted();
            long _longValue_1 = _transmitted.longValue();
            it.setTransmitPacketCount(_longValue_1);
            Bytes _bytes = nodeConnectorStatistics.getBytes();
            BigInteger _received_1 = _bytes.getReceived();
            long _longValue_2 = _received_1.longValue();
            it.setReceiveByteCount(_longValue_2);
            Bytes _bytes_1 = nodeConnectorStatistics.getBytes();
            BigInteger _transmitted_1 = _bytes_1.getTransmitted();
            long _longValue_3 = _transmitted_1.longValue();
            it.setTransmitByteCount(_longValue_3);
            BigInteger _receiveDrops = nodeConnectorStatistics.getReceiveDrops();
            long _longValue_4 = _receiveDrops.longValue();
            it.setReceiveDropCount(_longValue_4);
            BigInteger _transmitDrops = nodeConnectorStatistics.getTransmitDrops();
            long _longValue_5 = _transmitDrops.longValue();
            it.setTransmitDropCount(_longValue_5);
            BigInteger _receiveErrors = nodeConnectorStatistics.getReceiveErrors();
            long _longValue_6 = _receiveErrors.longValue();
            it.setReceiveErrorCount(_longValue_6);
            BigInteger _transmitErrors = nodeConnectorStatistics.getTransmitErrors();
            long _longValue_7 = _transmitErrors.longValue();
            it.setTransmitErrorCount(_longValue_7);
            BigInteger _receiveFrameError = nodeConnectorStatistics.getReceiveFrameError();
            long _longValue_8 = _receiveFrameError.longValue();
            it.setReceiveFrameErrorCount(_longValue_8);
            BigInteger _receiveOverRunError = nodeConnectorStatistics.getReceiveOverRunError();
            long _longValue_9 = _receiveOverRunError.longValue();
            it.setReceiveOverRunErrorCount(_longValue_9);
            BigInteger _receiveCrcError = nodeConnectorStatistics.getReceiveCrcError();
            long _longValue_10 = _receiveCrcError.longValue();
            it.setReceiveCRCErrorCount(_longValue_10);
            BigInteger _collisionCount = nodeConnectorStatistics.getCollisionCount();
            long _longValue_11 = _collisionCount.longValue();
            it.setCollisionCount(_longValue_11);
            InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(Nodes.class);
            NodeKey _nodeKey = new NodeKey(nodeId);
            InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class, (Identifier)_nodeKey);
            NodeConnectorKey _nodeConnectorKey = new NodeConnectorKey(nodeConnectorId);
            InstanceIdentifier.InstanceIdentifierBuilder _child_1 = _child.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector.class, (Identifier)_nodeConnectorKey);
            InstanceIdentifier nodeConnectorRef = (InstanceIdentifier)_child_1.toInstance();
            NodeConnectorRef _nodeConnectorRef = new NodeConnectorRef(nodeConnectorRef);
            NodeConnector _aDNodeConnector = NodeMapping.toADNodeConnector(_nodeConnectorRef);
            it.setNodeConnector(_aDNodeConnector);
            return it;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private NodeTableStatistics toNodeTableStatistics(FlowTableStatistics tableStats, Short tableId, Node node) {
        try {
            NodeTableStatistics _nodeTableStatistics;
            NodeTableStatistics it = _nodeTableStatistics = new NodeTableStatistics();
            Counter32 _activeFlows = tableStats.getActiveFlows();
            Long _value = _activeFlows.getValue();
            int _intValue = _value.intValue();
            it.setActiveCount(_intValue);
            Counter64 _packetsLookedUp = tableStats.getPacketsLookedUp();
            BigInteger _value_1 = _packetsLookedUp.getValue();
            int _intValue_1 = _value_1.intValue();
            it.setLookupCount((long)_intValue_1);
            Counter64 _packetsMatched = tableStats.getPacketsMatched();
            BigInteger _value_2 = _packetsMatched.getValue();
            int _intValue_2 = _value_2.intValue();
            it.setMatchedCount((long)_intValue_2);
            String _string = tableId.toString();
            it.setName(_string);
            NodeTable _nodeTable = new NodeTable("MD_SAL", (Object)tableId, node);
            it.setNodeTable(_nodeTable);
            return it;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private NodeDescription toNodeDescription(NodeRef nodeRef) {
        boolean _notEquals;
        FlowCapableNode capableNode = this.readFlowCapableNode(nodeRef);
        boolean bl = _notEquals = !Objects.equal((Object)capableNode, null);
        if (_notEquals) {
            NodeDescription _nodeDescription;
            NodeDescription it = _nodeDescription = new NodeDescription();
            String _manufacturer = capableNode.getManufacturer();
            it.setManufacturer(_manufacturer);
            String _serialNumber = capableNode.getSerialNumber();
            it.setSerialNumber(_serialNumber);
            String _software = capableNode.getSoftware();
            it.setSoftware(_software);
            String _description = capableNode.getDescription();
            it.setDescription(_description);
            return it;
        }
        return null;
    }

    public Edge toADEdge(Link link) {
        try {
            NodeConnectorRef _source = link.getSource();
            NodeConnector _aDNodeConnector = NodeMapping.toADNodeConnector(_source);
            NodeConnectorRef _destination = link.getDestination();
            NodeConnector _aDNodeConnector_1 = NodeMapping.toADNodeConnector(_destination);
            Edge _edge = new Edge(_aDNodeConnector, _aDNodeConnector_1);
            return _edge;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void onAggregateFlowStatisticsUpdate(AggregateFlowStatisticsUpdate notification) {
    }

    public void onFlowsStatisticsUpdate(FlowsStatisticsUpdate notification) {
        try {
            ArrayList<FlowOnNode> _arrayList;
            ArrayList<FlowOnNode> adsalFlowsStatistics = _arrayList = new ArrayList<FlowOnNode>();
            InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(Nodes.class);
            NodeId _id = notification.getId();
            NodeKey _nodeKey = new NodeKey(_id);
            InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class, (Identifier)_nodeKey);
            InstanceIdentifier nodeRef = (InstanceIdentifier)_child.toInstance();
            List _flowAndStatisticsMapList = notification.getFlowAndStatisticsMapList();
            for (FlowAndStatisticsMapList flowStats : _flowAndStatisticsMapList) {
                Short _tableId = flowStats.getTableId();
                boolean _equals = _tableId == 0;
                if (!_equals) continue;
                Node _aDNode = NodeMapping.toADNode((InstanceIdentifier<? extends Object>)nodeRef);
                FlowOnNode _flowOnNode = InventoryAndReadAdapter.toFlowOnNode(flowStats, _aDNode);
                adsalFlowsStatistics.add(_flowOnNode);
            }
            List<IPluginOutReadService> _statisticsPublisher = this.getStatisticsPublisher();
            for (IPluginOutReadService statsPublisher : _statisticsPublisher) {
                Node _aDNode_1 = NodeMapping.toADNode((InstanceIdentifier<? extends Object>)nodeRef);
                statsPublisher.nodeFlowStatisticsUpdated(_aDNode_1, adsalFlowsStatistics);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void onFlowTableStatisticsUpdate(FlowTableStatisticsUpdate notification) {
        try {
            ArrayList<NodeTableStatistics> _arrayList;
            ArrayList<NodeTableStatistics> adsalFlowTableStatistics = _arrayList = new ArrayList<NodeTableStatistics>();
            List _flowTableAndStatisticsMap = notification.getFlowTableAndStatisticsMap();
            for (FlowTableAndStatisticsMap stats : _flowTableAndStatisticsMap) {
                NodeTableStatistics _nodeTableStatistics;
                TableId _tableId = stats.getTableId();
                Short _value = _tableId.getValue();
                boolean _equals = _value == 0;
                if (!_equals) continue;
                NodeTableStatistics it = _nodeTableStatistics = new NodeTableStatistics();
                Counter32 _activeFlows = stats.getActiveFlows();
                Long _value_1 = _activeFlows.getValue();
                int _intValue = _value_1.intValue();
                it.setActiveCount(_intValue);
                Counter64 _packetsLookedUp = stats.getPacketsLookedUp();
                BigInteger _value_2 = _packetsLookedUp.getValue();
                long _longValue = _value_2.longValue();
                it.setLookupCount(_longValue);
                Counter64 _packetsMatched = stats.getPacketsMatched();
                BigInteger _value_3 = _packetsMatched.getValue();
                long _longValue_1 = _value_3.longValue();
                it.setMatchedCount(_longValue_1);
                adsalFlowTableStatistics.add(it);
            }
            List<IPluginOutReadService> _statisticsPublisher = this.getStatisticsPublisher();
            for (IPluginOutReadService statsPublisher : _statisticsPublisher) {
                InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(Nodes.class);
                NodeId _id = notification.getId();
                NodeKey _nodeKey = new NodeKey(_id);
                InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class, (Identifier)_nodeKey);
                InstanceIdentifier nodeRef = (InstanceIdentifier)_child.toInstance();
                Node _aDNode = NodeMapping.toADNode((InstanceIdentifier<? extends Object>)nodeRef);
                statsPublisher.nodeTableStatisticsUpdated(_aDNode, adsalFlowTableStatistics);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void onNodeConnectorStatisticsUpdate(NodeConnectorStatisticsUpdate notification) {
        try {
            ArrayList<NodeConnectorStatistics> _arrayList;
            ArrayList<NodeConnectorStatistics> adsalPortStatistics = _arrayList = new ArrayList<NodeConnectorStatistics>();
            List _nodeConnectorStatisticsAndPortNumberMap = notification.getNodeConnectorStatisticsAndPortNumberMap();
            for (NodeConnectorStatisticsAndPortNumberMap nodeConnectorStatistics : _nodeConnectorStatisticsAndPortNumberMap) {
                NodeId _id = notification.getId();
                NodeConnectorId _nodeConnectorId = nodeConnectorStatistics.getNodeConnectorId();
                NodeConnectorStatistics _nodeConnectorStatistics = this.toNodeConnectorStatistics((org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.NodeConnectorStatistics)nodeConnectorStatistics, _id, _nodeConnectorId);
                adsalPortStatistics.add(_nodeConnectorStatistics);
            }
            List<IPluginOutReadService> _statisticsPublisher = this.getStatisticsPublisher();
            for (IPluginOutReadService statsPublisher : _statisticsPublisher) {
                InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(Nodes.class);
                NodeId _id_1 = notification.getId();
                NodeKey _nodeKey = new NodeKey(_id_1);
                InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class, (Identifier)_nodeKey);
                InstanceIdentifier nodeRef = (InstanceIdentifier)_child.toInstance();
                Node _aDNode = NodeMapping.toADNode((InstanceIdentifier<? extends Object>)nodeRef);
                statsPublisher.nodeConnectorStatisticsUpdated(_aDNode, adsalPortStatistics);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static FlowOnNode toFlowOnNode(FlowAndStatisticsMapList flowAndStatsMap, Node node) {
        FlowOnNode _flowOnNode;
        Flow _flow = ToSalConversionsUtils.toFlow((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow)flowAndStatsMap, node);
        FlowOnNode it = _flowOnNode = new FlowOnNode(_flow);
        Counter64 _byteCount = flowAndStatsMap.getByteCount();
        BigInteger _value = _byteCount.getValue();
        long _longValue = _value.longValue();
        it.setByteCount(_longValue);
        Counter64 _packetCount = flowAndStatsMap.getPacketCount();
        BigInteger _value_1 = _packetCount.getValue();
        long _longValue_1 = _value_1.longValue();
        it.setPacketCount(_longValue_1);
        Duration _duration = flowAndStatsMap.getDuration();
        Counter32 _second = _duration.getSecond();
        Long _value_2 = _second.getValue();
        int _intValue = _value_2.intValue();
        it.setDurationSeconds(_intValue);
        Duration _duration_1 = flowAndStatsMap.getDuration();
        Counter32 _nanosecond = _duration_1.getNanosecond();
        Long _value_3 = _nanosecond.getValue();
        int _intValue_1 = _value_3.intValue();
        it.setDurationNanoseconds(_intValue_1);
        return it;
    }

    public Set<Node> getConfiguredNotConnectedNodes() {
        return Collections.emptySet();
    }

    private void publishNodeUpdate(Node node, UpdateType updateType, Set<Property> properties) {
        List<IPluginOutInventoryService> _inventoryPublisher = this.getInventoryPublisher();
        for (IPluginOutInventoryService publisher : _inventoryPublisher) {
            publisher.updateNode(node, updateType, properties);
        }
    }

    private void publishNodeConnectorUpdate(NodeConnector nodeConnector, UpdateType updateType, Set<Property> properties) {
        List<IPluginOutInventoryService> _inventoryPublisher = this.getInventoryPublisher();
        for (IPluginOutInventoryService publisher : _inventoryPublisher) {
            publisher.updateNodeConnector(nodeConnector, updateType, properties);
        }
    }
}

