/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.compatibility;

import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.opendaylight.controller.sal.compatibility.MDFlowMapping;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.match.MatchField;
import org.opendaylight.controller.sal.match.MatchType;
import org.opendaylight.controller.sal.utils.NetUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Dscp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.address.Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.address.address.Ipv4Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.address.address.Ipv6Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.EtherType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanPcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.arp.match.fields.ArpSourceHardwareAddressBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.arp.match.fields.ArpTargetHardwareAddressBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetDestinationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetSourceBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.EthernetMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.EthernetMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.IpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.IpMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer3Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.VlanMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.VlanMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.ArpMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv4MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv6MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.SctpMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.TcpMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.UdpMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.vlan.match.fields.VlanIdBuilder;

public class FromSalConversionsUtils {
    private FromSalConversionsUtils() {
    }

    private static Address addressFromAction(InetAddress inetAddress) {
        String strInetAddresss = InetAddresses.toAddrString((InetAddress)inetAddress);
        if (inetAddress instanceof Inet4Address) {
            Ipv4Builder ipv4Builder = new Ipv4Builder();
            ipv4Builder.setIpv4Address(new Ipv4Prefix(strInetAddresss));
            return ipv4Builder.build();
        }
        if (inetAddress instanceof Inet6Address) {
            Ipv6Builder ipv6Builder = new Ipv6Builder();
            ipv6Builder.setIpv6Address(new Ipv6Prefix(strInetAddresss));
            return ipv6Builder.build();
        }
        return null;
    }

    public static Match toMatch(org.opendaylight.controller.sal.match.Match sourceMatch) {
        if (sourceMatch != null) {
            MatchBuilder targetBuilder = new MatchBuilder();
            targetBuilder.setEthernetMatch(FromSalConversionsUtils.ethernetMatch(sourceMatch));
            targetBuilder.setIpMatch(FromSalConversionsUtils.ipMatch(sourceMatch));
            targetBuilder.setVlanMatch(FromSalConversionsUtils.vlanMatch(sourceMatch));
            targetBuilder.setLayer3Match(FromSalConversionsUtils.layer3Match(sourceMatch));
            targetBuilder.setLayer4Match(FromSalConversionsUtils.layer4Match(sourceMatch));
            targetBuilder.setInPort(FromSalConversionsUtils.inPortMatch(sourceMatch));
            return targetBuilder.build();
        }
        return null;
    }

    private static NodeConnectorId inPortMatch(org.opendaylight.controller.sal.match.Match sourceMatch) {
        MatchField inPort = sourceMatch.getField(MatchType.IN_PORT);
        if (inPort != null && inPort.getValue() != null && inPort.getValue() instanceof NodeConnector) {
            return new NodeConnectorId(((NodeConnector)inPort.getValue()).getNodeConnectorIdAsString());
        }
        return null;
    }

    private static Layer4Match layer4Match(org.opendaylight.controller.sal.match.Match sourceMatch) {
        MatchField nwProto = sourceMatch.getField(MatchType.NW_PROTO);
        Short nwProtocolSource = null;
        if (nwProto != null && nwProto.getValue() != null) {
            nwProtocolSource = (short)((Byte)nwProto.getValue());
            switch (nwProtocolSource) {
                case 6: {
                    return FromSalConversionsUtils.Layer4MatchAsTcp(sourceMatch);
                }
                case 17: {
                    return FromSalConversionsUtils.Layer4MatchAsUdp(sourceMatch);
                }
                case 127: {
                    return FromSalConversionsUtils.Layer4MatchAsSctp(sourceMatch);
                }
            }
        }
        return null;
    }

    private static Layer4Match Layer4MatchAsSctp(org.opendaylight.controller.sal.match.Match sourceMatch) {
        SctpMatchBuilder sctpMatchBuilder = new SctpMatchBuilder();
        Integer sourcePort = FromSalConversionsUtils.transportPort(sourceMatch, MatchType.TP_SRC);
        Integer destinationPort = FromSalConversionsUtils.transportPort(sourceMatch, MatchType.TP_DST);
        if (sourcePort != null) {
            sctpMatchBuilder.setSctpSourcePort(new PortNumber(sourcePort));
        }
        if (destinationPort != null) {
            sctpMatchBuilder.setSctpDestinationPort(new PortNumber(destinationPort));
        }
        if (sourcePort != null || destinationPort != null) {
            return sctpMatchBuilder.build();
        }
        return null;
    }

    private static Layer4Match Layer4MatchAsUdp(org.opendaylight.controller.sal.match.Match sourceMatch) {
        UdpMatchBuilder udpMatchBuilder = new UdpMatchBuilder();
        Integer sourcePort = FromSalConversionsUtils.transportPort(sourceMatch, MatchType.TP_SRC);
        Integer destinationPort = FromSalConversionsUtils.transportPort(sourceMatch, MatchType.TP_DST);
        if (sourcePort != null) {
            udpMatchBuilder.setUdpSourcePort(new PortNumber(sourcePort));
        }
        if (destinationPort != null) {
            udpMatchBuilder.setUdpDestinationPort(new PortNumber(destinationPort));
        }
        if (sourcePort != null || destinationPort != null) {
            return udpMatchBuilder.build();
        }
        return null;
    }

    private static Layer4Match Layer4MatchAsTcp(org.opendaylight.controller.sal.match.Match sourceMatch) {
        TcpMatchBuilder tcpMatchBuilder = new TcpMatchBuilder();
        Integer sourcePort = FromSalConversionsUtils.transportPort(sourceMatch, MatchType.TP_SRC);
        Integer destinationPort = FromSalConversionsUtils.transportPort(sourceMatch, MatchType.TP_DST);
        if (sourcePort != null) {
            tcpMatchBuilder.setTcpSourcePort(new PortNumber(sourcePort));
        }
        if (destinationPort != null) {
            tcpMatchBuilder.setTcpDestinationPort(new PortNumber(destinationPort));
        }
        if (sourcePort != null || destinationPort != null) {
            return tcpMatchBuilder.build();
        }
        return null;
    }

    private static Integer transportPort(org.opendaylight.controller.sal.match.Match sourceMatch, MatchType matchType) {
        MatchField transportPort = sourceMatch.getField(matchType);
        if (transportPort != null && transportPort.getValue() != null && transportPort.getValue().getClass().equals(Short.class)) {
            return new Integer(NetUtils.getUnsignedShort((short)((Short)transportPort.getValue())));
        }
        return null;
    }

    private static VlanMatch vlanMatch(org.opendaylight.controller.sal.match.Match sourceMatch) {
        MatchField vlanPriority;
        VlanMatchBuilder vlanMatchBuild = new VlanMatchBuilder();
        MatchField vlan = sourceMatch.getField(MatchType.DL_VLAN);
        if (vlan != null && vlan.getValue() != null) {
            VlanIdBuilder vlanIDBuilder = new VlanIdBuilder();
            vlanIDBuilder.setVlanId(new VlanId(Integer.valueOf(NetUtils.getUnsignedShort((short)((Short)vlan.getValue())))));
            vlanMatchBuild.setVlanId(vlanIDBuilder.build());
        }
        if ((vlanPriority = sourceMatch.getField(MatchType.DL_VLAN_PR)) != null && vlanPriority.getValue() != null) {
            vlanMatchBuild.setVlanPcp(new VlanPcp(Short.valueOf(((Byte)vlanPriority.getValue()).byteValue())));
        }
        if (vlan != null && vlan.getValue() != null || vlanPriority != null && vlanPriority.getValue() != null) {
            return vlanMatchBuild.build();
        }
        return null;
    }

    private static IpMatch ipMatch(org.opendaylight.controller.sal.match.Match sourceMatch) {
        MatchField protocol;
        IpMatchBuilder targetIpMatchBuild = new IpMatchBuilder();
        MatchField networkTos = sourceMatch.getField(MatchType.NW_TOS);
        if (networkTos != null && networkTos.getValue() != null) {
            Dscp dscp = new Dscp(Short.valueOf((short)NetUtils.getUnsignedByte((byte)((Byte)networkTos.getValue()))));
            targetIpMatchBuild.setIpDscp(dscp);
        }
        if ((protocol = sourceMatch.getField(MatchType.NW_PROTO)) != null && protocol.getValue() != null) {
            targetIpMatchBuild.setIpProtocol(Short.valueOf(((Byte)protocol.getValue()).byteValue()));
        }
        if (networkTos != null && networkTos.getValue() != null || protocol != null && protocol.getValue() != null) {
            return targetIpMatchBuild.build();
        }
        return null;
    }

    private static EthernetMatch ethernetMatch(org.opendaylight.controller.sal.match.Match sourceMatch) {
        MatchField dataLinkType;
        EthernetMatchBuilder targetEthMatchBuild = new EthernetMatchBuilder();
        if (sourceMatch.getField(MatchType.DL_SRC) != null && sourceMatch.getField(MatchType.DL_SRC).getValue() != null) {
            EthernetSourceBuilder ethSourBuild = new EthernetSourceBuilder().setAddress(FromSalConversionsUtils.ethernetSourceAddress(sourceMatch));
            targetEthMatchBuild.setEthernetSource(ethSourBuild.build());
        }
        if (sourceMatch.getField(MatchType.DL_DST) != null && sourceMatch.getField(MatchType.DL_DST).getValue() != null) {
            EthernetDestinationBuilder ethDestBuild = new EthernetDestinationBuilder().setAddress(FromSalConversionsUtils.ethernetDestAddress(sourceMatch));
            targetEthMatchBuild.setEthernetDestination(ethDestBuild.build());
        }
        if ((dataLinkType = sourceMatch.getField(MatchType.DL_TYPE)) != null && dataLinkType.getValue() != null) {
            EtherType etherType = new EtherType(new Long(NetUtils.getUnsignedShort((short)((Short)dataLinkType.getValue()))));
            EthernetTypeBuilder ethType = new EthernetTypeBuilder().setType(etherType);
            targetEthMatchBuild.setEthernetType(ethType.build());
        }
        if (sourceMatch.getField(MatchType.DL_SRC) != null && sourceMatch.getField(MatchType.DL_SRC).getValue() != null || sourceMatch.getField(MatchType.DL_DST) != null && sourceMatch.getField(MatchType.DL_DST).getValue() != null || dataLinkType != null) {
            return targetEthMatchBuild.build();
        }
        return null;
    }

    private static MacAddress ethernetSourceAddress(org.opendaylight.controller.sal.match.Match sourceMatch) {
        MatchField dataLinkSource = sourceMatch.getField(MatchType.DL_SRC);
        if (dataLinkSource != null && dataLinkSource.getValue() != null) {
            return MDFlowMapping.toMacAddress((byte[])dataLinkSource.getValue());
        }
        return null;
    }

    private static Layer3Match layer3Match(org.opendaylight.controller.sal.match.Match sourceMatch) {
        InetAddress inetSourceAddress = null;
        MatchField netSource = sourceMatch.getField(MatchType.NW_SRC);
        if (netSource != null && netSource.getValue() != null) {
            inetSourceAddress = (InetAddress)netSource.getValue();
        }
        InetAddress inetDestAddress = null;
        MatchField netDest = sourceMatch.getField(MatchType.NW_DST);
        if (netDest != null && netDest.getValue() != null) {
            inetDestAddress = (InetAddress)netDest.getValue();
        }
        if (inetSourceAddress instanceof Inet4Address || inetDestAddress instanceof Inet4Address) {
            MatchField dataLinkType = sourceMatch.getField(MatchType.DL_TYPE);
            Short dLType = null;
            if (dataLinkType != null && dataLinkType.getValue() != null) {
                dLType = (Short)dataLinkType.getValue();
            }
            if (dLType != null && dLType.equals((short)2054)) {
                return FromSalConversionsUtils.setLayer3MatchAsArp(sourceMatch, (Inet4Address)inetSourceAddress, (Inet4Address)inetDestAddress);
            }
            return FromSalConversionsUtils.setLayer3MatchAsIpv4((Inet4Address)inetSourceAddress, (Inet4Address)inetDestAddress);
        }
        if (inetSourceAddress instanceof Inet6Address || inetDestAddress instanceof Inet6Address) {
            return FromSalConversionsUtils.setLayer3MatchAsIpv6((Inet6Address)inetSourceAddress, (Inet6Address)inetDestAddress);
        }
        return null;
    }

    private static Layer3Match setLayer3MatchAsArp(org.opendaylight.controller.sal.match.Match sourceMatch, Inet4Address inetSourceAddress, Inet4Address inetDestAddress) {
        String inetSourceAddressStr = InetAddresses.toAddrString((InetAddress)inetSourceAddress);
        Ipv4Prefix ipv4SourcePrefix = new Ipv4Prefix(inetSourceAddressStr);
        String inetDestAddressValue = InetAddresses.toAddrString((InetAddress)inetDestAddress);
        Ipv4Prefix ipv4DestPrefix = new Ipv4Prefix(inetDestAddressValue);
        ArpMatchBuilder arpMatchBuilder = new ArpMatchBuilder();
        arpMatchBuilder.setArpSourceTransportAddress(ipv4SourcePrefix);
        arpMatchBuilder.setArpTargetTransportAddress(ipv4DestPrefix);
        ArpSourceHardwareAddressBuilder arpSourceHardwareAddressBuilder = new ArpSourceHardwareAddressBuilder();
        arpSourceHardwareAddressBuilder.setAddress(FromSalConversionsUtils.ethernetSourceAddress(sourceMatch));
        arpMatchBuilder.setArpSourceHardwareAddress(arpSourceHardwareAddressBuilder.build());
        ArpTargetHardwareAddressBuilder arpTargetHardwareAddressBuilder = new ArpTargetHardwareAddressBuilder();
        arpTargetHardwareAddressBuilder.setAddress(FromSalConversionsUtils.ethernetDestAddress(sourceMatch));
        arpMatchBuilder.setArpTargetHardwareAddress(arpTargetHardwareAddressBuilder.build());
        return arpMatchBuilder.build();
    }

    private static MacAddress ethernetDestAddress(org.opendaylight.controller.sal.match.Match sourceMatch) {
        MatchField dataLinkDest = sourceMatch.getField(MatchType.DL_DST);
        if (dataLinkDest != null && dataLinkDest.getValue() != null) {
            return MDFlowMapping.toMacAddress((byte[])dataLinkDest.getValue());
        }
        return null;
    }

    private static Layer3Match setLayer3MatchAsIpv4(Inet4Address inetSourceAddress, Inet4Address inetDestAddress) {
        Ipv4MatchBuilder layer4MatchBuild = new Ipv4MatchBuilder();
        if (inetSourceAddress != null) {
            String inetSrcAddressString = InetAddresses.toAddrString((InetAddress)inetSourceAddress);
            layer4MatchBuild.setIpv4Source(new Ipv4Prefix(inetSrcAddressString));
        }
        if (inetDestAddress != null) {
            String inetDstAddressString = InetAddresses.toAddrString((InetAddress)inetDestAddress);
            layer4MatchBuild.setIpv4Destination(new Ipv4Prefix(inetDstAddressString));
        }
        return layer4MatchBuild.build();
    }

    private static Layer3Match setLayer3MatchAsIpv6(Inet6Address inetSourceAddress, Inet6Address inetDestAddress) {
        Ipv6MatchBuilder layer6MatchBuild = new Ipv6MatchBuilder();
        if (inetSourceAddress != null) {
            String inetSrcAddressString = InetAddresses.toAddrString((InetAddress)inetSourceAddress);
            layer6MatchBuild.setIpv6Source(new Ipv6Prefix(inetSrcAddressString));
        }
        if (inetDestAddress != null) {
            String inetDstAddressString = InetAddresses.toAddrString((InetAddress)inetDestAddress);
            layer6MatchBuild.setIpv6Destination(new Ipv6Prefix(inetDstAddressString));
        }
        return layer6MatchBuild.build();
    }

    public static boolean flowEquals(Flow statsFlow, Flow storedFlow) {
        if (statsFlow.getClass() != storedFlow.getClass()) {
            return false;
        }
        if (statsFlow.getBufferId() == null ? storedFlow.getBufferId() != null : !statsFlow.getBufferId().equals(storedFlow.getBufferId())) {
            return false;
        }
        if (statsFlow.getContainerName() == null ? storedFlow.getContainerName() != null : !statsFlow.getContainerName().equals(storedFlow.getContainerName())) {
            return false;
        }
        if (statsFlow.getCookie() == null ? storedFlow.getCookie() != null : !statsFlow.getCookie().equals(storedFlow.getCookie())) {
            return false;
        }
        if (statsFlow.getMatch() == null ? storedFlow.getMatch() != null : !statsFlow.getMatch().equals(storedFlow.getMatch())) {
            return false;
        }
        if (statsFlow.getCookie() == null ? storedFlow.getCookie() != null : !statsFlow.getCookie().equals(storedFlow.getCookie())) {
            return false;
        }
        if (statsFlow.getHardTimeout() == null ? storedFlow.getHardTimeout() != null : !statsFlow.getHardTimeout().equals(storedFlow.getHardTimeout())) {
            return false;
        }
        if (statsFlow.getIdleTimeout() == null ? storedFlow.getIdleTimeout() != null : !statsFlow.getIdleTimeout().equals(storedFlow.getIdleTimeout())) {
            return false;
        }
        if (statsFlow.getPriority() == null ? storedFlow.getPriority() != null : !statsFlow.getPriority().equals(storedFlow.getPriority())) {
            return false;
        }
        return !(statsFlow.getTableId() == null ? storedFlow.getTableId() != null : !statsFlow.getTableId().equals(storedFlow.getTableId()));
    }
}

