/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.compatibility;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.IClusterGlobalServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.sal.binding.api.data.DataBrokerService;
import org.opendaylight.controller.sal.binding.api.data.DataModificationTransaction;
import org.opendaylight.controller.sal.compatibility.MDFlowMapping;
import org.opendaylight.controller.sal.compatibility.NodeMapping;
import org.opendaylight.controller.sal.compatibility.ToSalConversionsUtils;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.flowprogrammer.IPluginInFlowProgrammerService;
import org.opendaylight.controller.sal.flowprogrammer.IPluginOutFlowProgrammerService;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.FlowKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.FlowAdded;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.FlowRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.FlowUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeErrorNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeExperimenterErrorNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.SalFlowListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.SalFlowService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.SwitchFlowRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowProgrammerAdapter
implements IPluginInFlowProgrammerService,
SalFlowListener {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(FlowProgrammerAdapter.class);
            return _logger;
        }
    }.apply();
    private static final String CACHE_NAME = "flowprogrammeradapter.flowtoid";
    private SalFlowService _delegate;
    private DataBrokerService _dataBrokerService;
    private IPluginOutFlowProgrammerService _flowProgrammerPublisher;
    private IClusterGlobalServices _clusterGlobalServices;
    private Map<org.opendaylight.controller.sal.flowprogrammer.Flow, UUID> _flowToFlowId = new Functions.Function0<Map<org.opendaylight.controller.sal.flowprogrammer.Flow, UUID>>(){

        public Map<org.opendaylight.controller.sal.flowprogrammer.Flow, UUID> apply() {
            ConcurrentHashMap<org.opendaylight.controller.sal.flowprogrammer.Flow, UUID> _concurrentHashMap = new ConcurrentHashMap<org.opendaylight.controller.sal.flowprogrammer.Flow, UUID>();
            return _concurrentHashMap;
        }
    }.apply();

    public SalFlowService getDelegate() {
        return this._delegate;
    }

    public void setDelegate(SalFlowService delegate) {
        this._delegate = delegate;
    }

    public DataBrokerService getDataBrokerService() {
        return this._dataBrokerService;
    }

    public void setDataBrokerService(DataBrokerService dataBrokerService) {
        this._dataBrokerService = dataBrokerService;
    }

    public IPluginOutFlowProgrammerService getFlowProgrammerPublisher() {
        return this._flowProgrammerPublisher;
    }

    public void setFlowProgrammerPublisher(IPluginOutFlowProgrammerService flowProgrammerPublisher) {
        this._flowProgrammerPublisher = flowProgrammerPublisher;
    }

    public IClusterGlobalServices getClusterGlobalServices() {
        return this._clusterGlobalServices;
    }

    public void setClusterGlobalServices(IClusterGlobalServices clusterGlobalServices) {
        this._clusterGlobalServices = clusterGlobalServices;
    }

    public Map<org.opendaylight.controller.sal.flowprogrammer.Flow, UUID> getFlowToFlowId() {
        return this._flowToFlowId;
    }

    public void setFlowToFlowId(Map<org.opendaylight.controller.sal.flowprogrammer.Flow, UUID> flowToFlowId) {
        this._flowToFlowId = flowToFlowId;
    }

    public Status addFlow(Node node, org.opendaylight.controller.sal.flowprogrammer.Flow flow) {
        Future<RpcResult<TransactionStatus>> _internalAddFlowAsync = this.internalAddFlowAsync(node, flow, 0L);
        return this.toFutureStatus(_internalAddFlowAsync);
    }

    public Status modifyFlow(Node node, org.opendaylight.controller.sal.flowprogrammer.Flow oldFlow, org.opendaylight.controller.sal.flowprogrammer.Flow newFlow) {
        Future<RpcResult<TransactionStatus>> _internalModifyFlowAsync = this.internalModifyFlowAsync(node, oldFlow, newFlow, 0L);
        return this.toFutureStatus(_internalModifyFlowAsync);
    }

    public Status removeFlow(Node node, org.opendaylight.controller.sal.flowprogrammer.Flow flow) {
        Future<RpcResult<TransactionStatus>> _internalRemoveFlowAsync = this.internalRemoveFlowAsync(node, flow, 0L);
        return this.toFutureStatus(_internalRemoveFlowAsync);
    }

    public Status addFlowAsync(Node node, org.opendaylight.controller.sal.flowprogrammer.Flow flow, long rid) {
        this.internalAddFlowAsync(node, flow, rid);
        return FlowProgrammerAdapter.toStatus(true);
    }

    public Status modifyFlowAsync(Node node, org.opendaylight.controller.sal.flowprogrammer.Flow oldFlow, org.opendaylight.controller.sal.flowprogrammer.Flow newFlow, long rid) {
        this.internalModifyFlowAsync(node, oldFlow, newFlow, rid);
        return FlowProgrammerAdapter.toStatus(true);
    }

    public Status removeFlowAsync(Node node, org.opendaylight.controller.sal.flowprogrammer.Flow flow, long rid) {
        this.internalRemoveFlowAsync(node, flow, rid);
        return FlowProgrammerAdapter.toStatus(true);
    }

    public Status removeAllFlows(Node node) {
        Status _status = new Status(StatusCode.SUCCESS);
        return _status;
    }

    public Status syncSendBarrierMessage(Node node) {
        return null;
    }

    public Status asyncSendBarrierMessage(Node node) {
        return null;
    }

    private static Status toStatus(boolean successful) {
        if (successful) {
            Status _status = new Status(StatusCode.SUCCESS);
            return _status;
        }
        Status _status_1 = new Status(StatusCode.INTERNALERROR);
        return _status_1;
    }

    public static Status toStatus(RpcResult<? extends Object> result) {
        boolean _isSuccessful = result.isSuccessful();
        return FlowProgrammerAdapter.toStatus(_isSuccessful);
    }

    private static Status _processException(InterruptedException e) {
        LOG.error("Interruption occured during processing flow", (Throwable)e);
        Status _status = new Status(StatusCode.INTERNALERROR);
        return _status;
    }

    private static Status _processException(ExecutionException e) {
        Throwable _cause = e.getCause();
        LOG.error("Execution exception occured during processing flow", _cause);
        Status _status = new Status(StatusCode.INTERNALERROR);
        return _status;
    }

    private static Status _processException(Exception e) {
        RuntimeException _runtimeException = new RuntimeException(e);
        throw _runtimeException;
    }

    public void onFlowAdded(FlowAdded notification) {
    }

    public void onFlowRemoved(FlowRemoved notification) {
        try {
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)notification, null);
            if (!_notEquals) {
                _and = false;
            } else {
                NodeRef _node = notification.getNode();
                boolean _notEquals_1 = !Objects.equal((Object)_node, null);
                boolean bl2 = _and = _notEquals && _notEquals_1;
            }
            if (_and) {
                boolean _notEquals_2;
                NodeRef _node_1 = notification.getNode();
                Node adNode = NodeMapping.toADNode(_node_1);
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)adNode, null);
                if (_notEquals_2) {
                    IPluginOutFlowProgrammerService _flowProgrammerPublisher = this.getFlowProgrammerPublisher();
                    org.opendaylight.controller.sal.flowprogrammer.Flow _flow = ToSalConversionsUtils.toFlow((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow)notification, adNode);
                    _flowProgrammerPublisher.flowRemoved(adNode, _flow);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void onFlowUpdated(FlowUpdated notification) {
    }

    public void onSwitchFlowRemoved(SwitchFlowRemoved notification) {
    }

    public void onNodeErrorNotification(NodeErrorNotification notification) {
    }

    public void onNodeExperimenterErrorNotification(NodeExperimenterErrorNotification notification) {
    }

    private Future<RpcResult<TransactionStatus>> writeFlowAsync(Flow flow, NodeKey nodeKey) {
        DataModificationTransaction modification = this._dataBrokerService.beginTransaction();
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(Nodes.class);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class, (Identifier)nodeKey);
        InstanceIdentifier.InstanceIdentifierBuilder _augmentation = _child.augmentation(FlowCapableNode.class);
        Short _tableId = flow.getTableId();
        TableKey _tableKey = new TableKey(_tableId);
        InstanceIdentifier.InstanceIdentifierBuilder _child_1 = _augmentation.child(Table.class, (Identifier)_tableKey);
        FlowId _id = flow.getId();
        FlowKey _flowKey = new FlowKey(_id);
        InstanceIdentifier.InstanceIdentifierBuilder _child_2 = _child_1.child(Flow.class, (Identifier)_flowKey);
        InstanceIdentifier flowPath = _child_2.build();
        modification.putConfigurationData((Object)flowPath, (Object)flow);
        return modification.commit();
    }

    private Future<RpcResult<TransactionStatus>> internalAddFlowAsync(Node node, org.opendaylight.controller.sal.flowprogrammer.Flow flow, long rid) {
        UUID _randomUUID;
        boolean _notEquals;
        Map<org.opendaylight.controller.sal.flowprogrammer.Flow, UUID> _cache = this.getCache();
        UUID flowId = _cache.get(flow);
        boolean bl = _notEquals = !Objects.equal((Object)flowId, null);
        if (_notEquals) {
            this.removeFlow(node, flow);
            return this.internalAddFlowAsync(node, flow, rid);
        }
        flowId = _randomUUID = UUID.randomUUID();
        Map<org.opendaylight.controller.sal.flowprogrammer.Flow, UUID> _cache_1 = this.getCache();
        _cache_1.put(flow, flowId);
        String _string = flowId.toString();
        Flow _mDFlow = MDFlowMapping.toMDFlow(flow, _string);
        String _nodeIDString = node.getNodeIDString();
        NodeId _nodeId = new NodeId(_nodeIDString);
        NodeKey _nodeKey = new NodeKey(_nodeId);
        return this.writeFlowAsync(_mDFlow, _nodeKey);
    }

    private Future<RpcResult<TransactionStatus>> internalModifyFlowAsync(Node node, org.opendaylight.controller.sal.flowprogrammer.Flow oldFlow, org.opendaylight.controller.sal.flowprogrammer.Flow newFlow, long rid) {
        Map<org.opendaylight.controller.sal.flowprogrammer.Flow, UUID> _cache = this.getCache();
        UUID flowId = _cache.remove(oldFlow);
        boolean _equals = Objects.equal((Object)flowId, null);
        if (_equals) {
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("oldFlow is unknown");
            throw _illegalArgumentException;
        }
        Map<org.opendaylight.controller.sal.flowprogrammer.Flow, UUID> _cache_1 = this.getCache();
        _cache_1.put(newFlow, flowId);
        String _string = flowId.toString();
        Flow _mDFlow = MDFlowMapping.toMDFlow(newFlow, _string);
        String _nodeIDString = node.getNodeIDString();
        NodeId _nodeId = new NodeId(_nodeIDString);
        NodeKey _nodeKey = new NodeKey(_nodeId);
        return this.writeFlowAsync(_mDFlow, _nodeKey);
    }

    private Future<RpcResult<TransactionStatus>> internalRemoveFlowAsync(Node node, org.opendaylight.controller.sal.flowprogrammer.Flow adflow, long rid) {
        Map<org.opendaylight.controller.sal.flowprogrammer.Flow, UUID> _cache = this.getCache();
        UUID flowId = _cache.remove(adflow);
        boolean _equals = Objects.equal((Object)flowId, null);
        if (_equals) {
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("adflow is unknown");
            throw _illegalArgumentException;
        }
        String _string = flowId.toString();
        Flow flow = MDFlowMapping.toMDFlow(adflow, _string);
        DataModificationTransaction modification = this._dataBrokerService.beginTransaction();
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(Nodes.class);
        String _nodeIDString = node.getNodeIDString();
        NodeId _nodeId = new NodeId(_nodeIDString);
        NodeKey _nodeKey = new NodeKey(_nodeId);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node.class, (Identifier)_nodeKey);
        InstanceIdentifier.InstanceIdentifierBuilder _augmentation = _child.augmentation(FlowCapableNode.class);
        Short _tableId = flow.getTableId();
        TableKey _tableKey = new TableKey(_tableId);
        InstanceIdentifier.InstanceIdentifierBuilder _child_1 = _augmentation.child(Table.class, (Identifier)_tableKey);
        FlowId _id = flow.getId();
        FlowKey _flowKey = new FlowKey(_id);
        InstanceIdentifier.InstanceIdentifierBuilder _child_2 = _child_1.child(Flow.class, (Identifier)_flowKey);
        InstanceIdentifier flowPath = _child_2.build();
        modification.removeConfigurationData((Object)flowPath);
        return modification.commit();
    }

    private Status toFutureStatus(Future<RpcResult<TransactionStatus>> future) {
        try {
            RpcResult<TransactionStatus> result = future.get();
            return FlowProgrammerAdapter.toStatus(result);
        }
        catch (Throwable _t) {
            if (_t instanceof InterruptedException) {
                InterruptedException e = (InterruptedException)_t;
                return FlowProgrammerAdapter.processException(e);
            }
            if (_t instanceof ExecutionException) {
                ExecutionException e_1 = (ExecutionException)_t;
                return FlowProgrammerAdapter.processException(e_1);
            }
            if (!(_t instanceof Exception)) {
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            Exception e_2 = (Exception)_t;
            FlowProgrammerAdapter.processException(e_2);
            return FlowProgrammerAdapter.toStatus(false);
        }
    }

    private Map<org.opendaylight.controller.sal.flowprogrammer.Flow, UUID> getCache() {
        try {
            IClusterGlobalServices _clusterGlobalServices = this.getClusterGlobalServices();
            boolean _equals = Objects.equal((Object)_clusterGlobalServices, null);
            if (_equals) {
                ConcurrentHashMap<org.opendaylight.controller.sal.flowprogrammer.Flow, UUID> _concurrentHashMap = new ConcurrentHashMap<org.opendaylight.controller.sal.flowprogrammer.Flow, UUID>();
                return _concurrentHashMap;
            }
            IClusterGlobalServices _clusterGlobalServices_1 = this.getClusterGlobalServices();
            ConcurrentMap cache = _clusterGlobalServices_1.getCache(CACHE_NAME);
            boolean _equals_1 = Objects.equal((Object)cache, null);
            if (_equals_1) {
                try {
                    ConcurrentMap _createCache;
                    IClusterGlobalServices _clusterGlobalServices_2 = this.getClusterGlobalServices();
                    EnumSet<IClusterServices.cacheMode> _of = EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL);
                    cache = _createCache = _clusterGlobalServices_2.createCache(CACHE_NAME, _of);
                }
                catch (Throwable _t) {
                    if (_t instanceof CacheExistException) {
                        ConcurrentMap _cache;
                        CacheExistException e = (CacheExistException)_t;
                        IClusterGlobalServices _clusterGlobalServices_3 = this.getClusterGlobalServices();
                        cache = _cache = _clusterGlobalServices_3.getCache(CACHE_NAME);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            return cache;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static Status processException(Exception e) {
        if (e instanceof InterruptedException) {
            return FlowProgrammerAdapter._processException((InterruptedException)e);
        }
        if (e instanceof ExecutionException) {
            return FlowProgrammerAdapter._processException((ExecutionException)e);
        }
        if (e != null) {
            return FlowProgrammerAdapter._processException(e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }
}

