/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.compatibility;

import org.eclipse.xtext.xbase.lib.Exceptions;
import org.opendaylight.controller.sal.compatibility.NodeMapping;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.packet.IPluginOutDataPacketService;
import org.opendaylight.controller.sal.packet.RawPacket;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketProcessingListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketReceived;

public class DataPacketAdapter
implements PacketProcessingListener {
    private IPluginOutDataPacketService _dataPacketPublisher;

    public IPluginOutDataPacketService getDataPacketPublisher() {
        return this._dataPacketPublisher;
    }

    public void setDataPacketPublisher(IPluginOutDataPacketService dataPacketPublisher) {
        this._dataPacketPublisher = dataPacketPublisher;
    }

    public void onPacketReceived(PacketReceived packet) {
        RawPacket inPacket = DataPacketAdapter.toRawPacket(packet);
        IPluginOutDataPacketService _dataPacketPublisher = this.getDataPacketPublisher();
        _dataPacketPublisher.receiveDataPacket(inPacket);
    }

    public static RawPacket toRawPacket(PacketReceived received) {
        try {
            RawPacket _rawPacket;
            byte[] _payload = received.getPayload();
            RawPacket ret = _rawPacket = new RawPacket(_payload);
            NodeConnectorRef _ingress = received.getIngress();
            NodeConnector _aDNodeConnector = NodeMapping.toADNodeConnector(_ingress);
            ret.setIncomingNodeConnector(_aDNodeConnector);
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

