/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.connector.api;

import java.util.concurrent.Future;
import org.opendaylight.controller.sal.connector.api.RpcRouter;
import org.opendaylight.yangtools.concepts.Immutable;

public interface BindingAwareRpcRouter
extends RpcRouter<String, String, String, byte[]> {
    @Override
    public Future<RpcRouter.RpcReply<byte[]>> sendRpc(RpcRouter.RpcRequest<String, String, String, byte[]> var1);

    public static class BindingAwareRouteIdentifier
    implements RpcRouter.RouteIdentifier<String, String, String>,
    Immutable {
        private final String type;
        private final String route;
        private final String content;

        public BindingAwareRouteIdentifier(String type, String route, String content) {
            this.type = type;
            this.route = route;
            this.content = content;
        }

        @Override
        public String getContext() {
            return this.content;
        }

        @Override
        public String getRoute() {
            return this.route;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
            result = 31 * result + (this.route == null ? 0 : this.route.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BindingAwareRouteIdentifier other = (BindingAwareRouteIdentifier)obj;
            if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
                return false;
            }
            if (this.route == null ? other.route != null : !this.route.equals(other.route)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }

    public static class BindingAwareRequest
    implements RpcRouter.RpcRequest<String, String, String, byte[]>,
    Immutable {
        private final BindingAwareRouteIdentifier routingInformation;
        private final byte[] payload;

        public BindingAwareRequest(BindingAwareRouteIdentifier routingInformation, byte[] payload) {
            this.routingInformation = routingInformation;
            this.payload = payload;
        }

        public BindingAwareRouteIdentifier getRoutingInformation() {
            return this.routingInformation;
        }

        @Override
        public byte[] getPayload() {
            return this.payload;
        }
    }
}

