/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.util;

import com.google.common.base.Joiner;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;

public abstract class ByteUtil {
    private static final int MAC_ADDRESS_LENGTH = 6;

    public static String bytesToHexstring(byte[] bytes, String delimiter) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(String.format("%02x%s", b, delimiter));
        }
        return sb.toString();
    }

    public static byte[] convertBigIntegerToNBytes(BigInteger bigInteger, int numBytes) {
        if (bigInteger == null) {
            return null;
        }
        byte[] inputArray = bigInteger.toByteArray();
        byte[] outputArray = new byte[numBytes];
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            Arrays.fill(outputArray, (byte)-1);
        } else {
            Arrays.fill(outputArray, (byte)0);
        }
        System.arraycopy(inputArray, Math.max(0, inputArray.length - outputArray.length), outputArray, Math.max(0, outputArray.length - inputArray.length), Math.min(outputArray.length, inputArray.length));
        return outputArray;
    }

    public static final long bytesToUnsignedInt(byte[] bytes) {
        long unsignedInt = 0L;
        unsignedInt |= (long)(bytes[0] & 0xFF);
        unsignedInt <<= 8;
        unsignedInt |= (long)(bytes[1] & 0xFF);
        unsignedInt <<= 8;
        unsignedInt |= (long)(bytes[2] & 0xFF);
        unsignedInt <<= 8;
        return unsignedInt |= (long)(bytes[3] & 0xFF);
    }

    public static final int bytesToUnsignedShort(byte[] bytes) {
        int unsignedShort = 0;
        unsignedShort |= bytes[0] & 0xFF;
        unsignedShort <<= 8;
        return unsignedShort |= bytes[1] & 0xFF;
    }

    public static byte[] unsignedIntToBytes(Long unsignedInt) {
        byte[] bytes = new byte[4];
        bytes[3] = (byte)(unsignedInt & 0xFFL);
        bytes[2] = (byte)(unsignedInt >> 8 & 0xFFL);
        bytes[1] = (byte)(unsignedInt >> 16 & 0xFFL);
        bytes[0] = (byte)(unsignedInt >> 24 & 0xFFL);
        return bytes;
    }

    public static byte[] unsignedShortToBytes(Integer unsignedShort) {
        byte[] bytes = new byte[2];
        bytes[1] = (byte)(unsignedShort & 0xFF);
        bytes[0] = (byte)(unsignedShort >> 8 & 0xFF);
        return bytes;
    }

    public static String macAddressToString(byte[] address) {
        ArrayList<String> groups = new ArrayList<String>();
        for (int i = 0; i < 6; ++i) {
            groups.add(String.format("%02X", address[i]));
        }
        Joiner joiner = Joiner.on((String)":");
        return joiner.join(groups);
    }

    public static byte[] macAddressToBytes(MacAddress macAddress) {
        String macAddressString = macAddress.getValue();
        String[] sequences = macAddressString.split(":");
        int MAC_ADDRESS_LENGTH = 6;
        byte[] result = new byte[MAC_ADDRESS_LENGTH];
        for (int i = 0; i < sequences.length; ++i) {
            result[i] = (byte)Short.parseShort(sequences[i], 16);
        }
        return result;
    }
}

