/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opendaylight.openflowplugin.openflow.md.core.ConnectionConductor;
import org.opendaylight.openflowplugin.openflow.md.core.IMDMessageTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.SwitchConnectionDistinguisher;
import org.opendaylight.openflowplugin.openflow.md.core.TranslatorKey;
import org.opendaylight.openflowplugin.openflow.md.queue.MessageSpy;
import org.opendaylight.openflowplugin.openflow.md.queue.RegisteredTypeExtractor;
import org.opendaylight.openflowplugin.openflow.md.queue.Ticket;
import org.opendaylight.openflowplugin.openflow.md.queue.VersionExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketProcessorFactory<IN, OUT> {
    protected static final Logger LOG = LoggerFactory.getLogger(TicketProcessorFactory.class);
    protected VersionExtractor<IN> versionExtractor;
    protected RegisteredTypeExtractor<IN> registeredTypeExtractor;
    protected Map<TranslatorKey, Collection<IMDMessageTranslator<IN, List<OUT>>>> translatorMapping;
    protected MessageSpy<IN, OUT> spy;

    public void setVersionExtractor(VersionExtractor<IN> versionExtractor) {
        this.versionExtractor = versionExtractor;
    }

    public void setRegisteredTypeExtractor(RegisteredTypeExtractor<IN> registeredTypeExtractor) {
        this.registeredTypeExtractor = registeredTypeExtractor;
    }

    public void setTranslatorMapping(Map<TranslatorKey, Collection<IMDMessageTranslator<IN, List<OUT>>>> translatorMapping) {
        this.translatorMapping = translatorMapping;
    }

    public void setSpy(MessageSpy<IN, OUT> spy) {
        this.spy = spy;
    }

    public Runnable createProcessor(final Ticket<IN, OUT> ticket) {
        Runnable ticketProcessor = new Runnable(){

            @Override
            public void run() {
                LOG.debug("message received, type: {}", (Object)TicketProcessorFactory.this.registeredTypeExtractor.extractRegisteredType(ticket.getMessage()).getSimpleName());
                try {
                    List translate = this.translate();
                    ticket.getResult().set(translate);
                    if (TicketProcessorFactory.this.spy != null) {
                        TicketProcessorFactory.this.spy.spyIn(ticket.getMessage());
                        TicketProcessorFactory.this.spy.spyOut((List)ticket.getResult().get());
                    }
                }
                catch (Exception e) {
                    LOG.error("translation problem: {}", (Object)e.getMessage());
                    ticket.getResult().setException((Throwable)e);
                }
                LOG.debug("message processing done (type: {}, ticket: {})", (Object)TicketProcessorFactory.this.registeredTypeExtractor.extractRegisteredType(ticket.getMessage()).getSimpleName(), (Object)System.identityHashCode(ticket));
            }

            private List<OUT> translate() {
                ArrayList result = new ArrayList();
                Object message = ticket.getMessage();
                Class messageType = TicketProcessorFactory.this.registeredTypeExtractor.extractRegisteredType(ticket.getMessage());
                ConnectionConductor conductor = ticket.getConductor();
                Collection translators = null;
                LOG.debug("translating ticket: {}, ticket: {}", (Object)messageType.getSimpleName(), (Object)System.identityHashCode(ticket));
                Short version = TicketProcessorFactory.this.versionExtractor.extractVersion(message);
                if (version == null) {
                    throw new IllegalArgumentException("version is NULL");
                }
                TranslatorKey tKey = new TranslatorKey(version.shortValue(), messageType.getName());
                translators = TicketProcessorFactory.this.translatorMapping.get(tKey);
                LOG.debug("translatorKey: {} + {}", (Object)version, (Object)messageType.getName());
                if (translators != null) {
                    for (IMDMessageTranslator translator : translators) {
                        SwitchConnectionDistinguisher cookie = null;
                        if (messageType.equals("PacketInMessage.class")) {
                            cookie = conductor.getAuxiliaryKey();
                        }
                        long start = System.nanoTime();
                        List translatorOutput = translator.translate(cookie, conductor.getSessionContext(), message);
                        long end = System.nanoTime();
                        LOG.debug("translator: {} elapsed time {} ns", translator, (Object)(end - start));
                        if (translatorOutput == null || translatorOutput.isEmpty()) continue;
                        result.addAll(translatorOutput);
                    }
                } else {
                    LOG.warn("No translators for this message Type: {}", messageType);
                }
                return result;
            }
        };
        return ticketProcessor;
    }
}

