/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.opendaylight.openflowplugin.openflow.md.core.ConnectionConductor;
import org.opendaylight.openflowplugin.openflow.md.core.IMDMessageTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.SwitchConnectionDistinguisher;
import org.opendaylight.openflowplugin.openflow.md.core.TranslatorKey;
import org.opendaylight.openflowplugin.openflow.md.queue.MessageSpy;
import org.opendaylight.openflowplugin.openflow.md.queue.PopListener;
import org.opendaylight.openflowplugin.openflow.md.queue.QueueKeeper;
import org.opendaylight.openflowplugin.openflow.md.queue.RegisteredTypeExtractor;
import org.opendaylight.openflowplugin.openflow.md.queue.Ticket;
import org.opendaylight.openflowplugin.openflow.md.queue.TicketFinisher;
import org.opendaylight.openflowplugin.openflow.md.queue.TicketImpl;
import org.opendaylight.openflowplugin.openflow.md.queue.TicketProcessorFactory;
import org.opendaylight.openflowplugin.openflow.md.queue.TicketResult;
import org.opendaylight.openflowplugin.openflow.md.queue.VersionExtractor;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueKeeperLightImpl
implements QueueKeeper<OfHeader, DataObject> {
    private static final Logger LOG = LoggerFactory.getLogger(QueueKeeperLightImpl.class);
    private Map<Class<? extends DataObject>, Collection<PopListener<DataObject>>> popListenersMapping;
    private BlockingQueue<TicketResult<DataObject>> processQueue;
    private ScheduledThreadPoolExecutor pool;
    private int poolSize = 10;
    private Map<TranslatorKey, Collection<IMDMessageTranslator<OfHeader, List<DataObject>>>> translatorMapping;
    private TicketProcessorFactory<OfHeader, DataObject> ticketProcessorFactory;
    private MessageSpy<OfHeader, DataObject> messageSpy;
    private VersionExtractor<OfHeader> versionExtractor = new VersionExtractor<OfHeader>(){

        @Override
        public Short extractVersion(OfHeader message) {
            return message.getVersion();
        }
    };
    private RegisteredTypeExtractor<OfHeader> registeredSrcTypeExtractor = new RegisteredTypeExtractor<OfHeader>(){

        @Override
        public Class<? extends OfHeader> extractRegisteredType(OfHeader message) {
            return message.getImplementedInterface();
        }
    };
    private RegisteredTypeExtractor<DataObject> registeredOutTypeExtractor = new RegisteredTypeExtractor<DataObject>(){

        @Override
        public Class<? extends DataObject> extractRegisteredType(DataObject message) {
            return message.getImplementedInterface();
        }
    };

    public void init() {
        this.processQueue = new LinkedBlockingQueue<TicketResult<DataObject>>();
        this.pool = new ScheduledThreadPoolExecutor(this.poolSize);
        this.ticketProcessorFactory = new TicketProcessorFactory();
        this.ticketProcessorFactory.setRegisteredTypeExtractor(this.registeredSrcTypeExtractor);
        this.ticketProcessorFactory.setTranslatorMapping(this.translatorMapping);
        this.ticketProcessorFactory.setVersionExtractor(this.versionExtractor);
        this.ticketProcessorFactory.setSpy(this.messageSpy);
        TicketFinisher<DataObject> finisher = new TicketFinisher<DataObject>(this.processQueue, this.popListenersMapping, this.registeredOutTypeExtractor);
        new Thread(finisher).start();
    }

    public void shutdown() {
        this.pool.shutdown();
    }

    @Override
    public void push(OfHeader message, ConnectionConductor conductor) {
        this.push(message, conductor, QueueKeeper.QueueType.DEFAULT);
    }

    @Override
    public void push(OfHeader message, ConnectionConductor conductor, QueueKeeper.QueueType queueType) {
        if (queueType == QueueKeeper.QueueType.DEFAULT) {
            TicketImpl<OfHeader, DataObject> ticket = new TicketImpl<OfHeader, DataObject>();
            ticket.setConductor(conductor);
            ticket.setMessage(message);
            LOG.debug("ticket scheduling: {}, ticket: {}", (Object)message.getImplementedInterface().getSimpleName(), (Object)System.identityHashCode(ticket));
            this.processQueue.add(ticket);
            this.scheduleTicket(ticket);
        } else if (queueType == QueueKeeper.QueueType.UNORDERED) {
            List<DataObject> processedMessages = this.translate(message, conductor);
            this.pop(processedMessages, conductor);
        }
    }

    private void scheduleTicket(Ticket<OfHeader, DataObject> ticket) {
        Runnable ticketProcessor = this.ticketProcessorFactory.createProcessor(ticket);
        this.pool.execute(ticketProcessor);
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    @Override
    public void setTranslatorMapping(Map<TranslatorKey, Collection<IMDMessageTranslator<OfHeader, List<DataObject>>>> translatorMapping) {
        this.translatorMapping = translatorMapping;
    }

    @Override
    public void setPopListenersMapping(Map<Class<? extends DataObject>, Collection<PopListener<DataObject>>> popListenersMapping) {
        this.popListenersMapping = popListenersMapping;
    }

    public void setMessageSpy(MessageSpy<OfHeader, DataObject> messageSpy) {
        this.messageSpy = messageSpy;
    }

    private List<DataObject> translate(OfHeader message, ConnectionConductor conductor) {
        ArrayList<DataObject> result = new ArrayList<DataObject>();
        Class<OfHeader> messageType = this.registeredSrcTypeExtractor.extractRegisteredType(message);
        Collection<IMDMessageTranslator<OfHeader, List<DataObject>>> translators = null;
        LOG.debug("translating message: {}", (Object)messageType.getSimpleName());
        Short version = this.versionExtractor.extractVersion(message);
        if (version == null) {
            throw new IllegalArgumentException("version is NULL");
        }
        TranslatorKey tKey = new TranslatorKey(version.shortValue(), messageType.getName());
        translators = this.translatorMapping.get(tKey);
        LOG.debug("translatorKey: {} + {}", (Object)version, (Object)messageType.getName());
        if (translators != null) {
            for (IMDMessageTranslator<OfHeader, List<DataObject>> translator : translators) {
                List<DataObject> translatorOutput;
                SwitchConnectionDistinguisher cookie = null;
                if (messageType.equals("PacketInMessage.class")) {
                    cookie = conductor.getAuxiliaryKey();
                }
                if ((translatorOutput = translator.translate(cookie, conductor.getSessionContext(), message)) == null) continue;
                result.addAll((Collection<DataObject>)translator.translate(cookie, conductor.getSessionContext(), message));
            }
            if (this.messageSpy != null) {
                this.messageSpy.spyIn(message);
                this.messageSpy.spyOut(result);
            }
        } else {
            LOG.warn("No translators for this message Type: {}", messageType);
        }
        return result;
    }

    private void pop(List<DataObject> processedMessages, ConnectionConductor conductor) {
        for (DataObject msg : processedMessages) {
            Class<DataObject> registeredType = this.registeredOutTypeExtractor.extractRegisteredType(msg);
            Collection<PopListener<DataObject>> popListeners = this.popListenersMapping.get(registeredType);
            if (popListeners == null) {
                LOG.warn("no popListener registered for type {}" + registeredType);
                continue;
            }
            for (PopListener<DataObject> consumer : popListeners) {
                consumer.onPop(msg);
            }
        }
    }
}

