/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.queue;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.openflowplugin.openflow.md.queue.MessageObservatory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSpyCounterImpl
implements MessageObservatory<OfHeader, DataObject> {
    private static final Logger LOG = LoggerFactory.getLogger(MessageSpyCounterImpl.class);
    private Map<Class<? extends DataContainer>, AtomicLong[]> inputStats = new ConcurrentHashMap<Class<? extends DataContainer>, AtomicLong[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spyIn(OfHeader message) {
        AtomicLong counter;
        Class msgType;
        Class clazz = msgType = message.getImplementedInterface();
        synchronized (clazz) {
            AtomicLong[] counters = this.inputStats.get(msgType);
            if (counters == null) {
                counters = new AtomicLong[]{new AtomicLong(), new AtomicLong()};
                this.inputStats.put(msgType, counters);
            }
            counter = counters[0];
        }
        counter.incrementAndGet();
    }

    @Override
    public void spyOut(List<DataObject> message) {
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            for (String counterItem : this.dumpMessageCounts()) {
                LOG.debug(counterItem);
            }
        }
    }

    @Override
    public List<String> dumpMessageCounts() {
        ArrayList<String> dump = new ArrayList<String>();
        for (Map.Entry<Class<? extends DataContainer>, AtomicLong[]> statEntry : this.inputStats.entrySet()) {
            long amountPerInterval = statEntry.getValue()[0].getAndSet(0L);
            long cumulativeAmount = statEntry.getValue()[1].addAndGet(amountPerInterval);
            dump.add(String.format("MSG[%s] -> +%d | %d", statEntry.getKey().getSimpleName(), amountPerInterval, cumulativeAmount));
        }
        return dump;
    }
}

