/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.lldp;

import org.opendaylight.openflowplugin.openflow.md.lldp.LLDPSpeaker;
import org.opendaylight.openflowplugin.openflow.md.queue.PopListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnectorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnectorUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowCapablePort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.flow.capable.port.State;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class LLDPSpeakerPopListener<T>
implements PopListener<T> {
    @Override
    public void onPop(T processedMessage) {
        NodeConnectorUpdated connector;
        FlowCapableNodeConnectorUpdated flowConnector;
        if (processedMessage instanceof NodeConnectorUpdated && (flowConnector = (FlowCapableNodeConnectorUpdated)(connector = (NodeConnectorUpdated)processedMessage).getAugmentation(FlowCapableNodeConnectorUpdated.class)) != null) {
            InstanceIdentifier nodeConnectorInstanceId = connector.getNodeConnectorRef().getValue();
            NodeConnectorBuilder ncb = new NodeConnectorBuilder((NodeConnector)connector);
            FlowCapableNodeConnectorBuilder fcncb = new FlowCapableNodeConnectorBuilder((FlowCapablePort)flowConnector);
            ncb.addAugmentation(FlowCapableNodeConnector.class, (Augmentation)fcncb.build());
            State portState = flowConnector.getState();
            PortConfig portConfig = flowConnector.getConfiguration();
            if (!(portState != null && portState.isLinkDown().booleanValue() || portConfig != null && portConfig.isPORTDOWN().booleanValue())) {
                LLDPSpeaker.getInstance().addNodeConnector((InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector>)nodeConnectorInstanceId, ncb.build());
            } else {
                LLDPSpeaker.getInstance().removeNodeConnector((InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector>)nodeConnectorInstanceId, ncb.build());
            }
        }
    }
}

