/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.lldp;

import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.controller.sal.packet.Ethernet;
import org.opendaylight.controller.sal.packet.LLDP;
import org.opendaylight.controller.sal.packet.LLDPTLV;
import org.opendaylight.controller.sal.packet.Packet;
import org.opendaylight.controller.sal.packet.PacketException;
import org.opendaylight.controller.sal.utils.EtherTypes;
import org.opendaylight.controller.sal.utils.HexEncode;
import org.opendaylight.openflowplugin.openflow.md.ModelDrivenSwitch;
import org.opendaylight.openflowplugin.openflow.md.util.InventoryDataServiceUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.TransmitPacketInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.TransmitPacketInputBuilder;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LLDPSpeaker {
    private static Logger LOG = LoggerFactory.getLogger(LLDPSpeaker.class);
    private final Map<InstanceIdentifier<NodeConnector>, TransmitPacketInput> nodeConnectorMap = new ConcurrentHashMap<InstanceIdentifier<NodeConnector>, TransmitPacketInput>();
    private final Map<InstanceIdentifier<Node>, ModelDrivenSwitch> nodeMap = new ConcurrentHashMap<InstanceIdentifier<Node>, ModelDrivenSwitch>();
    private static final LLDPSpeaker instance = new LLDPSpeaker();
    private Timer timer = new Timer();
    private static final int DELAY = 0;
    private static final int PERIOD = 5000;

    private LLDPSpeaker() {
        this.timer.schedule((TimerTask)new LLDPSpeakerTask(), 0L, 5000L);
    }

    public static LLDPSpeaker getInstance() {
        return instance;
    }

    public void addModelDrivenSwitch(InstanceIdentifier<Node> nodeInstanceId, ModelDrivenSwitch sw) {
        this.nodeMap.put(nodeInstanceId, sw);
    }

    public void removeModelDrivenSwitch(InstanceIdentifier<Node> nodeInstanceId) {
        this.nodeMap.remove(nodeInstanceId);
        for (InstanceIdentifier<NodeConnector> nodeConnectorInstanceId : this.nodeConnectorMap.keySet()) {
            if (!nodeInstanceId.equals((Object)nodeConnectorInstanceId.firstIdentifierOf(Node.class))) continue;
            this.nodeConnectorMap.remove(nodeConnectorInstanceId);
        }
    }

    public void addNodeConnector(InstanceIdentifier<NodeConnector> nodeConnectorInstanceId, NodeConnector nodeConnector) {
        InstanceIdentifier nodeInstanceId = nodeConnectorInstanceId.firstIdentifierOf(Node.class);
        NodeKey nodeKey = (NodeKey)InstanceIdentifier.keyOf((InstanceIdentifier)nodeInstanceId);
        NodeId nodeId = nodeKey.getId();
        NodeConnectorId nodeConnectorId = nodeConnector.getId();
        FlowCapableNodeConnector flowConnector = (FlowCapableNodeConnector)nodeConnector.getAugmentation(FlowCapableNodeConnector.class);
        TransmitPacketInputBuilder tpib = new TransmitPacketInputBuilder();
        tpib.setEgress(new NodeConnectorRef(nodeConnectorInstanceId));
        tpib.setNode(new NodeRef(nodeInstanceId));
        tpib.setPayload(this.lldpDataFrom((InstanceIdentifier<Node>)nodeInstanceId, nodeConnectorInstanceId, flowConnector.getHardwareAddress()));
        this.nodeConnectorMap.put(nodeConnectorInstanceId, tpib.build());
        ModelDrivenSwitch md = this.nodeMap.get(nodeInstanceId);
        md.transmitPacket(this.nodeConnectorMap.get(nodeConnectorInstanceId));
    }

    public void removeNodeConnector(InstanceIdentifier<NodeConnector> nodeConnectorInstanceId, NodeConnector nodeConnector) {
        this.nodeConnectorMap.remove(nodeConnectorInstanceId);
    }

    private byte[] lldpDataFrom(InstanceIdentifier<Node> nodeInstanceId, InstanceIdentifier<NodeConnector> nodeConnectorInstanceId, MacAddress src) {
        NodeId nodeId = ((NodeKey)InstanceIdentifier.keyOf(nodeInstanceId)).getId();
        NodeConnectorId nodeConnectorId = ((NodeConnectorKey)InstanceIdentifier.keyOf(nodeConnectorInstanceId)).getId();
        byte[] ttl = new byte[]{0, 120};
        LLDPTLV ttlTlv = new LLDPTLV();
        ttlTlv.setType(LLDPTLV.TLVType.TTL.getValue()).setLength((short)ttl.length).setValue(ttl);
        byte[] cidValue = LLDPTLV.createChassisIDTLVValue((String)this.colonize(StringUtils.leftPad((String)Long.toHexString(InventoryDataServiceUtil.dataPathIdFromNodeId(nodeId)), (int)16, (String)"0")));
        LLDPTLV chassisIdTlv = new LLDPTLV();
        chassisIdTlv.setType(LLDPTLV.TLVType.ChassisID.getValue());
        chassisIdTlv.setType(LLDPTLV.TLVType.ChassisID.getValue()).setLength((short)cidValue.length).setValue(cidValue);
        byte[] snValue = LLDPTLV.createSystemNameTLVValue((String)nodeId.getValue());
        LLDPTLV systemNameTlv = new LLDPTLV();
        systemNameTlv.setType(LLDPTLV.TLVType.SystemName.getValue());
        systemNameTlv.setType(LLDPTLV.TLVType.SystemName.getValue()).setLength((short)snValue.length).setValue(snValue);
        Long portNo = InventoryDataServiceUtil.portNumberfromNodeConnectorId(nodeConnectorId);
        String hexString = Long.toHexString(portNo);
        byte[] pidValue = LLDPTLV.createPortIDTLVValue((String)hexString);
        LLDPTLV portIdTlv = new LLDPTLV();
        portIdTlv.setType(LLDPTLV.TLVType.PortID.getValue()).setLength((short)pidValue.length).setValue(pidValue);
        portIdTlv.setType(LLDPTLV.TLVType.PortID.getValue());
        byte[] customValue = LLDPTLV.createCustomTLVValue((String)nodeConnectorId.getValue());
        LLDPTLV customTlv = new LLDPTLV();
        customTlv.setType(LLDPTLV.TLVType.Custom.getValue()).setLength((short)customValue.length).setValue(customValue);
        ArrayList<LLDPTLV> customList = new ArrayList<LLDPTLV>();
        customList.add(customTlv);
        LLDP discoveryPkt = new LLDP();
        discoveryPkt.setChassisId(chassisIdTlv).setPortId(portIdTlv).setTtl(ttlTlv).setSystemNameId(systemNameTlv).setOptionalTLVList(customList);
        byte[] sourceMac = HexEncode.bytesFromHexString((String)src.getValue());
        Ethernet ethPkt = new Ethernet();
        ethPkt.setSourceMACAddress(sourceMac).setDestinationMACAddress(LLDP.LLDPMulticastMac).setEtherType(EtherTypes.LLDP.shortValue()).setPayload((Packet)discoveryPkt);
        try {
            byte[] data = ethPkt.serialize();
            return data;
        }
        catch (PacketException e) {
            LOG.error("Error creating LLDP packet", (Throwable)e);
            return null;
        }
    }

    private String colonize(String orig) {
        return orig.replaceAll("(?<=..)(..)", ":$1");
    }

    private class LLDPSpeakerTask
    extends TimerTask {
        private LLDPSpeakerTask() {
        }

        @Override
        public void run() {
            for (InstanceIdentifier nodeConnectorInstanceId : LLDPSpeaker.this.nodeConnectorMap.keySet()) {
                InstanceIdentifier nodeInstanceId = nodeConnectorInstanceId.firstIdentifierOf(Node.class);
                ModelDrivenSwitch md = (ModelDrivenSwitch)LLDPSpeaker.this.nodeMap.get(nodeInstanceId);
                md.transmitPacket((TransmitPacketInput)LLDPSpeaker.this.nodeConnectorMap.get(nodeConnectorInstanceId));
            }
        }
    }
}

