/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.translator;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opendaylight.openflowplugin.openflow.md.core.IMDMessageTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.SwitchConnectionDistinguisher;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionContext;
import org.opendaylight.openflowplugin.openflow.md.util.InventoryDataServiceUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortNumberMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.Cookie;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketReceived;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketReceivedBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketInTranslator
implements IMDMessageTranslator<OfHeader, List<DataObject>> {
    protected static final Logger LOG = LoggerFactory.getLogger(PacketInTranslator.class);

    @Override
    public List<DataObject> translate(SwitchConnectionDistinguisher cookie, SessionContext sc, OfHeader msg) {
        if (sc != null && msg instanceof PacketInMessage) {
            PacketInMessage message = (PacketInMessage)msg;
            CopyOnWriteArrayList<DataObject> list = new CopyOnWriteArrayList<DataObject>();
            LOG.trace("PacketIn: InPort: {} Cookie: {} Match.type: {}", new Object[]{message.getInPort(), message.getCookie(), message.getMatch() != null ? message.getMatch().getType() : message.getMatch()});
            PacketReceivedBuilder pktInBuilder = new PacketReceivedBuilder();
            pktInBuilder.setPayload(message.getData());
            GetFeaturesOutput features = sc.getFeatures();
            if (features != null) {
                BigInteger dpid = features.getDatapathId();
                if (message.getCookie() != null) {
                    pktInBuilder.setCookie(new Cookie(Long.valueOf(message.getCookie().longValue())));
                }
                Long port = null;
                if (message.getInPort() != null) {
                    port = message.getInPort().longValue();
                }
                if (message.getMatch() != null && message.getMatch().getMatchEntries() != null) {
                    List entries = message.getMatch().getMatchEntries();
                    for (MatchEntries entry : entries) {
                        PortNumberMatchEntry tmp = (PortNumberMatchEntry)entry.getAugmentation(PortNumberMatchEntry.class);
                        if (tmp == null) continue;
                        if (port == null) {
                            port = tmp.getPortNumber().getValue();
                            continue;
                        }
                        LOG.warn("Multiple input ports (at least {} and {})", (Object)port, (Object)tmp.getPortNumber().getValue());
                    }
                }
                if (port == null) {
                    LOG.warn("Received packet_in, but couldn't find an input port");
                    return null;
                }
                LOG.trace("Receive packet_in from {} on port {}", (Object)dpid, (Object)port);
                pktInBuilder.setIngress(InventoryDataServiceUtil.nodeConnectorRefFromDatapathIdPortno(dpid, port));
                PacketReceived pktInEvent = pktInBuilder.build();
                list.add((DataObject)pktInEvent);
                return list;
            }
        }
        return Collections.emptyList();
    }
}

