/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.translator;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opendaylight.openflowplugin.openflow.md.core.IMDMessageTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.SwitchConnectionDistinguisher;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.FlowStatsResponseConvertor;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.GroupStatsResponseConvertor;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.MeterStatsResponseConvertor;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionContext;
import org.opendaylight.openflowplugin.openflow.md.util.InventoryDataServiceUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter32;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.AggregateFlowStatisticsUpdateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.FlowsStatisticsUpdateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.FlowTableStatisticsUpdateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.flow.table.and.statistics.map.FlowTableAndStatisticsMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.flow.table.and.statistics.map.FlowTableAndStatisticsMapBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.QueueId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GroupDescStatsUpdatedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GroupFeaturesUpdatedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GroupStatisticsUpdatedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Chaining;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.ChainingChecks;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupAll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupFf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupIndirect;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupSelect;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.SelectLiveness;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.SelectWeight;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.MeterConfigStatsUpdatedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.MeterFeaturesUpdatedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.MeterStatisticsUpdatedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterBandDrop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterBandDscpRemark;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterBurst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterKbps;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterPktps;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.duration.DurationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.node.connector.statistics.BytesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.node.connector.statistics.PacketsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ActionType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyAggregateCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyFlowCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterConfigCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortStatsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.aggregate._case.MultipartReplyAggregate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.MultipartReplyFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.MultipartReplyGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.MultipartReplyGroupDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.features._case.MultipartReplyGroupFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.MultipartReplyMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.MultipartReplyMeterConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.features._case.MultipartReplyMeterFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.MultipartReplyPortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats.PortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.MultipartReplyQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue.QueueStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.MultipartReplyTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table.TableStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.NodeConnectorStatisticsUpdateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.node.connector.statistics.and.port.number.map.NodeConnectorStatisticsAndPortNumberMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.node.connector.statistics.and.port.number.map.NodeConnectorStatisticsAndPortNumberMapBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.node.connector.statistics.and.port.number.map.NodeConnectorStatisticsAndPortNumberMapKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.QueueStatisticsUpdateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.queue.id.and.statistics.map.QueueIdAndStatisticsMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.queue.id.and.statistics.map.QueueIdAndStatisticsMapBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableId;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartReplyTranslator
implements IMDMessageTranslator<OfHeader, List<DataObject>> {
    protected static final Logger logger = LoggerFactory.getLogger(MultipartReplyTranslator.class);
    private static FlowStatsResponseConvertor flowStatsConvertor = new FlowStatsResponseConvertor();
    private static GroupStatsResponseConvertor groupStatsConvertor = new GroupStatsResponseConvertor();
    private static MeterStatsResponseConvertor meterStatsConvertor = new MeterStatsResponseConvertor();

    @Override
    public List<DataObject> translate(SwitchConnectionDistinguisher cookie, SessionContext sc, OfHeader msg) {
        CopyOnWriteArrayList<DataObject> listDataObject = new CopyOnWriteArrayList<DataObject>();
        if (msg instanceof MultipartReplyMessage) {
            MultipartReplyMessage mpReply = (MultipartReplyMessage)msg;
            NodeId node = this.nodeIdFromDatapathId(sc.getFeatures().getDatapathId());
            switch (mpReply.getType()) {
                case OFPMPFLOW: {
                    logger.debug("Received flow statistics reponse from openflow {} switch", (Object)(msg.getVersion() == 1 ? "1.0" : "1.3+"));
                    FlowsStatisticsUpdateBuilder message = new FlowsStatisticsUpdateBuilder();
                    message.setId(node);
                    message.setMoreReplies(mpReply.getFlags().isOFPMPFREQMORE());
                    message.setTransactionId(this.generateTransactionId(mpReply.getXid()));
                    MultipartReplyFlowCase caseBody = (MultipartReplyFlowCase)mpReply.getMultipartReplyBody();
                    MultipartReplyFlow replyBody = caseBody.getMultipartReplyFlow();
                    message.setFlowAndStatisticsMapList(flowStatsConvertor.toSALFlowStatsList(replyBody.getFlowStats(), sc.getFeatures().getDatapathId()));
                    logger.debug("Converted flow statistics : {}", (Object)message.build().toString());
                    listDataObject.add((DataObject)message.build());
                    return listDataObject;
                }
                case OFPMPAGGREGATE: {
                    logger.debug("Received aggregate flow statistics reponse from openflow {} switch", (Object)(msg.getVersion() == 1 ? "1.0" : "1.3+"));
                    AggregateFlowStatisticsUpdateBuilder message = new AggregateFlowStatisticsUpdateBuilder();
                    message.setId(node);
                    message.setMoreReplies(mpReply.getFlags().isOFPMPFREQMORE());
                    message.setTransactionId(this.generateTransactionId(mpReply.getXid()));
                    MultipartReplyAggregateCase caseBody = (MultipartReplyAggregateCase)mpReply.getMultipartReplyBody();
                    MultipartReplyAggregate replyBody = caseBody.getMultipartReplyAggregate();
                    message.setByteCount(new Counter64(replyBody.getByteCount()));
                    message.setPacketCount(new Counter64(replyBody.getPacketCount()));
                    message.setFlowCount(new Counter32(replyBody.getFlowCount()));
                    logger.debug("Converted aggregate flow statistics : {}", (Object)message.build().toString());
                    listDataObject.add((DataObject)message.build());
                    return listDataObject;
                }
                case OFPMPPORTSTATS: {
                    logger.debug("Received port statistics multipart response");
                    NodeConnectorStatisticsUpdateBuilder message = new NodeConnectorStatisticsUpdateBuilder();
                    message.setId(node);
                    message.setMoreReplies(mpReply.getFlags().isOFPMPFREQMORE());
                    message.setTransactionId(this.generateTransactionId(mpReply.getXid()));
                    MultipartReplyPortStatsCase caseBody = (MultipartReplyPortStatsCase)mpReply.getMultipartReplyBody();
                    MultipartReplyPortStats replyBody = caseBody.getMultipartReplyPortStats();
                    ArrayList<NodeConnectorStatisticsAndPortNumberMap> statsMap = new ArrayList<NodeConnectorStatisticsAndPortNumberMap>();
                    for (PortStats portStats : replyBody.getPortStats()) {
                        NodeConnectorStatisticsAndPortNumberMapBuilder statsBuilder = new NodeConnectorStatisticsAndPortNumberMapBuilder();
                        statsBuilder.setNodeConnectorId(InventoryDataServiceUtil.nodeConnectorIdfromDatapathPortNo(sc.getFeatures().getDatapathId(), portStats.getPortNo()));
                        BytesBuilder bytesBuilder = new BytesBuilder();
                        bytesBuilder.setReceived(portStats.getRxBytes());
                        bytesBuilder.setTransmitted(portStats.getTxBytes());
                        statsBuilder.setBytes(bytesBuilder.build());
                        PacketsBuilder packetsBuilder = new PacketsBuilder();
                        packetsBuilder.setReceived(portStats.getRxPackets());
                        packetsBuilder.setTransmitted(portStats.getTxPackets());
                        statsBuilder.setPackets(packetsBuilder.build());
                        DurationBuilder durationBuilder = new DurationBuilder();
                        durationBuilder.setSecond(new Counter32(portStats.getDurationSec()));
                        durationBuilder.setNanosecond(new Counter32(portStats.getDurationNsec()));
                        statsBuilder.setDuration(durationBuilder.build());
                        statsBuilder.setCollisionCount(portStats.getCollisions());
                        statsBuilder.setKey(new NodeConnectorStatisticsAndPortNumberMapKey(statsBuilder.getNodeConnectorId()));
                        statsBuilder.setReceiveCrcError(portStats.getRxCrcErr());
                        statsBuilder.setReceiveDrops(portStats.getRxDropped());
                        statsBuilder.setReceiveErrors(portStats.getRxErrors());
                        statsBuilder.setReceiveFrameError(portStats.getRxFrameErr());
                        statsBuilder.setReceiveOverRunError(portStats.getRxOverErr());
                        statsBuilder.setTransmitDrops(portStats.getTxDropped());
                        statsBuilder.setTransmitErrors(portStats.getTxErrors());
                        statsMap.add(statsBuilder.build());
                    }
                    message.setNodeConnectorStatisticsAndPortNumberMap(statsMap);
                    logger.debug("Converted ports statistics : {}", (Object)message.build().toString());
                    listDataObject.add((DataObject)message.build());
                    return listDataObject;
                }
                case OFPMPGROUP: {
                    logger.debug("Received group statistics multipart reponse");
                    GroupStatisticsUpdatedBuilder message = new GroupStatisticsUpdatedBuilder();
                    message.setId(node);
                    message.setMoreReplies(mpReply.getFlags().isOFPMPFREQMORE());
                    message.setTransactionId(this.generateTransactionId(mpReply.getXid()));
                    MultipartReplyGroupCase caseBody = (MultipartReplyGroupCase)mpReply.getMultipartReplyBody();
                    MultipartReplyGroup replyBody = caseBody.getMultipartReplyGroup();
                    message.setGroupStats(groupStatsConvertor.toSALGroupStatsList(replyBody.getGroupStats()));
                    logger.debug("Converted group statistics : {}", (Object)message.toString());
                    listDataObject.add((DataObject)message.build());
                    return listDataObject;
                }
                case OFPMPGROUPDESC: {
                    logger.debug("Received group description statistics multipart reponse");
                    GroupDescStatsUpdatedBuilder message = new GroupDescStatsUpdatedBuilder();
                    message.setId(node);
                    message.setMoreReplies(mpReply.getFlags().isOFPMPFREQMORE());
                    message.setTransactionId(this.generateTransactionId(mpReply.getXid()));
                    MultipartReplyGroupDescCase caseBody = (MultipartReplyGroupDescCase)mpReply.getMultipartReplyBody();
                    MultipartReplyGroupDesc replyBody = caseBody.getMultipartReplyGroupDesc();
                    message.setGroupDescStats(groupStatsConvertor.toSALGroupDescStatsList(replyBody.getGroupDesc()));
                    logger.debug("Converted group statistics : {}", (Object)message.toString());
                    listDataObject.add((DataObject)message.build());
                    return listDataObject;
                }
                case OFPMPGROUPFEATURES: {
                    logger.debug("Received group features multipart reponse");
                    GroupFeaturesUpdatedBuilder message = new GroupFeaturesUpdatedBuilder();
                    message.setId(node);
                    message.setMoreReplies(mpReply.getFlags().isOFPMPFREQMORE());
                    message.setTransactionId(this.generateTransactionId(mpReply.getXid()));
                    MultipartReplyGroupFeaturesCase caseBody = (MultipartReplyGroupFeaturesCase)mpReply.getMultipartReplyBody();
                    MultipartReplyGroupFeatures replyBody = caseBody.getMultipartReplyGroupFeatures();
                    ArrayList<Class> supportedGroups = new ArrayList<Class>();
                    if (replyBody.getTypes().isOFPGTALL().booleanValue()) {
                        supportedGroups.add(GroupAll.class);
                    }
                    if (replyBody.getTypes().isOFPGTSELECT().booleanValue()) {
                        supportedGroups.add(GroupSelect.class);
                    }
                    if (replyBody.getTypes().isOFPGTINDIRECT().booleanValue()) {
                        supportedGroups.add(GroupIndirect.class);
                    }
                    if (replyBody.getTypes().isOFPGTFF().booleanValue()) {
                        supportedGroups.add(GroupFf.class);
                    }
                    message.setGroupTypesSupported(supportedGroups);
                    message.setMaxGroups(replyBody.getMaxGroups());
                    ArrayList<Class> supportedCapabilities = new ArrayList<Class>();
                    if (replyBody.getCapabilities().isOFPGFCCHAINING().booleanValue()) {
                        supportedCapabilities.add(Chaining.class);
                    }
                    if (replyBody.getCapabilities().isOFPGFCCHAININGCHECKS().booleanValue()) {
                        supportedCapabilities.add(ChainingChecks.class);
                    }
                    if (replyBody.getCapabilities().isOFPGFCSELECTLIVENESS().booleanValue()) {
                        supportedCapabilities.add(SelectLiveness.class);
                    }
                    if (replyBody.getCapabilities().isOFPGFCSELECTWEIGHT().booleanValue()) {
                        supportedCapabilities.add(SelectWeight.class);
                    }
                    message.setGroupCapabilitiesSupported(supportedCapabilities);
                    message.setActions(this.getGroupActionsSupportBitmap(replyBody.getActionsBitmap()));
                    listDataObject.add((DataObject)message.build());
                    return listDataObject;
                }
                case OFPMPMETER: {
                    logger.debug("Received meter statistics multipart reponse");
                    MeterStatisticsUpdatedBuilder message = new MeterStatisticsUpdatedBuilder();
                    message.setId(node);
                    message.setMoreReplies(mpReply.getFlags().isOFPMPFREQMORE());
                    message.setTransactionId(this.generateTransactionId(mpReply.getXid()));
                    MultipartReplyMeterCase caseBody = (MultipartReplyMeterCase)mpReply.getMultipartReplyBody();
                    MultipartReplyMeter replyBody = caseBody.getMultipartReplyMeter();
                    message.setMeterStats(meterStatsConvertor.toSALMeterStatsList(replyBody.getMeterStats()));
                    listDataObject.add((DataObject)message.build());
                    return listDataObject;
                }
                case OFPMPMETERCONFIG: {
                    logger.debug("Received meter config statistics multipart reponse");
                    MeterConfigStatsUpdatedBuilder message = new MeterConfigStatsUpdatedBuilder();
                    message.setId(node);
                    message.setMoreReplies(mpReply.getFlags().isOFPMPFREQMORE());
                    message.setTransactionId(this.generateTransactionId(mpReply.getXid()));
                    MultipartReplyMeterConfigCase caseBody = (MultipartReplyMeterConfigCase)mpReply.getMultipartReplyBody();
                    MultipartReplyMeterConfig replyBody = caseBody.getMultipartReplyMeterConfig();
                    message.setMeterConfigStats(meterStatsConvertor.toSALMeterConfigList(replyBody.getMeterConfig()));
                    listDataObject.add((DataObject)message.build());
                    return listDataObject;
                }
                case OFPMPMETERFEATURES: {
                    logger.debug("Received meter features multipart reponse");
                    MeterFeaturesUpdatedBuilder message = new MeterFeaturesUpdatedBuilder();
                    message.setId(node);
                    message.setMoreReplies(mpReply.getFlags().isOFPMPFREQMORE());
                    message.setTransactionId(this.generateTransactionId(mpReply.getXid()));
                    MultipartReplyMeterFeaturesCase caseBody = (MultipartReplyMeterFeaturesCase)mpReply.getMultipartReplyBody();
                    MultipartReplyMeterFeatures replyBody = caseBody.getMultipartReplyMeterFeatures();
                    message.setMaxBands(replyBody.getMaxBands());
                    message.setMaxColor(replyBody.getMaxColor());
                    message.setMaxMeter(new Counter32(replyBody.getMaxMeter()));
                    ArrayList<Class> supportedCapabilities = new ArrayList<Class>();
                    if (replyBody.getCapabilities().isOFPMFBURST().booleanValue()) {
                        supportedCapabilities.add(MeterBurst.class);
                    }
                    if (replyBody.getCapabilities().isOFPMFKBPS().booleanValue()) {
                        supportedCapabilities.add(MeterKbps.class);
                    }
                    if (replyBody.getCapabilities().isOFPMFPKTPS().booleanValue()) {
                        supportedCapabilities.add(MeterPktps.class);
                    }
                    if (replyBody.getCapabilities().isOFPMFSTATS().booleanValue()) {
                        supportedCapabilities.add(MeterStats.class);
                    }
                    message.setMeterCapabilitiesSupported(supportedCapabilities);
                    ArrayList<Class> supportedMeterBand = new ArrayList<Class>();
                    if (replyBody.getBandTypes().isOFPMBTDROP().booleanValue()) {
                        supportedMeterBand.add(MeterBandDrop.class);
                    }
                    if (replyBody.getBandTypes().isOFPMBTDSCPREMARK().booleanValue()) {
                        supportedMeterBand.add(MeterBandDscpRemark.class);
                    }
                    message.setMeterBandSupported(supportedMeterBand);
                    listDataObject.add((DataObject)message.build());
                    return listDataObject;
                }
                case OFPMPTABLE: {
                    logger.debug("Received flow table statistics reponse from openflow {} switch", (Object)(msg.getVersion() == 1 ? "1.0" : "1.3+"));
                    FlowTableStatisticsUpdateBuilder message = new FlowTableStatisticsUpdateBuilder();
                    message.setId(node);
                    message.setMoreReplies(mpReply.getFlags().isOFPMPFREQMORE());
                    message.setTransactionId(this.generateTransactionId(mpReply.getXid()));
                    MultipartReplyTableCase caseBody = (MultipartReplyTableCase)mpReply.getMultipartReplyBody();
                    MultipartReplyTable replyBody = caseBody.getMultipartReplyTable();
                    List swTablesStats = replyBody.getTableStats();
                    ArrayList<FlowTableAndStatisticsMap> salFlowStats = new ArrayList<FlowTableAndStatisticsMap>();
                    for (TableStats swTableStats : swTablesStats) {
                        FlowTableAndStatisticsMapBuilder statisticsBuilder = new FlowTableAndStatisticsMapBuilder();
                        statisticsBuilder.setActiveFlows(new Counter32(swTableStats.getActiveCount()));
                        statisticsBuilder.setPacketsLookedUp(new Counter64(swTableStats.getLookupCount()));
                        statisticsBuilder.setPacketsMatched(new Counter64(swTableStats.getMatchedCount()));
                        statisticsBuilder.setTableId(new TableId(swTableStats.getTableId()));
                        salFlowStats.add(statisticsBuilder.build());
                    }
                    message.setFlowTableAndStatisticsMap(salFlowStats);
                    logger.debug("Converted flow table statistics : {}", (Object)message.build().toString());
                    listDataObject.add((DataObject)message.build());
                    return listDataObject;
                }
                case OFPMPQUEUE: {
                    logger.debug("Received queue statistics multipart response");
                    QueueStatisticsUpdateBuilder message = new QueueStatisticsUpdateBuilder();
                    message.setId(node);
                    message.setMoreReplies(mpReply.getFlags().isOFPMPFREQMORE());
                    message.setTransactionId(this.generateTransactionId(mpReply.getXid()));
                    MultipartReplyQueueCase caseBody = (MultipartReplyQueueCase)mpReply.getMultipartReplyBody();
                    MultipartReplyQueue replyBody = caseBody.getMultipartReplyQueue();
                    ArrayList<QueueIdAndStatisticsMap> statsMap = new ArrayList<QueueIdAndStatisticsMap>();
                    for (QueueStats queueStats : replyBody.getQueueStats()) {
                        QueueIdAndStatisticsMapBuilder statsBuilder = new QueueIdAndStatisticsMapBuilder();
                        statsBuilder.setNodeConnectorId(InventoryDataServiceUtil.nodeConnectorIdfromDatapathPortNo(sc.getFeatures().getDatapathId(), queueStats.getPortNo()));
                        statsBuilder.setTransmissionErrors(new Counter64(queueStats.getTxErrors()));
                        statsBuilder.setTransmittedBytes(new Counter64(queueStats.getTxBytes()));
                        statsBuilder.setTransmittedPackets(new Counter64(queueStats.getTxPackets()));
                        DurationBuilder durationBuilder = new DurationBuilder();
                        durationBuilder.setSecond(new Counter32(queueStats.getDurationSec()));
                        durationBuilder.setNanosecond(new Counter32(queueStats.getDurationNsec()));
                        statsBuilder.setDuration(durationBuilder.build());
                        statsBuilder.setQueueId(new QueueId(queueStats.getQueueId()));
                        statsBuilder.setNodeConnectorId(InventoryDataServiceUtil.nodeConnectorIdfromDatapathPortNo(sc.getFeatures().getDatapathId(), queueStats.getPortNo()));
                        statsMap.add(statsBuilder.build());
                    }
                    message.setQueueIdAndStatisticsMap(statsMap);
                    logger.debug("Converted queue statistics : {}", (Object)message.build().toString());
                    listDataObject.add((DataObject)message.build());
                    return listDataObject;
                }
            }
            return listDataObject;
        }
        return listDataObject;
    }

    private NodeId nodeIdFromDatapathId(BigInteger datapathId) {
        String current = datapathId.toString();
        return new NodeId("openflow:" + current);
    }

    private TransactionId generateTransactionId(Long xid) {
        String stringXid = xid.toString();
        BigInteger bigIntXid = new BigInteger(stringXid);
        return new TransactionId(bigIntXid);
    }

    private List<Long> getGroupActionsSupportBitmap(List<ActionType> actionsSupported) {
        ArrayList<Long> supportActionByGroups = new ArrayList<Long>();
        for (ActionType supportedActions : actionsSupported) {
            long supportActionBitmap = 0L;
            supportActionBitmap |= supportedActions.isOFPATOUTPUT() != false ? 1L : -2L;
            supportActionBitmap |= supportedActions.isOFPATCOPYTTLOUT() != false ? 2048L : -2049L;
            supportActionBitmap |= supportedActions.isOFPATCOPYTTLIN() != false ? 4096L : -4097L;
            supportActionBitmap |= supportedActions.isOFPATSETMPLSTTL() != false ? 32768L : -32769L;
            supportActionBitmap |= supportedActions.isOFPATDECMPLSTTL() != false ? 65536L : -65537L;
            supportActionBitmap |= supportedActions.isOFPATPUSHVLAN() != false ? 65536L : -65537L;
            supportActionBitmap |= supportedActions.isOFPATPOPVLAN() != false ? 131072L : -131073L;
            supportActionBitmap |= supportedActions.isOFPATPUSHMPLS() != false ? 262144L : -262145L;
            supportActionBitmap |= supportedActions.isOFPATPOPMPLS() != false ? 524288L : -524289L;
            supportActionBitmap |= supportedActions.isOFPATSETQUEUE() != false ? 0x100000L : -1048577L;
            supportActionBitmap |= supportedActions.isOFPATGROUP() != false ? 0x200000L : -2097153L;
            supportActionBitmap |= supportedActions.isOFPATSETNWTTL() != false ? 0x400000L : -4194305L;
            supportActionBitmap |= supportedActions.isOFPATDECNWTTL() != false ? 0x800000L : -8388609L;
            supportActionBitmap |= supportedActions.isOFPATSETFIELD() != false ? 0x1000000L : -16777217L;
            supportActionBitmap |= supportedActions.isOFPATPUSHPBB() != false ? 0x2000000L : -33554433L;
            supportActionBitmap |= supportedActions.isOFPATPOPPBB() != false ? 0x4000000L : -67108865L;
            supportActionByGroups.add(new Long(supportActionBitmap |= supportedActions.isOFPATEXPERIMENTER() != false ? 0x8000000L : -134217729L));
        }
        return supportActionByGroups;
    }
}

