/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.translator;

import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opendaylight.openflowplugin.openflow.md.core.IMDMessageTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.SwitchConnectionDistinguisher;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.match.MatchConvertorImpl;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionContext;
import org.opendaylight.openflowplugin.openflow.md.util.ByteUtil;
import org.opendaylight.openflowplugin.openflow.md.util.InventoryDataServiceUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Dscp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6FlowLabel;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.SwitchFlowRemovedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.RemovedReasonFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.mod.removed.MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.EtherType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.arp.match.fields.ArpSourceHardwareAddressBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.arp.match.fields.ArpTargetHardwareAddressBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetDestinationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetSourceBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ipv6.match.fields.Ipv6ExtHeaderBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ipv6.match.fields.Ipv6LabelBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.EthernetMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Icmpv4MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Icmpv6MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.IpMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer3Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.MetadataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.ProtocolMatchFieldsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.TunnelBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.VlanMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.ArpMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv4MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv6MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.SctpMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.TcpMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.UdpMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.protocol.match.fields.PbbBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.vlan.match.fields.VlanIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.BosMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.DscpMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EcnMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EthTypeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv4CodeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv4TypeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv6CodeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv6TypeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv4AddressMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv6AddressMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv6FlabelMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.IsidMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MacAddressMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaskMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MetadataMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MplsLabelMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OpCodeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortNumberMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ProtocolNumberMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PseudoFieldMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.TcMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanPcpMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanVidMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowRemovedReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Ipv6ExthdrFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpOp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpSha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpSpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpTha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpTpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv4Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv4Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv6Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv6Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.InPhyPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.InPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.IpDscp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.IpEcn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.IpProto;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv4Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv4Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Exthdr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Flabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6NdSll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6NdTarget;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6NdTll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Metadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MplsBos;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MplsLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MplsTc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.PbbIsid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.SctpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.SctpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.TcpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.TcpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.TunnelId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.UdpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.UdpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.VlanPcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.VlanVid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowRemovedTranslator
implements IMDMessageTranslator<OfHeader, List<DataObject>> {
    protected static final Logger LOG = LoggerFactory.getLogger(FlowRemovedTranslator.class);
    private static final String PREFIX_SEPARATOR = "/";

    @Override
    public List<DataObject> translate(SwitchConnectionDistinguisher cookie, SessionContext sc, OfHeader msg) {
        if (msg instanceof FlowRemovedMessage) {
            FlowRemovedMessage ofFlow = (FlowRemovedMessage)msg;
            CopyOnWriteArrayList<DataObject> list = new CopyOnWriteArrayList<DataObject>();
            LOG.debug("Flow Removed Message received: Table Id={}, Flow removed reason={} ", (Object)ofFlow.getTableId(), (Object)ofFlow.getReason());
            SwitchFlowRemovedBuilder salFlowRemoved = new SwitchFlowRemovedBuilder();
            salFlowRemoved.setCookie(ofFlow.getCookie());
            salFlowRemoved.setPriority(ofFlow.getPriority());
            if (ofFlow.getTableId() != null) {
                salFlowRemoved.setTableId(Short.valueOf(ofFlow.getTableId().getValue().shortValue()));
            }
            salFlowRemoved.setDurationSec(ofFlow.getDurationSec());
            salFlowRemoved.setDurationNsec(ofFlow.getDurationNsec());
            salFlowRemoved.setIdleTimeout(ofFlow.getIdleTimeout());
            salFlowRemoved.setHardTimeout(ofFlow.getHardTimeout());
            salFlowRemoved.setPacketCount(ofFlow.getPacketCount());
            salFlowRemoved.setByteCount(ofFlow.getByteCount());
            RemovedReasonFlags removeReasonFlag = new RemovedReasonFlags(Boolean.valueOf(FlowRemovedReason.OFPRRDELETE.equals((Object)ofFlow.getReason())), Boolean.valueOf(FlowRemovedReason.OFPRRGROUPDELETE.equals((Object)ofFlow.getReason())), Boolean.valueOf(FlowRemovedReason.OFPRRHARDTIMEOUT.equals((Object)ofFlow.getReason())), Boolean.valueOf(FlowRemovedReason.OFPRRIDLETIMEOUT.equals((Object)ofFlow.getReason())));
            salFlowRemoved.setRemovedReason(removeReasonFlag);
            org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.match.grouping.Match ofMatch = ofFlow.getMatch();
            if (ofMatch != null) {
                salFlowRemoved.setMatch(this.fromMatch(ofMatch, sc.getFeatures().getDatapathId()));
            } else if (ofFlow.getMatchV10() != null) {
                MatchBuilder matchBuilder = new MatchBuilder((Match)MatchConvertorImpl.fromOFMatchV10ToSALMatch(ofFlow.getMatchV10(), sc.getFeatures().getDatapathId()));
                salFlowRemoved.setMatch(matchBuilder.build());
            }
            salFlowRemoved.setNode(new NodeRef(InventoryDataServiceUtil.identifierFromDatapathId(sc.getFeatures().getDatapathId())));
            list.add((DataObject)salFlowRemoved.build());
            return list;
        }
        LOG.error("Message is not a flow removed message ");
        return Collections.emptyList();
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.mod.removed.Match fromMatch(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.match.grouping.Match ofMatch, BigInteger datapathid) {
        MatchBuilder matchBuilder = new MatchBuilder();
        EthernetMatchBuilder ethernetMatch = null;
        VlanMatchBuilder vlanMatch = null;
        IpMatchBuilder ipMatch = null;
        TcpMatchBuilder tcpMatch = null;
        UdpMatchBuilder udpMatch = null;
        SctpMatchBuilder sctpMatch = null;
        Icmpv4MatchBuilder icmpv4Match = null;
        Icmpv6MatchBuilder icmpv6Match = null;
        Ipv4MatchBuilder ipv4Match = null;
        ArpMatchBuilder arpMatch = null;
        Ipv6MatchBuilder ipv6Match = null;
        ProtocolMatchFieldsBuilder protocolMatchFields = null;
        for (MatchEntries entry : ofMatch.getMatchEntries()) {
            Class field = entry.getOxmMatchField();
            if (field.equals(InPort.class)) {
                matchBuilder.setInPort(InventoryDataServiceUtil.nodeConnectorIdfromDatapathPortNo(datapathid, (long)((PortNumberMatchEntry)entry.getAugmentation(PortNumberMatchEntry.class)).getPortNumber().getValue()));
                continue;
            }
            if (field.equals(InPhyPort.class)) {
                matchBuilder.setInPhyPort(InventoryDataServiceUtil.nodeConnectorIdfromDatapathPortNo(datapathid, (long)((PortNumberMatchEntry)entry.getAugmentation(PortNumberMatchEntry.class)).getPortNumber().getValue()));
                continue;
            }
            if (field.equals(Metadata.class)) {
                MetadataBuilder metadata = new MetadataBuilder();
                metadata.setMetadata(new BigInteger(1, ((MetadataMatchEntry)entry.getAugmentation(MetadataMatchEntry.class)).getMetadata()));
                if (entry.isHasMask().booleanValue()) {
                    metadata.setMetadataMask(new BigInteger(1, ((MaskMatchEntry)entry.getAugmentation(MaskMatchEntry.class)).getMask()));
                }
                matchBuilder.setMetadata(metadata.build());
                continue;
            }
            if (field.equals(EthDst.class) || field.equals(EthSrc.class) || field.equals(EthType.class)) {
                if (ethernetMatch == null) {
                    ethernetMatch = new EthernetMatchBuilder();
                }
                if (field.equals(EthDst.class)) {
                    EthernetDestinationBuilder ethDst = new EthernetDestinationBuilder();
                    ethDst.setAddress(((MacAddressMatchEntry)entry.getAugmentation(MacAddressMatchEntry.class)).getMacAddress());
                    if (entry.isHasMask().booleanValue()) {
                        ethDst.setMask(new MacAddress(ByteUtil.bytesToHexstring(((MaskMatchEntry)entry.getAugmentation(MaskMatchEntry.class)).getMask(), ":")));
                    }
                    ethernetMatch.setEthernetDestination(ethDst.build());
                    continue;
                }
                if (field.equals(EthSrc.class)) {
                    EthernetSourceBuilder ethSrc = new EthernetSourceBuilder();
                    ethSrc.setAddress(((MacAddressMatchEntry)entry.getAugmentation(MacAddressMatchEntry.class)).getMacAddress());
                    if (entry.isHasMask().booleanValue()) {
                        ethSrc.setMask(new MacAddress(ByteUtil.bytesToHexstring(((MaskMatchEntry)entry.getAugmentation(MaskMatchEntry.class)).getMask(), ":")));
                    }
                    ethernetMatch.setEthernetSource(ethSrc.build());
                    continue;
                }
                if (!field.equals(EthType.class)) continue;
                EthernetTypeBuilder ethType = new EthernetTypeBuilder();
                ethType.setType(new EtherType(Long.valueOf(((EthTypeMatchEntry)entry.getAugmentation(EthTypeMatchEntry.class)).getEthType().getValue().longValue())));
                ethernetMatch.setEthernetType(ethType.build());
                continue;
            }
            if (field.equals(VlanVid.class) || field.equals(VlanPcp.class)) {
                if (vlanMatch == null) {
                    vlanMatch = new VlanMatchBuilder();
                }
                if (field.equals(VlanVid.class)) {
                    boolean vlanIdPresent = false;
                    VlanIdBuilder vlanId = new VlanIdBuilder();
                    VlanVidMatchEntry vlanVid = (VlanVidMatchEntry)entry.getAugmentation(VlanVidMatchEntry.class);
                    Integer vlanVidValue = vlanVid.getVlanVid();
                    if (vlanVid.isCfiBit().booleanValue()) {
                        vlanIdPresent = true;
                    }
                    vlanId.setVlanIdPresent(Boolean.valueOf(vlanIdPresent));
                    if (vlanVidValue != null) {
                        vlanId.setVlanId(new VlanId(vlanVidValue));
                    }
                    vlanMatch.setVlanId(vlanId.build());
                    continue;
                }
                if (!field.equals(VlanPcp.class)) continue;
                vlanMatch.setVlanPcp(new org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanPcp(Short.valueOf(((VlanPcpMatchEntry)entry.getAugmentation(VlanPcpMatchEntry.class)).getVlanPcp())));
                continue;
            }
            if (field.equals(IpDscp.class) || field.equals(IpEcn.class) || field.equals(IpProto.class)) {
                if (ipMatch == null) {
                    ipMatch = new IpMatchBuilder();
                }
                if (field.equals(IpDscp.class)) {
                    ipMatch.setIpDscp(new Dscp(((DscpMatchEntry)entry.getAugmentation(DscpMatchEntry.class)).getDscp().getValue()));
                    continue;
                }
                if (field.equals(IpEcn.class)) {
                    ipMatch.setIpEcn(((EcnMatchEntry)entry.getAugmentation(EcnMatchEntry.class)).getEcn());
                    continue;
                }
                if (!field.equals(IpProto.class)) continue;
                ipMatch.setIpProtocol(((ProtocolNumberMatchEntry)entry.getAugmentation(ProtocolNumberMatchEntry.class)).getProtocolNumber());
                continue;
            }
            if (field.equals(TcpSrc.class) || field.equals(TcpDst.class)) {
                if (tcpMatch == null) {
                    tcpMatch = new TcpMatchBuilder();
                }
                if (field.equals(TcpSrc.class)) {
                    tcpMatch.setTcpSourcePort(new PortNumber(((PortMatchEntry)entry.getAugmentation(PortMatchEntry.class)).getPort().getValue()));
                    continue;
                }
                if (!field.equals(TcpDst.class)) continue;
                tcpMatch.setTcpDestinationPort(new PortNumber(((PortMatchEntry)entry.getAugmentation(PortMatchEntry.class)).getPort().getValue()));
                continue;
            }
            if (field.equals(UdpSrc.class) || field.equals(UdpDst.class)) {
                if (udpMatch == null) {
                    udpMatch = new UdpMatchBuilder();
                }
                if (field.equals(UdpSrc.class)) {
                    udpMatch.setUdpSourcePort(new PortNumber(((PortMatchEntry)entry.getAugmentation(PortMatchEntry.class)).getPort().getValue()));
                    continue;
                }
                if (!field.equals(UdpDst.class)) continue;
                udpMatch.setUdpDestinationPort(new PortNumber(((PortMatchEntry)entry.getAugmentation(PortMatchEntry.class)).getPort().getValue()));
                continue;
            }
            if (field.equals(SctpSrc.class) || field.equals(SctpDst.class)) {
                if (sctpMatch == null) {
                    sctpMatch = new SctpMatchBuilder();
                }
                if (field.equals(SctpSrc.class)) {
                    sctpMatch.setSctpSourcePort(new PortNumber(((PortMatchEntry)entry.getAugmentation(PortMatchEntry.class)).getPort().getValue()));
                    continue;
                }
                if (!field.equals(SctpDst.class)) continue;
                sctpMatch.setSctpDestinationPort(new PortNumber(((PortMatchEntry)entry.getAugmentation(PortMatchEntry.class)).getPort().getValue()));
                continue;
            }
            if (field.equals(Icmpv4Type.class) || field.equals(Icmpv4Code.class)) {
                if (icmpv4Match == null) {
                    icmpv4Match = new Icmpv4MatchBuilder();
                }
                if (field.equals(Icmpv4Type.class)) {
                    icmpv4Match.setIcmpv4Type(((Icmpv4TypeMatchEntry)entry.getAugmentation(Icmpv4TypeMatchEntry.class)).getIcmpv4Type());
                    continue;
                }
                if (!field.equals(Icmpv4Code.class)) continue;
                icmpv4Match.setIcmpv4Code(((Icmpv4CodeMatchEntry)entry.getAugmentation(Icmpv4CodeMatchEntry.class)).getIcmpv4Code());
                continue;
            }
            if (field.equals(Icmpv6Type.class) || field.equals(Icmpv6Code.class)) {
                if (icmpv6Match == null) {
                    icmpv6Match = new Icmpv6MatchBuilder();
                }
                if (field.equals(Icmpv6Type.class)) {
                    icmpv6Match.setIcmpv6Type(((Icmpv6TypeMatchEntry)entry.getAugmentation(Icmpv6TypeMatchEntry.class)).getIcmpv6Type());
                    continue;
                }
                if (!field.equals(Icmpv6Code.class)) continue;
                icmpv6Match.setIcmpv6Code(((Icmpv6CodeMatchEntry)entry.getAugmentation(Icmpv6CodeMatchEntry.class)).getIcmpv6Code());
                continue;
            }
            if (field.equals(Ipv4Src.class) || field.equals(Ipv4Dst.class)) {
                if (ipv4Match == null) {
                    ipv4Match = new Ipv4MatchBuilder();
                }
                if (field.equals(Ipv4Src.class)) {
                    ipv4Match.setIpv4Source(this.toIpv4Prefix(entry));
                    continue;
                }
                if (!field.equals(Ipv4Dst.class)) continue;
                ipv4Match.setIpv4Destination(this.toIpv4Prefix(entry));
                continue;
            }
            if (field.equals(ArpOp.class) || field.equals(ArpSpa.class) || field.equals(ArpTpa.class) || field.equals(ArpSha.class) || field.equals(ArpTha.class)) {
                if (arpMatch == null) {
                    arpMatch = new ArpMatchBuilder();
                }
                if (field.equals(ArpOp.class)) {
                    arpMatch.setArpOp(((OpCodeMatchEntry)entry.getAugmentation(OpCodeMatchEntry.class)).getOpCode());
                    continue;
                }
                if (field.equals(ArpSpa.class)) {
                    arpMatch.setArpSourceTransportAddress(this.toIpv4Prefix(entry));
                    continue;
                }
                if (field.equals(ArpTpa.class)) {
                    arpMatch.setArpTargetTransportAddress(this.toIpv4Prefix(entry));
                    continue;
                }
                if (field.equals(ArpSha.class)) {
                    ArpSourceHardwareAddressBuilder arpSha = new ArpSourceHardwareAddressBuilder();
                    arpSha.setAddress(((MacAddressMatchEntry)entry.getAugmentation(MacAddressMatchEntry.class)).getMacAddress());
                    if (entry.isHasMask().booleanValue()) {
                        arpSha.setMask(new MacAddress(ByteUtil.bytesToHexstring(((MaskMatchEntry)entry.getAugmentation(MaskMatchEntry.class)).getMask(), ":")));
                    }
                    arpMatch.setArpSourceHardwareAddress(arpSha.build());
                    continue;
                }
                if (!field.equals(ArpTha.class)) continue;
                ArpTargetHardwareAddressBuilder arpTha = new ArpTargetHardwareAddressBuilder();
                arpTha.setAddress(((MacAddressMatchEntry)entry.getAugmentation(MacAddressMatchEntry.class)).getMacAddress());
                if (entry.isHasMask().booleanValue()) {
                    arpTha.setMask(new MacAddress(ByteUtil.bytesToHexstring(((MaskMatchEntry)entry.getAugmentation(MaskMatchEntry.class)).getMask(), ":")));
                }
                arpMatch.setArpTargetHardwareAddress(arpTha.build());
                continue;
            }
            if (field.equals(Ipv6Src.class) || field.equals(Ipv6Dst.class) || field.equals(Ipv6Flabel.class) || field.equals(Ipv6NdTarget.class) || field.equals(Ipv6NdSll.class) || field.equals(Ipv6NdTll.class) || field.equals(Ipv6Exthdr.class)) {
                if (ipv6Match == null) {
                    ipv6Match = new Ipv6MatchBuilder();
                }
                if (field.equals(Ipv6Src.class)) {
                    ipv6Match.setIpv6Source(this.toIpv6Prefix(entry));
                    continue;
                }
                if (field.equals(Ipv6Dst.class)) {
                    ipv6Match.setIpv6Destination(this.toIpv6Prefix(entry));
                    continue;
                }
                if (field.equals(Ipv6Flabel.class)) {
                    Ipv6LabelBuilder ipv6Label = new Ipv6LabelBuilder();
                    ipv6Label.setIpv6Flabel(((Ipv6FlabelMatchEntry)entry.getAugmentation(Ipv6FlabelMatchEntry.class)).getIpv6Flabel());
                    if (entry.isHasMask().booleanValue()) {
                        ipv6Label.setFlabelMask(new Ipv6FlowLabel(Long.valueOf(ByteUtil.bytesToUnsignedInt(((MaskMatchEntry)entry.getAugmentation(MaskMatchEntry.class)).getMask()))));
                    }
                    ipv6Match.setIpv6Label(ipv6Label.build());
                    continue;
                }
                if (field.equals(Ipv6NdTarget.class)) {
                    ipv6Match.setIpv6NdTarget(((Ipv6AddressMatchEntry)entry.getAugmentation(Ipv6AddressMatchEntry.class)).getIpv6Address());
                    continue;
                }
                if (field.equals(Ipv6NdSll.class)) {
                    ipv6Match.setIpv6NdSll(((MacAddressMatchEntry)entry.getAugmentation(MacAddressMatchEntry.class)).getMacAddress());
                    continue;
                }
                if (field.equals(Ipv6NdTll.class)) {
                    ipv6Match.setIpv6NdTll(((MacAddressMatchEntry)entry.getAugmentation(MacAddressMatchEntry.class)).getMacAddress());
                    continue;
                }
                if (!field.equals(Ipv6Exthdr.class)) continue;
                Ipv6ExtHeaderBuilder ipv6ExtHeaderBuilder = new Ipv6ExtHeaderBuilder();
                Ipv6ExthdrFlags pseudoField = ((PseudoFieldMatchEntry)entry.getAugmentation(PseudoFieldMatchEntry.class)).getPseudoField();
                HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
                map.put(0, pseudoField.isNonext());
                map.put(1, pseudoField.isEsp());
                map.put(2, pseudoField.isAuth());
                map.put(3, pseudoField.isDest());
                map.put(4, pseudoField.isFrag());
                map.put(5, pseudoField.isRouter());
                map.put(6, pseudoField.isHop());
                map.put(7, pseudoField.isUnrep());
                map.put(8, pseudoField.isUnseq());
                int bitmap = this.fillBitMaskFromMap(map);
                ipv6ExtHeaderBuilder.setIpv6Exthdr(Integer.valueOf(bitmap));
                if (entry.isHasMask().booleanValue()) {
                    ipv6ExtHeaderBuilder.setIpv6ExthdrMask(Integer.valueOf(ByteUtil.bytesToUnsignedShort(((MaskMatchEntry)entry.getAugmentation(MaskMatchEntry.class)).getMask())));
                }
                ipv6Match.setIpv6ExtHeader(ipv6ExtHeaderBuilder.build());
                continue;
            }
            if (field.equals(MplsLabel.class) || field.equals(MplsTc.class) || field.equals(MplsBos.class) || field.equals(PbbIsid.class)) {
                if (protocolMatchFields == null) {
                    protocolMatchFields = new ProtocolMatchFieldsBuilder();
                }
                if (field.equals(MplsLabel.class)) {
                    protocolMatchFields.setMplsLabel(((MplsLabelMatchEntry)entry.getAugmentation(MplsLabelMatchEntry.class)).getMplsLabel());
                    continue;
                }
                if (field.equals(MplsTc.class)) {
                    protocolMatchFields.setMplsTc(((TcMatchEntry)entry.getAugmentation(TcMatchEntry.class)).getTc());
                    continue;
                }
                if (field.equals(MplsBos.class)) {
                    protocolMatchFields.setMplsBos(Short.valueOf((short)(((BosMatchEntry)entry.getAugmentation(BosMatchEntry.class)).isBos() != false ? 1 : 0)));
                    continue;
                }
                if (!field.equals(PbbIsid.class)) continue;
                PbbBuilder pbb = new PbbBuilder();
                pbb.setPbbIsid(((IsidMatchEntry)entry.getAugmentation(IsidMatchEntry.class)).getIsid());
                if (entry.isHasMask().booleanValue()) {
                    pbb.setPbbMask(Long.valueOf(ByteUtil.bytesToUnsignedInt(((MaskMatchEntry)entry.getAugmentation(MaskMatchEntry.class)).getMask())));
                }
                protocolMatchFields.setPbb(pbb.build());
                continue;
            }
            if (!field.equals(TunnelId.class)) continue;
            TunnelBuilder tunnel = new TunnelBuilder();
            tunnel.setTunnelId(new BigInteger(1, ((MetadataMatchEntry)entry.getAugmentation(MetadataMatchEntry.class)).getMetadata()));
            if (entry.isHasMask().booleanValue()) {
                tunnel.setTunnelMask(new BigInteger(1, ((MaskMatchEntry)entry.getAugmentation(MaskMatchEntry.class)).getMask()));
            }
            matchBuilder.setTunnel(tunnel.build());
        }
        if (ethernetMatch != null) {
            matchBuilder.setEthernetMatch(ethernetMatch.build());
        }
        if (vlanMatch != null) {
            matchBuilder.setVlanMatch(vlanMatch.build());
        }
        if (ipMatch != null) {
            matchBuilder.setIpMatch(ipMatch.build());
        }
        if (tcpMatch != null) {
            matchBuilder.setLayer4Match((Layer4Match)tcpMatch.build());
        } else if (udpMatch != null) {
            matchBuilder.setLayer4Match((Layer4Match)udpMatch.build());
        } else if (sctpMatch != null) {
            matchBuilder.setLayer4Match((Layer4Match)sctpMatch.build());
        }
        if (icmpv4Match != null) {
            matchBuilder.setIcmpv4Match(icmpv4Match.build());
        } else if (icmpv6Match != null) {
            matchBuilder.setIcmpv6Match(icmpv6Match.build());
        }
        if (ipv4Match != null) {
            matchBuilder.setLayer3Match((Layer3Match)ipv4Match.build());
        } else if (arpMatch != null) {
            matchBuilder.setLayer3Match((Layer3Match)arpMatch.build());
        } else if (ipv6Match != null) {
            matchBuilder.setLayer3Match((Layer3Match)ipv6Match.build());
        }
        if (protocolMatchFields != null) {
            matchBuilder.setProtocolMatchFields(protocolMatchFields.build());
        }
        return matchBuilder.build();
    }

    private int fillBitMaskFromMap(Map<Integer, Boolean> booleanMap) {
        int bitmask = 0;
        for (Map.Entry<Integer, Boolean> iterator : booleanMap.entrySet()) {
            if (iterator.getValue() == null || !iterator.getValue().booleanValue()) continue;
            bitmask |= 1 << iterator.getKey();
        }
        return bitmask;
    }

    private Ipv4Prefix toIpv4Prefix(MatchEntries entry) {
        String ipv4Prefix = ((Ipv4AddressMatchEntry)entry.getAugmentation(Ipv4AddressMatchEntry.class)).getIpv4Address().toString();
        if (entry.isHasMask().booleanValue()) {
            byte[] mask = ((MaskMatchEntry)entry.getAugmentation(MaskMatchEntry.class)).getMask();
            ipv4Prefix = ipv4Prefix + PREFIX_SEPARATOR + this.countBits(mask);
        }
        return new Ipv4Prefix(ipv4Prefix);
    }

    private Ipv6Prefix toIpv6Prefix(MatchEntries entry) {
        String ipv6Prefix = ((Ipv6AddressMatchEntry)entry.getAugmentation(Ipv6AddressMatchEntry.class)).getIpv6Address().toString();
        if (entry.isHasMask().booleanValue()) {
            byte[] mask = ((MaskMatchEntry)entry.getAugmentation(MaskMatchEntry.class)).getMask();
            ipv6Prefix = ipv6Prefix + PREFIX_SEPARATOR + this.countBits(mask);
        }
        return new Ipv6Prefix(ipv6Prefix);
    }

    private int toInt(byte b) {
        return b < 0 ? b + 256 : b;
    }

    private int countBits(byte[] mask) {
        int netmask = 0;
        for (byte b : mask) {
            netmask += Integer.bitCount(this.toInt(b));
        }
        return netmask;
    }
}

