/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.translator;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opendaylight.openflowplugin.openflow.md.core.IMDMessageTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.SwitchConnectionDistinguisher;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionContext;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeExperimenterErrorNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeExperimenterErrorNotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimenterTranslator
implements IMDMessageTranslator<OfHeader, List<DataObject>> {
    protected static final Logger LOG = LoggerFactory.getLogger(ExperimenterTranslator.class);

    @Override
    public List<DataObject> translate(SwitchConnectionDistinguisher cookie, SessionContext sc, OfHeader msg) {
        if (msg instanceof ExperimenterMessage) {
            ExperimenterMessage message = (ExperimenterMessage)msg;
            CopyOnWriteArrayList<DataObject> list = new CopyOnWriteArrayList<DataObject>();
            LOG.error(" Experimenter Error Message received: Exp type={}, Exp Id={}, data={} ", new Object[]{message.getExpType(), message.getExperimenter(), new String(message.getData())});
            NodeExperimenterErrorNotificationBuilder nodeErrBuilder = new NodeExperimenterErrorNotificationBuilder();
            nodeErrBuilder.setTransactionId(new TransactionId(BigInteger.valueOf(message.getXid())));
            nodeErrBuilder.setType(ErrorType.Experimenter);
            nodeErrBuilder.setExpType(Integer.valueOf(message.getExpType().intValue()));
            nodeErrBuilder.setExperimenterId(message.getExperimenter());
            nodeErrBuilder.setData(new String(message.getData()));
            NodeExperimenterErrorNotification nodeExpErrorEvent = nodeErrBuilder.build();
            list.add((DataObject)nodeExpErrorEvent);
            return list;
        }
        LOG.error("Message is not of Experimenter Error Message ");
        return Collections.emptyList();
    }
}

