/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.translator;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opendaylight.openflowplugin.openflow.md.core.IMDMessageTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.SwitchConnectionDistinguisher;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionContext;
import org.opendaylight.openflowplugin.openflow.md.util.ByteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeErrorNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeErrorNotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorTranslator
implements IMDMessageTranslator<OfHeader, List<DataObject>> {
    protected static final Logger LOG = LoggerFactory.getLogger(ErrorTranslator.class);

    @Override
    public List<DataObject> translate(SwitchConnectionDistinguisher cookie, SessionContext sc, OfHeader msg) {
        if (msg instanceof ErrorMessage) {
            ErrorMessage message = (ErrorMessage)msg;
            CopyOnWriteArrayList<DataObject> list = new CopyOnWriteArrayList<DataObject>();
            LOG.debug(" Error Message received: type={}[{}], code={}[{}], data=[{}] ", new Object[]{message.getType(), message.getTypeString(), message.getCode(), message.getCodeString(), ByteUtil.bytesToHexstring(message.getData(), " ")});
            NodeErrorNotificationBuilder nodeErrBuilder = new NodeErrorNotificationBuilder();
            nodeErrBuilder.setTransactionId(new TransactionId(BigInteger.valueOf(message.getXid())));
            nodeErrBuilder.setType(ErrorType.forValue((int)message.getType()));
            nodeErrBuilder.setCode(message.getCode());
            nodeErrBuilder.setData(new String(message.getData()));
            NodeErrorNotification nodeErrorEvent = nodeErrBuilder.build();
            list.add((DataObject)nodeErrorEvent);
            return list;
        }
        LOG.error("Message is not of Error Message ");
        return Collections.emptyList();
    }
}

