/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.session;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.opendaylight.openflowplugin.openflow.md.core.SwitchConnectionDistinguisher;

public class SwitchSessionKeyOFImpl
implements SwitchConnectionDistinguisher {
    protected byte[] encodedId;
    private BigInteger datapathId;

    public SwitchSessionKeyOFImpl() {
    }

    public SwitchSessionKeyOFImpl(byte[] encodedId) {
        this.encodedId = encodedId;
    }

    @Override
    public byte[] getId() {
        return this.encodedId;
    }

    public void setDatapathId(BigInteger datapathId) {
        this.datapathId = datapathId;
    }

    public void initId() {
        try {
            MessageDigest medi = MessageDigest.getInstance("sha-1");
            this.extend(medi);
            this.encodedId = medi.digest();
        }
        catch (NullPointerException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("can not proceed datapathId: " + this.datapathId);
        }
    }

    protected void extend(MessageDigest medi) {
        medi.update(this.datapathId.toByteArray());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.encodedId);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwitchSessionKeyOFImpl other = (SwitchSessionKeyOFImpl)obj;
        return Arrays.equals(this.encodedId, other.encodedId);
    }
}

