/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.session;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.opendaylight.openflowplugin.openflow.md.core.ConnectionConductor;
import org.opendaylight.openflowplugin.openflow.md.core.IMDMessageTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.SwitchConnectionDistinguisher;
import org.opendaylight.openflowplugin.openflow.md.core.TranslatorKey;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionContext;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionListener;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionManager;
import org.opendaylight.openflowplugin.openflow.md.queue.PopListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManagerOFImpl
implements SessionManager {
    protected static final Logger LOG = LoggerFactory.getLogger(SessionManagerOFImpl.class);
    private static SessionManager instance;
    private ConcurrentHashMap<SwitchConnectionDistinguisher, SessionContext> sessionLot;
    private Map<TranslatorKey, Collection<IMDMessageTranslator<OfHeader, List<DataObject>>>> translatorMapping;
    private Map<Class<? extends DataObject>, Collection<PopListener<DataObject>>> popListenerMapping;
    protected final ListenerRegistry<SessionListener> sessionListeners = new ListenerRegistry();
    private NotificationProviderService notificationProviderService;
    private DataProviderService dataProviderService;
    private final SessionListener sessionNotifier = new SessionListener(){

        @Override
        public void onSessionAdded(SwitchConnectionDistinguisher sessionKey, SessionContext context) {
            for (ListenerRegistration listener : SessionManagerOFImpl.this.sessionListeners) {
                try {
                    ((SessionListener)listener.getInstance()).onSessionAdded(sessionKey, context);
                }
                catch (Exception e) {
                    LOG.error("Unhandled exeption occured while invoking onSessionAdded on listener", (Throwable)e);
                }
            }
        }

        @Override
        public void onSessionRemoved(SessionContext context) {
            for (ListenerRegistration listener : SessionManagerOFImpl.this.sessionListeners) {
                try {
                    ((SessionListener)listener.getInstance()).onSessionRemoved(context);
                }
                catch (Exception e) {
                    LOG.error("Unhandled exeption occured while invoking onSessionRemoved on listener", (Throwable)e);
                }
            }
        }
    };

    public static synchronized SessionManager getInstance() {
        if (instance == null) {
            instance = new SessionManagerOFImpl();
        }
        return instance;
    }

    private SessionManagerOFImpl() {
        this.sessionLot = new ConcurrentHashMap();
    }

    @Override
    public SessionContext getSessionContext(SwitchConnectionDistinguisher sessionKey) {
        return this.sessionLot.get(sessionKey);
    }

    @Override
    public void invalidateSessionContext(SwitchConnectionDistinguisher sessionKey) {
        SessionContext context = this.getSessionContext(sessionKey);
        if (context == null) {
            LOG.warn("context for invalidation not found");
        } else {
            for (Map.Entry<SwitchConnectionDistinguisher, ConnectionConductor> auxEntry : context.getAuxiliaryConductors()) {
                this.invalidateAuxiliary(sessionKey, auxEntry.getKey());
            }
            context.getPrimaryConductor().disconnect();
            context.setValid(false);
            this.removeSessionContext(context);
        }
    }

    private void invalidateDeadSessionContext(SessionContext sessionContext) {
        if (sessionContext == null) {
            LOG.warn("context for invalidation not found");
        } else {
            for (Map.Entry<SwitchConnectionDistinguisher, ConnectionConductor> auxEntry : sessionContext.getAuxiliaryConductors()) {
                SessionManagerOFImpl.invalidateAuxiliary(sessionContext, auxEntry.getKey(), true);
            }
            sessionContext.setValid(false);
            this.removeSessionContext(sessionContext);
        }
    }

    private void removeSessionContext(SessionContext sessionContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("removing session: {}", (Object)Arrays.toString(sessionContext.getSessionKey().getId()));
        }
        this.sessionLot.remove(sessionContext.getSessionKey(), sessionContext);
        this.sessionNotifier.onSessionRemoved(sessionContext);
    }

    @Override
    public void addSessionContext(SwitchConnectionDistinguisher sessionKey, SessionContext context) {
        this.sessionLot.put(sessionKey, context);
        this.sessionNotifier.onSessionAdded(sessionKey, context);
    }

    @Override
    public void invalidateAuxiliary(SwitchConnectionDistinguisher sessionKey, SwitchConnectionDistinguisher connectionCookie) {
        SessionContext context = this.getSessionContext(sessionKey);
        SessionManagerOFImpl.invalidateAuxiliary(context, connectionCookie, true);
    }

    private static void invalidateAuxiliary(SessionContext context, SwitchConnectionDistinguisher connectionCookie, boolean disconnect) {
        if (context == null) {
            LOG.warn("context for invalidation not found");
        } else {
            ConnectionConductor auxiliaryConductor = context.removeAuxiliaryConductor(connectionCookie);
            if (auxiliaryConductor == null) {
                LOG.warn("auxiliary conductor not found");
            } else if (disconnect) {
                auxiliaryConductor.disconnect();
            }
        }
    }

    @Override
    public void invalidateOnDisconnect(ConnectionConductor conductor) {
        if (conductor.getAuxiliaryKey() == null) {
            this.invalidateDeadSessionContext(conductor.getSessionContext());
        } else {
            SessionManagerOFImpl.invalidateAuxiliary(conductor.getSessionContext(), conductor.getAuxiliaryKey(), false);
        }
    }

    @Override
    public void setTranslatorMapping(Map<TranslatorKey, Collection<IMDMessageTranslator<OfHeader, List<DataObject>>>> translatorMapping) {
        this.translatorMapping = translatorMapping;
    }

    @Override
    public ListenerRegistration<SessionListener> registerSessionListener(SessionListener listener) {
        return this.sessionListeners.register((EventListener)listener);
    }

    @Override
    public Map<TranslatorKey, Collection<IMDMessageTranslator<OfHeader, List<DataObject>>>> getTranslatorMapping() {
        return this.translatorMapping;
    }

    @Override
    public void setNotificationProviderService(NotificationProviderService notificationProviderService) {
        this.notificationProviderService = notificationProviderService;
    }

    @Override
    public DataProviderService getDataProviderService() {
        return this.dataProviderService;
    }

    @Override
    public void setDataProviderService(DataProviderService dataServiceProvider) {
        this.dataProviderService = dataServiceProvider;
    }

    @Override
    public NotificationProviderService getNotificationProviderService() {
        return this.notificationProviderService;
    }

    @Override
    public Map<Class<? extends DataObject>, Collection<PopListener<DataObject>>> getPopListenerMapping() {
        return this.popListenerMapping;
    }

    @Override
    public void setPopListenerMapping(Map<Class<? extends DataObject>, Collection<PopListener<DataObject>>> popListenerMapping) {
        this.popListenerMapping = popListenerMapping;
    }
}

