/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.openflowplugin.openflow.md.core.ConnectionConductor;
import org.opendaylight.openflowplugin.openflow.md.core.SwitchConnectionDistinguisher;
import org.opendaylight.openflowplugin.openflow.md.core.session.IMessageDispatchService;
import org.opendaylight.openflowplugin.openflow.md.core.session.MessageDispatchServiceImpl;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionContext;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Port;

public class SessionContextOFImpl
implements SessionContext {
    private GetFeaturesOutput features;
    private ConnectionConductor primaryConductor;
    private ConcurrentHashMap<SwitchConnectionDistinguisher, ConnectionConductor> auxiliaryConductors = new ConcurrentHashMap();
    private boolean valid;
    private SwitchConnectionDistinguisher sessionKey;
    private IMessageDispatchService mdService = new MessageDispatchServiceImpl(this);
    private final AtomicLong xid = new AtomicLong();
    private final Map<Long, Port> physicalPorts = new HashMap<Long, Port>();
    private final Map<Long, Boolean> portBandwidth = new HashMap<Long, Boolean>();

    @Override
    public ConnectionConductor getPrimaryConductor() {
        return this.primaryConductor;
    }

    @Override
    public ConnectionConductor getAuxiliaryConductor(SwitchConnectionDistinguisher auxiliaryKey) {
        return this.auxiliaryConductors.get(auxiliaryKey);
    }

    @Override
    public void addAuxiliaryConductor(SwitchConnectionDistinguisher auxiliaryKey, ConnectionConductor conductor) {
        this.auxiliaryConductors.put(auxiliaryKey, conductor);
    }

    @Override
    public Set<Map.Entry<SwitchConnectionDistinguisher, ConnectionConductor>> getAuxiliaryConductors() {
        return Collections.unmodifiableSet(this.auxiliaryConductors.entrySet());
    }

    @Override
    public GetFeaturesOutput getFeatures() {
        return this.features;
    }

    public void setFeatures(GetFeaturesOutput features) {
        this.features = features;
    }

    public void setPrimaryConductor(ConnectionConductor primaryConductor) {
        this.primaryConductor = primaryConductor;
    }

    @Override
    public ConnectionConductor removeAuxiliaryConductor(SwitchConnectionDistinguisher connectionCookie) {
        return this.auxiliaryConductors.remove(connectionCookie);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setSessionKey(SwitchConnectionDistinguisher sessionKey) {
        this.sessionKey = sessionKey;
    }

    @Override
    public SwitchConnectionDistinguisher getSessionKey() {
        return this.sessionKey;
    }

    @Override
    public IMessageDispatchService getMessageDispatchService() {
        return this.mdService;
    }

    @Override
    public Long getNextXid() {
        return this.xid.incrementAndGet();
    }

    @Override
    public Map<Long, Port> getPhysicalPorts() {
        return this.physicalPorts;
    }

    @Override
    public Map<Long, Boolean> getPortsBandwidth() {
        return this.portBandwidth;
    }

    @Override
    public Set<Long> getPorts() {
        return this.physicalPorts.keySet();
    }

    @Override
    public Port getPhysicalPort(Long portNumber) {
        return this.physicalPorts.get(portNumber);
    }

    @Override
    public Boolean getPortBandwidth(Long portNumber) {
        return this.portBandwidth.get(portNumber);
    }

    @Override
    public boolean isPortEnabled(long portNumber) {
        return this.isPortEnabled(this.physicalPorts.get(portNumber));
    }

    @Override
    public boolean isPortEnabled(Port port) {
        if (port == null) {
            return false;
        }
        if (port.getConfig().isPortDown().booleanValue()) {
            return false;
        }
        if (port.getState().isLinkDown().booleanValue()) {
            return false;
        }
        return port.getState().isBlocked() == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Port> getEnabledPorts() {
        ArrayList<Port> result = new ArrayList<Port>();
        Map<Long, Port> map = this.physicalPorts;
        synchronized (map) {
            for (Port port : this.physicalPorts.values()) {
                if (!this.isPortEnabled(port)) continue;
                result.add(port);
            }
        }
        return result;
    }
}

