/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.session;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.openflowplugin.openflow.md.core.session.FeaturesV10Bandwidth;
import org.opendaylight.openflowplugin.openflow.md.core.session.FeaturesV13Bandwidth;
import org.opendaylight.openflowplugin.openflow.md.core.session.IGetBandwith;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Port;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortFeaturesUtil {
    private static PortFeaturesUtil instance = new PortFeaturesUtil();
    private final Map<Short, IGetBandwith> portVersionBandwidth = new HashMap<Short, IGetBandwith>();
    protected static final Logger LOG = LoggerFactory.getLogger(PortFeaturesUtil.class);

    private PortFeaturesUtil() {
        this.portVersionBandwidth.put((short)1, FeaturesV10Bandwidth.getInstance());
        this.portVersionBandwidth.put((short)4, FeaturesV13Bandwidth.getInstance());
    }

    public static PortFeaturesUtil getInstance() {
        return instance;
    }

    public Boolean getPortBandwidth(PortStatus msg) {
        if (this.portVersionBandwidth.containsKey(msg.getVersion())) {
            try {
                return this.portVersionBandwidth.get(msg.getVersion()).getBandwidth((Port)msg);
            }
            catch (NullPointerException e) {
                LOG.error("error while getting port features {}", (Throwable)e);
            }
        } else {
            LOG.warn("unknown port version: {}", (Object)msg.getVersion());
        }
        return null;
    }
}

