/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.session;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opendaylight.openflowplugin.openflow.md.core.ConnectionConductor;
import org.opendaylight.openflowplugin.openflow.md.core.IMDMessageTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.SwitchConnectionDistinguisher;
import org.opendaylight.openflowplugin.openflow.md.core.TranslatorKey;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionContext;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionContextOFImpl;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionManager;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionManagerOFImpl;
import org.opendaylight.openflowplugin.openflow.md.core.session.SwitchConnectionCookieOFImpl;
import org.opendaylight.openflowplugin.openflow.md.core.session.SwitchSessionKeyOFImpl;
import org.opendaylight.openflowplugin.openflow.md.queue.PopListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OFSessionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OFSessionUtil.class);

    public static void registerSession(ConnectionConductor connectionConductor, GetFeaturesOutput features, short version) {
        SwitchConnectionDistinguisher sessionKey = OFSessionUtil.createSwitchSessionKey(features.getDatapathId());
        SessionContext sessionContext = OFSessionUtil.getSessionManager().getSessionContext(sessionKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug("registering sessionKey: {}", (Object)Arrays.toString(sessionKey.getId()));
        }
        if (features.getAuxiliaryId() == null || features.getAuxiliaryId() == 0) {
            if (sessionContext != null) {
                LOG.warn("duplicate datapathId occured while registering new switch session: " + OFSessionUtil.dumpDataPathId(features.getDatapathId()));
                OFSessionUtil.getSessionManager().invalidateSessionContext(sessionKey);
            }
            SessionContextOFImpl context = new SessionContextOFImpl();
            context.setPrimaryConductor(connectionConductor);
            context.setFeatures(features);
            context.setSessionKey(sessionKey);
            connectionConductor.setSessionContext(context);
            context.setValid(true);
            OFSessionUtil.getSessionManager().addSessionContext(sessionKey, context);
        } else {
            if (sessionContext == null) {
                throw new IllegalStateException("unexpected auxiliary connection - primary connection missing: " + OFSessionUtil.dumpDataPathId(features.getDatapathId()));
            }
            SwitchConnectionDistinguisher auxiliaryKey = OFSessionUtil.createConnectionCookie(features);
            if (sessionContext.getAuxiliaryConductor(auxiliaryKey) != null) {
                LOG.warn("duplicate datapathId+auxiliary occured while registering switch session: " + OFSessionUtil.dumpDataPathId(features.getDatapathId()) + " | " + features.getAuxiliaryId());
                OFSessionUtil.getSessionManager().invalidateAuxiliary(sessionKey, auxiliaryKey);
            }
            sessionContext.addAuxiliaryConductor(auxiliaryKey, connectionConductor);
            connectionConductor.setSessionContext(sessionContext);
            connectionConductor.setConnectionCookie(auxiliaryKey);
        }
        SessionContext resulContext = OFSessionUtil.getSessionManager().getSessionContext(sessionKey);
        if (resulContext == null) {
            throw new IllegalStateException("session context registration failed");
        }
        if (!resulContext.isValid()) {
            throw new IllegalStateException("registered session context is invalid");
        }
    }

    public static String dumpDataPathId(BigInteger datapathId) {
        return datapathId.toString(16);
    }

    public static SwitchConnectionDistinguisher createSwitchSessionKey(BigInteger datapathId) {
        SwitchSessionKeyOFImpl key = new SwitchSessionKeyOFImpl();
        key.setDatapathId(datapathId);
        key.initId();
        return key;
    }

    public static SwitchConnectionDistinguisher createConnectionCookie(GetFeaturesOutput features) {
        return OFSessionUtil.createConnectionCookie(features.getDatapathId(), features.getAuxiliaryId());
    }

    public static SwitchConnectionDistinguisher createConnectionCookie(BigInteger datapathId, short auxiliaryId) {
        SwitchConnectionCookieOFImpl cookie = null;
        if (auxiliaryId != 0) {
            cookie = new SwitchConnectionCookieOFImpl();
            cookie.setDatapathId(datapathId);
            cookie.setAuxiliaryId(auxiliaryId);
            cookie.initId();
        }
        return cookie;
    }

    public static SessionManager getSessionManager() {
        return SessionManagerOFImpl.getInstance();
    }

    public static Map<TranslatorKey, Collection<IMDMessageTranslator<OfHeader, List<DataObject>>>> getTranslatorMap() {
        return OFSessionUtil.getSessionManager().getTranslatorMapping();
    }

    public static Map<Class<? extends DataObject>, Collection<PopListener<DataObject>>> getPopListenerMapping() {
        return OFSessionUtil.getSessionManager().getPopListenerMapping();
    }
}

