/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.session;

import com.google.common.util.concurrent.Futures;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.opendaylight.controller.sal.common.util.Rpcs;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionAdapter;
import org.opendaylight.openflowplugin.openflow.md.core.ConnectionConductor;
import org.opendaylight.openflowplugin.openflow.md.core.SwitchConnectionDistinguisher;
import org.opendaylight.openflowplugin.openflow.md.core.session.IMessageDispatchService;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionContext;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.UpdateFlowOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.UpdateFlowOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.UpdateGroupOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.UpdateGroupOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.UpdateMeterOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.UpdateMeterOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetAsyncOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.UpdatePortOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.UpdatePortOutputBuilder;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDispatchServiceImpl
implements IMessageDispatchService {
    private static final Logger LOG = LoggerFactory.getLogger(MessageDispatchServiceImpl.class);
    private SessionContext session;

    public MessageDispatchServiceImpl(SessionContext session) {
        this.session = session;
    }

    private ConnectionAdapter getConnectionAdapter(SwitchConnectionDistinguisher cookie) {
        ConnectionConductor conductor;
        if (!this.session.isValid()) {
            LOG.warn("Session for the cookie {} is invalid.", (Object)cookie);
            throw new IllegalArgumentException("Session for the cookie is invalid. Reason: the switch has been recently diconnected OR inventory provides outdated information.");
        }
        LOG.debug("finding connecton for cookie value {}. ", (Object)cookie);
        ConnectionAdapter connectionAdapter = this.session.getPrimaryConductor().getConnectionAdapter();
        if (null != cookie && null != (conductor = this.session.getAuxiliaryConductor(cookie))) {
            LOG.debug("found auxiliary connection for the cookie.");
            connectionAdapter = conductor.getConnectionAdapter();
        }
        return connectionAdapter;
    }

    @Override
    public Future<RpcResult<BarrierOutput>> barrier(BarrierInput input, SwitchConnectionDistinguisher cookie) {
        return this.getConnectionAdapter(cookie).barrier(input);
    }

    @Override
    public Future<RpcResult<Void>> experimenter(ExperimenterInput input, SwitchConnectionDistinguisher cookie) {
        return this.getConnectionAdapter(cookie).experimenter(input);
    }

    @Override
    public Future<RpcResult<UpdateFlowOutput>> flowMod(FlowModInput input, SwitchConnectionDistinguisher cookie) {
        LOG.debug("Calling OFLibrary flowMod");
        Future response = this.getConnectionAdapter(cookie).flowMod(input);
        UpdateFlowOutputBuilder flowModOutput = new UpdateFlowOutputBuilder();
        BigInteger bigIntXid = BigInteger.valueOf(input.getXid());
        flowModOutput.setTransactionId(new TransactionId(bigIntXid));
        UpdateFlowOutput result = flowModOutput.build();
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)result, errors);
        LOG.debug("Returning to ModelDrivenSwitch for flowMod RPC");
        return Futures.immediateFuture((Object)rpcResult);
    }

    @Override
    public Future<RpcResult<GetAsyncOutput>> getAsync(GetAsyncInput input, SwitchConnectionDistinguisher cookie) {
        return this.getConnectionAdapter(cookie).getAsync(input);
    }

    @Override
    public Future<RpcResult<GetConfigOutput>> getConfig(GetConfigInput input, SwitchConnectionDistinguisher cookie) {
        return this.getConnectionAdapter(cookie).getConfig(input);
    }

    @Override
    public Future<RpcResult<GetFeaturesOutput>> getFeatures(GetFeaturesInput input, SwitchConnectionDistinguisher cookie) {
        return this.getConnectionAdapter(cookie).getFeatures(input);
    }

    @Override
    public Future<RpcResult<GetQueueConfigOutput>> getQueueConfig(GetQueueConfigInput input, SwitchConnectionDistinguisher cookie) {
        return this.getConnectionAdapter(cookie).getQueueConfig(input);
    }

    @Override
    public Future<RpcResult<UpdateGroupOutput>> groupMod(GroupModInput input, SwitchConnectionDistinguisher cookie) {
        LOG.debug("Calling OFLibrary groupMod");
        Future response = this.getConnectionAdapter(cookie).groupMod(input);
        UpdateGroupOutputBuilder groupModOutput = new UpdateGroupOutputBuilder();
        BigInteger bigIntXid = BigInteger.valueOf(input.getXid());
        groupModOutput.setTransactionId(new TransactionId(bigIntXid));
        UpdateGroupOutput result = groupModOutput.build();
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)result, errors);
        LOG.debug("Returning to ModelDrivenSwitch for groupMod RPC");
        return Futures.immediateFuture((Object)rpcResult);
    }

    @Override
    public Future<RpcResult<UpdateMeterOutput>> meterMod(MeterModInput input, SwitchConnectionDistinguisher cookie) {
        LOG.debug("Calling OFLibrary meterMod");
        Future response = this.getConnectionAdapter(cookie).meterMod(input);
        UpdateMeterOutputBuilder meterModOutput = new UpdateMeterOutputBuilder();
        BigInteger bigIntXid = BigInteger.valueOf(input.getXid());
        meterModOutput.setTransactionId(new TransactionId(bigIntXid));
        UpdateMeterOutput result = meterModOutput.build();
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)result, errors);
        LOG.debug("Returning to ModelDrivenSwitch for meterMod RPC");
        return Futures.immediateFuture((Object)rpcResult);
    }

    @Override
    public Future<RpcResult<Void>> multipartRequest(MultipartRequestInput input, SwitchConnectionDistinguisher cookie) {
        return this.getConnectionAdapter(cookie).multipartRequest(input);
    }

    @Override
    public Future<RpcResult<Void>> packetOut(PacketOutInput input, SwitchConnectionDistinguisher cookie) {
        return this.getConnectionAdapter(cookie).packetOut(input);
    }

    @Override
    public Future<RpcResult<UpdatePortOutput>> portMod(PortModInput input, SwitchConnectionDistinguisher cookie) {
        LOG.debug("Calling OFLibrary portMod");
        Future response = this.getConnectionAdapter(cookie).portMod(input);
        UpdatePortOutputBuilder portModOutput = new UpdatePortOutputBuilder();
        String stringXid = input.getXid().toString();
        BigInteger bigIntXid = new BigInteger(stringXid);
        portModOutput.setTransactionId(new TransactionId(bigIntXid));
        UpdatePortOutput result = portModOutput.build();
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)result, errors);
        LOG.debug("Returning to ModelDrivenSwitch for portMod RPC");
        return Futures.immediateFuture((Object)rpcResult);
    }

    @Override
    public Future<RpcResult<RoleRequestOutput>> roleRequest(RoleRequestInput input, SwitchConnectionDistinguisher cookie) {
        return this.getConnectionAdapter(cookie).roleRequest(input);
    }

    @Override
    public Future<RpcResult<Void>> setAsync(SetAsyncInput input, SwitchConnectionDistinguisher cookie) {
        return this.getConnectionAdapter(cookie).setAsync(input);
    }

    @Override
    public Future<RpcResult<Void>> setConfig(SetConfigInput input, SwitchConnectionDistinguisher cookie) {
        return this.getConnectionAdapter(cookie).setConfig(input);
    }

    @Override
    public Future<RpcResult<Void>> tableMod(TableModInput input, SwitchConnectionDistinguisher cookie) {
        return this.getConnectionAdapter(cookie).tableMod(input);
    }
}

