/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.match;

import java.util.List;
import java.util.Map;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.FlowConvertor;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.common.Convertor;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.common.InjectionKey;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.common.ResultInjector;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.match.MatchConvertorImpl;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.match.MatchConvertorV10Impl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OxmFieldsActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.match.grouping.MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.aggregate._case.MultipartRequestAggregateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.flow._case.MultipartRequestFlowBuilder;

public class MatchReactorMappingFactory {
    public static void addMatchConvertors(Map<Short, Convertor<Match, ?>> conversionMapping) {
        conversionMapping.put((short)4, new MatchConvertorImpl());
        conversionMapping.put((short)1, new MatchConvertorV10Impl());
    }

    public static void addMatchIjectors(Map<InjectionKey, ResultInjector<?, ?>> injectionMapping) {
        injectionMapping.put(new InjectionKey(4, FlowModInputBuilder.class.getName()), new ResultInjector<List<MatchEntries>, FlowModInputBuilder>(){

            @Override
            public void inject(List<MatchEntries> value, FlowModInputBuilder target) {
                target.setMatch(MatchReactorMappingFactory.wrapMatchV13(value).build());
            }
        });
        injectionMapping.put(new InjectionKey(4, OxmFieldsActionBuilder.class.getName()), new ResultInjector<List<MatchEntries>, OxmFieldsActionBuilder>(){

            @Override
            public void inject(List<MatchEntries> value, OxmFieldsActionBuilder target) {
                target.setMatchEntries(value);
            }
        });
        injectionMapping.put(new InjectionKey(1, FlowModInputBuilder.class.getName()), new ResultInjector<MatchV10, FlowModInputBuilder>(){

            @Override
            public void inject(MatchV10 value, FlowModInputBuilder target) {
                target.setMatchV10(value);
            }
        });
        injectionMapping.put(new InjectionKey(4, MultipartRequestFlowBuilder.class.getName()), new ResultInjector<List<MatchEntries>, MultipartRequestFlowBuilder>(){

            @Override
            public void inject(List<MatchEntries> value, MultipartRequestFlowBuilder target) {
                target.setMatch(MatchReactorMappingFactory.wrapMatchV13(value).build());
            }
        });
        injectionMapping.put(new InjectionKey(1, MultipartRequestFlowBuilder.class.getName()), new ResultInjector<MatchV10, MultipartRequestFlowBuilder>(){

            @Override
            public void inject(MatchV10 value, MultipartRequestFlowBuilder target) {
                target.setMatchV10(value);
            }
        });
        injectionMapping.put(new InjectionKey(4, MultipartRequestAggregateBuilder.class.getName()), new ResultInjector<List<MatchEntries>, MultipartRequestAggregateBuilder>(){

            @Override
            public void inject(List<MatchEntries> value, MultipartRequestAggregateBuilder target) {
                target.setMatch(MatchReactorMappingFactory.wrapMatchV13(value).build());
            }
        });
        injectionMapping.put(new InjectionKey(1, MultipartRequestAggregateBuilder.class.getName()), new ResultInjector<MatchV10, MultipartRequestAggregateBuilder>(){

            @Override
            public void inject(MatchV10 value, MultipartRequestAggregateBuilder target) {
                target.setMatchV10(value);
            }
        });
    }

    public static MatchBuilder wrapMatchV13(List<MatchEntries> value) {
        MatchBuilder matchBuilder = new MatchBuilder();
        matchBuilder.setType(FlowConvertor.DEFAULT_MATCH_TYPE);
        if (value == null) {
            matchBuilder.setMatchEntries(FlowConvertor.DEFAULT_MATCH_ENTRIES);
        } else {
            matchBuilder.setMatchEntries(value);
        }
        return matchBuilder;
    }
}

