/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.match;

import java.math.BigInteger;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.match.MatchConvertor;
import org.opendaylight.openflowplugin.openflow.md.util.InventoryDataServiceUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.EthernetMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.IpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer3Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.VlanMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.TcpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.UdpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.match.v10.grouping.MatchV10Builder;

public class MatchConvertorV10Impl
implements MatchConvertor<MatchV10> {
    public static final MacAddress zeroMac = new MacAddress("00:00:00:00:00:00");
    public static final Ipv4Address zeroIPv4 = new Ipv4Address("0.0.0.0");

    @Override
    public MatchV10 convert(Match match, BigInteger datapathid) {
        Layer4Match layer4Match;
        IpMatch ipMatch;
        Layer3Match l3Match;
        NodeConnectorId inPort;
        VlanMatch vlanMatch;
        MatchV10Builder matchBuilder = new MatchV10Builder();
        boolean _dLDST = true;
        boolean _dLSRC = true;
        boolean _dLTYPE = true;
        boolean _dLVLAN = true;
        boolean _dLVLANPCP = true;
        boolean _iNPORT = true;
        boolean _nWPROTO = true;
        boolean _nWTOS = true;
        boolean _tPDST = true;
        boolean _tPSRC = true;
        matchBuilder.setInPort(Integer.valueOf(0));
        matchBuilder.setDlDst(zeroMac);
        matchBuilder.setDlSrc(zeroMac);
        matchBuilder.setDlType(Integer.valueOf(0));
        matchBuilder.setDlVlan(Integer.valueOf(0));
        matchBuilder.setDlVlanPcp(Short.valueOf((short)0));
        matchBuilder.setNwDst(zeroIPv4);
        matchBuilder.setNwDstMask(Short.valueOf((short)0));
        matchBuilder.setNwSrc(zeroIPv4);
        matchBuilder.setNwSrcMask(Short.valueOf((short)0));
        matchBuilder.setNwProto(Short.valueOf((short)0));
        matchBuilder.setNwTos(Short.valueOf((short)0));
        matchBuilder.setTpSrc(Integer.valueOf(0));
        matchBuilder.setTpDst(Integer.valueOf(0));
        EthernetMatch ethernetMatch = match.getEthernetMatch();
        if (ethernetMatch != null) {
            _dLDST = MatchConvertorV10Impl.convertEthernetDlDst(matchBuilder, ethernetMatch);
            _dLSRC = MatchConvertorV10Impl.convertEthernetDlSrc(matchBuilder, ethernetMatch);
            _dLTYPE = MatchConvertorV10Impl.convertEthernetDlType(matchBuilder, ethernetMatch);
        }
        if ((vlanMatch = match.getVlanMatch()) != null) {
            _dLVLAN = MatchConvertorV10Impl.convertDlVlan(matchBuilder, vlanMatch);
            _dLVLANPCP = MatchConvertorV10Impl.convertDlVlanPcp(matchBuilder, vlanMatch);
        }
        if ((inPort = match.getInPort()) != null) {
            _iNPORT = MatchConvertorV10Impl.convertInPortMatch(matchBuilder, inPort);
        }
        if ((l3Match = match.getLayer3Match()) != null && l3Match instanceof Ipv4Match) {
            Ipv4Match ipv4 = (Ipv4Match)l3Match;
            _tPSRC = MatchConvertorV10Impl.convertL3Ipv4SrcMatch(matchBuilder, ipv4);
            _tPDST = MatchConvertorV10Impl.convertL3Ipv4DstMatch(matchBuilder, ipv4);
        }
        if ((ipMatch = match.getIpMatch()) != null) {
            _nWPROTO = MatchConvertorV10Impl.convertNwProto(matchBuilder, ipMatch);
            _nWTOS = MatchConvertorV10Impl.convertNwTos(matchBuilder, ipMatch);
        }
        if ((layer4Match = match.getLayer4Match()) != null) {
            if (layer4Match instanceof TcpMatch) {
                TcpMatch tcpMatch = (TcpMatch)layer4Match;
                _tPSRC = MatchConvertorV10Impl.convertL4TpSrcMatch(matchBuilder, tcpMatch);
                _tPDST = MatchConvertorV10Impl.convertL4TpDstMatch(matchBuilder, tcpMatch);
            } else if (layer4Match instanceof UdpMatch) {
                UdpMatch udpMatch = (UdpMatch)layer4Match;
                _tPSRC = MatchConvertorV10Impl.convertL4UdpSrcMatch(matchBuilder, udpMatch);
                _tPDST = MatchConvertorV10Impl.convertL4UdpDstMatch(matchBuilder, udpMatch);
            }
        }
        FlowWildcardsV10 wildCards = new FlowWildcardsV10(Boolean.valueOf(_dLDST), Boolean.valueOf(_dLSRC), Boolean.valueOf(_dLTYPE), Boolean.valueOf(_dLVLAN), Boolean.valueOf(_dLVLANPCP), Boolean.valueOf(_iNPORT), Boolean.valueOf(_nWPROTO), Boolean.valueOf(_nWTOS), Boolean.valueOf(_tPDST), Boolean.valueOf(_tPSRC));
        matchBuilder.setWildcards(wildCards);
        return matchBuilder.build();
    }

    private static boolean convertL4UdpDstMatch(MatchV10Builder matchBuilder, UdpMatch udpMatch) {
        if (udpMatch.getUdpDestinationPort() != null) {
            matchBuilder.setTpDst(udpMatch.getUdpDestinationPort().getValue());
            return false;
        }
        return true;
    }

    private static boolean convertL4UdpSrcMatch(MatchV10Builder matchBuilder, UdpMatch udpMatch) {
        if (udpMatch.getUdpSourcePort() != null) {
            matchBuilder.setTpSrc(udpMatch.getUdpSourcePort().getValue());
            return false;
        }
        return true;
    }

    private static boolean convertL4TpDstMatch(MatchV10Builder matchBuilder, TcpMatch tcpMatch) {
        if (tcpMatch.getTcpDestinationPort() != null) {
            matchBuilder.setTpDst(tcpMatch.getTcpDestinationPort().getValue());
            return false;
        }
        return true;
    }

    private static boolean convertL4TpSrcMatch(MatchV10Builder matchBuilder, TcpMatch tcpMatch) {
        if (tcpMatch.getTcpSourcePort() != null) {
            matchBuilder.setTpSrc(tcpMatch.getTcpSourcePort().getValue());
            return false;
        }
        return true;
    }

    private static boolean convertNwTos(MatchV10Builder matchBuilder, IpMatch ipMatch) {
        if (ipMatch.getIpDscp() != null) {
            matchBuilder.setNwTos(ipMatch.getIpDscp().getValue());
            return false;
        }
        return true;
    }

    private static boolean convertNwProto(MatchV10Builder matchBuilder, IpMatch ipMatch) {
        if (ipMatch.getIpProtocol() != null) {
            matchBuilder.setNwProto(ipMatch.getIpProtocol());
            return false;
        }
        return true;
    }

    private static boolean convertL3Ipv4DstMatch(MatchV10Builder matchBuilder, Ipv4Match ipv4) {
        if (ipv4.getIpv4Destination() != null) {
            String[] addressParts = ipv4.getIpv4Destination().getValue().split("/");
            Integer prefix = MatchConvertorV10Impl.buildPrefix(addressParts);
            Ipv4Address ipv4Address = new Ipv4Address(addressParts[0]);
            matchBuilder.setNwDst(ipv4Address);
            matchBuilder.setNwDstMask(Short.valueOf(prefix.shortValue()));
            return false;
        }
        return true;
    }

    private static boolean convertL3Ipv4SrcMatch(MatchV10Builder matchBuilder, Ipv4Match ipv4) {
        if (ipv4.getIpv4Source() != null) {
            String[] addressParts = ipv4.getIpv4Source().getValue().split("/");
            Ipv4Address ipv4Address = new Ipv4Address(addressParts[0]);
            int prefix = MatchConvertorV10Impl.buildPrefix(addressParts);
            matchBuilder.setNwSrc(ipv4Address);
            matchBuilder.setNwSrcMask(Short.valueOf((short)prefix));
            return false;
        }
        return true;
    }

    private static int buildPrefix(String[] addressParts) {
        int prefix = 32;
        if (addressParts.length > 1) {
            prefix = Integer.parseInt(addressParts[1]);
        }
        return prefix;
    }

    private static boolean convertDlVlanPcp(MatchV10Builder matchBuilder, VlanMatch vlanMatch) {
        if (vlanMatch.getVlanPcp() != null) {
            matchBuilder.setDlVlanPcp(vlanMatch.getVlanPcp().getValue());
            return false;
        }
        return true;
    }

    private static boolean convertDlVlan(MatchV10Builder matchBuilder, VlanMatch vlanMatch) {
        if (vlanMatch.getVlanId() != null) {
            matchBuilder.setDlVlan(vlanMatch.getVlanId().getVlanId().getValue());
            return false;
        }
        return true;
    }

    private static boolean convertEthernetDlType(MatchV10Builder matchBuilder, EthernetMatch ethernetMatch) {
        if (ethernetMatch.getEthernetType() != null) {
            matchBuilder.setDlType(Integer.valueOf(ethernetMatch.getEthernetType().getType().getValue().intValue()));
            return false;
        }
        return true;
    }

    private static boolean convertEthernetDlSrc(MatchV10Builder matchBuilder, EthernetMatch ethernetMatch) {
        if (ethernetMatch.getEthernetSource() != null) {
            matchBuilder.setDlSrc(ethernetMatch.getEthernetSource().getAddress());
            return false;
        }
        return true;
    }

    private static boolean convertEthernetDlDst(MatchV10Builder matchBuilder, EthernetMatch ethernetMatch) {
        if (ethernetMatch.getEthernetDestination() != null) {
            matchBuilder.setDlDst(ethernetMatch.getEthernetDestination().getAddress());
            return false;
        }
        return true;
    }

    private static boolean convertInPortMatch(MatchV10Builder matchBuilder, NodeConnectorId inPort) {
        if (inPort != null) {
            matchBuilder.setInPort(Integer.valueOf(InventoryDataServiceUtil.portNumberfromNodeConnectorId(inPort).intValue()));
            return false;
        }
        return true;
    }
}

