/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.match;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.match.MatchConvertor;
import org.opendaylight.openflowplugin.openflow.md.util.ByteUtil;
import org.opendaylight.openflowplugin.openflow.md.util.InventoryDataServiceUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Dscp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6FlowLabel;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.field._case.SetField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.field._case.SetFieldBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.arp.match.fields.ArpSourceHardwareAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.arp.match.fields.ArpSourceHardwareAddressBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.arp.match.fields.ArpTargetHardwareAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.arp.match.fields.ArpTargetHardwareAddressBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetDestination;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetDestinationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetSource;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetSourceBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ipv6.match.fields.Ipv6ExtHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ipv6.match.fields.Ipv6ExtHeaderBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ipv6.match.fields.Ipv6Label;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ipv6.match.fields.Ipv6LabelBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.EthernetMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.EthernetMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Icmpv4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Icmpv4MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Icmpv6Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Icmpv6MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.IpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.IpMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer3Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.MetadataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.ProtocolMatchFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.ProtocolMatchFieldsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Tunnel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.TunnelBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.VlanMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.VlanMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.ArpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.ArpMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv4MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv6Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv6MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.SctpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.SctpMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.TcpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.TcpMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.UdpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._4.match.UdpMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.protocol.match.fields.Pbb;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.protocol.match.fields.PbbBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.vlan.match.fields.VlanId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.vlan.match.fields.VlanIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.BosMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.BosMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.DscpMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.DscpMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EcnMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EcnMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EthTypeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EthTypeMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv4CodeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv4CodeMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv4TypeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv4TypeMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv6CodeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv6CodeMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv6TypeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv6TypeMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv4AddressMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv4AddressMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv6AddressMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv6AddressMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv6FlabelMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv6FlabelMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.IsidMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.IsidMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MacAddressMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MacAddressMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaskMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaskMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MetadataMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MetadataMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MplsLabelMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MplsLabelMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OpCodeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OpCodeMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortNumberMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortNumberMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ProtocolNumberMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ProtocolNumberMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PseudoFieldMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PseudoFieldMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.TcMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.TcMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanPcpMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanPcpMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanVidMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanVidMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.actions.list.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.EtherType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Ipv6ExthdrFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpOp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpSha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpSpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpTha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpTpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv4Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv4Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv6Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv6Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.InPhyPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.InPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.IpDscp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.IpEcn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.IpProto;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv4Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv4Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Exthdr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Flabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6NdSll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6NdTarget;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6NdTll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Metadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MplsBos;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MplsLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MplsTc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.PbbIsid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.SctpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.SctpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.TcpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.TcpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.TunnelId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.UdpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.UdpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.VlanPcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.VlanVid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntriesBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchConvertorImpl
implements MatchConvertor<List<MatchEntries>> {
    private static final Logger logger = LoggerFactory.getLogger(MatchConvertorImpl.class);
    static final String PREFIX_SEPARATOR = "/";
    private static final byte[] VLAN_VID_MASK = new byte[]{16, 0};
    private static final short PROTO_TCP = 6;
    private static final short PROTO_UDP = 17;
    private static final String noIp = "0.0.0.0/0";

    @Override
    public List<MatchEntries> convert(org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match match, BigInteger datapathid) {
        Tunnel tunnel;
        ProtocolMatchFields protocolMatchFields;
        Layer3Match layer3Match;
        Icmpv6Match icmpv6Match;
        Icmpv4Match icmpv4Match;
        Layer4Match layer4Match;
        IpMatch ipMatch;
        VlanMatch vlanMatch;
        EthernetMatch ethernetMatch;
        org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Metadata metadata;
        ArrayList<MatchEntries> matchEntriesList = new ArrayList<MatchEntries>();
        if (match.getInPort() != null) {
            matchEntriesList.add(MatchConvertorImpl.toOfPort(InPort.class, InventoryDataServiceUtil.portNumberfromNodeConnectorId(match.getInPort())));
        }
        if (match.getInPhyPort() != null) {
            matchEntriesList.add(MatchConvertorImpl.toOfPort(InPhyPort.class, InventoryDataServiceUtil.portNumberfromNodeConnectorId(match.getInPhyPort())));
        }
        if ((metadata = match.getMetadata()) != null) {
            matchEntriesList.add(MatchConvertorImpl.toOfMetadata(Metadata.class, metadata.getMetadata(), metadata.getMetadataMask()));
        }
        if ((ethernetMatch = match.getEthernetMatch()) != null) {
            EthernetSource ethernetSource;
            EthernetDestination ethernetDestination = ethernetMatch.getEthernetDestination();
            if (ethernetDestination != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfMacAddress(EthDst.class, ethernetDestination.getAddress(), ethernetDestination.getMask()));
            }
            if ((ethernetSource = ethernetMatch.getEthernetSource()) != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfMacAddress(EthSrc.class, ethernetSource.getAddress(), ethernetSource.getMask()));
            }
            if (ethernetMatch.getEthernetType() != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfEthernetType(ethernetMatch.getEthernetType()));
            }
        }
        if ((vlanMatch = match.getVlanMatch()) != null) {
            if (vlanMatch.getVlanId() != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfVlanVid(vlanMatch.getVlanId()));
            }
            if (vlanMatch.getVlanPcp() != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfVlanPcp(vlanMatch.getVlanPcp()));
            }
        }
        if ((ipMatch = match.getIpMatch()) != null) {
            if (ipMatch.getIpDscp() != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfIpDscp(ipMatch.getIpDscp()));
            }
            if (ipMatch.getIpEcn() != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfIpEcn(ipMatch.getIpEcn()));
            }
            if (ipMatch.getIpProtocol() != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfIpProto(ipMatch.getIpProtocol()));
            }
        }
        if ((layer4Match = match.getLayer4Match()) != null) {
            if (layer4Match instanceof TcpMatch) {
                TcpMatch tcpMatch = (TcpMatch)layer4Match;
                if (tcpMatch.getTcpSourcePort() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfLayer3Port(TcpSrc.class, tcpMatch.getTcpSourcePort()));
                }
                if (tcpMatch.getTcpDestinationPort() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfLayer3Port(TcpDst.class, tcpMatch.getTcpDestinationPort()));
                }
            } else if (layer4Match instanceof UdpMatch) {
                UdpMatch udpMatch = (UdpMatch)layer4Match;
                if (udpMatch.getUdpSourcePort() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfLayer3Port(UdpSrc.class, udpMatch.getUdpSourcePort()));
                }
                if (udpMatch.getUdpDestinationPort() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfLayer3Port(UdpDst.class, udpMatch.getUdpDestinationPort()));
                }
            } else if (layer4Match instanceof SctpMatch) {
                SctpMatch sctpMatch = (SctpMatch)layer4Match;
                if (sctpMatch.getSctpSourcePort() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfLayer3Port(SctpSrc.class, sctpMatch.getSctpSourcePort()));
                }
                if (sctpMatch.getSctpDestinationPort() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfLayer3Port(SctpDst.class, sctpMatch.getSctpDestinationPort()));
                }
            }
        }
        if ((icmpv4Match = match.getIcmpv4Match()) != null) {
            if (icmpv4Match.getIcmpv4Type() != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfIcmpv4Type(icmpv4Match.getIcmpv4Type()));
            }
            if (icmpv4Match.getIcmpv4Code() != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfIcmpv4Code(icmpv4Match.getIcmpv4Code()));
            }
        }
        if ((icmpv6Match = match.getIcmpv6Match()) != null) {
            if (icmpv6Match.getIcmpv6Type() != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfIcmpv6Type(icmpv6Match.getIcmpv6Type()));
            }
            if (icmpv6Match.getIcmpv6Code() != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfIcmpv6Code(icmpv6Match.getIcmpv6Code()));
            }
        }
        if ((layer3Match = match.getLayer3Match()) != null) {
            if (layer3Match instanceof Ipv4Match) {
                Ipv4Match ipv4Match = (Ipv4Match)layer3Match;
                if (ipv4Match.getIpv4Source() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfIpv4Prefix(Ipv4Src.class, ipv4Match.getIpv4Source()));
                }
                if (ipv4Match.getIpv4Destination() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfIpv4Prefix(Ipv4Dst.class, ipv4Match.getIpv4Destination()));
                }
            } else if (layer3Match instanceof ArpMatch) {
                ArpTargetHardwareAddress arpTargetHardwareAddress;
                ArpSourceHardwareAddress arpSourceHardwareAddress;
                ArpMatch arpMatch = (ArpMatch)layer3Match;
                if (arpMatch.getArpOp() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfArpOpCode(arpMatch.getArpOp()));
                }
                if (arpMatch.getArpSourceTransportAddress() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfIpv4Prefix(ArpSpa.class, arpMatch.getArpSourceTransportAddress()));
                }
                if (arpMatch.getArpTargetTransportAddress() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfIpv4Prefix(ArpTpa.class, arpMatch.getArpTargetTransportAddress()));
                }
                if ((arpSourceHardwareAddress = arpMatch.getArpSourceHardwareAddress()) != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfMacAddress(ArpSha.class, arpSourceHardwareAddress.getAddress(), arpSourceHardwareAddress.getMask()));
                }
                if ((arpTargetHardwareAddress = arpMatch.getArpTargetHardwareAddress()) != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfMacAddress(ArpTha.class, arpTargetHardwareAddress.getAddress(), arpTargetHardwareAddress.getMask()));
                }
            } else if (layer3Match instanceof Ipv6Match) {
                Ipv6Match ipv6Match = (Ipv6Match)layer3Match;
                if (ipv6Match.getIpv6Source() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfIpv6Prefix(Ipv6Src.class, ipv6Match.getIpv6Source()));
                }
                if (ipv6Match.getIpv6Destination() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfIpv6Prefix(Ipv6Dst.class, ipv6Match.getIpv6Destination()));
                }
                if (ipv6Match.getIpv6Label() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfIpv6FlowLabel(ipv6Match.getIpv6Label()));
                }
                if (ipv6Match.getIpv6NdTarget() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfIpv6Address(ipv6Match.getIpv6NdTarget()));
                }
                if (ipv6Match.getIpv6NdSll() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfMacAddress(Ipv6NdSll.class, ipv6Match.getIpv6NdSll(), null));
                }
                if (ipv6Match.getIpv6NdTll() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfMacAddress(Ipv6NdTll.class, ipv6Match.getIpv6NdTll(), null));
                }
                if (ipv6Match.getIpv6ExtHeader() != null) {
                    matchEntriesList.add(MatchConvertorImpl.toOfIpv6ExtHeader(ipv6Match.getIpv6ExtHeader()));
                }
            }
        }
        if ((protocolMatchFields = match.getProtocolMatchFields()) != null) {
            if (protocolMatchFields.getMplsLabel() != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfMplsLabel(protocolMatchFields.getMplsLabel()));
            }
            if (protocolMatchFields.getMplsBos() != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfMplsBos(protocolMatchFields.getMplsBos()));
            }
            if (protocolMatchFields.getMplsTc() != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfMplsTc(protocolMatchFields.getMplsTc()));
            }
            if (protocolMatchFields.getPbb() != null) {
                matchEntriesList.add(MatchConvertorImpl.toOfMplsPbb(protocolMatchFields.getPbb()));
            }
        }
        if ((tunnel = match.getTunnel()) != null) {
            matchEntriesList.add(MatchConvertorImpl.toOfMetadata(TunnelId.class, tunnel.getTunnelId(), tunnel.getTunnelMask()));
        }
        return matchEntriesList;
    }

    public static Match fromOFMatchV10ToSALMatch(MatchV10 swMatch, BigInteger datapathid) {
        String ipv4PrefixStr;
        MatchBuilder matchBuilder = new MatchBuilder();
        EthernetMatchBuilder ethMatchBuilder = new EthernetMatchBuilder();
        VlanMatchBuilder vlanMatchBuilder = new VlanMatchBuilder();
        Ipv4MatchBuilder ipv4MatchBuilder = new Ipv4MatchBuilder();
        IpMatchBuilder ipMatchBuilder = new IpMatchBuilder();
        if (!swMatch.getWildcards().isINPORT().booleanValue() && swMatch.getInPort() != null) {
            matchBuilder.setInPort(InventoryDataServiceUtil.nodeConnectorIdfromDatapathPortNo(datapathid, (long)swMatch.getInPort()));
        }
        if (!swMatch.getWildcards().isDLSRC().booleanValue() && swMatch.getDlSrc() != null) {
            EthernetSourceBuilder ethSrcBuilder = new EthernetSourceBuilder();
            ethSrcBuilder.setAddress(swMatch.getDlSrc());
            ethMatchBuilder.setEthernetSource(ethSrcBuilder.build());
            matchBuilder.setEthernetMatch(ethMatchBuilder.build());
        }
        if (!swMatch.getWildcards().isDLDST().booleanValue() && swMatch.getDlDst() != null) {
            EthernetDestinationBuilder ethDstBuilder = new EthernetDestinationBuilder();
            ethDstBuilder.setAddress(swMatch.getDlDst());
            ethMatchBuilder.setEthernetDestination(ethDstBuilder.build());
            matchBuilder.setEthernetMatch(ethMatchBuilder.build());
        }
        if (!swMatch.getWildcards().isDLTYPE().booleanValue() && swMatch.getDlType() != null) {
            EthernetTypeBuilder ethTypeBuilder = new EthernetTypeBuilder();
            ethTypeBuilder.setType(new org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.EtherType(Long.valueOf(swMatch.getDlType().intValue())));
            ethMatchBuilder.setEthernetType(ethTypeBuilder.build());
            matchBuilder.setEthernetMatch(ethMatchBuilder.build());
        }
        if (!swMatch.getWildcards().isDLVLAN().booleanValue() && swMatch.getDlVlan() != null) {
            VlanIdBuilder vlanIdBuilder = new VlanIdBuilder();
            vlanIdBuilder.setVlanId(new org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanId(swMatch.getDlVlan()));
            vlanMatchBuilder.setVlanId(vlanIdBuilder.build());
            matchBuilder.setVlanMatch(vlanMatchBuilder.build());
        }
        if (!swMatch.getWildcards().isDLVLANPCP().booleanValue() && swMatch.getDlVlanPcp() != null) {
            vlanMatchBuilder.setVlanPcp(new org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanPcp(swMatch.getDlVlanPcp()));
            matchBuilder.setVlanMatch(vlanMatchBuilder.build());
        }
        if (!swMatch.getWildcards().isDLTYPE().booleanValue() && swMatch.getNwSrc() != null) {
            ipv4PrefixStr = swMatch.getNwSrc().getValue();
            if (swMatch.getNwSrcMask() != null) {
                ipv4PrefixStr = ipv4PrefixStr + PREFIX_SEPARATOR + swMatch.getNwSrcMask();
            }
            if (!ipv4PrefixStr.equals(noIp)) {
                ipv4MatchBuilder.setIpv4Source(new Ipv4Prefix(ipv4PrefixStr));
                matchBuilder.setLayer3Match((Layer3Match)ipv4MatchBuilder.build());
            }
        }
        if (!swMatch.getWildcards().isDLTYPE().booleanValue() && swMatch.getNwDst() != null) {
            ipv4PrefixStr = swMatch.getNwDst().getValue();
            if (swMatch.getNwDstMask() != null) {
                ipv4PrefixStr = ipv4PrefixStr + PREFIX_SEPARATOR + swMatch.getNwDstMask();
            }
            if (!ipv4PrefixStr.equals(noIp)) {
                ipv4MatchBuilder.setIpv4Destination(new Ipv4Prefix(ipv4PrefixStr));
                matchBuilder.setLayer3Match((Layer3Match)ipv4MatchBuilder.build());
            }
        }
        if (!swMatch.getWildcards().isNWPROTO().booleanValue() && swMatch.getNwProto() != null) {
            ipMatchBuilder.setIpProtocol(swMatch.getNwProto());
            matchBuilder.setIpMatch(ipMatchBuilder.build());
        }
        if (!swMatch.getWildcards().isNWPROTO().booleanValue() && swMatch.getNwProto() == 6) {
            TcpMatchBuilder tcpMatchBuilder = new TcpMatchBuilder();
            if (!swMatch.getWildcards().isTPSRC().booleanValue() && swMatch.getTpSrc() != null) {
                tcpMatchBuilder.setTcpSourcePort(new PortNumber(swMatch.getTpSrc()));
            }
            if (!swMatch.getWildcards().isTPDST().booleanValue() && swMatch.getTpDst() != null) {
                tcpMatchBuilder.setTcpDestinationPort(new PortNumber(swMatch.getTpDst()));
            }
            if (!swMatch.getWildcards().isTPSRC().booleanValue() || !swMatch.getWildcards().isTPDST().booleanValue()) {
                matchBuilder.setLayer4Match((Layer4Match)tcpMatchBuilder.build());
            }
        }
        if (!swMatch.getWildcards().isNWPROTO().booleanValue() && swMatch.getNwProto() == 17) {
            UdpMatchBuilder udpMatchBuilder = new UdpMatchBuilder();
            if (!swMatch.getWildcards().isTPSRC().booleanValue() && swMatch.getTpSrc() != null) {
                udpMatchBuilder.setUdpSourcePort(new PortNumber(swMatch.getTpSrc()));
            }
            if (!swMatch.getWildcards().isTPDST().booleanValue() && swMatch.getTpDst() != null) {
                udpMatchBuilder.setUdpDestinationPort(new PortNumber(swMatch.getTpDst()));
            }
            if (!swMatch.getWildcards().isTPSRC().booleanValue() || !swMatch.getWildcards().isTPDST().booleanValue()) {
                matchBuilder.setLayer4Match((Layer4Match)udpMatchBuilder.build());
            }
        }
        if (!swMatch.getWildcards().isNWTOS().booleanValue() && swMatch.getNwTos() != null) {
            if (0 != swMatch.getNwTos()) {
                ipMatchBuilder.setIpDscp(new Dscp(swMatch.getNwTos()));
            }
            matchBuilder.setIpMatch(ipMatchBuilder.build());
        }
        return matchBuilder.build();
    }

    public static Match fromOFMatchToSALMatch(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.match.grouping.Match swMatch, BigInteger datapathid) {
        MatchBuilder matchBuilder = new MatchBuilder();
        EthernetMatchBuilder ethMatchBuilder = new EthernetMatchBuilder();
        VlanMatchBuilder vlanMatchBuilder = new VlanMatchBuilder();
        IpMatchBuilder ipMatchBuilder = new IpMatchBuilder();
        TcpMatchBuilder tcpMatchBuilder = new TcpMatchBuilder();
        UdpMatchBuilder udpMatchBuilder = new UdpMatchBuilder();
        SctpMatchBuilder sctpMatchBuilder = new SctpMatchBuilder();
        Icmpv4MatchBuilder icmpv4MatchBuilder = new Icmpv4MatchBuilder();
        Icmpv6MatchBuilder icmpv6MatchBuilder = new Icmpv6MatchBuilder();
        Ipv4MatchBuilder ipv4MatchBuilder = new Ipv4MatchBuilder();
        ArpMatchBuilder arpMatchBuilder = new ArpMatchBuilder();
        Ipv6MatchBuilder ipv6MatchBuilder = new Ipv6MatchBuilder();
        ProtocolMatchFieldsBuilder protocolMatchFieldsBuilder = new ProtocolMatchFieldsBuilder();
        List swMatchList = swMatch.getMatchEntries();
        for (MatchEntries ofMatch : swMatchList) {
            Ipv6AddressMatchEntry ipv6AddressMatchEntry;
            String ipv4PrefixStr;
            Ipv4AddressMatchEntry ipv4AddressMatchEntry;
            PortMatchEntry portMatchEntry;
            MacAddressMatchEntry macAddressMatchEntry;
            MaskMatchEntry maskMatchEntry;
            MetadataMatchEntry metadataMatchEntry;
            PortNumberMatchEntry portNumber;
            if (ofMatch.getOxmMatchField().equals(InPort.class)) {
                portNumber = (PortNumberMatchEntry)ofMatch.getAugmentation(PortNumberMatchEntry.class);
                matchBuilder.setInPort(InventoryDataServiceUtil.nodeConnectorIdfromDatapathPortNo(datapathid, portNumber.getPortNumber().getValue()));
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(InPhyPort.class)) {
                portNumber = (PortNumberMatchEntry)ofMatch.getAugmentation(PortNumberMatchEntry.class);
                matchBuilder.setInPhyPort(InventoryDataServiceUtil.nodeConnectorIdfromDatapathPortNo(datapathid, portNumber.getPortNumber().getValue()));
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(Metadata.class)) {
                MetadataBuilder metadataBuilder = new MetadataBuilder();
                metadataMatchEntry = (MetadataMatchEntry)ofMatch.getAugmentation(MetadataMatchEntry.class);
                if (metadataMatchEntry == null) continue;
                metadataBuilder.setMetadata(new BigInteger(1, metadataMatchEntry.getMetadata()));
                maskMatchEntry = (MaskMatchEntry)ofMatch.getAugmentation(MaskMatchEntry.class);
                if (maskMatchEntry != null) {
                    metadataBuilder.setMetadataMask(new BigInteger(1, maskMatchEntry.getMask()));
                }
                matchBuilder.setMetadata(metadataBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(EthSrc.class)) {
                macAddressMatchEntry = (MacAddressMatchEntry)ofMatch.getAugmentation(MacAddressMatchEntry.class);
                if (macAddressMatchEntry == null) continue;
                EthernetSourceBuilder ethSourceBuilder = new EthernetSourceBuilder();
                ethSourceBuilder.setAddress(macAddressMatchEntry.getMacAddress());
                ethMatchBuilder.setEthernetSource(ethSourceBuilder.build());
                matchBuilder.setEthernetMatch(ethMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(EthDst.class)) {
                macAddressMatchEntry = (MacAddressMatchEntry)ofMatch.getAugmentation(MacAddressMatchEntry.class);
                if (macAddressMatchEntry == null) continue;
                EthernetDestinationBuilder ethDestinationBuilder = new EthernetDestinationBuilder();
                ethDestinationBuilder.setAddress(macAddressMatchEntry.getMacAddress());
                ethMatchBuilder.setEthernetDestination(ethDestinationBuilder.build());
                matchBuilder.setEthernetMatch(ethMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(EthType.class)) {
                EthTypeMatchEntry ethTypeMatchEntry = (EthTypeMatchEntry)ofMatch.getAugmentation(EthTypeMatchEntry.class);
                if (ethTypeMatchEntry == null) continue;
                EthernetTypeBuilder ethTypeBuilder = new EthernetTypeBuilder();
                ethTypeBuilder.setType(new org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.EtherType(Long.valueOf(ethTypeMatchEntry.getEthType().getValue().intValue())));
                ethMatchBuilder.setEthernetType(ethTypeBuilder.build());
                matchBuilder.setEthernetMatch(ethMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(VlanVid.class)) {
                VlanVidMatchEntry vlanVidMatchEntry = (VlanVidMatchEntry)ofMatch.getAugmentation(VlanVidMatchEntry.class);
                if (vlanVidMatchEntry == null) continue;
                VlanIdBuilder vlanBuilder = new VlanIdBuilder();
                vlanBuilder.setVlanId(new org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanId(vlanVidMatchEntry.getVlanVid()));
                vlanMatchBuilder.setVlanId(vlanBuilder.build());
                matchBuilder.setVlanMatch(vlanMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(VlanPcp.class)) {
                VlanPcpMatchEntry vlanPcpMatchEntry = (VlanPcpMatchEntry)ofMatch.getAugmentation(VlanPcpMatchEntry.class);
                if (vlanPcpMatchEntry == null) continue;
                vlanMatchBuilder.setVlanPcp(new org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanPcp(vlanPcpMatchEntry.getVlanPcp()));
                matchBuilder.setVlanMatch(vlanMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(IpDscp.class)) {
                DscpMatchEntry dscpMatchEntry = (DscpMatchEntry)ofMatch.getAugmentation(DscpMatchEntry.class);
                if (dscpMatchEntry == null) continue;
                ipMatchBuilder.setIpDscp(new Dscp(dscpMatchEntry.getDscp().getValue()));
                matchBuilder.setIpMatch(ipMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(IpEcn.class)) {
                EcnMatchEntry ecnMatchEntry = (EcnMatchEntry)ofMatch.getAugmentation(EcnMatchEntry.class);
                if (ecnMatchEntry == null) continue;
                ipMatchBuilder.setIpEcn(ecnMatchEntry.getEcn());
                matchBuilder.setIpMatch(ipMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(IpProto.class)) {
                ProtocolNumberMatchEntry protocolNumberMatchEntry = (ProtocolNumberMatchEntry)ofMatch.getAugmentation(ProtocolNumberMatchEntry.class);
                if (protocolNumberMatchEntry == null) continue;
                ipMatchBuilder.setIpProtocol(protocolNumberMatchEntry.getProtocolNumber());
                matchBuilder.setIpMatch(ipMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(TcpSrc.class)) {
                portMatchEntry = (PortMatchEntry)ofMatch.getAugmentation(PortMatchEntry.class);
                if (portMatchEntry == null) continue;
                tcpMatchBuilder.setTcpSourcePort(portMatchEntry.getPort());
                matchBuilder.setLayer4Match((Layer4Match)tcpMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(TcpDst.class)) {
                portMatchEntry = (PortMatchEntry)ofMatch.getAugmentation(PortMatchEntry.class);
                if (portMatchEntry == null) continue;
                tcpMatchBuilder.setTcpDestinationPort(portMatchEntry.getPort());
                matchBuilder.setLayer4Match((Layer4Match)tcpMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(UdpSrc.class)) {
                portMatchEntry = (PortMatchEntry)ofMatch.getAugmentation(PortMatchEntry.class);
                if (portMatchEntry == null) continue;
                udpMatchBuilder.setUdpSourcePort(portMatchEntry.getPort());
                matchBuilder.setLayer4Match((Layer4Match)udpMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(UdpDst.class)) {
                portMatchEntry = (PortMatchEntry)ofMatch.getAugmentation(PortMatchEntry.class);
                if (portMatchEntry == null) continue;
                udpMatchBuilder.setUdpDestinationPort(portMatchEntry.getPort());
                matchBuilder.setLayer4Match((Layer4Match)udpMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(SctpSrc.class)) {
                portMatchEntry = (PortMatchEntry)ofMatch.getAugmentation(PortMatchEntry.class);
                if (portMatchEntry == null) continue;
                sctpMatchBuilder.setSctpSourcePort(portMatchEntry.getPort());
                matchBuilder.setLayer4Match((Layer4Match)sctpMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(SctpDst.class)) {
                portMatchEntry = (PortMatchEntry)ofMatch.getAugmentation(PortMatchEntry.class);
                if (portMatchEntry == null) continue;
                sctpMatchBuilder.setSctpDestinationPort(portMatchEntry.getPort());
                matchBuilder.setLayer4Match((Layer4Match)sctpMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(Icmpv4Type.class)) {
                Icmpv4TypeMatchEntry icmpv4TypeMatchEntry = (Icmpv4TypeMatchEntry)ofMatch.getAugmentation(Icmpv4TypeMatchEntry.class);
                if (icmpv4TypeMatchEntry == null) continue;
                icmpv4MatchBuilder.setIcmpv4Type(icmpv4TypeMatchEntry.getIcmpv4Type());
                matchBuilder.setIcmpv4Match(icmpv4MatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(Icmpv4Code.class)) {
                Icmpv4CodeMatchEntry icmpv4CodeMatchEntry = (Icmpv4CodeMatchEntry)ofMatch.getAugmentation(Icmpv4CodeMatchEntry.class);
                if (icmpv4CodeMatchEntry == null) continue;
                icmpv4MatchBuilder.setIcmpv4Code(icmpv4CodeMatchEntry.getIcmpv4Code());
                matchBuilder.setIcmpv4Match(icmpv4MatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(Icmpv6Type.class)) {
                Icmpv6TypeMatchEntry icmpv6TypeMatchEntry = (Icmpv6TypeMatchEntry)ofMatch.getAugmentation(Icmpv6TypeMatchEntry.class);
                if (icmpv6TypeMatchEntry == null) continue;
                icmpv6MatchBuilder.setIcmpv6Type(icmpv6TypeMatchEntry.getIcmpv6Type());
                matchBuilder.setIcmpv6Match(icmpv6MatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(Icmpv6Code.class)) {
                Icmpv6CodeMatchEntry icmpv6CodeMatchEntry = (Icmpv6CodeMatchEntry)ofMatch.getAugmentation(Icmpv6CodeMatchEntry.class);
                if (icmpv6CodeMatchEntry == null) continue;
                icmpv6MatchBuilder.setIcmpv6Code(icmpv6CodeMatchEntry.getIcmpv6Code());
                matchBuilder.setIcmpv6Match(icmpv6MatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(Ipv4Src.class) || ofMatch.getOxmMatchField().equals(Ipv4Dst.class)) {
                ipv4AddressMatchEntry = (Ipv4AddressMatchEntry)ofMatch.getAugmentation(Ipv4AddressMatchEntry.class);
                if (ipv4AddressMatchEntry == null) continue;
                ipv4PrefixStr = ipv4AddressMatchEntry.getIpv4Address().getValue();
                maskMatchEntry = (MaskMatchEntry)ofMatch.getAugmentation(MaskMatchEntry.class);
                if (maskMatchEntry != null) {
                    int receivedMask = ByteBuffer.wrap(maskMatchEntry.getMask()).getInt();
                    int shiftCount = 0;
                    while (receivedMask != -1) {
                        receivedMask >>= 1;
                        ++shiftCount;
                    }
                    ipv4PrefixStr = ipv4PrefixStr + PREFIX_SEPARATOR + (32 - shiftCount);
                } else {
                    ipv4PrefixStr = ipv4PrefixStr + "/32";
                }
                if (ofMatch.getOxmMatchField().equals(Ipv4Src.class)) {
                    ipv4MatchBuilder.setIpv4Source(new Ipv4Prefix(ipv4PrefixStr));
                }
                if (ofMatch.getOxmMatchField().equals(Ipv4Dst.class)) {
                    ipv4MatchBuilder.setIpv4Destination(new Ipv4Prefix(ipv4PrefixStr));
                }
                matchBuilder.setLayer3Match((Layer3Match)ipv4MatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(ArpOp.class)) {
                OpCodeMatchEntry opCodeMatchEntry = (OpCodeMatchEntry)ofMatch.getAugmentation(OpCodeMatchEntry.class);
                if (opCodeMatchEntry == null) continue;
                arpMatchBuilder.setArpOp(opCodeMatchEntry.getOpCode());
                matchBuilder.setLayer3Match((Layer3Match)arpMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(ArpSpa.class) || ofMatch.getOxmMatchField().equals(ArpTpa.class)) {
                ipv4AddressMatchEntry = (Ipv4AddressMatchEntry)ofMatch.getAugmentation(Ipv4AddressMatchEntry.class);
                if (ipv4AddressMatchEntry == null) continue;
                ipv4PrefixStr = ipv4AddressMatchEntry.getIpv4Address().getValue();
                maskMatchEntry = (MaskMatchEntry)ofMatch.getAugmentation(MaskMatchEntry.class);
                if (maskMatchEntry != null) {
                    ipv4PrefixStr = ipv4PrefixStr + PREFIX_SEPARATOR + ByteBuffer.wrap(maskMatchEntry.getMask()).getInt();
                }
                if (ofMatch.getOxmMatchField().equals(ArpSpa.class)) {
                    arpMatchBuilder.setArpSourceTransportAddress(new Ipv4Prefix(ipv4PrefixStr));
                }
                if (ofMatch.getOxmMatchField().equals(ArpTpa.class)) {
                    arpMatchBuilder.setArpTargetTransportAddress(new Ipv4Prefix(ipv4PrefixStr));
                }
                matchBuilder.setLayer3Match((Layer3Match)arpMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(ArpSha.class) || ofMatch.getOxmMatchField().equals(ArpTha.class)) {
                macAddressMatchEntry = (MacAddressMatchEntry)ofMatch.getAugmentation(MacAddressMatchEntry.class);
                if (macAddressMatchEntry == null) continue;
                if (ofMatch.getOxmMatchField().equals(ArpSha.class)) {
                    ArpSourceHardwareAddressBuilder arpSourceHardwareAddressBuilder = new ArpSourceHardwareAddressBuilder();
                    arpSourceHardwareAddressBuilder.setAddress(macAddressMatchEntry.getMacAddress());
                    maskMatchEntry = (MaskMatchEntry)ofMatch.getAugmentation(MaskMatchEntry.class);
                    if (maskMatchEntry != null) {
                        arpSourceHardwareAddressBuilder.setMask(new MacAddress(ByteUtil.macAddressToString(maskMatchEntry.getMask())));
                    }
                    arpMatchBuilder.setArpSourceHardwareAddress(arpSourceHardwareAddressBuilder.build());
                    matchBuilder.setLayer3Match((Layer3Match)arpMatchBuilder.build());
                }
                if (!ofMatch.getOxmMatchField().equals(ArpTha.class)) continue;
                ArpTargetHardwareAddressBuilder arpTargetHardwareAddressBuilder = new ArpTargetHardwareAddressBuilder();
                arpTargetHardwareAddressBuilder.setAddress(macAddressMatchEntry.getMacAddress());
                maskMatchEntry = (MaskMatchEntry)ofMatch.getAugmentation(MaskMatchEntry.class);
                if (maskMatchEntry != null) {
                    arpTargetHardwareAddressBuilder.setMask(new MacAddress(ByteUtil.macAddressToString(maskMatchEntry.getMask())));
                }
                arpMatchBuilder.setArpTargetHardwareAddress(arpTargetHardwareAddressBuilder.build());
                matchBuilder.setLayer3Match((Layer3Match)arpMatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(Ipv6Src.class) || ofMatch.getOxmMatchField().equals(Ipv6Dst.class)) {
                ipv6AddressMatchEntry = (Ipv6AddressMatchEntry)ofMatch.getAugmentation(Ipv6AddressMatchEntry.class);
                if (ipv6AddressMatchEntry == null) continue;
                String ipv6PrefixStr = ipv6AddressMatchEntry.getIpv6Address().getValue();
                maskMatchEntry = (MaskMatchEntry)ofMatch.getAugmentation(MaskMatchEntry.class);
                if (maskMatchEntry != null) {
                    ipv6PrefixStr = ipv6PrefixStr + PREFIX_SEPARATOR + ByteBuffer.wrap(maskMatchEntry.getMask()).getInt();
                }
                if (ofMatch.getOxmMatchField().equals(Ipv6Src.class)) {
                    ipv6MatchBuilder.setIpv6Source(new Ipv6Prefix(ipv6PrefixStr));
                }
                if (ofMatch.getOxmMatchField().equals(Ipv6Dst.class)) {
                    ipv6MatchBuilder.setIpv6Destination(new Ipv6Prefix(ipv6PrefixStr));
                }
                matchBuilder.setLayer3Match((Layer3Match)ipv6MatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(Ipv6Flabel.class)) {
                Ipv6FlabelMatchEntry ipv6FlabelMatchEntry = (Ipv6FlabelMatchEntry)ofMatch.getAugmentation(Ipv6FlabelMatchEntry.class);
                if (ipv6FlabelMatchEntry == null) continue;
                Ipv6LabelBuilder ipv6LabelBuilder = new Ipv6LabelBuilder();
                ipv6LabelBuilder.setIpv6Flabel(new Ipv6FlowLabel(ipv6FlabelMatchEntry.getIpv6Flabel()));
                maskMatchEntry = (MaskMatchEntry)ofMatch.getAugmentation(MaskMatchEntry.class);
                if (maskMatchEntry != null) {
                    ipv6LabelBuilder.setFlabelMask(new Ipv6FlowLabel(new Long(ByteUtil.bytesToUnsignedInt(maskMatchEntry.getMask()))));
                }
                ipv6MatchBuilder.setIpv6Label(ipv6LabelBuilder.build());
                matchBuilder.setLayer3Match((Layer3Match)ipv6MatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(Ipv6NdTarget.class)) {
                ipv6AddressMatchEntry = (Ipv6AddressMatchEntry)ofMatch.getAugmentation(Ipv6AddressMatchEntry.class);
                if (ipv6AddressMatchEntry == null) continue;
                ipv6MatchBuilder.setIpv6NdTarget(ipv6AddressMatchEntry.getIpv6Address());
                matchBuilder.setLayer3Match((Layer3Match)ipv6MatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(Ipv6NdSll.class)) {
                macAddressMatchEntry = (MacAddressMatchEntry)ofMatch.getAugmentation(MacAddressMatchEntry.class);
                if (macAddressMatchEntry == null) continue;
                ipv6MatchBuilder.setIpv6NdSll(macAddressMatchEntry.getMacAddress());
                matchBuilder.setLayer3Match((Layer3Match)ipv6MatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(Ipv6NdTll.class)) {
                macAddressMatchEntry = (MacAddressMatchEntry)ofMatch.getAugmentation(MacAddressMatchEntry.class);
                if (macAddressMatchEntry == null) continue;
                ipv6MatchBuilder.setIpv6NdTll(macAddressMatchEntry.getMacAddress());
                matchBuilder.setLayer3Match((Layer3Match)ipv6MatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(Ipv6Exthdr.class)) {
                PseudoFieldMatchEntry pseudoFieldMatchEntry = (PseudoFieldMatchEntry)ofMatch.getAugmentation(PseudoFieldMatchEntry.class);
                if (pseudoFieldMatchEntry == null) continue;
                Ipv6ExtHeaderBuilder ipv6ExtHeaderBuilder = new Ipv6ExtHeaderBuilder();
                Ipv6ExthdrFlags pField = pseudoFieldMatchEntry.getPseudoField();
                Integer bitmap = 0;
                bitmap = bitmap | (pField.isNonext() != false ? 1 : -2);
                bitmap = bitmap | (pField.isEsp() != false ? 2 : -3);
                bitmap = bitmap | (pField.isAuth() != false ? 4 : -5);
                bitmap = bitmap | (pField.isDest() != false ? 8 : -9);
                bitmap = bitmap | (pField.isFrag() != false ? 16 : -17);
                bitmap = bitmap | (pField.isRouter() != false ? 32 : -33);
                bitmap = bitmap | (pField.isHop() != false ? 64 : -65);
                bitmap = bitmap | (pField.isUnrep() != false ? 128 : -129);
                bitmap = bitmap | (pField.isUnseq() != false ? 256 : -257);
                ipv6ExtHeaderBuilder.setIpv6Exthdr(bitmap);
                MaskMatchEntry maskMatchEntry2 = (MaskMatchEntry)ofMatch.getAugmentation(MaskMatchEntry.class);
                if (maskMatchEntry2 != null) {
                    ipv6ExtHeaderBuilder.setIpv6ExthdrMask(Integer.valueOf(ByteUtil.bytesToUnsignedShort(maskMatchEntry2.getMask())));
                }
                ipv6MatchBuilder.setIpv6ExtHeader(ipv6ExtHeaderBuilder.build());
                matchBuilder.setLayer3Match((Layer3Match)ipv6MatchBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(MplsLabel.class)) {
                MplsLabelMatchEntry mplsLabelMatchEntry = (MplsLabelMatchEntry)ofMatch.getAugmentation(MplsLabelMatchEntry.class);
                if (mplsLabelMatchEntry == null) continue;
                protocolMatchFieldsBuilder.setMplsLabel(mplsLabelMatchEntry.getMplsLabel());
                matchBuilder.setProtocolMatchFields(protocolMatchFieldsBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(MplsBos.class)) {
                BosMatchEntry bosMatchEntry = (BosMatchEntry)ofMatch.getAugmentation(BosMatchEntry.class);
                if (bosMatchEntry == null) continue;
                protocolMatchFieldsBuilder.setMplsBos(Short.valueOf(bosMatchEntry.isBos() != false ? (short)1 : 0));
                matchBuilder.setProtocolMatchFields(protocolMatchFieldsBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(MplsTc.class)) {
                TcMatchEntry tcMatchEntry = (TcMatchEntry)ofMatch.getAugmentation(TcMatchEntry.class);
                if (tcMatchEntry == null) continue;
                protocolMatchFieldsBuilder.setMplsTc(tcMatchEntry.getTc());
                matchBuilder.setProtocolMatchFields(protocolMatchFieldsBuilder.build());
                continue;
            }
            if (ofMatch.getOxmMatchField().equals(PbbIsid.class)) {
                IsidMatchEntry isidMatchEntry = (IsidMatchEntry)ofMatch.getAugmentation(IsidMatchEntry.class);
                if (isidMatchEntry == null) continue;
                PbbBuilder pbbBuilder = new PbbBuilder();
                pbbBuilder.setPbbIsid(isidMatchEntry.getIsid());
                maskMatchEntry = (MaskMatchEntry)ofMatch.getAugmentation(MaskMatchEntry.class);
                if (maskMatchEntry != null) {
                    pbbBuilder.setPbbMask(Long.valueOf(ByteUtil.bytesToUnsignedInt(maskMatchEntry.getMask())));
                }
                protocolMatchFieldsBuilder.setPbb(pbbBuilder.build());
                matchBuilder.setProtocolMatchFields(protocolMatchFieldsBuilder.build());
                continue;
            }
            if (!ofMatch.getOxmMatchField().equals(TunnelId.class)) continue;
            TunnelBuilder tunnelBuilder = new TunnelBuilder();
            metadataMatchEntry = (MetadataMatchEntry)ofMatch.getAugmentation(MetadataMatchEntry.class);
            if (metadataMatchEntry == null) continue;
            tunnelBuilder.setTunnelId(new BigInteger(1, metadataMatchEntry.getMetadata()));
            maskMatchEntry = (MaskMatchEntry)ofMatch.getAugmentation(MaskMatchEntry.class);
            if (maskMatchEntry != null) {
                tunnelBuilder.setTunnelMask(new BigInteger(1, maskMatchEntry.getMask()));
            }
            matchBuilder.setTunnel(tunnelBuilder.build());
        }
        return matchBuilder.build();
    }

    private static MatchEntries toOfMplsPbb(Pbb pbb) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        boolean hasmask = false;
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setOxmMatchField(PbbIsid.class);
        IsidMatchEntryBuilder isidBuilder = new IsidMatchEntryBuilder();
        isidBuilder.setIsid(pbb.getPbbIsid());
        matchEntriesBuilder.addAugmentation(IsidMatchEntry.class, (Augmentation)isidBuilder.build());
        if (pbb.getPbbMask() != null) {
            hasmask = true;
            MatchConvertorImpl.addMaskAugmentation(matchEntriesBuilder, ByteUtil.unsignedIntToBytes(pbb.getPbbMask()));
        }
        matchEntriesBuilder.setHasMask(Boolean.valueOf(hasmask));
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfMplsTc(Short mplsTc) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(MplsTc.class);
        TcMatchEntryBuilder tcBuilder = new TcMatchEntryBuilder();
        tcBuilder.setTc(mplsTc);
        matchEntriesBuilder.addAugmentation(TcMatchEntry.class, (Augmentation)tcBuilder.build());
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfMplsBos(Short mplsBos) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(MplsBos.class);
        BosMatchEntryBuilder bosBuilder = new BosMatchEntryBuilder();
        if (mplsBos != 0) {
            bosBuilder.setBos(Boolean.valueOf(true));
        } else {
            bosBuilder.setBos(Boolean.valueOf(false));
        }
        matchEntriesBuilder.addAugmentation(BosMatchEntry.class, (Augmentation)bosBuilder.build());
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfMplsLabel(Long mplsLabel) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(MplsLabel.class);
        MplsLabelMatchEntryBuilder mplsLabelBuilder = new MplsLabelMatchEntryBuilder();
        mplsLabelBuilder.setMplsLabel(mplsLabel);
        matchEntriesBuilder.addAugmentation(MplsLabelMatchEntry.class, (Augmentation)mplsLabelBuilder.build());
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfIpv6ExtHeader(Ipv6ExtHeader ipv6ExtHeader) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        boolean hasmask = false;
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setOxmMatchField(Ipv6Exthdr.class);
        PseudoFieldMatchEntryBuilder pseudoBuilder = new PseudoFieldMatchEntryBuilder();
        Integer bitmap = ipv6ExtHeader.getIpv6Exthdr();
        Boolean NONEXT = (bitmap & 1) != 0;
        Boolean ESP = (bitmap & 2) != 0;
        Boolean AUTH = (bitmap & 4) != 0;
        Boolean DEST = (bitmap & 8) != 0;
        Boolean FRAG = (bitmap & 0x10) != 0;
        Boolean ROUTER = (bitmap & 0x20) != 0;
        Boolean HOP = (bitmap & 0x40) != 0;
        Boolean UNREP = (bitmap & 0x80) != 0;
        Boolean UNSEQ = (bitmap & 0x100) != 0;
        pseudoBuilder.setPseudoField(new Ipv6ExthdrFlags(AUTH, DEST, ESP, FRAG, HOP, NONEXT, ROUTER, UNREP, UNSEQ));
        matchEntriesBuilder.addAugmentation(PseudoFieldMatchEntry.class, (Augmentation)pseudoBuilder.build());
        if (ipv6ExtHeader.getIpv6ExthdrMask() != null) {
            hasmask = true;
            MatchConvertorImpl.addMaskAugmentation(matchEntriesBuilder, ByteUtil.unsignedShortToBytes(ipv6ExtHeader.getIpv6ExthdrMask()));
        }
        matchEntriesBuilder.setHasMask(Boolean.valueOf(hasmask));
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfIpv6FlowLabel(Ipv6Label ipv6Label) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        boolean hasmask = false;
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setOxmMatchField(Ipv6Flabel.class);
        Ipv6FlabelMatchEntryBuilder ipv6FlabelBuilder = new Ipv6FlabelMatchEntryBuilder();
        ipv6FlabelBuilder.setIpv6Flabel(ipv6Label.getIpv6Flabel());
        matchEntriesBuilder.addAugmentation(Ipv6FlabelMatchEntry.class, (Augmentation)ipv6FlabelBuilder.build());
        if (ipv6Label.getFlabelMask() != null) {
            hasmask = true;
            MatchConvertorImpl.addMaskAugmentation(matchEntriesBuilder, ByteUtil.unsignedIntToBytes(ipv6Label.getFlabelMask().getValue()));
        }
        matchEntriesBuilder.setHasMask(Boolean.valueOf(hasmask));
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfPort(Class<? extends MatchField> field, Long portNumber) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(field);
        PortNumberMatchEntryBuilder port = new PortNumberMatchEntryBuilder();
        port.setPortNumber(new org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber(portNumber));
        matchEntriesBuilder.addAugmentation(PortNumberMatchEntry.class, (Augmentation)port.build());
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfMetadata(Class<? extends MatchField> field, BigInteger metadata, BigInteger metadataMask) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        boolean hasmask = false;
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setOxmMatchField(field);
        MatchConvertorImpl.addMetadataAugmentation(matchEntriesBuilder, metadata);
        if (metadataMask != null) {
            hasmask = true;
            MatchConvertorImpl.addMaskAugmentation(matchEntriesBuilder, ByteUtil.convertBigIntegerToNBytes(metadataMask, 8));
        }
        matchEntriesBuilder.setHasMask(Boolean.valueOf(hasmask));
        return matchEntriesBuilder.build();
    }

    public static MatchEntries toOfMacAddress(Class<? extends MatchField> field, MacAddress macAddress, MacAddress mask) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        boolean hasmask = false;
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setOxmMatchField(field);
        MatchConvertorImpl.addMacAddressAugmentation(matchEntriesBuilder, macAddress);
        if (mask != null) {
            hasmask = true;
            MatchConvertorImpl.addMaskAugmentation(matchEntriesBuilder, ByteUtil.macAddressToBytes(mask));
        }
        matchEntriesBuilder.setHasMask(Boolean.valueOf(hasmask));
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfEthernetType(EthernetType ethernetType) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(EthType.class);
        EthTypeMatchEntryBuilder ethertypeBuilder = new EthTypeMatchEntryBuilder();
        ethertypeBuilder.setEthType(new EtherType(Integer.valueOf(ethernetType.getType().getValue().intValue())));
        matchEntriesBuilder.addAugmentation(EthTypeMatchEntry.class, (Augmentation)ethertypeBuilder.build());
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfLayer3Port(Class<? extends MatchField> field, PortNumber portNumber) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(field);
        PortMatchEntryBuilder portBuilder = new PortMatchEntryBuilder();
        portBuilder.setPort(portNumber);
        matchEntriesBuilder.addAugmentation(PortMatchEntry.class, (Augmentation)portBuilder.build());
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfIcmpv4Type(Short icmpv4Type) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(Icmpv4Type.class);
        Icmpv4TypeMatchEntryBuilder icmpv4TypeBuilder = new Icmpv4TypeMatchEntryBuilder();
        icmpv4TypeBuilder.setIcmpv4Type(icmpv4Type);
        matchEntriesBuilder.addAugmentation(Icmpv4TypeMatchEntry.class, (Augmentation)icmpv4TypeBuilder.build());
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfIcmpv4Code(Short icmpv4Code) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(Icmpv4Code.class);
        Icmpv4CodeMatchEntryBuilder icmpv4CodeBuilder = new Icmpv4CodeMatchEntryBuilder();
        icmpv4CodeBuilder.setIcmpv4Code(icmpv4Code);
        matchEntriesBuilder.addAugmentation(Icmpv4CodeMatchEntry.class, (Augmentation)icmpv4CodeBuilder.build());
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfIcmpv6Type(Short icmpv6Type) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(Icmpv6Type.class);
        Icmpv6TypeMatchEntryBuilder icmpv6TypeBuilder = new Icmpv6TypeMatchEntryBuilder();
        icmpv6TypeBuilder.setIcmpv6Type(icmpv6Type);
        matchEntriesBuilder.addAugmentation(Icmpv6TypeMatchEntry.class, (Augmentation)icmpv6TypeBuilder.build());
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfIcmpv6Code(Short icmpv6Code) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(Icmpv6Code.class);
        Icmpv6CodeMatchEntryBuilder icmpv6CodeBuilder = new Icmpv6CodeMatchEntryBuilder();
        icmpv6CodeBuilder.setIcmpv6Code(icmpv6Code);
        matchEntriesBuilder.addAugmentation(Icmpv6CodeMatchEntry.class, (Augmentation)icmpv6CodeBuilder.build());
        return matchEntriesBuilder.build();
    }

    public static MatchEntries toOfIpv4Prefix(Class<? extends MatchField> field, Ipv4Prefix ipv4Prefix) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setOxmMatchField(field);
        boolean hasMask = MatchConvertorImpl.addIpv4PrefixAugmentation(matchEntriesBuilder, ipv4Prefix);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(hasMask));
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfIpv6Prefix(Class<? extends MatchField> field, Ipv6Prefix ipv6Prefix) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setOxmMatchField(field);
        boolean hasmask = MatchConvertorImpl.addIpv6PrefixAugmentation(matchEntriesBuilder, ipv6Prefix);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(hasmask));
        return matchEntriesBuilder.build();
    }

    public static MatchEntries toOfIpDscp(Dscp ipDscp) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(IpDscp.class);
        DscpMatchEntryBuilder dscpBuilder = new DscpMatchEntryBuilder();
        dscpBuilder.setDscp(ipDscp);
        matchEntriesBuilder.addAugmentation(DscpMatchEntry.class, (Augmentation)dscpBuilder.build());
        return matchEntriesBuilder.build();
    }

    public static MatchEntries toOfVlanPcp(org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanPcp vlanPcp) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(VlanPcp.class);
        VlanPcpMatchEntryBuilder vlanPcpBuilder = new VlanPcpMatchEntryBuilder();
        vlanPcpBuilder.setVlanPcp(vlanPcp.getValue());
        matchEntriesBuilder.addAugmentation(VlanPcpMatchEntry.class, (Augmentation)vlanPcpBuilder.build());
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfVlanVid(VlanId vlanId) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        boolean hasmask = false;
        boolean setCfiBit = false;
        Integer vidEntryValue = 0;
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setOxmMatchField(VlanVid.class);
        VlanVidMatchEntryBuilder vlanVidBuilder = new VlanVidMatchEntryBuilder();
        if (vlanId.isVlanIdPresent() == Boolean.TRUE) {
            setCfiBit = true;
            if (vlanId.getVlanId() != null) {
                vidEntryValue = vlanId.getVlanId().getValue();
            }
            hasmask = vidEntryValue == 0;
        }
        vlanVidBuilder.setCfiBit(Boolean.valueOf(setCfiBit));
        vlanVidBuilder.setVlanVid(vidEntryValue);
        matchEntriesBuilder.addAugmentation(VlanVidMatchEntry.class, (Augmentation)vlanVidBuilder.build());
        if (hasmask) {
            MatchConvertorImpl.addMaskAugmentation(matchEntriesBuilder, VLAN_VID_MASK);
        }
        matchEntriesBuilder.setHasMask(Boolean.valueOf(hasmask));
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfIpProto(Short ipProtocol) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(IpProto.class);
        ProtocolNumberMatchEntryBuilder protoNumberBuilder = new ProtocolNumberMatchEntryBuilder();
        protoNumberBuilder.setProtocolNumber(ipProtocol);
        matchEntriesBuilder.addAugmentation(ProtocolNumberMatchEntry.class, (Augmentation)protoNumberBuilder.build());
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfIpEcn(Short ipEcn) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(IpEcn.class);
        EcnMatchEntryBuilder ecnBuilder = new EcnMatchEntryBuilder();
        ecnBuilder.setEcn(ipEcn);
        matchEntriesBuilder.addAugmentation(EcnMatchEntry.class, (Augmentation)ecnBuilder.build());
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfArpOpCode(Integer arpOp) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(ArpOp.class);
        OpCodeMatchEntryBuilder opcodeBuilder = new OpCodeMatchEntryBuilder();
        opcodeBuilder.setOpCode(arpOp);
        matchEntriesBuilder.addAugmentation(OpCodeMatchEntry.class, (Augmentation)opcodeBuilder.build());
        return matchEntriesBuilder.build();
    }

    private static MatchEntries toOfIpv6Address(Ipv6Address address) {
        MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
        matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        matchEntriesBuilder.setOxmMatchField(Ipv6NdTarget.class);
        Ipv6AddressMatchEntryBuilder ipv6AddressBuilder = new Ipv6AddressMatchEntryBuilder();
        ipv6AddressBuilder.setIpv6Address(address);
        matchEntriesBuilder.addAugmentation(Ipv6AddressMatchEntry.class, (Augmentation)ipv6AddressBuilder.build());
        return matchEntriesBuilder.build();
    }

    private static void addMaskAugmentation(MatchEntriesBuilder builder, byte[] mask) {
        MaskMatchEntryBuilder maskBuilder = new MaskMatchEntryBuilder();
        maskBuilder.setMask(mask);
        builder.addAugmentation(MaskMatchEntry.class, (Augmentation)maskBuilder.build());
    }

    private static boolean addIpv6PrefixAugmentation(MatchEntriesBuilder builder, Ipv6Prefix address) {
        boolean hasMask = false;
        String[] addressParts = address.getValue().split(PREFIX_SEPARATOR);
        Integer prefix = null;
        if (addressParts.length == 2) {
            prefix = Integer.parseInt(addressParts[1]);
        }
        Ipv6Address ipv6Address = new Ipv6Address(addressParts[0]);
        Ipv6AddressMatchEntryBuilder ipv6AddressBuilder = new Ipv6AddressMatchEntryBuilder();
        ipv6AddressBuilder.setIpv6Address(ipv6Address);
        builder.addAugmentation(Ipv6AddressMatchEntry.class, (Augmentation)ipv6AddressBuilder.build());
        if (prefix != null) {
            hasMask = true;
            MatchConvertorImpl.addMaskAugmentation(builder, MatchConvertorImpl.convertIpv6PrefixToByteArray(prefix));
        }
        return hasMask;
    }

    private static byte[] convertIpv6PrefixToByteArray(int prefix) {
        byte[] mask = new byte[16];
        int oneCount = prefix;
        for (int count = 0; count < 16; ++count) {
            int byteBits = 0;
            if (oneCount >= 8) {
                byteBits = 8;
                oneCount -= 8;
            } else {
                byteBits = oneCount;
                oneCount = 0;
            }
            mask[count] = (byte)(256.0 - Math.pow(2.0, 8 - byteBits));
        }
        return mask;
    }

    private static void addMetadataAugmentation(MatchEntriesBuilder builder, BigInteger metadata) {
        MetadataMatchEntryBuilder metadataMatchEntry = new MetadataMatchEntryBuilder();
        metadataMatchEntry.setMetadata(ByteUtil.convertBigIntegerToNBytes(metadata, 8));
        builder.addAugmentation(MetadataMatchEntry.class, (Augmentation)metadataMatchEntry.build());
    }

    private static boolean addIpv4PrefixAugmentation(MatchEntriesBuilder builder, Ipv4Prefix address) {
        boolean hasMask = false;
        String[] addressParts = address.getValue().split(PREFIX_SEPARATOR);
        Integer prefix = null;
        prefix = addressParts.length < 2 ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(addressParts[1]));
        Ipv4Address ipv4Address = new Ipv4Address(addressParts[0]);
        Ipv4AddressMatchEntryBuilder ipv4AddressBuilder = new Ipv4AddressMatchEntryBuilder();
        ipv4AddressBuilder.setIpv4Address(ipv4Address);
        builder.addAugmentation(Ipv4AddressMatchEntry.class, (Augmentation)ipv4AddressBuilder.build());
        if (prefix != 0) {
            int mask = -1 << 32 - prefix;
            byte[] maskBytes = new byte[]{(byte)(mask >>> 24), (byte)(mask >>> 16), (byte)(mask >>> 8), (byte)mask};
            MatchConvertorImpl.addMaskAugmentation(builder, maskBytes);
            hasMask = true;
        }
        return hasMask;
    }

    private static void addMacAddressAugmentation(MatchEntriesBuilder builder, MacAddress address) {
        MacAddressMatchEntryBuilder macAddress = new MacAddressMatchEntryBuilder();
        macAddress.setMacAddress(address);
        builder.addAugmentation(MacAddressMatchEntry.class, (Augmentation)macAddress.build());
    }

    public static SetField ofToSALSetField(Action action) {
        logger.debug("OF SetField match to SAL SetField match converstion begins");
        SetFieldBuilder setField = new SetFieldBuilder();
        return setField.build();
    }
}

