/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.common;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.common.Convertor;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.common.InjectionKey;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.common.ResultInjector;

public abstract class ConvertReactor<FROM> {
    private Map<Short, Convertor<FROM, ?>> conversionMapping = new HashMap();
    private Map<InjectionKey, ResultInjector<?, ?>> injectionMapping = new HashMap();

    protected ConvertReactor() {
        this.initMappings(this.conversionMapping, this.injectionMapping);
    }

    protected abstract void initMappings(Map<Short, Convertor<FROM, ?>> var1, Map<InjectionKey, ResultInjector<?, ?>> var2);

    public <RESULT, TARGET> void convert(FROM source, short version, TARGET target, BigInteger datapathid) {
        Convertor<FROM, ?> convertor = this.conversionMapping.get(version);
        if (convertor == null) {
            throw new IllegalArgumentException("convertor for given version [" + version + "] not found");
        }
        Object convertedItem = convertor.convert(source, datapathid);
        InjectionKey key = new InjectionKey(version, target.getClass().getName());
        ResultInjector<?, ?> injection = this.injectionMapping.get(key);
        if (injection == null) {
            throw new IllegalArgumentException("injector for given version and target [" + key + "] not found");
        }
        injection.inject(convertedItem, target);
    }
}

