/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal.convertor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.CopyTtlInCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.CopyTtlOutCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.DecMplsTtlCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.DecNwTtlCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.GroupActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.OutputActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PopMplsActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PopPbbActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PopVlanActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PushMplsActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PushPbbActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PushVlanActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetFieldCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetMplsTtlActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetNwTtlActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetQueueActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.ApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.ClearActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.GoToTableCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.MeterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.WriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.WriteMetadataCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.InstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ActionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.InstructionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.NextTableRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OxmRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.table.features.properties.container.table.feature.properties.NextTableIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.CopyTtlIn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.CopyTtlOut;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.DecMplsTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.DecNwTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Output;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PopMpls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PopPbb;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PopVlan;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PushMpls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PushPbb;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PushVlan;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetMplsTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetNwTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.ApplyActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.ClearActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.Experimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.GotoTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.WriteActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.WriteMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableFeaturesPropType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpTha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpTpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv4Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv6Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv6Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.InPhyPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.IpDscp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv4Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv4Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Exthdr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Flabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Metadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MplsBos;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MplsLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.PbbIsid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.SctpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.SctpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.TcpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.TunnelId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.UdpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.UdpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.VlanPcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.VlanVid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.MultipartReplyTableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.ArpOp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.ArpSha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.ArpSpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.EthType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.Icmpv4Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.InPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.IpEcn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.IpProto;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.Ipv6NdSll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.Ipv6NdTarget;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.Ipv6NdTll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.MplsTc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TcpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.set.field.match.SetFieldMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.set.field.match.SetFieldMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.TableFeaturePropType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.ApplyActionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.ApplyActionsMissBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.ApplySetfieldMissBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.NextTableBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.NextTableMissBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.WildcardsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.WriteActionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.WriteActionsMissBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.WriteSetfieldBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.apply.setfield.ApplySetfieldBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.instructions.InstructionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.instructions.miss.InstructionsMissBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.match.MatchSetfieldBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.next.table.TablesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.next.table.miss.TablesMissBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.wildcards.WildcardSetfieldBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.write.setfield.miss.WriteSetfieldMissBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.features.TableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.features.TableFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.features.table.features.TableProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.features.table.features.TablePropertiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.features.table.features.table.properties.TableFeatureProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.features.table.features.table.properties.TableFeaturePropertiesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableFeaturesReplyConvertor {
    private static final Logger logger = LoggerFactory.getLogger(TableFeaturesReplyConvertor.class);

    public static List<TableFeatures> toTableFeaturesReply(MultipartReplyTableFeatures ofTableFeaturesList) {
        if (ofTableFeaturesList == null || ofTableFeaturesList.getTableFeatures() == null) {
            return Collections.emptyList();
        }
        ArrayList<TableFeatures> salTableFeaturesList = new ArrayList<TableFeatures>();
        TableFeaturesBuilder salTableFeatures = new TableFeaturesBuilder();
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.multipart.reply.table.features.TableFeatures ofTableFeatures : ofTableFeaturesList.getTableFeatures()) {
            salTableFeatures.setTableId(ofTableFeatures.getTableId());
            salTableFeatures.setName(ofTableFeatures.getName());
            if (ofTableFeatures.getMetadataMatch() != null) {
                salTableFeatures.setMetadataMatch(new BigInteger(ofTableFeatures.getMetadataMatch()));
            }
            if (ofTableFeatures.getMetadataWrite() != null) {
                salTableFeatures.setMetadataWrite(new BigInteger(ofTableFeatures.getMetadataWrite()));
            }
            if (ofTableFeatures.getConfig() != null) {
                salTableFeatures.setConfig(new TableConfig(ofTableFeatures.getConfig().isOFPTCDEPRECATEDMASK()));
            }
            salTableFeatures.setMaxEntries(ofTableFeatures.getMaxEntries());
            salTableFeatures.setTableProperties(TableFeaturesReplyConvertor.toTableProperties(ofTableFeatures.getTableFeatureProperties()));
            salTableFeaturesList.add(salTableFeatures.build());
        }
        return salTableFeaturesList;
    }

    private static TableProperties toTableProperties(List<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.TableFeatureProperties> ofTablePropertiesList) {
        if (ofTablePropertiesList == null) {
            return new TablePropertiesBuilder().setTableFeatureProperties(Collections.emptyList()).build();
        }
        ArrayList<TableFeatureProperties> salTablePropertiesList = new ArrayList<TableFeatureProperties>();
        TableFeaturePropertiesBuilder propBuilder = new TableFeaturePropertiesBuilder();
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.TableFeatureProperties property : ofTablePropertiesList) {
            TableFeaturesPropType propType = property.getType();
            if (propType == null) continue;
            switch (propType) {
                case OFPTFPTINSTRUCTIONS: {
                    org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.InstructionsBuilder instructionBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.InstructionsBuilder();
                    instructionBuilder.setInstructions(new InstructionsBuilder().setInstruction(TableFeaturesReplyConvertor.setInstructionTableFeatureProperty(property)).build());
                    propBuilder.setTableFeaturePropType((TableFeaturePropType)instructionBuilder.build());
                    break;
                }
                case OFPTFPTINSTRUCTIONSMISS: {
                    org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.InstructionsMissBuilder instructionMissBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.InstructionsMissBuilder();
                    instructionMissBuilder.setInstructionsMiss(new InstructionsMissBuilder().setInstruction(TableFeaturesReplyConvertor.setInstructionTableFeatureProperty(property)).build());
                    propBuilder.setTableFeaturePropType((TableFeaturePropType)instructionMissBuilder.build());
                    break;
                }
                case OFPTFPTNEXTTABLES: {
                    NextTableBuilder nextTableBuilder = new NextTableBuilder();
                    nextTableBuilder.setTables(new TablesBuilder().setTableIds(TableFeaturesReplyConvertor.setNextTableFeatureProperty(property)).build());
                    propBuilder.setTableFeaturePropType((TableFeaturePropType)nextTableBuilder.build());
                    break;
                }
                case OFPTFPTNEXTTABLESMISS: {
                    NextTableMissBuilder nextTableMissBuilder = new NextTableMissBuilder();
                    nextTableMissBuilder.setTablesMiss(new TablesMissBuilder().setTableIds(TableFeaturesReplyConvertor.setNextTableFeatureProperty(property)).build());
                    propBuilder.setTableFeaturePropType((TableFeaturePropType)nextTableMissBuilder.build());
                    break;
                }
                case OFPTFPTWRITEACTIONS: {
                    WriteActionsBuilder writeActionsBuilder = new WriteActionsBuilder();
                    writeActionsBuilder.setWriteActions(new org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.write.actions.WriteActionsBuilder().setAction(TableFeaturesReplyConvertor.setActionTableFeatureProperty(property)).build());
                    propBuilder.setTableFeaturePropType((TableFeaturePropType)writeActionsBuilder.build());
                    break;
                }
                case OFPTFPTWRITEACTIONSMISS: {
                    WriteActionsMissBuilder writeActionsMissBuilder = new WriteActionsMissBuilder();
                    writeActionsMissBuilder.setWriteActionsMiss(new org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.write.actions.miss.WriteActionsMissBuilder().setAction(TableFeaturesReplyConvertor.setActionTableFeatureProperty(property)).build());
                    propBuilder.setTableFeaturePropType((TableFeaturePropType)writeActionsMissBuilder.build());
                    break;
                }
                case OFPTFPTAPPLYACTIONS: {
                    ApplyActionsBuilder applyActionsBuilder = new ApplyActionsBuilder();
                    applyActionsBuilder.setApplyActions(new org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.apply.actions.ApplyActionsBuilder().setAction(TableFeaturesReplyConvertor.setActionTableFeatureProperty(property)).build());
                    propBuilder.setTableFeaturePropType((TableFeaturePropType)applyActionsBuilder.build());
                    break;
                }
                case OFPTFPTAPPLYACTIONSMISS: {
                    ApplyActionsMissBuilder applyActionsMissBuilder = new ApplyActionsMissBuilder();
                    applyActionsMissBuilder.setApplyActionsMiss(new org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.apply.actions.miss.ApplyActionsMissBuilder().setAction(TableFeaturesReplyConvertor.setActionTableFeatureProperty(property)).build());
                    propBuilder.setTableFeaturePropType((TableFeaturePropType)applyActionsMissBuilder.build());
                    break;
                }
                case OFPTFPTMATCH: {
                    MatchSetfieldBuilder matchBuilder = new MatchSetfieldBuilder();
                    matchBuilder.setSetFieldMatch(TableFeaturesReplyConvertor.setSetFieldTableFeatureProperty(property, true));
                    propBuilder.setTableFeaturePropType((TableFeaturePropType)new MatchBuilder().setMatchSetfield(matchBuilder.build()).build());
                    break;
                }
                case OFPTFPTWILDCARDS: {
                    WildcardSetfieldBuilder wildcardsBuilder = new WildcardSetfieldBuilder();
                    wildcardsBuilder.setSetFieldMatch(TableFeaturesReplyConvertor.setSetFieldTableFeatureProperty(property, false));
                    propBuilder.setTableFeaturePropType((TableFeaturePropType)new WildcardsBuilder().setWildcardSetfield(wildcardsBuilder.build()).build());
                    break;
                }
                case OFPTFPTWRITESETFIELD: {
                    org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.write.setfield.WriteSetfieldBuilder writeSetfieldBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.write.setfield.WriteSetfieldBuilder();
                    writeSetfieldBuilder.setSetFieldMatch(TableFeaturesReplyConvertor.setSetFieldTableFeatureProperty(property, false));
                    propBuilder.setTableFeaturePropType((TableFeaturePropType)new WriteSetfieldBuilder().setWriteSetfield(writeSetfieldBuilder.build()).build());
                    break;
                }
                case OFPTFPTWRITESETFIELDMISS: {
                    WriteSetfieldMissBuilder writeSetfieldMissBuilder = new WriteSetfieldMissBuilder();
                    writeSetfieldMissBuilder.setSetFieldMatch(TableFeaturesReplyConvertor.setSetFieldTableFeatureProperty(property, false));
                    propBuilder.setTableFeaturePropType((TableFeaturePropType)new org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.WriteSetfieldMissBuilder().setWriteSetfieldMiss(writeSetfieldMissBuilder.build()).build());
                    break;
                }
                case OFPTFPTAPPLYSETFIELD: {
                    ApplySetfieldBuilder applySetfieldBuilder = new ApplySetfieldBuilder();
                    applySetfieldBuilder.setSetFieldMatch(TableFeaturesReplyConvertor.setSetFieldTableFeatureProperty(property, false));
                    propBuilder.setTableFeaturePropType((TableFeaturePropType)new org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.ApplySetfieldBuilder().setApplySetfield(applySetfieldBuilder.build()).build());
                    break;
                }
                case OFPTFPTAPPLYSETFIELDMISS: {
                    org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.apply.setfield.miss.ApplySetfieldMissBuilder applySetfieldMissBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.feature.prop.type.table.feature.prop.type.apply.setfield.miss.ApplySetfieldMissBuilder();
                    applySetfieldMissBuilder.setSetFieldMatch(TableFeaturesReplyConvertor.setSetFieldTableFeatureProperty(property, false));
                    propBuilder.setTableFeaturePropType((TableFeaturePropType)new ApplySetfieldMissBuilder().setApplySetfieldMiss(applySetfieldMissBuilder.build()).build());
                    break;
                }
                case OFPTFPTEXPERIMENTER: {
                    break;
                }
                case OFPTFPTEXPERIMENTERMISS: {
                    break;
                }
                default: {
                    logger.error("Unsupported table feature property : " + propType);
                }
            }
            salTablePropertiesList.add(propBuilder.build());
        }
        return new TablePropertiesBuilder().setTableFeatureProperties(salTablePropertiesList).build();
    }

    private static List<Instruction> setInstructionTableFeatureProperty(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.TableFeatureProperties properties) {
        ArrayList<Instruction> instructionList = new ArrayList<Instruction>();
        InstructionBuilder builder = new InstructionBuilder();
        for (Instructions currInstruction : ((InstructionRelatedTableFeatureProperty)properties.getAugmentation(InstructionRelatedTableFeatureProperty.class)).getInstructions()) {
            Class currInstructionType = currInstruction.getType();
            if (currInstructionType.equals(GotoTable.class)) {
                builder.setInstruction((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.Instruction)new GoToTableCaseBuilder().build());
            } else if (currInstructionType.equals(WriteMetadata.class)) {
                builder.setInstruction((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.Instruction)new WriteMetadataCaseBuilder().build());
            } else if (currInstructionType.equals(WriteActions.class)) {
                builder.setInstruction((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.Instruction)new WriteActionsCaseBuilder().build());
            } else if (currInstructionType.equals(ApplyActions.class)) {
                builder.setInstruction((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.Instruction)new ApplyActionsCaseBuilder().build());
            } else if (currInstructionType.equals(ClearActions.class)) {
                builder.setInstruction((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.Instruction)new ClearActionsCaseBuilder().build());
            } else if (currInstructionType.equals(Meter.class)) {
                builder.setInstruction((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.Instruction)new MeterCaseBuilder().build());
            } else if (currInstructionType.equals(Experimenter.class)) {
                // empty if block
            }
            instructionList.add(builder.build());
        }
        return instructionList;
    }

    private static List<Short> setNextTableFeatureProperty(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.TableFeatureProperties properties) {
        ArrayList<Short> nextTableIdsList = new ArrayList<Short>();
        for (NextTableIds tableId : ((NextTableRelatedTableFeatureProperty)properties.getAugmentation(NextTableRelatedTableFeatureProperty.class)).getNextTableIds()) {
            nextTableIdsList.add(tableId.getTableId());
        }
        return nextTableIdsList;
    }

    private static List<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action> setActionTableFeatureProperty(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.TableFeatureProperties properties) {
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action> actionList = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action>();
        ActionBuilder actionBuilder = new ActionBuilder();
        for (ActionsList currAction : ((ActionRelatedTableFeatureProperty)properties.getAugmentation(ActionRelatedTableFeatureProperty.class)).getActionsList()) {
            org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.actions.list.Action action = currAction.getAction();
            if (action == null) continue;
            Class actionType = action.getType();
            if (actionType.equals(Output.class)) {
                actionBuilder.setAction((Action)new OutputActionCaseBuilder().build());
            } else if (actionType.equals(Group.class)) {
                actionBuilder.setAction((Action)new GroupActionCaseBuilder().build());
            } else if (actionType.equals(CopyTtlOut.class)) {
                actionBuilder.setAction((Action)new CopyTtlOutCaseBuilder().build());
            } else if (actionType.equals(CopyTtlIn.class)) {
                actionBuilder.setAction((Action)new CopyTtlInCaseBuilder().build());
            } else if (actionType.equals(SetMplsTtl.class)) {
                actionBuilder.setAction((Action)new SetMplsTtlActionCaseBuilder().build());
            } else if (actionType.equals(DecMplsTtl.class)) {
                actionBuilder.setAction((Action)new DecMplsTtlCaseBuilder().build());
            } else if (actionType.equals(PushVlan.class)) {
                actionBuilder.setAction((Action)new PushVlanActionCaseBuilder().build());
            } else if (actionType.equals(PopVlan.class)) {
                actionBuilder.setAction((Action)new PopVlanActionCaseBuilder().build());
            } else if (actionType.equals(PushMpls.class)) {
                actionBuilder.setAction((Action)new PushMplsActionCaseBuilder().build());
            } else if (actionType.equals(PopMpls.class)) {
                actionBuilder.setAction((Action)new PopMplsActionCaseBuilder().build());
            } else if (actionType.equals(SetQueue.class)) {
                actionBuilder.setAction((Action)new SetQueueActionCaseBuilder().build());
            } else if (actionType.equals(SetNwTtl.class)) {
                actionBuilder.setAction((Action)new SetNwTtlActionCaseBuilder().build());
            } else if (actionType.equals(DecNwTtl.class)) {
                actionBuilder.setAction((Action)new DecNwTtlCaseBuilder().build());
            } else if (actionType.equals(SetField.class)) {
                actionBuilder.setAction((Action)new SetFieldCaseBuilder().build());
            } else if (actionType.equals(PushPbb.class)) {
                actionBuilder.setAction((Action)new PushPbbActionCaseBuilder().build());
            } else if (actionType.equals(PopPbb.class)) {
                actionBuilder.setAction((Action)new PopPbbActionCaseBuilder().build());
            } else if (actionType.equals(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Experimenter.class)) {
                // empty if block
            }
            actionList.add(actionBuilder.build());
        }
        return actionList;
    }

    private static List<SetFieldMatch> setSetFieldTableFeatureProperty(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.TableFeatureProperties properties, boolean setHasMask) {
        ArrayList<SetFieldMatch> setFieldMatchList = new ArrayList<SetFieldMatch>();
        SetFieldMatchBuilder setFieldMatchBuilder = new SetFieldMatchBuilder();
        Class<ArpOp> salMatchField = null;
        Class ofMatchField = null;
        for (MatchEntries currMatch : ((OxmRelatedTableFeatureProperty)properties.getAugmentation(OxmRelatedTableFeatureProperty.class)).getMatchEntries()) {
            ofMatchField = currMatch.getOxmMatchField();
            if (ofMatchField.equals(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpOp.class)) {
                salMatchField = ArpOp.class;
            } else if (ofMatchField.equals(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpSha.class)) {
                salMatchField = ArpSha.class;
            } else if (ofMatchField.equals(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpSpa.class)) {
                salMatchField = ArpSpa.class;
            } else if (ofMatchField.equals(ArpTha.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.ArpTha.class;
            } else if (ofMatchField.equals(ArpTpa.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.ArpTpa.class;
            } else if (ofMatchField.equals(EthDst.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.EthDst.class;
            } else if (ofMatchField.equals(EthSrc.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.EthSrc.class;
            } else if (ofMatchField.equals(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthType.class)) {
                salMatchField = EthType.class;
            } else if (ofMatchField.equals(Icmpv4Code.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.Icmpv4Code.class;
            } else if (ofMatchField.equals(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv4Type.class)) {
                salMatchField = Icmpv4Type.class;
            } else if (ofMatchField.equals(Icmpv6Code.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.Icmpv6Code.class;
            } else if (ofMatchField.equals(Icmpv6Type.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.Icmpv6Type.class;
            } else if (ofMatchField.equals(InPhyPort.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.InPhyPort.class;
            } else if (ofMatchField.equals(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.InPort.class)) {
                salMatchField = InPort.class;
            } else if (ofMatchField.equals(IpDscp.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.IpDscp.class;
            } else if (ofMatchField.equals(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.IpEcn.class)) {
                salMatchField = IpEcn.class;
            } else if (ofMatchField.equals(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.IpProto.class)) {
                salMatchField = IpProto.class;
            } else if (ofMatchField.equals(Ipv4Dst.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.Ipv4Dst.class;
            } else if (ofMatchField.equals(Ipv4Src.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.Ipv4Src.class;
            } else if (ofMatchField.equals(Ipv6Dst.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.Ipv6Dst.class;
            } else if (ofMatchField.equals(Ipv6Exthdr.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.Ipv6Exthdr.class;
            } else if (ofMatchField.equals(Ipv6Flabel.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.Ipv6Flabel.class;
            } else if (ofMatchField.equals(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6NdSll.class)) {
                salMatchField = Ipv6NdSll.class;
            } else if (ofMatchField.equals(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6NdTarget.class)) {
                salMatchField = Ipv6NdTarget.class;
            } else if (ofMatchField.equals(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6NdTll.class)) {
                salMatchField = Ipv6NdTll.class;
            } else if (ofMatchField.equals(Ipv6Src.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.Ipv6Src.class;
            } else if (ofMatchField.equals(Metadata.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.Metadata.class;
            } else if (ofMatchField.equals(MplsBos.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.MplsBos.class;
            } else if (ofMatchField.equals(MplsLabel.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.MplsLabel.class;
            } else if (ofMatchField.equals(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MplsTc.class)) {
                salMatchField = MplsTc.class;
            } else if (ofMatchField.equals(PbbIsid.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.PbbIsid.class;
            } else if (ofMatchField.equals(SctpDst.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.SctpDst.class;
            } else if (ofMatchField.equals(SctpSrc.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.SctpSrc.class;
            } else if (ofMatchField.equals(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.TcpDst.class)) {
                salMatchField = TcpDst.class;
            } else if (ofMatchField.equals(TcpSrc.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TcpSrc.class;
            } else if (ofMatchField.equals(TunnelId.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TunnelId.class;
            } else if (ofMatchField.equals(UdpDst.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.UdpDst.class;
            } else if (ofMatchField.equals(UdpSrc.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.UdpSrc.class;
            } else if (ofMatchField.equals(VlanPcp.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.VlanPcp.class;
            } else if (ofMatchField.equals(VlanVid.class)) {
                salMatchField = org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.VlanVid.class;
            }
            setFieldMatchBuilder.setMatchType(salMatchField);
            if (setHasMask) {
                setFieldMatchBuilder.setHasMask(currMatch.isHasMask());
            }
            setFieldMatchList.add(setFieldMatchBuilder.build());
        }
        return setFieldMatchList;
    }
}

