/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal.convertor;

import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowCapablePort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.port.mod.port.Port;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.multipart.reply.port.desc.Ports;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.multipart.reply.port.desc.PortsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PortConvertor {
    private static final Logger log = LoggerFactory.getLogger(PortConvertor.class);

    private PortConvertor() {
    }

    public static PortModInput toPortModInput(Port source, short version) {
        PortConfig config = null;
        PortModInputBuilder portModInputBuilder = new PortModInputBuilder();
        portModInputBuilder.setAdvertise(PortConvertor.getPortFeatures(source.getAdvertisedFeatures()));
        portModInputBuilder.setPortNo(new PortNumber(source.getPortNumber()));
        PortConvertor.maskPortConfigFields(source.getConfiguration(), config);
        portModInputBuilder.setConfig(config);
        portModInputBuilder.setHwAddress(new MacAddress(source.getHardwareAddress()));
        config = null;
        PortConvertor.maskPortConfigFields(source.getMask(), config);
        portModInputBuilder.setMask(config);
        portModInputBuilder.setVersion(Short.valueOf(version));
        return portModInputBuilder.build();
    }

    private static void maskPortConfigFields(org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortConfig configData, PortConfig config) {
        Boolean portDown = false;
        Boolean noRecv = false;
        Boolean noFwd = false;
        Boolean noPacketIn = false;
        if (configData.isNOFWD().booleanValue()) {
            noFwd = true;
        }
        if (configData.isNOPACKETIN().booleanValue()) {
            noPacketIn = true;
        }
        if (configData.isNORECV().booleanValue()) {
            noRecv = true;
        }
        if (configData.isPORTDOWN().booleanValue()) {
            portDown = true;
        }
        config = new PortConfig(noFwd, noPacketIn, noRecv, portDown);
    }

    private static PortFeatures getPortFeatures(org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortFeatures salPortFeatures) {
        return new PortFeatures(salPortFeatures.isHundredGbFd(), salPortFeatures.isHundredMbFd(), salPortFeatures.isHundredMbHd(), salPortFeatures.isTenGbFd(), salPortFeatures.isTenMbFd(), salPortFeatures.isTenMbHd(), salPortFeatures.isOneGbFd(), salPortFeatures.isOneGbHd(), salPortFeatures.isOneTbFd(), salPortFeatures.isFortyGbFd(), salPortFeatures.isAutoeng(), salPortFeatures.isCopper(), salPortFeatures.isFiber(), salPortFeatures.isOther(), salPortFeatures.isPause(), salPortFeatures.isPauseAsym());
    }

    public static Ports toPortDesc(FlowCapablePort source) {
        PortConfig config = null;
        org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortState portState = null;
        PortsBuilder OFPortDescDataBuilder = new PortsBuilder();
        OFPortDescDataBuilder.setPortNo(source.getPortNumber());
        OFPortDescDataBuilder.setHwAddr(source.getHardwareAddress());
        OFPortDescDataBuilder.setName(source.getName());
        PortConvertor.maskPortConfigFields(source.getConfiguration(), config);
        OFPortDescDataBuilder.setConfig(config);
        PortConvertor.getPortState((PortState)source.getState(), portState);
        OFPortDescDataBuilder.setState(portState);
        OFPortDescDataBuilder.setCurrentFeatures(PortConvertor.getPortFeatures(source.getCurrentFeature()));
        OFPortDescDataBuilder.setAdvertisedFeatures(PortConvertor.getPortFeatures(source.getAdvertisedFeatures()));
        OFPortDescDataBuilder.setSupportedFeatures(PortConvertor.getPortFeatures(source.getSupported()));
        OFPortDescDataBuilder.setPeerFeatures(PortConvertor.getPortFeatures(source.getPeerFeatures()));
        OFPortDescDataBuilder.setCurrSpeed(source.getCurrentSpeed());
        OFPortDescDataBuilder.setMaxSpeed(source.getMaximumSpeed());
        return OFPortDescDataBuilder.build();
    }

    private static void getPortState(PortState state, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortState portState) {
        boolean isLinkDown = false;
        boolean isBlocked = false;
        boolean isLive = false;
        if (state.isLinkDown().booleanValue()) {
            isLinkDown = true;
        } else if (state.isBlocked().booleanValue()) {
            isBlocked = true;
        } else if (state.isLive().booleanValue()) {
            isLive = true;
        }
        portState = new org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortState(Boolean.valueOf(isLinkDown), Boolean.valueOf(isBlocked), Boolean.valueOf(isLive));
    }
}

