/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal.convertor;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.controller.sal.common.util.Arguments;
import org.opendaylight.openflowplugin.openflow.md.OFConstants;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.MeterConvertor;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaxLengthAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaxLengthActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Output;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.actions.list.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.TransmitPacketInput;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketOutConvertor {
    private static final Logger logger = LoggerFactory.getLogger(MeterConvertor.class);
    private static final String PREFIX_SEPARATOR = "/";

    private PacketOutConvertor() {
    }

    public static PacketOutInput toPacketOutInput(TransmitPacketInput inputPacket, short version, Long xid) {
        PortNumber inPortNr = null;
        List inArgs = null;
        if (inputPacket.getIngress() != null) {
            inArgs = inputPacket.getIngress().getValue().getPath();
        }
        inPortNr = inArgs != null && inArgs.size() >= 3 ? PacketOutConvertor.getPortNumber((InstanceIdentifier.PathArgument)inArgs.get(2)) : new PortNumber(Long.valueOf(0xFFFFFFFDL));
        Long bufferId = OFConstants.OFP_NO_BUFFER;
        PortNumber outPort = null;
        NodeConnectorRef outRef = inputPacket.getEgress();
        List outArgs = outRef.getValue().getPathArguments();
        if (outArgs.size() >= 3) {
            outPort = PacketOutConvertor.getPortNumber((InstanceIdentifier.PathArgument)outArgs.get(2));
        } else {
            new Exception("PORT NR not exist in Egress");
        }
        ArrayList<ActionsList> actions = new ArrayList<ActionsList>();
        ActionsListBuilder asBuild = new ActionsListBuilder();
        ActionBuilder aBuild = new ActionBuilder();
        aBuild.setType(Output.class);
        PortActionBuilder paBuild = new PortActionBuilder();
        paBuild.setPort(outPort);
        aBuild.addAugmentation(PortAction.class, (Augmentation)paBuild.build());
        MaxLengthActionBuilder mlBuild = new MaxLengthActionBuilder();
        mlBuild.setMaxLength(Integer.valueOf(65535));
        aBuild.addAugmentation(MaxLengthAction.class, (Augmentation)mlBuild.build());
        asBuild.setAction(aBuild.build());
        actions.add(asBuild.build());
        PacketOutInputBuilder builder = new PacketOutInputBuilder();
        builder.setActionsList(actions);
        builder.setData(inputPacket.getPayload());
        builder.setVersion(Short.valueOf(version));
        builder.setXid(xid);
        builder.setInPort(inPortNr);
        builder.setBufferId(bufferId);
        return builder.build();
    }

    private static PortNumber getPortNumber(InstanceIdentifier.PathArgument pathArgument) {
        InstanceIdentifier.IdentifiableItem item = (InstanceIdentifier.IdentifiableItem)Arguments.checkInstanceOf((Object)pathArgument, InstanceIdentifier.IdentifiableItem.class);
        NodeConnectorKey key = (NodeConnectorKey)Arguments.checkInstanceOf((Object)item.getKey(), NodeConnectorKey.class);
        String[] split = key.getId().getValue().split(":");
        Long port = Long.decode(split[split.length - 1]);
        return new PortNumber(port);
    }
}

