/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal.convertor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.AddMeterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.RemoveMeterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.meter.update.UpdatedMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.band.type.band.type.Drop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.band.type.band.type.DscpRemark;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.band.type.band.type.Experimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.MeterBandHeaders;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.meter.band.headers.MeterBandHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterBandType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.MeterBand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDropCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDropCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDscpRemarkCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandExperimenterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.drop._case.MeterBandDropBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.dscp.remark._case.MeterBandDscpRemarkBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.experimenter._case.MeterBandExperimenterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.mod.Bands;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.mod.BandsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MeterConvertor {
    private static final Logger logger = LoggerFactory.getLogger(MeterConvertor.class);
    private static final String PREFIX_SEPARATOR = "/";

    private MeterConvertor() {
    }

    public static MeterModInputBuilder toMeterModInput(Meter source, short version) {
        MeterModInputBuilder meterModInputBuilder = new MeterModInputBuilder();
        ArrayList<Bands> bands = new ArrayList<Bands>();
        if (source instanceof AddMeterInput) {
            meterModInputBuilder.setCommand(MeterModCommand.OFPMCADD);
        } else if (source instanceof RemoveMeterInput) {
            meterModInputBuilder.setCommand(MeterModCommand.OFPMCDELETE);
        } else if (source instanceof UpdatedMeter) {
            meterModInputBuilder.setCommand(MeterModCommand.OFPMCMODIFY);
        }
        meterModInputBuilder.setMeterId(new MeterId(source.getMeterId().getValue()));
        if (null != source.getFlags()) {
            meterModInputBuilder.setFlags(new MeterFlags(source.getFlags().isMeterBurst(), source.getFlags().isMeterKbps(), source.getFlags().isMeterPktps(), source.getFlags().isMeterStats()));
        } else {
            meterModInputBuilder.setFlags(new MeterFlags(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        }
        if (source.getMeterBandHeaders() != null) {
            MeterConvertor.getBandsFromSAL(source.getMeterBandHeaders(), bands);
            meterModInputBuilder.setBands(bands);
        } else {
            logger.error("For this meter Id" + source.getMeterId().getValue() + ",no associated band data found!");
        }
        meterModInputBuilder.setVersion(Short.valueOf(version));
        return meterModInputBuilder;
    }

    private static void getBandsFromSAL(MeterBandHeaders meterBandHeaders, List<Bands> bands) {
        Iterator bandHeadersIterator = meterBandHeaders.getMeterBandHeader().iterator();
        BandsBuilder bandsB = null;
        while (bandHeadersIterator.hasNext()) {
            MeterBandHeader meterBandHeader = (MeterBandHeader)bandHeadersIterator.next();
            MeterBandDropCase meterBandItem = null;
            if (null != meterBandHeader.getMeterBandTypes() && null != meterBandHeader.getMeterBandTypes().getFlags()) {
                if (meterBandHeader.getMeterBandTypes().getFlags().isOfpmbtDrop().booleanValue()) {
                    if (meterBandHeader.getBandType() != null) {
                        MeterBandDropCaseBuilder dropCaseBuilder = new MeterBandDropCaseBuilder();
                        MeterBandDropBuilder meterBandDropBuilder = new MeterBandDropBuilder();
                        meterBandDropBuilder.setType(MeterBandType.OFPMBTDROP);
                        Drop drop = (Drop)meterBandHeader.getBandType();
                        meterBandDropBuilder.setBurstSize(drop.getDropRate());
                        meterBandDropBuilder.setRate(drop.getDropBurstSize());
                        dropCaseBuilder.setMeterBandDrop(meterBandDropBuilder.build());
                        meterBandItem = dropCaseBuilder.build();
                        bandsB = new BandsBuilder();
                        bandsB.setMeterBand((MeterBand)meterBandItem);
                        bands.add(bandsB.build());
                        continue;
                    }
                    logger.error("BandType: " + MeterBandType.OFPMBTDROP + "No Band Data found");
                    continue;
                }
                if (meterBandHeader.getMeterBandTypes().getFlags().isOfpmbtDscpRemark().booleanValue()) {
                    if (meterBandHeader.getBandType() != null) {
                        MeterBandDscpRemarkCaseBuilder dscpCaseBuilder = new MeterBandDscpRemarkCaseBuilder();
                        MeterBandDscpRemarkBuilder meterBandDscpRemarkBuilder = new MeterBandDscpRemarkBuilder();
                        meterBandDscpRemarkBuilder.setType(MeterBandType.OFPMBTDSCPREMARK);
                        DscpRemark dscpRemark = (DscpRemark)meterBandHeader.getBandType();
                        meterBandDscpRemarkBuilder.setBurstSize(dscpRemark.getDscpRemarkBurstSize());
                        meterBandDscpRemarkBuilder.setRate(dscpRemark.getDscpRemarkRate());
                        meterBandDscpRemarkBuilder.setPrecLevel(dscpRemark.getPercLevel());
                        dscpCaseBuilder.setMeterBandDscpRemark(meterBandDscpRemarkBuilder.build());
                        meterBandItem = dscpCaseBuilder.build();
                        bandsB = new BandsBuilder();
                        bandsB.setMeterBand((MeterBand)meterBandItem);
                        bands.add(bandsB.build());
                        continue;
                    }
                    logger.error("BandType: " + MeterBandType.OFPMBTDSCPREMARK + "No Band Data found");
                    continue;
                }
                if (!meterBandHeader.getMeterBandTypes().getFlags().isOfpmbtExperimenter().booleanValue()) continue;
                if (meterBandHeader.getBandType() != null) {
                    MeterBandExperimenterCaseBuilder experimenterCaseBuilder = new MeterBandExperimenterCaseBuilder();
                    MeterBandExperimenterBuilder meterBandExperimenterBuilder = new MeterBandExperimenterBuilder();
                    meterBandExperimenterBuilder.setType(MeterBandType.OFPMBTEXPERIMENTER);
                    Experimenter experimenter = (Experimenter)meterBandHeader.getBandType();
                    meterBandExperimenterBuilder.setBurstSize(experimenter.getExperimenterBurstSize());
                    meterBandExperimenterBuilder.setRate(experimenter.getExperimenterRate());
                    meterBandExperimenterBuilder.setExperimenter(experimenter.getExperimenter());
                    experimenterCaseBuilder.setMeterBandExperimenter(meterBandExperimenterBuilder.build());
                    meterBandItem = experimenterCaseBuilder.build();
                    bandsB = new BandsBuilder();
                    bandsB.setMeterBand((MeterBand)meterBandItem);
                    bands.add(bandsB.build());
                    continue;
                }
                logger.error("BandType: " + MeterBandType.OFPMBTEXPERIMENTER + "No Band Data found");
                continue;
            }
            logger.error("Invalid meter band data found.");
        }
    }
}

